--------------------------------------------------------
--  File created - Tuesday-August-04-2015   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Sequence AIRCRAFTFLEET_AIRCRAFTFLEETID_
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."AIRCRAFTFLEET_AIRCRAFTFLEETID_"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence AIRPORTS_AIRPORTID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."AIRPORTS_AIRPORTID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence EMPLOYEES_EMPLOYEEID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."EMPLOYEES_EMPLOYEEID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence EMPLOYEE_MGR_EMPLOYEEID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."EMPLOYEE_MGR_EMPLOYEEID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence FLIGHTS_FLIGHTID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."FLIGHTS_FLIGHTID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence PASSENGERS_PASSENGERID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."PASSENGERS_PASSENGERID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence ROUTES_ROUTEID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."ROUTES_ROUTEID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence TRIPITINERARY_ITINERARYID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."TRIPITINERARY_ITINERARYID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Sequence TRIPS_TRIPID_SEQ
--------------------------------------------------------

   CREATE SEQUENCE  "CANARYAIRLINES"."TRIPS_TRIPID_SEQ"  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20 NOORDER  NOCYCLE ;
--------------------------------------------------------
--  DDL for Table AIRCRAFT
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."AIRCRAFT" 
   (	"AIRCRAFTCODE" VARCHAR2(3 CHAR), 
	"AIRCRAFTTYPE" VARCHAR2(75 CHAR), 
	"FREIGHTONLY" NUMBER(1,0), 
	"SEATING" NUMBER(18,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table AIRCRAFTFLEET
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."AIRCRAFTFLEET" 
   (	"AIRCRAFTFLEETID" NUMBER(10,0), 
	"AIRCRAFTCODE" VARCHAR2(3 CHAR), 
	"AIRCRAFTDESIGNATOR" VARCHAR2(10 CHAR), 
	"STATUS" VARCHAR2(50 CHAR), 
	"HOMEAIRPORTID" NUMBER(10,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table AIRPORTS
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."AIRPORTS" 
   (	"AIRPORTID" NUMBER(10,0), 
	"AIRPORTNAME" VARCHAR2(255 CHAR), 
	"CITY" VARCHAR2(255 CHAR), 
	"COUNTRYCODE" CHAR(3 CHAR), 
	"AIRPORTCODE" CHAR(3 CHAR), 
	"GEOLOCATION" BLOB
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" 
 LOB ("GEOLOCATION") STORE AS BASICFILE (
  TABLESPACE "USERS" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;
--------------------------------------------------------
--  DDL for Table COUNTRIES
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."COUNTRIES" 
   (	"COUNTRYCODE" CHAR(3 CHAR), 
	"COUNTRY" VARCHAR2(50 CHAR), 
	"COUNTRYGEOCODEID" VARCHAR2(10 CHAR), 
	"WORLDAREACODE" NUMBER(10,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EMPLOYEEPOSITIONS
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."EMPLOYEEPOSITIONS" 
   (	"POSITIONID" NUMBER(19,0), 
	"POSITION" VARCHAR2(50 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EMPLOYEES
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."EMPLOYEES" 
   (	"EMPLOYEEID" NUMBER(10,0), 
	"AIRPORTID" NUMBER(10,0), 
	"FIRSTNAME" VARCHAR2(50 CHAR), 
	"LASTNAME" VARCHAR2(50 CHAR), 
	"CITY" VARCHAR2(255 CHAR), 
	"STATE" VARCHAR2(10 CHAR), 
	"PAYRATE" NUMBER(8,2), 
	"SALARY" NUMBER(8,2), 
	"POSITION" VARCHAR2(50 CHAR), 
	"ZIP" VARCHAR2(10 CHAR), 
	"PHONENUMBER" VARCHAR2(11 CHAR), 
	"HIREDATE" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table EMPLOYEE_MGR
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."EMPLOYEE_MGR" 
   (	"EMPLOYEEID" NUMBER(10,0), 
	"FIRSTNAME" VARCHAR2(50 CHAR), 
	"LASTNAME" VARCHAR2(50 CHAR), 
	"MGR_ID" NUMBER(10,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table FLIGHTS
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."FLIGHTS" 
   (	"FLIGHTID" NUMBER(10,0), 
	"FLIGHTSTART" DATE, 
	"FLIGHTEND" DATE, 
	"FLIGHTDURATION" NUMBER(5,0), 
	"ROUTEID" NUMBER(10,0), 
	"AIRCRAFTFLEETID" NUMBER(10,0), 
	"STATUSCODE" CHAR(3 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table FLIGHTSTATUSES
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."FLIGHTSTATUSES" 
   (	"STATUSCODE" CHAR(3 CHAR), 
	"STATUSNAME" VARCHAR2(50 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table HIGH_SALARIES
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."HIGH_SALARIES" 
   (	"SALARY" NUMBER(8,2)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PASSENGERS
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."PASSENGERS" 
   (	"PASSENGERID" NUMBER(10,0), 
	"FIRSTNAME" VARCHAR2(50 CHAR), 
	"LASTNAME" VARCHAR2(50 CHAR), 
	"BIRTHDATE" DATE, 
	"COUNTRYCODE" CHAR(3 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table RICH_EMPLOYEES
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."RICH_EMPLOYEES" 
   (	"EMPLOYEEID" NUMBER(10,0), 
	"LASTNAME" VARCHAR2(50 CHAR), 
	"FIRSTNAME" VARCHAR2(50 CHAR), 
	"AIRPORTNAME" VARCHAR2(255 CHAR), 
	"SALARY" NUMBER(8,2)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table ROUTES
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."ROUTES" 
   (	"ROUTEID" NUMBER(10,0), 
	"ROUTECODE" VARCHAR2(50 CHAR), 
	"SOURCEAIRPORTID" NUMBER(10,0), 
	"DESTINATIONAIRPORTID" NUMBER(10,0), 
	"AIRPLANECODE" CHAR(3 CHAR), 
	"DISTANCE" NUMBER(10,0), 
	"TRAVELTIME" NUMBER(10,0), 
	"FUELCOSTPERMINUTE" NUMBER(19,4), 
	"STARTDATE" DATE, 
	"ENDDATE" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TRIPITINERARY
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."TRIPITINERARY" 
   (	"ITINERARYID" NUMBER(10,0), 
	"TRIPID" NUMBER(10,0), 
	"FLIGHTID" NUMBER(10,0), 
	"ORIGINATINGFLIGHT" NUMBER(1,0), 
	"RETURNFLIGHT" NUMBER(1,0), 
	"FLIGHTRANK" NUMBER(5,0), 
	"BOARDED" NUMBER(1,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table TRIPS
--------------------------------------------------------

  CREATE TABLE "CANARYAIRLINES"."TRIPS" 
   (	"TRIPID" NUMBER(10,0), 
	"PASSENGERID" NUMBER(10,0), 
	"SOURCEFLIGHTID" NUMBER(10,0), 
	"LEAVING" DATE, 
	"LEAVINGCHECKEDIN" NUMBER(1,0), 
	"LEAVINGCHECKEDLUGGAGE" NUMBER(3,0), 
	"HASRETURNFLIGHT" NUMBER(1,0), 
	"RETURNFLIGHTID" NUMBER(10,0), 
	"RETURNING" DATE, 
	"RETURNCHECKEDIN" NUMBER(1,0), 
	"RETURNCHECKEDLUGGAGE" NUMBER(3,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for View RANDOMVIEW
--------------------------------------------------------

  CREATE OR REPLACE FORCE VIEW "CANARYAIRLINES"."RANDOMVIEW" ("VAL") AS 
  SELECT utils.rand() Val  
     FROM DUAL;
--------------------------------------------------------
--  DDL for View VW_FLIGHTINFO
--------------------------------------------------------

  CREATE OR REPLACE FORCE VIEW "CANARYAIRLINES"."VW_FLIGHTINFO" ("FLIGHTID", "SOURCEAIRPORTID", "DESTINATIONAIRPORTID", "FLIGHTSTART", "FLIGHTEND", "DISTANCE", "SOURCECOUNTRY", "DESTINATIONCOUNTRY", "DESTINATIONCITY", "SOURCECITY", "FLIGHTDURATION", "SOURCEAIRPORTCODE", "DESTINATIONAIRPORTCODE") AS 
  SELECT CanaryAirlines.Flights.FlightID ,
          CanaryAirlines.Routes.SourceAirportID ,
          CanaryAirlines.Routes.DestinationAirportID ,
          CanaryAirlines.Flights.FlightStart ,
          CanaryAirlines.Flights.FlightEnd ,
          CanaryAirlines.Routes.Distance ,
          A1.CountryCode SourceCountry  ,
          A2.CountryCode DestinationCountry  ,
          A2.City DestinationCity  ,
          A1.City SourceCity  ,
          CanaryAirlines.Flights.FlightDuration ,
          A1.AirportCode SourceAirportCode  ,
          A2.AirportCode DestinationAirportCode  
     FROM CanaryAirlines.Flights 
            JOIN CanaryAirlines.Routes    ON CanaryAirlines.Flights.RouteID = CanaryAirlines.Routes.RouteID
            JOIN CanaryAirlines.Airports A1   ON CanaryAirlines.Routes.SourceAirportID = A1.AirportID
            JOIN CanaryAirlines.Airports A2   ON CanaryAirlines.Routes.DestinationAirportID = A2.AirportID;
--------------------------------------------------------
--  DDL for View VW_FLIGHTNUMBERSPERDAY
--------------------------------------------------------

  CREATE OR REPLACE FORCE VIEW "CANARYAIRLINES"."VW_FLIGHTNUMBERSPERDAY" ("FLIGHTDATE", "NUMOFFLIGHTS") AS 
  SELECT UTILS.CONVERT_TO_VARCHAR2(FlightStart,200) FlightDate  ,
          COUNT(*)  NumofFlights  
     FROM Flights 
     GROUP BY UTILS.CONVERT_TO_VARCHAR2(FlightStart,200);
REM INSERTING into CANARYAIRLINES.AIRCRAFT
SET DEFINE OFF;
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('146','British Aerospace BAe146-100',0,82);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('310','Airbus A310',0,198);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('313','Airbus A310-300',0,218);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('330','Airbus 330 (200 & 300) series',0,335);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('343','Airbus 340-300',0,230);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('72S','Boeing 727',0,153);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('733','Boeing 737-300',0,106);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('734','Boeing 737-400',0,129);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('735','Boeing 737-500',0,108);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('737','Boeing 737',0,100);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('738','Boeing 737-800',0,114);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('742','Boeing 747-200',0,420);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('743','Boeing 747-300',0,420);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('744','Boeing 747-400',0,400);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('747','Boeing 747 (all series)',0,420);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('74F','Boeing 747 Freighter',1,0);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('74L','Boeing 747SP',0,314);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('74M','Boeing 747 Combi',0,246);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('762','Boeing 767-200',0,200);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('763','Boeing 763-300',0,228);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('772','Boeing 777-200',0,375);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('773','Boeing 777-300',0,420);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('777','Boeing 777',0,375);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('AB6','Airbus 600 Series E',0,226);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('AR7','British Aerospace RJ70',0,76);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('BBB','Boeing',0,null);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('BEH','Beachcraft 1900D',0,18);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('BEK','Beach 200',0,13);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('CCC','Boeing',0,null);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('CV5','Convair 500',0,36);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('D10','McDonnell Douglas DC10',0,399);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('DH8','Bombardier DE HA',0,37);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('E12','Embraer (EMB) 120',0,30);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('EM2','Embraer 120',0,26);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('F10','Fokker F100',0,95);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('F28','Fokker F28-1000',0,65);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('L10','Lockheed L/1011 TR',0,400);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('M11','McDonnell Douglas MD-11',0,323);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('M1F','McDonnell Douglas MD-11 Freighter',1,0);
Insert into CANARYAIRLINES.AIRCRAFT (AIRCRAFTCODE,AIRCRAFTTYPE,FREIGHTONLY,SEATING) values ('WWF','Westwind Freighter',1,0);
REM INSERTING into CANARYAIRLINES.AIRCRAFTFLEET
SET DEFINE OFF;
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (224,'735','UVPY-709','ACTIVE',1912);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (225,'CV5','CNNM-308','ACTIVE',1704);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (226,'D10','RWMV-797','ACTIVE',1977);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (227,'737','KBIN-553','ACTIVE',3576);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (228,'M1F','GRCP-693','ACTIVE',1886);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (229,'M1F','LVWM-436','ACTIVE',2276);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (230,'M1F','LPVD-698','ACTIVE',3732);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (231,'M1F','UOWC-988','ACTIVE',3888);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (232,'74F','VWHR-133','ACTIVE',3459);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (233,'74F','TLQY-434','ACTIVE',3654);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (234,'BEH','RJSC-579','ACTIVE',3992);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (235,'L10','IRSF-485','ACTIVE',3342);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (236,'AB6','MWLI-934','ACTIVE',1457);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (237,'762','UFQS-673','ACTIVE',1483);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (238,'733','DHUO-638','ACTIVE',3641);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (239,'F10','PNDW-113','ACTIVE',27);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (240,'F10','VEHS-976','ACTIVE',3771);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (241,'F10','JFMG-816','ACTIVE',1548);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (242,'F10','EVTI-362','ACTIVE',1782);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (243,'EM2','BTYF-754','ACTIVE',2029);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (244,'737','UHQL-270','ACTIVE',1834);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (245,'772','IHTJ-377','ACTIVE',3589);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (246,'F10','FGFB-113','ACTIVE',3680);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (247,'F10','RWKY-848','ACTIVE',2081);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (248,'F10','NVNI-588','ACTIVE',1327);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (249,'F10','UWSX-804','ACTIVE',3264);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (250,'F10','ACJG-514','ACTIVE',1509);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (251,'DH8','RIXC-572','ACTIVE',1743);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (252,'737','NURC-361','ACTIVE',2172);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (253,'777','LXPG-319','ACTIVE',1561);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (254,'777','EKVI-250','ACTIVE',1964);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (255,'M1F','HQGH-384','ACTIVE',3251);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (256,'L10','MYPL-452','ACTIVE',2354);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (257,'F28','BFFC-453','ACTIVE',2055);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (258,'310','WJFT-620','ACTIVE',3511);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (259,'310','NYOB-666','ACTIVE',1821);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (260,'M11','KPEX-654','ACTIVE',4005);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (261,'343','WCFY-554','ACTIVE',3537);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (262,'L10','VDPX-523','ACTIVE',2263);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (263,'L10','SGPW-523','ACTIVE',2029);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (264,'D10','QGTY-720','ACTIVE',3498);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (265,'D10','FAPX-142','ACTIVE',2367);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (266,'773','LRTU-295','ACTIVE',1249);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (267,'146','GCRX-455','ACTIVE',3979);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (268,'DH8','LRUP-887','ACTIVE',2354);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (269,'AB6','OQNF-426','ACTIVE',3550);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (270,'AB6','TNQF-991','ACTIVE',3407);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (271,'M1F','DFHG-932','ACTIVE',1314);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (272,'M1F','CCYE-437','ACTIVE',1496);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (273,'M1F','NWXL-728','ACTIVE',3979);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (274,'BEK','RJOD-864','ACTIVE',4018);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (275,'BEK','PMKV-900','ACTIVE',2042);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (276,'BEK','UBKK-896','ACTIVE',1886);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (277,'AR7','AUYY-134','ACTIVE',1353);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (278,'AR7','MBBH-792','ACTIVE',2016);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (279,'777','SESF-634','ACTIVE',2172);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (280,'EM2','SSOS-217','ACTIVE',3602);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (281,'BEK','PYNS-870','ACTIVE',3810);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (282,'M11','KLRB-621','ACTIVE',2263);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (283,'M11','XHYX-348','ACTIVE',3784);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (284,'735','YOKY-842','ACTIVE',3316);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (285,'744','FUKW-990','ACTIVE',27);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (286,'744','KPHD-310','ACTIVE',3134);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (287,'744','DICV-572','ACTIVE',1613);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (288,'744','BYMQ-716','ACTIVE',2406);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (289,'EM2','RVUM-265','ACTIVE',2406);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (290,'742','KPIR-935','ACTIVE',1808);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (291,'E12','PUYQ-385','ACTIVE',2016);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (292,'762','KWWC-432','ACTIVE',3953);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (293,'330','QLLF-935','ACTIVE',3329);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (294,'74L','MXNX-135','ACTIVE',3589);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (295,'74L','HXEE-366','ACTIVE',3836);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (296,'74L','UUVY-354','ACTIVE',4031);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (297,'M1F','PCDG-693','ACTIVE',3368);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (298,'M1F','WVOR-957','ACTIVE',1340);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (299,'747','QFPP-545','ACTIVE',3212);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (300,'L10','JTWY-213','ACTIVE',1535);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (301,'EM2','MJHO-463','ACTIVE',3888);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (302,'74F','AYXL-662','ACTIVE',3862);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (303,'74M','OAUL-528','ACTIVE',3056);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (304,'74M','UBNL-169','ACTIVE',1886);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (305,'D10','AIBM-819','ACTIVE',3784);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (306,'734','SHFE-325','ACTIVE',2133);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (307,'734','AWKR-646','ACTIVE',3563);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (308,'74L','LEWJ-653','ACTIVE',1262);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (309,'M11','DSXQ-184','ACTIVE',2289);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (310,'AB6','NRVD-572','ACTIVE',1392);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (311,'F28','OCKE-988','ACTIVE',1600);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (312,'F10','FIXM-832','ACTIVE',3537);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (313,'BEK','DYFL-642','ACTIVE',1977);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (314,'BEK','XRJC-648','ACTIVE',1834);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (315,'D10','TVPX-295','ACTIVE',1769);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (316,'D10','TEKL-766','ACTIVE',2016);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (317,'735','GIBT-580','ACTIVE',1340);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (318,'BEH','HUWB-322','ACTIVE',2120);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (319,'BEH','DNRO-983','ACTIVE',3680);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (320,'AB6','JSUQ-658','ACTIVE',3342);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (321,'DH8','DYLB-901','ACTIVE',2159);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (322,'DH8','RPHL-689','ACTIVE',3225);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (323,'DH8','XIDQ-290','ACTIVE',1470);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (324,'DH8','HTLA-193','ACTIVE',2289);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (325,'M11','VQFX-145','ACTIVE',3953);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (326,'M11','IRQR-371','ACTIVE',2367);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (327,'M11','SIUO-660','ACTIVE',3108);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (328,'M11','TSIK-464','ACTIVE',3173);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (329,'735','QVBQ-986','ACTIVE',3173);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (330,'735','INHD-370','ACTIVE',3342);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (331,'M1F','BXXC-639','ACTIVE',3225);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (332,'DH8','VSUB-923','ACTIVE',1782);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (333,'DH8','UXNT-292','ACTIVE',2159);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (334,'DH8','JENB-172','ACTIVE',2198);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (335,'L10','GUFG-195','ACTIVE',3862);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (336,'735','HJAO-703','ACTIVE',3732);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (337,'735','BOYW-257','ACTIVE',1457);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (338,'735','MSTD-373','ACTIVE',4018);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (339,'74M','PUCF-849','ACTIVE',1353);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (340,'CV5','DEAX-891','ACTIVE',2185);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (341,'D10','OCES-396','ACTIVE',3251);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (342,'D10','PFXA-200','ACTIVE',3693);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (343,'747','FPAR-152','ACTIVE',3628);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (344,'M1F','HPXY-247','ACTIVE',3888);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (345,'M1F','MBSP-381','ACTIVE',1392);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (346,'M1F','CHKG-193','ACTIVE',2081);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (347,'744','XUTR-923','ACTIVE',3173);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (348,'L10','EAGM-737','ACTIVE',3238);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (349,'733','RLDO-567','ACTIVE',2159);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (350,'762','XUJA-589','ACTIVE',3784);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (1,'M1F','AEPE-287','ACTIVE',3797);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (2,'777','CPYJ-463','ACTIVE',1912);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (3,'777','IVYD-386','ACTIVE',3160);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (4,'AR7','EFWX-268','ACTIVE',3849);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (5,'M11','QMRU-749','ACTIVE',3199);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (6,'L10','FNID-520','ACTIVE',4044);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (7,'773','HIDE-415','ACTIVE',1964);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (8,'F10','LAKT-550','ACTIVE',3394);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (9,'F10','WWVN-677','ACTIVE',4031);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (10,'L10','YLVH-196','ACTIVE',3576);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (11,'738','PXLT-525','ACTIVE',1236);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (12,'CV5','IMWQ-247','ACTIVE',3771);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (13,'AR7','QSEK-111','ACTIVE',1457);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (14,'AR7','GABK-648','ACTIVE',3433);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (15,'AR7','BGHT-789','ACTIVE',1782);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (16,'DH8','UCWM-856','ACTIVE',3277);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (17,'M11','HYKC-582','ACTIVE',4044);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (18,'M11','EGPN-564','ACTIVE',2380);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (19,'M11','YJER-997','ACTIVE',2224);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (20,'74M','TNHK-861','ACTIVE',2263);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (21,'F28','UPEH-163','ACTIVE',1743);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (22,'F28','TRNC-819','ACTIVE',1756);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (23,'F28','HCFB-343','ACTIVE',2146);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (24,'744','FQWV-164','ACTIVE',3433);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (25,'F10','OKCP-472','ACTIVE',3355);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (26,'F10','USRR-180','ACTIVE',2055);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (27,'F10','MQPI-513','ACTIVE',2250);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (28,'F10','WNPA-892','ACTIVE',2107);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (29,'343','DUWF-942','ACTIVE',1275);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (30,'BEK','BYYJ-352','ACTIVE',2172);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (31,'BEK','WCJL-994','ACTIVE',3212);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (32,'D10','AKFB-182','ACTIVE',1353);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (33,'F10','JIHD-939','ACTIVE',3134);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (34,'763','QIHX-397','ACTIVE',1873);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (35,'AB6','KTSW-988','ACTIVE',1340);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (36,'BEK','SKQU-790','ACTIVE',3108);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (37,'BEK','HOAY-703','ACTIVE',1340);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (38,'BEK','TACN-429','ACTIVE',3784);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (39,'F10','SKSF-267','ACTIVE',1444);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (40,'BEK','VWXR-312','ACTIVE',2146);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (41,'AB6','EKQB-459','ACTIVE',2198);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (42,'F10','EQVI-711','ACTIVE',2107);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (43,'743','JMPV-320','ACTIVE',1262);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (44,'M11','ABVN-910','ACTIVE',3849);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (45,'D10','PSCY-983','ACTIVE',1691);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (46,'D10','LTCD-530','ACTIVE',1717);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (47,'74F','RONU-469','ACTIVE',3459);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (48,'D10','GAPX-588','ACTIVE',2159);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (49,'D10','JGBE-777','ACTIVE',3134);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (50,'146','TKWQ-557','ACTIVE',3459);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (51,'DH8','MKJJ-759','ACTIVE',3628);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (52,'773','ECWJ-975','ACTIVE',3901);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (53,'773','GJKF-276','ACTIVE',1639);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (54,'343','GNPU-776','ACTIVE',4018);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (55,'343','RHFQ-495','ACTIVE',2094);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (56,'747','XEEI-603','ACTIVE',3199);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (57,'747','KKEN-179','ACTIVE',2042);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (58,'742','YBUL-178','ACTIVE',3238);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (59,'742','MMOW-553','ACTIVE',3381);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (60,'742','LESB-697','ACTIVE',3732);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (61,'737','JHQT-781','ACTIVE',3901);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (62,'737','RBWS-176','ACTIVE',3680);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (63,'L10','ABWU-539','ACTIVE',1340);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (64,'L10','PFAM-785','ACTIVE',3589);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (65,'EM2','IEQF-918','ACTIVE',2367);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (66,'EM2','WACB-992','ACTIVE',3693);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (67,'EM2','UDLG-870','ACTIVE',3082);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (68,'EM2','NDGB-839','ACTIVE',4070);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (69,'EM2','EFFM-106','ACTIVE',3797);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (70,'EM2','WLQE-441','ACTIVE',1379);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (71,'EM2','BDCA-157','ACTIVE',3641);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (72,'EM2','DXEL-951','ACTIVE',3797);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (73,'EM2','GWKK-847','ACTIVE',1782);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (74,'EM2','SOMM-125','ACTIVE',3446);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (75,'EM2','LCYS-251','ACTIVE',4070);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (76,'EM2','KWQQ-813','ACTIVE',1847);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (77,'EM2','VESC-110','ACTIVE',4005);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (78,'763','UXVH-185','ACTIVE',2328);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (79,'DH8','XJCF-737','ACTIVE',1769);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (80,'F28','OXOB-511','ACTIVE',2302);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (81,'F28','CFMF-447','ACTIVE',2133);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (82,'F10','KQBC-917','ACTIVE',3979);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (83,'F10','NSUF-646','ACTIVE',2237);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (84,'F10','QFME-606','ACTIVE',1769);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (85,'F10','HCAM-672','ACTIVE',3745);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (86,'F28','LXUT-830','ACTIVE',1977);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (87,'F28','MEAB-177','ACTIVE',4070);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (88,'CV5','ULEI-828','ACTIVE',3550);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (89,'CV5','QRYW-903','ACTIVE',2107);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (90,'AB6','XQOY-296','ACTIVE',2198);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (91,'BEH','SULI-725','ACTIVE',3511);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (92,'BEH','PBGB-907','ACTIVE',2367);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (93,'737','HQAG-602','ACTIVE',3329);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (94,'737','SBNU-240','ACTIVE',2172);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (95,'737','GYAP-245','ACTIVE',2042);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (96,'737','AWAW-993','ACTIVE',4070);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (97,'733','QBOM-891','ACTIVE',3550);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (98,'733','UFLE-896','ACTIVE',1990);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (99,'733','HTNL-592','ACTIVE',2198);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (100,'777','HWSI-510','ACTIVE',2146);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (101,'72S','MWAM-556','ACTIVE',1912);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (102,'BEH','KOYK-441','ACTIVE',1990);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (103,'74M','TUJG-510','ACTIVE',1535);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (104,'330','REWI-747','ACTIVE',2237);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (105,'330','WUVV-168','ACTIVE',3797);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (106,'F28','AGTX-691','ACTIVE',1769);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (107,'M1F','VFCH-785','ACTIVE',3888);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (108,'M11','PTCP-595','ACTIVE',1392);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (109,'737','IIKC-963','ACTIVE',3472);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (110,'737','ABOM-857','ACTIVE',1496);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (111,'DH8','JIPN-711','ACTIVE',3719);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (112,'742','FRWO-795','ACTIVE',1431);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (113,'EM2','OBTQ-688','ACTIVE',3290);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (114,'CV5','JKLD-598','ACTIVE',1275);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (115,'762','LPQS-330','ACTIVE',3095);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (116,'E12','SXUA-545','ACTIVE',3524);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (117,'E12','AIEC-888','ACTIVE',1249);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (118,'E12','VUFJ-801','ACTIVE',3563);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (119,'E12','SRTV-780','ACTIVE',3602);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (120,'146','RWWK-144','ACTIVE',3641);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (121,'74L','SPSM-643','ACTIVE',2263);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (122,'74L','YNMG-677','ACTIVE',1482);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (123,'F28','IACX-695','ACTIVE',1418);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (124,'74L','OFYW-613','ACTIVE',3381);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (125,'74L','SEYS-951','ACTIVE',1769);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (126,'734','VMYJ-379','ACTIVE',2185);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (127,'777','BKDV-405','ACTIVE',1899);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (128,'777','KJEM-777','ACTIVE',2185);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (129,'F10','KQNN-871','ACTIVE',1704);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (130,'777','LGFU-489','ACTIVE',3862);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (131,'777','XRXC-164','ACTIVE',3186);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (132,'310','JRUL-710','ACTIVE',2380);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (133,'F10','EXNJ-570','ACTIVE',4031);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (134,'F10','GDMB-224','ACTIVE',2250);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (135,'772','MXNJ-946','ACTIVE',2289);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (136,'777','WQGA-809','ACTIVE',1483);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (137,'E12','CVNC-280','ACTIVE',1899);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (138,'E12','MMEK-270','ACTIVE',3680);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (139,'773','KJTQ-775','ACTIVE',1639);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (140,'773','AXGR-786','ACTIVE',3225);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (141,'747','OQSS-292','ACTIVE',4005);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (142,'343','PBUP-378','ACTIVE',3615);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (143,'343','JXKB-587','ACTIVE',3979);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (144,'343','IDFV-569','ACTIVE',3199);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (145,'343','CDKU-905','ACTIVE',3797);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (146,'773','JOOG-788','ACTIVE',2406);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (147,'762','LJUA-887','ACTIVE',3173);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (148,'M11','CIVG-217','ACTIVE',2263);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (149,'737','JHFK-509','ACTIVE',3771);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (150,'737','BMBR-608','ACTIVE',3264);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (151,'BEK','OPGE-196','ACTIVE',3732);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (152,'BEK','HHAO-832','ACTIVE',1353);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (153,'BEK','HVHL-786','ACTIVE',3147);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (154,'DH8','WBAS-557','ACTIVE',3849);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (155,'DH8','FVCD-879','ACTIVE',3823);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (156,'CV5','AQBT-329','ACTIVE',1392);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (157,'L10','QBOO-646','ACTIVE',1717);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (158,'L10','IUYG-541','ACTIVE',1236);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (159,'AR7','TFKT-729','ACTIVE',1457);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (160,'AR7','ENYQ-791','ACTIVE',3602);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (161,'330','DOJM-815','ACTIVE',3771);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (162,'AB6','TXPN-171','ACTIVE',3719);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (163,'743','LQNG-912','ACTIVE',1782);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (164,'743','YVYE-653','ACTIVE',3446);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (165,'743','PEWW-641','ACTIVE',3108);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (166,'773','HYVR-473','ACTIVE',1964);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (167,'F10','SBKC-991','ACTIVE',3615);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (168,'BEH','GLJM-417','ACTIVE',3225);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (169,'BEH','KVXI-740','ACTIVE',1847);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (170,'L10','IMSS-364','ACTIVE',1639);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (171,'74M','YUAB-349','ACTIVE',1899);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (172,'74M','BYDP-906','ACTIVE',4031);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (173,'AR7','TSNS-123','ACTIVE',3069);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (174,'D10','WCFM-713','ACTIVE',3186);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (175,'D10','NQWI-348','ACTIVE',3680);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (176,'DH8','ALFO-575','ACTIVE',3134);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (177,'DH8','VKKE-212','ACTIVE',3628);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (178,'DH8','FOWE-289','ACTIVE',1587);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (179,'E12','CRMB-966','ACTIVE',1938);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (180,'735','IIPQ-549','ACTIVE',2029);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (181,'E12','KIPU-880','ACTIVE',2133);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (182,'BEH','GJWT-698','ACTIVE',3316);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (183,'BEH','KUEP-113','ACTIVE',3719);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (184,'BEH','OGTW-205','ACTIVE',1886);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (185,'BEH','FIDM-123','ACTIVE',3225);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (186,'BEH','XDDV-528','ACTIVE',3550);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (187,'313','TJVL-499','ACTIVE',1886);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (188,'313','MKRY-279','ACTIVE',3784);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (189,'313','RNEY-223','ACTIVE',1482);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (190,'313','JSOI-552','ACTIVE',3732);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (191,'CV5','MGCM-649','ACTIVE',2094);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (192,'EM2','PQUA-236','ACTIVE',3693);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (193,'EM2','MUFH-406','ACTIVE',3979);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (194,'762','KPAC-401','ACTIVE',2393);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (195,'744','YIUK-522','ACTIVE',1457);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (196,'747','QYVC-271','ACTIVE',4044);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (197,'310','FADU-822','ACTIVE',2302);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (198,'310','FCFQ-651','ACTIVE',3641);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (199,'738','SUWF-361','ACTIVE',1899);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (200,'L10','UWRV-786','ACTIVE',2159);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (201,'762','FKWF-355','ACTIVE',3576);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (202,'M11','OJNQ-439','ACTIVE',1496);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (203,'M11','EBMB-762','ACTIVE',2263);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (204,'M11','SYUT-586','ACTIVE',3329);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (205,'747','HCMD-237','ACTIVE',1587);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (206,'74L','BACN-380','ACTIVE',3056);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (207,'74L','MVFW-604','ACTIVE',4044);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (208,'763','ETHC-396','ACTIVE',3732);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (209,'E12','MOBB-128','ACTIVE',2133);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (210,'E12','QWLJ-114','ACTIVE',3667);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (211,'M11','OGMT-833','ACTIVE',3511);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (212,'E12','BIOA-249','ACTIVE',1665);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (213,'F10','VITU-795','ACTIVE',1821);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (214,'F10','PIMC-531','ACTIVE',1665);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (215,'E12','NHKD-379','ACTIVE',2328);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (216,'E12','SFMT-323','ACTIVE',3641);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (217,'BEK','HLAE-469','ACTIVE',3238);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (218,'BEK','KWLU-753','ACTIVE',1327);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (219,'777','XLJG-192','ACTIVE',1808);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (220,'AB6','YHIK-191','ACTIVE',1353);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (221,'AB6','GHBM-587','ACTIVE',3264);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (222,'343','JJAL-195','ACTIVE',4005);
Insert into CANARYAIRLINES.AIRCRAFTFLEET (AIRCRAFTFLEETID,AIRCRAFTCODE,AIRCRAFTDESIGNATOR,STATUS,HOMEAIRPORTID) values (223,'L10','XMDV-273','ACTIVE',3901);
REM INSERTING into CANARYAIRLINES.AIRPORTS
SET DEFINE OFF;
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1,'Bamiyan','Bamiyan','AF ','BIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2,'Bost','Bost','AF ','BST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3,'Chakcharan','Chakcharan','AF ','CCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4,'Darwaz','Darwaz','AF ','DAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5,'Faizabad','Faizabad','AF ','FBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6,'Farah','Farah','AF ','FAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (7,'Gardez','Gardez','AF ','GRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (8,'Ghazni','Ghazni','AF ','GZI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (9,'Herat','Herat','AF ','HEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (10,'Jalalabad','Jalalabad','AF ','JAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (11,'Kandahar','Kandahar','AF ','KDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (12,'Khost','Khost','AF ','KHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (13,'Khwahan','Khwahan','AF ','KWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (14,'Khwaja Rawash','Kabul','AF ','KBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (15,'Kunduz','Kunduz','AF ','UND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (16,'Kuran-O-Munjan','Kuran-O-Munjan','AF ','KUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (17,'Maimana','Maimana','AF ','MMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (18,'Mazar-i-sharif','Mazar-i-sharif','AF ','MZR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (19,'Nimroz','Nimroz','AF ','IMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (20,'Qala Nau','Qala Nau','AF ','LQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (21,'Sardeh Band','Sardeh Band','AF ','SBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (22,'Sheghnan','Sheghnan','AF ','SGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (23,'Taluqan','Taluqan','AF ','TQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (24,'Tirinkot','Tirinkot','AF ','TII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (25,'Uruzgan','Uruzgan','AF ','URZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (26,'Zaranj','Zaranj','AF ','ZAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (27,'Red Dog','Red Dog','US ','RDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (28,'Rinas Mother Teresa','Tirana','AL ','TIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (29,'Adrar','Adrar','DZ ','AZR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (30,'Aguemar','Tamanrasset','DZ ','TMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (31,'Ain Beida','Ouargla','DZ ','OGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (32,'Ain Eddis','Boussaada','DZ ','BUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (33,'Ain El Bey','Constantine','DZ ','CZL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (34,'Batna','Batna','DZ ','BLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (35,'Bejaia','Bejaia','DZ ','BJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (36,'Biskra','Biskra','DZ ','BSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (37,'Bordj Badji Mokhtar','Bordj Badji Mokhtar','DZ ','BMW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (38,'Bouchekif Abde Al-hafidh Boussof','Tiaret','DZ ','TID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (39,'Djamet','El Golea','DZ ','ELG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (40,'Es Senia','Oran','DZ ','ORN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (41,'Gara Djebilet','Gara Djebilet','DZ ','GBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (42,'Guemar','El Oued','DZ ','ELU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (43,'Houari Boumediene','Algiers','DZ ','ALG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (44,'Illizi','Illizi','DZ ','VVZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (45,'In Amenas','In Amenas','DZ ','IAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (46,'In Salah','In Salah','DZ ','INZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (47,'Inedbirenne','Djanet','DZ ','DJG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (48,'Jijel','Jijel','DZ ','GJL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (49,'Kouba','Kouba','DZ ','KDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (50,'Leger','Bechar','DZ ','CBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (51,'Les Salines','Annaba','DZ ','AAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (52,'Mascara','Mascara','DZ ','MUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (53,'Mechria','Mechria','DZ ','MZW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (54,'Mostaganem','Mostaganem','DZ ','MQV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (55,'Newark Liberty International','In Guezzam','DZ ','INF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (56,'Noumerate','Ghardaia','DZ ','GHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (57,'Oued Irara Apt','Hassi Messaoud','DZ ','HME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (58,'Setif','Setif','DZ ','QSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (59,'Skikda','Skikda','DZ ','SKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (60,'Tafaraoui','Oran','DZ ','TAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (61,'Timimoun','Timimoun','DZ ','TMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (62,'Tindouf','Tindouf','DZ ','TIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (63,'Touggourt','Touggourt','DZ ','TGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (64,'Zenata','Tlemcen','DZ ','TLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (65,'Fitiuta','Fitiuta','AS ','FTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (66,'International','Pago Pago','AS ','PPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (67,'Ofu','Ofu','AS ','OFU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (68,'Tau','Tau','AS ','TAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (69,'Andorra La Vella H/P','Andorra La Vella','AD ','ALV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (70,'4 de Fevereiro','Luanda','AO ','LAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (71,'Ambriz','Ambriz','AO ','AZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (72,'Ambriz','Ambriz','AO ','AAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (73,'Andulo','Andulo','AO ','ANL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (74,'Cabinda','Cabinda','AO ','CAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (75,'Cafunfo','Cafunfo','AO ','CFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (76,'Cangamba','Cangamba','AO ','CNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (77,'Capanda','Capanda','AO ','KNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (152,'Goya','Goya','AR ','OYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (153,'Gualeguaychu','Gualeguaychu','AR ','GHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (154,'Ingeniero Jacobacci','Ingeniero Jacobacci','AR ','IGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (155,'Internacional','Rio Gallegos','AR ','RGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (156,'International','San Carlos DeBariloche','AR ','BRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (157,'Islas Malvinas','Ushuaia','AR ','USH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (158,'Jose De San Martin','Jose De San Martin','AR ','JSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (159,'Junin','Junin','AR ','JNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (160,'La Cumbre','La Cumbre','AR ','LCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (161,'La Plata','La Plata','AR ','LPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (162,'Lago Argentino','Lago Argentino','AR ','ING');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (163,'Las Heras','Las Heras','AR ','LHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (164,'Las Lomitas','Las Lomitas','AR ','LLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (165,'Loncopue','Loncopue','AR ','LCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (166,'Los Menucos','Los Menucos','AR ','LMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (167,'Malargue','Malargue','AR ','LGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (168,'Maquinchao','Maquinchao','AR ','MQD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (169,'Mar Del Plata','Mar Del Plata','AR ','MDQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (170,'Mercedes','Mercedes','AR ','MDX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (171,'Miramar','Miramar','AR ','MJR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (172,'Monte Caseros','Monte Caseros','AR ','MCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (173,'Necochea','Necochea','AR ','NEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (174,'Neuquen','Neuquen','AR ','NQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (175,'Olavarria','Olavarria','AR ','OVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (176,'Oran','Oran','AR ','ORA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (177,'Pajas Blancas','Cordoba','AR ','COR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (178,'Parana','Parana','AR ','PRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (179,'Paso De Los Libres','Paso De Los Libres','AR ','AOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (180,'Pehuajo','Pehuajo','AR ','PEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (181,'Perito Moreno','Perito Moreno','AR ','PMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (182,'Posadas','Posadas','AR ','PSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (183,'Pres. Roque Saenz Pena','Pres. Roque Saenz Pena','AR ','PRQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (184,'Puerto Deseado','Puerto Deseado','AR ','PUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (185,'Reconquista','Reconquista','AR ','RCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (186,'Resistencia','Resistencia','AR ','RES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (187,'Rio Cuarto','Rio Cuarto','AR ','RCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (188,'Rio Grande','Rio Grande','AR ','RGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (189,'Rio Hondo','Rio Hondo','AR ','RHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (190,'Rio Mayo','Rio Mayo','AR ','ROY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (191,'Rio Turbio','Rio Turbio','AR ','RYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (192,'Saenz Pena','Saenz Pena','AR ','SZQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (193,'San Antonio Oeste','San Antonio Oeste','AR ','OES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (194,'San Juan','San Juan','AR ','UAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (195,'San Julian','San Julian','AR ','ULA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (196,'San Luis','San Luis','AR ','LUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (197,'San Rafael','San Rafael','AR ','AFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (198,'Santa Cruz','Santa Cruz','AR ','RZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (199,'Santa Fe','Santa Fe','AR ','SFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (200,'Santa Rosa','Santa Rosa','AR ','RSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (201,'Santa Teresita','Santa Teresita','AR ','SST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (202,'Santiago Del Estero','Santiago Del Estero','AR ','SDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (203,'Sierra Grande','Sierra Grande','AR ','SGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (204,'Tandil','Tandil','AR ','TDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (205,'Tartagal','Tartagal','AR ','TTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (206,'Valcheta','Valcheta','AR ','VCF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (207,'Valle Del Conlara','Merlo','AR ','RLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (208,'Viedma','Viedma','AR ','VDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (209,'Villa Dolores','Villa Dolores','AR ','VDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (210,'Villa Gesell','Villa Gesell','AR ','VLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (211,'Villa Mercedes','Villa Mercedes','AR ','VME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (212,'Zapala','Zapala','AR ','APZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (213,'Gyoumri','Gyoumri','AM ','LWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (214,'Zvartnots','Yerevan','AM ','EVN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (215,'Reina Beatrix','Aruba','AW ','AUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (216,'Victoria River Downs','Victoria River Downs','AU ','VCD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (217,'Abingdon','Abingdon','AU ','ABG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (218,'Adelaide International Airport','Adelaide','AU ','ADL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (219,'Adelaide Keswick Rail','Adelaide','AU ','XHX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (220,'Agnew','Agnew','AU ','AGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (221,'Albany','Albany','AU ','ALH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (222,'Albury','Albury','AU ','ABX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (223,'Alexandria','Alexandria','AU ','AXL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (224,'Alice Springs','Alice Springs','AU ','ASP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (225,'Alice Springs Railway','Alice Springs','AU ','XHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (226,'Alpha','Alpha','AU ','ABH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (227,'Alroy Downs','Alroy Downs','AU ','AYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (228,'Alton Downs','Alton Downs','AU ','AWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (229,'Alyangula','Groote Eylandt','AU ','GTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (230,'Amata','Amata','AU ','AMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (231,'American River','American River','AU ','RCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (232,'Ammaroo','Ammaroo','AU ','AMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (233,'Andamooka','Andamooka','AU ','ADO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (234,'Angus Downs','Angus Downs','AU ','ANZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (235,'Anthony Lagoon','Anthony Lagoon','AU ','AYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (236,'Aramac','Aramac','AU ','AXC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (237,'Ararat','Ararat','AU ','ARY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (238,'Argyle','Argyle','AU ','GYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (239,'Argyle Downs','Argyle Downs','AU ','AGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (240,'Armidale','Armidale','AU ','ARM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (241,'Arrabury','Arrabury','AU ','AAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (242,'Augustus Downs','Augustus Downs','AU ','AUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (243,'Aurukun Mission','Aurukun Mission','AU ','AUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (244,'Austral Downs','Austral Downs','AU ','AWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (245,'Auvergne','Auvergne','AU ','AVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (246,'Avalon','Geelong','AU ','AVV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (247,'Ayr','Ayr','AU ','AYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (248,'Badu Island','Badu Island','AU ','BDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (249,'Bairnsdale','Bairnsdale','AU ','BSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (250,'Balcanoona','Balcanoona','AU ','LCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (251,'Balgo Hills','Balgo Hills','AU ','BQW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (252,'Ballina Byron Gateway','Ballina','AU ','BNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (253,'Balranald','Balranald','AU ','BZD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (254,'Bamaga Injinoo','Bamaga Queensland','AU ','ABM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (255,'Baniyala','Baniyala','AU ','BYX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (256,'Barcaldine','Barcaldine','AU ','BCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (257,'Barkly Downs','Barkly Downs','AU ','BKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (258,'Barrow Island','Barrow Island','AU ','BWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (259,'Batavia Downs','Batavia Downs','AU ','BVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (260,'Bathurst Island','Bathurst Island','AU ','BRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (261,'Beagle Bay','Beagle Bay','AU ','BEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (262,'Bedford Downs','Bedford Downs','AU ','BDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (263,'Bedourie','Bedourie','AU ','BEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (264,'Belburn','Belburn','AU ','BXF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (265,'Belmont','Newcastle','AU ','BEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (266,'Benalla','Benalla','AU ','BLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (267,'Bendigo','Bendigo','AU ','BXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (268,'Betoota','Betoota','AU ','BTX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (269,'Beverley Springs','Beverley Springs','AU ','BVZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (270,'Bickerton Island','Bickerton Island','AU ','BCZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (271,'Big Bell','Big Bell','AU ','BBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (272,'Billiluna','Billiluna','AU ','BIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (273,'Biloela','Biloela','AU ','ZBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (274,'Birdsville','Birdsville Queensland','AU ','BVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (275,'Bizant','Bizant','AU ','BZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (276,'Blackall','Blackall','AU ','BKQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (277,'Blackwater','Blackwater','AU ','BLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (278,'Bloomfield','Bloomfield','AU ','BFC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (279,'Boigu Island','Boigu Island','AU ','GIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (280,'Bollon','Bollon','AU ','BLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (281,'Bolwarra','Bolwarra','AU ','BCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (282,'Borroloola','Borroloola','AU ','BOX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (283,'Boulia','Boulia','AU ','BQL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (284,'Bourke','Bourke','AU ','BRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (285,'Bowen','Bowen','AU ','ZBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (286,'Brampton Island','Brampton Island','AU ','BMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (287,'Brewarrina','Brewarrina','AU ','BWQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (288,'Bright','Bright','AU ','BRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (289,'Brighton Downs','Brighton Downs','AU ','BHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (290,'Brisbane International','Brisbane','AU ','BNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (291,'Broken Hill','Broken Hill','AU ','BHQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (292,'Broome','Broome Western Australia','AU ','BME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (293,'Brunette Downs','Brunette Downs','AU ','BTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (294,'Bulimba','Bulimba','AU ','BIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (295,'Bunbury','Bunbury','AU ','BUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (296,'Bundaberg','Bundaberg','AU ','BDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (297,'Burketown','Burketown','AU ','BUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (298,'Burnie Wynyard','Burnie','AU ','BWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (299,'Bussellton','Bussellton','AU ','BQB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (300,'Caiguna','Caiguna','AU ','CGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (301,'Cairns','Cairns','AU ','CNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (302,'Caloundra','Caloundra','AU ','CUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (303,'Camden','Camden','AU ','CDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (304,'Camfield','Camfield','AU ','CFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (305,'Camooweal','Camooweal','AU ','CML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (306,'Canberra','Canberra','AU ','CBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (307,'Canobie','Canobie','AU ','CBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (308,'Cape Barren Island','Cape Barren Island','AU ','CBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (309,'Cape Flattery','Cape Flattery','AU ','CQP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (310,'Carlton Hill','Carlton Hill','AU ','CRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (311,'Carnarvon','Carnarvon','AU ','CVQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (312,'Carpentaria Downs','Carpentaria Downs','AU ','CFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (313,'Cattle Creek','Cattle Creek','AU ','CTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (314,'Ceduna','Ceduna','AU ','CED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (315,'Cessnock','Cessnock','AU ','CES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (316,'Charleville','Charleville','AU ','CTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (317,'Charters Towers','Charters Towers','AU ','CXT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (318,'Cherrabun','Cherrabun','AU ','CBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (319,'Cherribah','Cherribah','AU ','CRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (320,'Chillagoe','Chillagoe','AU ','LLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (321,'Chinchilla','Chinchilla','AU ','CCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (322,'Christmas Creek','Christmas Creek','AU ','CXQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (323,'City Heliport','Melbourne','AU ','KAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (324,'Clermont','Clermont','AU ','CMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (325,'Cleve','Cleve','AU ','CVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (326,'Clifton Hills','Clifton Hills','AU ','CFH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (327,'Cloncurry','Cloncurry','AU ','CNJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (328,'Cluny','Cluny','AU ','CZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (329,'Cobar','Cobar','AU ','CAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (330,'Coconut Island','Coconut Island','AU ','CNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (331,'Coen','Coen','AU ','CUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (332,'Coffs Harbour','Coffs Harbour','AU ','CFS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (333,'Colac','Colac','AU ','XCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (334,'Collarenebri','Collarenebri','AU ','CRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (335,'Collie','Collie','AU ','CIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (336,'Collinsville','Collinsville','AU ','KCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (337,'Condobolin','Condobolin','AU ','CBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (338,'Connellan','Ayers Rock','AU ','AYQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (339,'Coober Pedy','Coober Pedy','AU ','CPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (340,'Cooinda','Cooinda','AU ','CDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (341,'Cooktown','Cooktown','AU ','CTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (342,'Coolah','Coolah','AU ','CLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (343,'Coolawanyah','Coolawanyah','AU ','COY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (344,'Coolibah','Coolibah','AU ','COB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (345,'Cooma','Cooma','AU ','OOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (346,'Coonabarabran','Coonabarabran','AU ','COJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (347,'Coonamble','Coonamble','AU ','CNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (348,'Coorabie','Coorabie','AU ','CRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (349,'Cootamundra','Cootamundra','AU ','CMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (350,'Cordillo Downs','Cordillo Downs','AU ','ODL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (351,'Corowa','Corowa','AU ','CWW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (352,'Corryong','Corryong','AU ','CYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (353,'Cowarie','Cowarie','AU ','CWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (354,'Cowell','Cowell','AU ','CCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (355,'Cowra','Cowra','AU ','CWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (356,'Cresswell Downs','Cresswell Downs','AU ','CSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (357,'Croker Island','Croker Island','AU ','CKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (358,'Croydon','Croydon','AU ','CDQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (359,'Cudal','Cudal','AU ','CUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (360,'Cue','Cue','AU ','CUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (361,'Cunnamulla','Cunnamulla','AU ','CMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (362,'Dalby','Dalby','AU ','DBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (363,'Dalgaranga','Dalgaranga','AU ','DGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (364,'Daly River','Daly River','AU ','DVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (365,'Daly Waters','Daly Waters','AU ','DYW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (366,'Darnley Island','Darnley Island','AU ','NLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (367,'Darwin','Darwin','AU ','DRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (368,'Darwin Railway','Darwin','AU ','XJG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (369,'Dauan Island','Dauan Island','AU ','DAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (370,'Davenport Downs','Davenport Downs','AU ','DVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (371,'Daydream Is','Daydream Is','AU ','DDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (372,'Delissaville','Delissaville','AU ','DLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (78,'Catumbela','Catumbela','AO ','CBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (79,'Cazombo','Cazombo','AO ','CAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (80,'Chitato','Chitato','AO ','PGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (81,'Cuito Cuanavale','Cuito Cuanavale','AO ','CTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (82,'Dirico','Dirico','AO ','DRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (83,'Dundo','Dundo','AO ','DUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (84,'Gen V Deslandes','Benguela','AO ','BUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (85,'Huambo','Huambo','AO ','NOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (86,'Jamba','Jamba','AO ','JMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (87,'Kuito','Kuito','AO ','SVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (88,'Luau','Luau','AO ','UAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (89,'Lubango','Lubango','AO ','SDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (90,'Luena','Luena','AO ','LUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (91,'Lukapa','Lukapa','AO ','LBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (92,'Lumbala','Lumbala','AO ','GGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (93,'Luzamba','Luzamba','AO ','LZM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (94,'Malange','Malange','AO ','MEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (95,'Menongue','Menongue','AO ','SPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (96,'Namibe','Namibe','AO ','MSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (97,'Ndalatandos','Ndalatandos','AO ','NDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (98,'Negage','Negage','AO ','GXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (99,'Ngiva','Ngiva','AO ','NGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (100,'Ongiva','Ongiva','AO ','VPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (101,'Porto Amboim','Porto Amboim','AO ','PBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (102,'Saurimo','Saurimo','AO ','VHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (103,'Soyo','Soyo','AO ','SZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (104,'Sumbe','Sumbe','AO ','NDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (105,'Uige','Uige','AO ','UGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (106,'Waco Kungo','Waco Kungo','AO ','CEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (107,'Xangongo','Xangongo','AO ','XGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (108,'Wallblake','Anguilla','AI ','AXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (109,'Teniente R. Marsh Martin','Teniente R. Marsh Martin','AQ ','TNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (110,'Barbuda','Barbuda','AG ','BBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (111,'V. C. Bird Intl','St. John''s','AG ','ANU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (112,'Almirante Zar','Trelew','AR ','REL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (113,'Alto Rio Senguerr','Alto Rio Senguerr','AR ','ARR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (114,'Arpt. Jorge Newbery','Buenos Aires','AR ','AEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (115,'Benj Matienzo','Tucuman','AR ','TUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (116,'Brigadier Hector Ruiz','Coronel Suarez','AR ','CSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (117,'Caleta Olivia','Caleta Olivia','AR ','CVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (118,'Camba Punta','Corrientes','AR ','CNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (119,'Capitan Vicente Almando','La Rioja','AR ','IRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (120,'Carmen De Patagones','Carmen De Patagones','AR ','CPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (121,'Catamarca','Catamarca','AR ','CTC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (122,'Cataratas','Iguazu','AR ','IGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (123,'Caviahue','Caviahue','AR ','CVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (124,'Ceres','Ceres','AR ','CRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (125,'Chapelco','San Martin DeLos Andes','AR ','CPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (126,'Charata','Charata','AR ','CNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (127,'Clorinda','Clorinda','AR ','CLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (128,'Colonia Catriel','Colonia Catriel','AR ','CCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (129,'Colonia Sarmiento','Colonia Sarmiento','AR ','OLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (130,'Comandante','Bahia Blanca','AR ','BHI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (131,'Comodoro Rivadavia','Comodoro Rivadavia','AR ','CRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (132,'Concordia','Concordia','AR ','COC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (133,'Curuzu Cuatia','Curuzu Cuatia','AR ','UZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (134,'Cutral','Cutral','AR ','CUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (135,'El Bolson','El Bolson','AR ','EHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (136,'El Cadillal','Jujuy','AR ','JUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (137,'El Calafate','El Calafate','AR ','FTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (138,'El Maiten','El Maiten','AR ','EMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (139,'El Palomar','El Palomar','AR ','EPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (140,'El Plumerillo','Mendoza','AR ','MDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (141,'El Pucu','Formosa','AR ','FMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (142,'El Tehuelche','Puerto Madryn','AR ','PMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (143,'Eldorado','Eldorado','AR ','ELO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (144,'Esquel','Esquel','AR ','EQS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (145,'Ezeiza Ministro Pistarini','Buenos Aires','AR ','EZE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (146,'Fisherton','Rosario','AR ','ROS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (147,'Gen Belgrano','Salta','AR ','SLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (148,'General Pico','General Pico','AR ','GPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (149,'General Roca','General Roca','AR ','GNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (150,'General Villegas','General Villegas','AR ','VGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (151,'Gobernador Gregores','Gobernador Gregores','AR ','GGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (743,'Starcke','Starcke','AU ','SQP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (744,'Stawell','Stawell','AU ','SWC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (745,'Stephen Island','Stephen Island','AU ','STF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (746,'Strahan','Strahan','AU ','SRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (747,'Strathmore','Strathmore','AU ','STH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (748,'Streaky Bay','Streaky Bay','AU ','KBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (749,'Sturt Creek','Sturt Creek','AU ','SSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (750,'Surfers Paradise','Surfers Paradise','AU ','SFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (751,'Swan Hill','Swan Hill','AU ','SWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (752,'Sydney Bankstown','Sydney','AU ','BWU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (753,'Sydney West','Sydney','AU ','SWZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (754,'Tableland','Tableland','AU ','TBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (755,'Tamworth Regional Airport','Tamworth','AU ','TMW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (756,'Tanbar','Tanbar','AU ','TXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (757,'Tangalooma','Tangalooma','AU ','TAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (758,'Tara','Tara','AU ','XTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (759,'Tarcoola','Tarcoola','AU ','TAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (760,'Taree','Taree','AU ','TRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (761,'Taroom','Taroom','AU ','XTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (762,'Telfer','Telfer','AU ','TEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (763,'Temora','Temora','AU ','TEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (764,'Tennant Creek','Tennant Creek','AU ','TCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (765,'Tewantin','Tewantin','AU ','TWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (766,'Thangool','Thangool','AU ','THG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (767,'Thargomindah','Thargomindah','AU ','XTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (768,'Theda Station','Theda','AU ','TDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (769,'Theodore','Theodore','AU ','TDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (770,'Thylungra','Thylungra','AU ','TYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (771,'Tibooburra','Tibooburra','AU ','TYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (772,'Timber Creek','Timber Creek','AU ','TBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (773,'Tindal','Katherine','AU ','KTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (774,'Tobermorey','Tobermorey','AU ','TYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (775,'Tocumwal','Tocumwal','AU ','TCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (776,'Tom Price','Tom Price','AU ','TPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (777,'Toowoomba','Toowoomba','AU ','TWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (778,'Torwood','Torwood','AU ','TWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (779,'Townsville International','Townsville','AU ','TSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (780,'Tullamarine','Melbourne','AU ','MEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (781,'Tumut','Tumut','AU ','TUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (782,'Turkey Creek','Turkey Creek','AU ','TKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (783,'Useless Loop','Useless Loop','AU ','USL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (784,'Vanrook','Vanrook','AU ','VNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (785,'Wahai','Wahai','AU ','WBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (786,'Walcha','Walcha','AU ','WLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (787,'Walgett','Walgett','AU ','WGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (788,'Wallal','Wallal','AU ','WLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (789,'Wangaratta','Wangaratta','AU ','WGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (790,'Warraber Island','Sue Island','AU ','SYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (791,'Warracknabeal','Warracknabeal','AU ','WKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (792,'Warrawagine','Warrawagine','AU ','WRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (793,'Warrnambool','Warrnambool','AU ','WMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (794,'Warwick','Warwick','AU ','WAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (795,'Waterloo','Waterloo','AU ','WLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (796,'Waterport','Orpheus Island Resort','AU ','ORS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (797,'Wauchope','Wauchope','AU ','WAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (798,'Waverney','Waverney','AU ','WAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (799,'Wee Waa','Wee Waa','AU ','WEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (800,'Weipa','Weipa','AU ','WEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (801,'Welshpool','Welshpool','AU ','WHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (802,'West Wyalong','West Wyalong','AU ','WWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (803,'Whitsunday Airstrip','Airlie Beach','AU ','WSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (804,'Whitsunday Coast','Proserpine','AU ','PPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (805,'Whyalla','Whyalla','AU ','WYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (806,'Wilcannia','Wilcannia','AU ','WIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (807,'Williamtown','Newcastle','AU ','NTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (808,'Wilpena Pound','Hawker','AU ','HWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (809,'Wiluna','Wiluna','AU ','WUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (810,'Windarra','Windarra','AU ','WND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (811,'Windorah','Windorah','AU ','WNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (812,'Winton','Winton','AU ','WIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (813,'Wittenoom','Wittenoom','AU ','WIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (814,'Wollogorang','Wollogorang','AU ','WLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (815,'Wollongong','Wollongong','AU ','WOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (816,'Wondai','Wondai','AU ','WDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (817,'Wondoola','Wondoola','AU ','WON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (818,'Woodgreen','Woodgreen','AU ','WOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (819,'Woomera','Woomera','AU ','UMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (820,'Wrotham Park','Wrotham Park','AU ','WPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (821,'Wudinna','Wudinna','AU ','WUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (822,'Wyndham','Wyndham','AU ','WYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (823,'Yalata Mission','Yalata Mission','AU ','KYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (824,'Yalgoo','Yalgoo','AU ','YLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (825,'Yam Island','Yam Island','AU ','XMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (826,'Yandi','Yandicoogina','AU ','YNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (827,'Yangoonabie','Yangoonabie','AU ','KYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (828,'Yeelirrie','Yeelirrie','AU ','KYF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (829,'Yorke Island','Yorke Island','AU ','OKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (830,'Yorketown','Yorketown','AU ','ORR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (831,'Young','Young','AU ','NGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (832,'Yuendumu','Yuendumu','AU ','YUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (833,'Alpe Adria','Klagenfurt','AT ','KLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (834,'Blue Danube','Linz','AT ','LNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (835,'Hohenems','Hohenems','AT ','HOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (836,'Innsbruck-kranebitten','Innsbruck','AT ','INN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (837,'Kitzbuehl Railway','Kitzbuehl','AT ','XJS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (838,'Lauterach','Lauterach','AT ','QLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (839,'Railway Station','Bregenz','AT ','XGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (840,'Schwechat International','Vienna','AT ','VIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (841,'Suedbahnhof Rail','Vienna','AT ','XWC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (842,'Thalerhof','Graz','AT ','GRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (843,'Vienna Danubepier Hov','Vienna','AT ','VDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (844,'W. A. Mozart','Salzburg','AT ','SZG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (845,'Westbahnhof Rail','Vienna','AT ','XWW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (846,'Gyandzha','Gyandzha','AZ ','KVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (847,'Heydar Aliyev','Baku','AZ ','ZXT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (848,'Heydar Aliyev International','Baku','AZ ','GYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (849,'Nakhichevan','Nakhichevan','AZ ','NAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (850,'Paradise Island Seaplane Base','Nassau','BS ','WZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (851,'Andros Town','Andros Town','BS ','ASD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (852,'Auxiliary Airfield','Grand Bahama','BS ','GBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (853,'Cape Eleuthera','Cape Eleuthera','BS ','CEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (854,'Cat Cays','Cat Cays','BS ','CXY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (855,'Chub Cay','Chub Cay','BS ','CCZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (856,'Congo Town','Congo Town','BS ','COX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (857,'Crooked Island','Crooked Island','BS ','CRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (858,'Deadmans Cay','Long Island','BS ','LGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (859,'Duncan Town','Duncan Town','BS ','DCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (860,'Estate Airstrip','Stella Maris','BS ','SML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (861,'Exuma International','George Town','BS ','GGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (862,'Governors Harbour','Governors Harbour','BS ','GHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (863,'Grand Bahama International','Freeport','BS ','FPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (864,'Great Harbour','Great Harbour','BS ','GHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (865,'Green Turtle','Green Turtle','BS ','GTC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (866,'Harbour Island','Harbour Island','BS ','HBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (867,'Inagua','Inagua','BS ','IGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (868,'International','Bimini','BS ','BIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (869,'International','Marsh Harbour','BS ','MHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (870,'International','North Eleuthera','BS ','ELH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (871,'Mangrove Cay','Mangrove Cay','BS ','MAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (872,'Mastic Point','Mastic Point','BS ','MSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (873,'Mayaguana','Mayaguana','BS ','MYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (874,'Nassau International','Nassau','BS ','NAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (875,'New Bight','Cat Island','BS ','CAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (876,'New Bight','New Bight','BS ','NET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (877,'New Bright','The Bight','BS ','TBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (878,'North SPB','Bimini','BS ','NSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (879,'Paradise Island','Nassau','BS ','PID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (880,'Pitts Town','Pitts Town','BS ','PWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (881,'Powell Point','Powell Point','BS ','PPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (882,'Rum Cay','Rum Cay','BS ','RCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (883,'S Eleuthera','Rock Sound','BS ','RSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (884,'San Andros','San Andros','BS ','SAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (885,'San Salvador','San Salvador','BS ','ZSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (886,'South Andros','South Andros','BS ','TZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (887,'Spanish Wells','Spanish Wells','BS ','SWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (888,'Springpoint Arpt','Spring Point','BS ','AXP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (889,'Staniel Cay','Staniel Cay','BS ','TYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (890,'Treasure Cay','Treasure Cay Ibaco Islands','BS ','TCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (891,'West End','West End','BS ','WTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (892,'Bahrain International','Manama','BH ','BAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (893,'Muharraq','Muharraq','BH ','GBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (894,'Off Line Point','Manama','BH ','WGF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (895,'Barisal','Barisal','BD ','BZL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (896,'Comilla','Comilla','BD ','CLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (897,'Ishurdi','Ishurdi','BD ','IRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (898,'Jessore','Jessore','BD ','JSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (899,'Khulna','Khulna','BD ','KHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (900,'Osmani International','Sylhet','BD ','ZYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (901,'Patenga','Chittagong','BD ','CGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (902,'Rajshahi','Rajshahi','BD ','RJH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (903,'Rangpur','Rangpur','BD ','RAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (904,'Saidpur','Saidpur','BD ','SPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (905,'Sandwip','Sandwip','BD ','SDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (906,'Shamshernagar','Shamshernagar','BD ','ZHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (907,'Sirajganj','Sirajganj','BD ','SAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (908,'Thakurgaon','Thakurgaon','BD ','TKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (909,'Grantley Adams International','Bridgetown','BB ','BGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (910,'Brest','Brest','BY ','BQT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (911,'Gomel','Gomel','BY ','GME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (912,'Grodna','Grodna','BY ','GNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (913,'Minsk International 1','Minsk','BY ','MHP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (914,'Minsk International 2','Minsk','BY ','MSQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (915,'Mogilev','Mogilev','BY ','MVQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (916,'Vitebsk','Vitebsk','BY ','VTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (917,'Berchem Railway Stn.','Antwerp','BE ','ZYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (918,'Brussels Airport','Brussels','BE ','BRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (919,'Charleroi Brussels South','Brussels','BE ','CRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (920,'De Keyserlei Bus Stn.','Antwerp','BE ','ZAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (921,'Deurne','Antwerp','BE ','ANR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (922,'Ghent','Ghent','BE ','GNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (923,'"Guillemins',' Raiway StnLiege','BE ','XHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (924,'Knokke/Het Zoute','Knokke/Het Zoute','BE ','KNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (925,'Kortrijk','Kortrijk','BE ','KJK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (926,'Liege Airport','Liege','BE ','LGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (927,'Ostend/Bruges International Airport','Ostend','BE ','OST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (928,'Belmopan','Belmopan','BZ ','BCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (929,'Big Creek','Big Creek','BZ ','BGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (930,'Caye Caulker','Caye Caulker','BZ ','CUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (931,'Caye Chapel','Caye Chapel','BZ ','CYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (932,'Corozal','Corozal','BZ ','CZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (933,'Dangriga','Dangriga','BZ ','DGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (934,'Independence','Independence','BZ ','INB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (935,'Manatee','Manatee','BZ ','MZE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (936,'Matthew Spain','San Ignacio','BZ ','SQS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (937,'Melinda','Melinda','BZ ','MDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (938,'Municipal','Belize City','BZ ','TZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (939,'Orange Walk','Orange Walk','BZ ','ORZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (940,'Philip S.W.Goldson Int','Belize City','BZ ','BZE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (941,'Placencia','Placencia','BZ ','PLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (942,'Punta Gorda','Punta Gorda','BZ ','PND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (943,'San Pedro','San Pedro','BZ ','SPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (944,'Santa Cruz','Santa Cruz','BZ ','STU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (945,'Sartaneja','Sartaneja','BZ ','SJX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (946,'Silver Creek','Silver Creek','BZ ','SVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (947,'Cotonou','Cotonou','BJ ','COO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (948,'Djougou','Djougou','BJ ','DJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (949,'Kandi','Kandi','BJ ','KDC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (950,'Natitingou','Natitingou','BJ ','NAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (951,'Parakou','Parakou','BJ ','PKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (952,'Save','Save','BJ ','SVF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (953,'Kindley Field','Bermuda','BM ','BDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (954,'NAS','Bermuda','BM ','NWU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (955,'Paro','Paro','BT ','PBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (956,'Apolo','Apolo','BO ','APB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (957,'Ascension','Ascension','BO ','ASC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (958,'Bermejo','Bermejo','BO ','BJO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (959,'Camiri','Camiri','BO ','CAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (960,'Capitan G Q Guardia','San Borja','BO ','SRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (961,'Concepcion','Concepcion','BO ','CEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (962,'E. Beltram','Cobija','BO ','CIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (963,'El Alto','La Paz','BO ','LPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (373,'Delta Downs','Delta Downs','AU ','DDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (374,'Denham','Denham','AU ','DNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (375,'Deniliquin','Deniliquin','AU ','DNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (376,'Derby','Derby','AU ','DRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (377,'Devonport','Devonport','AU ','DPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (378,'Diamantina Lakes','Diamantina Lakes','AU ','DYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (379,'Dirranbandi','Dirranbandi','AU ','DRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (380,'Dixie','Dixie','AU ','DXD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (381,'Docker River','Docker River','AU ','DKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (382,'Dongara','Dongara','AU ','DOX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (383,'Doomadgee','Doomadgee','AU ','DMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (384,'Doongan','Doongan','AU ','DNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (385,'Dorunda Station','Dorunda Station','AU ','DRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (386,'Drumduff','Drumduff','AU ','DFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (387,'Dubbo','Dubbo','AU ','DBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (388,'Dulkaninna','Dulkaninna','AU ','DLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (389,'Dunbar','Dunbar','AU ','DNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (390,'Dunk Island','Dunk Island','AU ','DKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (391,'Dunwich','Stradbroke Island','AU ','SRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (392,'Durham Downs','Durham Downs','AU ','DHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (393,'Durrie','Durrie','AU ','DRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (394,'Dysart','Dysart','AU ','DYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (395,'Echuca','Echuca','AU ','ECH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (396,'Edward River','Edward River','AU ','EDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (397,'Einasleigh','Einasleigh','AU ','EIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (398,'Elcho Island','Elcho Island','AU ','ELC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (399,'Elkedra','Elkedra','AU ','EKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (400,'Emerald','Emerald','AU ','EMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (401,'Eneabba West','Eneabba West','AU ','ENB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (402,'Erldunda','Erldunda','AU ','EDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (403,'Ernabella','Ernabella','AU ','ERB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (404,'Esperance','Esperance','AU ','EPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (405,'Essendon','Melbourne','AU ','MEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (406,'Etadunna','Etadunna','AU ','ETD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (407,'Eucla','Eucla','AU ','EUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (408,'Eva Downs','Eva Downs','AU ','EVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (409,'Evans Head','Evans Head','AU ','EVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (410,'Exmouth Gulf','Exmouth Gulf','AU ','EXM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (411,'Falls Creek','Falls Creek','AU ','FLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (412,'Finke','Finke','AU ','FIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (413,'Finley','Finley','AU ','FLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (414,'Fitzroy Crossing','Fitzroy Crossing','AU ','FIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (415,'Flinders Island','Flinders Island','AU ','FLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (416,'Flora Valey','Flora Valley','AU ','FVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (417,'Forbes','Forbes','AU ','FRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (418,'Forrest','Forrest','AU ','FOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (419,'Forrest Hill','Wagga Wagga','AU ','WGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (420,'Forrest River Airport','Forrest River','AU ','FVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (421,'Forster','Forster','AU ','FOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (422,'Fossil Downs','Fossil Downs','AU ','FSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (423,'Fraser Island','Orchid Beach','AU ','OKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (424,'Gamboola','Gamboola','AU ','GBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (425,'Garden Point','Garden Point','AU ','GPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (426,'Gascoyne Junction','Gascoyne Junction','AU ','GSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (427,'Gayndah','Gayndah','AU ','GAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (428,'Geelong','Geelong','AU ','GEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (429,'Georgetown','Georgetown','AU ','GTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (430,'Geraldton','Geraldton','AU ','GET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (431,'Gibb River','Gibb River','AU ','GBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (432,'Gladstone','Gladstone','AU ','GLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (433,'Glen Innes','Glen Innes','AU ','GLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (434,'Glengyle','Glengyle','AU ','GLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (435,'Glenormiston','Glenormiston','AU ','GLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (436,'Gold Coast','Gold Coast','AU ','OOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (437,'Goldsworthy','Goldsworthy','AU ','GLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (438,'Goondiwindi','Goondiwindi','AU ','GOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (439,'Gordon Downs','Gordon Downs','AU ','GDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (440,'Gosford','Gosford','AU ','GOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (441,'Goulburn','Goulburn','AU ','GUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (442,'Goulburn Island','Goulburn Island','AU ','GBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (443,'Grafton','Grafton','AU ','GFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (444,'Granites','Granites','AU ','GTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (445,'Great Keppel Island','Great Keppel Island','AU ','GKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (446,'Greenvale','Greenvale','AU ','GVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (447,'Gregory Downs','Gregory Downs','AU ','GGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (448,'Grenfell','Grenfell','AU ','GFE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (449,'Griffith','Griffith','AU ','GFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (450,'Gunnedah','Gunnedah','AU ','GUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (451,'Gympie','Gympie','AU ','GYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (452,'Halls Creek','Halls Creek','AU ','HCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (453,'Hamilton','Hamilton','AU ','HLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (454,'Hamilton Island','Hamilton Island','AU ','HTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (455,'Hamilton/Proserpine','Peppers Palm Bay','AU ','PBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (456,'Hay','Hay','AU ','HXX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (457,'Hayman Island','Hayman Island','AU ','HIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (458,'Headingly','Headingly','AU ','HIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (459,'Heathlands','Heathlands','AU ','HAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (460,'Helenvale','Helenvale','AU ','HLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (461,'Heliport','Fremantle','AU ','JFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (462,'Heliport','Heron Island','AU ','HRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (463,'Henbury','Henbury','AU ','HRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (464,'Hermannsburg','Hermannsburg','AU ','HMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (465,'Hervey Bay','Hervey Bay','AU ','HVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (466,'Highbury','Highbury','AU ','HIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (467,'Hillside','Hillside','AU ','HLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (468,'Hinchinbrook Island','Hinchinbrook Island','AU ','HNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (469,'Hobart','Hobart','AU ','HBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (470,'Hook Island','Hook Island','AU ','HIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (471,'Hooker Creek','Hooker Creek','AU ','HOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (472,'Hope Vale','Hope Vale','AU ','HPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (473,'Hopetoun','Hopetoun','AU ','HTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (474,'Horn Island','Horn Island','AU ','HID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (475,'Horsham','Horsham','AU ','HSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (476,'Hughenden','Hughenden','AU ','HGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (477,'Humbert River','Humbert River','AU ','HUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (478,'Iffley','Iffley','AU ','IFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (479,'Indulkana','Indulkana','AU ','IDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (480,'Ingham','Ingham','AU ','IGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (481,'Injune','Injune','AU ','INJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (482,'Inkerman','Inkerman','AU ','IKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (483,'Innamincka','Innamincka','AU ','INM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (484,'Innisfail','Innisfail','AU ','IFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (485,'Inverell','Inverell','AU ','IVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (486,'Inverway','Inverway','AU ','IVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (487,'Isisford','Isisford','AU ','ISI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (488,'Jabiru','Jabiru','AU ','JAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (489,'Jandakot','Perth','AU ','JAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (490,'Julia Creek','Julia Creek','AU ','JCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (491,'Jundah','Jundah','AU ','JUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (492,'Jurien Bay','Jurien Bay','AUS','JUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (493,'Kalbarri','Kalbarri','AU ','KAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (494,'Kalgoorlie','Kalgoorlie','AU ','KGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (495,'Kalkgurung','Wave Hill','AU ','WAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (496,'Kalkurung','Kalkurung','AU ','KFG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (497,'Kalpowar','Kalpowar','AU ','KPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (498,'Kalumburu','Kalumburu','AU ','UBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (499,'Kamaran Downs','Kamaran Downs','AU ','KDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (500,'Kambalda','Kambalda','AU ','KDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (501,'Kamileroi','Kamileroi','AU ','KML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (502,'Karratha','Karratha','AU ','KTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (503,'Karumba','Karumba','AU ','KRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (504,'Katanning','Katanning','AU ','KNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (505,'Kempsey','Kempsey','AU ','KPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (506,'Kerang','Kerang','AU ','KRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (507,'Kimberley Downs','Kimberley Downs','AU ','KBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (508,'King Island','King Island Tasmania','AU ','KNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (509,'Kingaroy','Kingaroy Queensland','AU ','KGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (510,'Kings Canyon','Kings Canyon','AU ','KBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (511,'Kings Creek Station','Kings Creek Station','AU ','KCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (512,'Kingscote','Kingscote','AU ','KGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (513,'Kingsford Smith','Sydney','AU ','SYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (514,'Kirkimbie','Kirkimbie','AU ','KBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (515,'Koolatah','Koolatah','AU ','KOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (516,'Koolburra','Koolburra','AU ','KKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (517,'Koonibba','Koonibba','AU ','KQB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (518,'Kowanyama','Kowanyama','AU ','KWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (519,'Kubin Island','Kubin Island','AU ','KUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (520,'Kulgera','Kulgera','AU ','KGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (521,'Kununurra','Kununurra','AU ','KNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (522,'Kurundi','Kurundi','AU ','KRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (523,'La Trobe Regional','Traralgon','AU ','TGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (524,'Lady Elliot Island','Lady Elliot Island','AU ','LYT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (525,'Lake Evella','Lake Evella','AU ','LEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (526,'Lake Gregory','Lake Gregory','AU ','LGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (527,'Lake Nash','Lake Nash','AU ','LNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (528,'Lakefield','Lakefield','AU ','LFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (529,'Lakeland Downs','Lakeland Downs','AU ','LKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (530,'Lansdowne','Lansdowne','AU ','LDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (531,'Latrobe','Latrobe','AU ','LTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (532,'Launceston','Launceston','AU ','LST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (533,'Laura','Laura','AU ','LUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (534,'Laura Station','Laura Station','AU ','LUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (535,'Laverton','Laverton','AU ','LVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (536,'Lawn Hill','Lawn Hill','AU ','LWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (537,'Learmonth','Learmonth','AU ','LEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (538,'Leigh Creek','Leigh Creek','AU ','LGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (539,'Leinster','Leinster','AU ','LER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (540,'Leonora','Leonora','AU ','LNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (541,'Lightning Ridge','Lightning Ridge','AU ','LHG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (542,'Lilydale Airport','Lilydale','AU ','LLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (543,'Limbunya','Limbunya','AU ','LIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (544,'Linda Downs','Linda Downs','AU ','LLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (545,'Lindeman Island','Lindeman Island','AU ','LDC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (546,'Lismore','Lismore','AU ','LSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (547,'Lissadell','Lissadell','AU ','LLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (548,'Lizard Island','Lizard Island','AU ','LZR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (549,'Lock','Lock','AU ','LOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (550,'Lockhart River','Lockhart River','AU ','IRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (551,'Long Island','Long Island','AU ','HAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (552,'Longreach','Longreach','AU ','LRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (553,'Lord Howe Island','Lord Howe Island','AU ','LDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (554,'Lorraine','Lorraine','AU ','LOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (555,'Lotusvale','Lotusvale','AU ','LTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (556,'Lyndhurst','Lyndhurst','AU ','LTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (557,'Mabuiag Island','Mabuiag Island','AU ','UBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (558,'Macdonald Downs','Macdonald Downs','AU ','MNW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (559,'Mackay','Mackay','AU ','MKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (560,'Macksville','Macksville','AU ','MVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (561,'Macmahon Camp 4','Macmahon Camp 4','AU ','MHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (562,'Mainoru','Mainoru','AU ','MIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (563,'Maitland','Maitland','AU ','MTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (564,'Mallacoota','Mallacoota','AU ','XMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (565,'Mandora','Mandora','AU ','MQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (566,'Maningrida','Maningrida','AU ','MNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (567,'Manjimup','Manjimup','AU ','MJP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (568,'Manners Creek','Manners Creek','AU ','MFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (569,'Marble Bar','Marble Bar','AU ','MBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (570,'Mareeba','Mareeba','AU ','MRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (571,'Margaret River','Margaret River','AU ','MQZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (572,'Margaret River','Margaret River Station','AU ','MGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (573,'Marion Downs','Marion Downs','AU ','MXD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (574,'Marla','Marla','AU ','MRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (575,'Maroochydore','Sunshine Coast','AU ','MCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (576,'Marqua','Marqua','AU ','MQE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (577,'Marree','Marree','AU ','RRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (578,'Maryborough','Maryborough','AU ','MBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (579,'Mcarthur River','Mcarthur River','AU ','MCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (580,'Meekatharra','Meekatharra','AU ','MKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (581,'Merimbula','Merimbula','AU ','MIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (582,'Merluna','Merluna','AU ','MLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (583,'Merty','Merty','AU ','RTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (584,'Middlemount','Middlemount','AU ','MMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (585,'Mildura','Mildura','AU ','MQL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (586,'Milingimbi','Milingimbi','AU ','MGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (587,'Millicent','Millicent','AU ','MLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (588,'Miners Lake','Miners Lake','AU ','MRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (589,'Minlaton','Minlaton','AU ','XML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (590,'Minnipa','Minnipa','AU ','MIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (591,'Miranda Downs','Miranda Downs','AU ','MWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (592,'Mitchell','Mitchell','AU ','MTQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (593,'Mitchell Plateau','Mitchell Plateau','AU ','MIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (594,'Mitchell River','Mitchell River','AU ','MXQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (595,'Mittiebah','Mittiebah','AU ','MIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (596,'Monkira','Monkira','AU ','ONR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (597,'Monto','Monto','AU ','MNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (598,'Moolawatana','Moolawatana','AU ','MWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (599,'Moomba','Moomba','AU ','MOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (600,'Moorabbin','Mentone','AU ','MBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (601,'Mooraberree','Mooraberree','AU ','OOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (602,'Moranbah','Moranbah','AU ','MOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (603,'Morawa','Morawa','AU ','MWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (604,'Moree','Moree','AU ','MRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (605,'Moreton','Moreton','AU ','MET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (606,'Morney','Morney','AU ','OXY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (607,'Mornington','Mornington','AU ','ONG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (608,'Moroak','Moroak','AU ','MRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (609,'Moruya','Moruya','AU ','MYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (610,'Mount Buffalo','Mount Buffalo','AU ','MBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (611,'Mount Full Stop','Mount Full Stop','AU ','MFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (612,'Mount Gambier','Mount Gambier','AU ','MGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (613,'Mount Gunson','Mount Gunson','AU ','GSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (614,'Mount Hotham','Mount Hotham','AU ','MHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (615,'Mount House','Mount House','AU ','MHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (616,'Mount Isa','Mount Isa','AU ','ISA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (617,'Mount Keith','Mount Keith','AU ','WME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (618,'Mount Magnet','Mount Magnet','AU ','MMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (619,'Mount Swan','Mount Swan','AU ','MSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (620,'Mountain Valley','Mountain Valley','AU ','MNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (621,'Mt Barnett','Mt Barnett','AU ','MBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (622,'Mt Cavenagh','Mt Cavenagh','AU ','MKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (623,'Mt Sandford','Mt Sandford','AU ','MTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (624,'Muccan','Muccan','AU ','MUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (625,'Mudgee','Mudgee','AU ','DGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (626,'Mulga Park','Mulga Park','AU ','MUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (627,'Mulka','Mulka','AU ','MVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (628,'Mullewa','Mullewa','AU ','MXU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (629,'Mungeranie','Mungeranie','AU ','MNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (630,'Murray Island','Murray Island','AU ','MYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (631,'Musgrave','Musgrave','AU ','MVU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (632,'Muttaburra','Muttaburra','AU ','UTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (633,'Myroodah','Myroodah','AU ','MYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (634,'Nambour','Nambour','AU ','NBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (635,'Nambucca Heads','Nambucca Heads','AU ','NBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (636,'Nappa Merry','Nappa Merry','AU ','NMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (637,'Napperby','Napperby','AU ','NPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (638,'Naracoorte','Naracoorte','AU ','NAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (639,'Narrabri','Narrabri','AU ','NAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (640,'Narrandera','Narrandera','AU ','NRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (641,'Narrogin','Narrogin','AU ','NRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (642,'New Moon','New Moon','AU ','NMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (643,'Newman','Newman','AU ','ZNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (644,'Newry','Newry','AU ','NRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (645,'Ngukurr','Ngukurr','AU ','RPM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (646,'Nhulunbuy','Gove','AU ','GOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (647,'Nicholson','Nicholson','AU ','NLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (648,'Noonkanbah','Noonkanbah','AU ','NKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (649,'Noosa','Noosa','AU ','NSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (650,'Noosaville','Noosaville','AU ','NSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (651,'Normanton','Normanton','AU ','NTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (652,'Norseman','Norseman','AU ','NSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (653,'Nowra','Nowra','AU ','NOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (654,'Nullagine','Nullagine','AU ','NLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (655,'Nullarbor','Nullarbor','AU ','NUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (656,'Numbulwar','Numbulwar','AU ','NUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (657,'Nutwood Downs','Nutwood Downs','AU ','UTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (658,'Nyngan','Nyngan','AU ','NYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (659,'Oakey','Oakey','AU ','OKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (660,'Oban','Oban','AU ','OBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (661,'Oenpelli','Oenpelli','AU ','OPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (662,'Off Line Point','Manly','AU ','WGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (663,'Off line Point','Rail','AU ','XZX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (664,'Olympic Dam','Olympic Dam','AU ','OLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (665,'Onslow','Onslow','AU ','ONS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (666,'Oodnadatta','Oodnadatta','AU ','ODD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (667,'Orbost','Orbost','AU ','RBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (668,'Ord River','Ord River','AU ','ODR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (669,'Orientos','Orientos','AU ','OXO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (670,'Ouyen','Ouyen','AU ','OYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (671,'Palm Beach SPB','Sydney','AU ','LBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (672,'Palm Island','Palm Island','AU ','PMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (673,'Pandie Pandie','Pandie Pandie','AU ','PDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (674,'Paraburdoo','Paraburdoo','AU ','PBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (675,'Pardoo','Pardoo','AU ','PRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (676,'Parkes','Parkes','AU ','PKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (677,'Parndana','Parndana','AU ','PDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (678,'Penneshaw','Penneshaw','AU ','PEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (679,'Penong','Penong','AU ','PEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (680,'Peppimenarti','Peppimenarti','AU ','PEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (681,'Perth International','Perth','AU ','PER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (682,'Port Augusta','Port Augusta','AU ','PUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (683,'Port Douglas','Port Douglas','AU ','PTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (684,'Port Hedland','Port Hedland','AU ','PHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (685,'Port Hunter','Port Hunter','AU ','PHJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (686,'Port Keats','Port Keats','AU ','PKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (687,'Port Lincoln','Port Lincoln','AU ','PLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (688,'Port Macquarie','Port Macquarie','AU ','PQQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (689,'Port Pirie','Port Pirie','AU ','PPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (690,'Port Stephens','Port Stephens','AU ','PTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (691,'Portland','Portland','AU ','PTJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (692,'Queenstown','Queenstown','AU ','UEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (693,'Quilpie','Quilpie','AU ','ULP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (694,'Quirindi','Quirindi','AU ','UIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (695,'Raglan','Bathurst','AU ','BHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (696,'Ramingining','Ramingining','AU ','RAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (697,'Ravensthorpe','Ravensthorpe','AU ','RVT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (698,'Renmark','Renmark','AU ','RMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (699,'Richmond','Richmond','AU ','RCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (700,'Richmond AFB','Richmond','AU ','XRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (701,'Robinhood','Robinhood','AU ','ROH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (702,'Robinson River','Robinson River','AU ','RRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (703,'Robinvale','Robinvale','AU ','RBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (704,'Rockhampton','Rockhampton','AU ','ROK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (705,'Rockhampton Downs','Rockhampton Downs','AU ','RDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (706,'Roebourne','Roebourne','AU ','RBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (707,'Rokeby','Rokeby','AU ','RKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (708,'Roma','Roma','AU ','RMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (709,'Roper Bar','Roper Bar','AU ','RPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (710,'Roper Valley','Roper Valley','AU ','RPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (711,'Rose Bay','Sydney','AU ','RSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (712,'Roseberth','Roseberth','AU ','RSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (713,'Rosella Plains','Rosella Plains','AU ','RLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (714,'Rottnest Island','Rottnest Island','AU ','RTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (715,'Roy Hill','Roy Hill','AU ','RHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (716,'Rutland Plains','Rutland Plains','AU ','RTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (717,'Saibai Island','Saibai Island','AU ','SBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (718,'Sale','Sale','AU ','SXE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (719,'Sandringham','Sandringham','AU ','SRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (720,'Sandstone','Sandstone','AU ','NDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (721,'Scone','Scone','AU ','NSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (722,'Shark Bay','Monkey Mia','AU ','MJK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (723,'Shaw River','Shaw River','AU ','SWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (724,'Shay Gap','Shay Gap','AU ','SGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (725,'Shepparton','Shepparton','AU ','SHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (726,'Shute Harbour H/P','Shute Harbour','AU ','JHQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (727,'Silver Plains','Silver Plains','AU ','SSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (728,'Singleton','Singleton','AU ','SIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (729,'Smith Point','Smith Point','AU ','SHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (730,'Smithton','Smithton','AU ','SIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (731,'Snake Bay','Snake Bay','AU ','SNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (732,'South Galway','South Galway','AU ','ZGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (733,'South Molle Island','South Molle Island','AU ','SOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (734,'Southern Cross','Southern Cross','AU ','SQC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (735,'Southport','Southport','AU ','SHQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (736,'Spring Creek','Spring Creek','AU ','SCG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (737,'Springhill','Orange','AU ','OAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (738,'Springvale','Springvale','AU ','KSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (739,'Springvale','Springvale','AU ','ZVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (740,'St George','St George','AU ','SGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (741,'St Helens','St Helens','AU ','HLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (742,'Stanthorpe','Stanthorpe','AU ','SNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (964,'El Trompillo','Santa Cruz','BO ','SRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (965,'Gen Buech','Riberalta','BO ','RIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (966,'Guayaramerin','Guayaramerin','BO ','GYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (967,'J Wilsterman','Cochabamba','BO ','CBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (968,'Juana Azurduy de Padilla','Sucre','BO ','SRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (969,'Magdalena','Magdalena','BO ','MGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (970,'Monteagudo','Monteagudo','BO ','MHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (971,'Oruro','Oruro','BO ','ORU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (972,'Potosi','Potosi','BO ','POI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (973,'Puerto Rico','Puerto Rico','BO ','PUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (974,'Puerto Suarez','Puerto Suarez','BO ','PSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (975,'Reyes','Reyes','BO ','REY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (976,'Robore','Robore','BO ','RBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (977,'Rurrenabaque','Rurrenabaque','BO ','RBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (978,'San Ignacio De M','San Ignacio De M','BO ','SNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (979,'San Ignacio De Velasco','San Ignacio De Velasco','BO ','SNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (980,'San Javier','San Javier','BO ','SJV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (981,'San Joaquin','San Joaquin','BO ','SJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (982,'San Jose','San Jose','BO ','SJS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (983,'San Matias','San Matias','BO ','MQK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (984,'San Ramon','San Ramon','BO ','SRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (985,'Santa Rosa','Santa Rosa','BO ','SRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (986,'Tarija','Tarija','BO ','TJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (987,'Trinidad','Trinidad','BO ','TDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (988,'Vallegrande','Vallegrande','BO ','VAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (989,'Villamontes','Villamontes','BO ','VLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (990,'Viru Viru Intl','Santa Cruz','BO ','VVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (991,'Yacuiba','Yacuiba','BO ','BYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (992,'Yacuma','Santa Ana','BO ','SBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (993,'Banja Luka','Banja Luka','BA ','BNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (994,'Mostar','Mostar','BA ','OMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (995,'Sarajevo','Sarajevo','BA ','SJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (996,'Tuzla International','Tuzla','BA ','TZL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (997,'Francistown','Francistown','BW ','FRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (998,'Ghanzi','Ghanzi','BW ','GNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (999,'Hukuntsi','Hukuntsi','BW ','HUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1000,'Jwaneng','Jwaneng','BW ','JWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1001,'Kasane','Kasane','BW ','BBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1002,'Khwai River Lodge','Khwai River Lodge','BW ','KHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1003,'Limpopo Valley','Tuli Block','BW ','TLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1004,'Lobatse','Lobatse','BW ','LOQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1005,'Maun','Maun','BW ','MUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1006,'Orapa','Orapa','BW ','ORP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1007,'Savuti','Savuti','BW ','SVT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1008,'Selebi-Phikwe','Selebi-Phikwe','BW ','PKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1009,'Shakawe','Shakawe','BW ','SWX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1010,'Sir Seretse Khama International','Gaborone','BW ','GBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1011,'Suapan','Suapan','BW ','SXN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1012,'Tsabong','Tsabong','BW ','TBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1013,'Luis Eduardo Magalhaes','Salvador Bahia','BR ','SSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1014,'Adhemar De Barros','Presidente Prudente','BR ','PPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1015,'Aeroporto Internacional Guarulhos','Sao Paulo','BR ','GRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1016,'Aeroporto Max Feffer','Mucuri','BR ','MVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1017,'Aeroporto Municipal Chapeco','Chapeco','BR ','XAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1018,'Afonso Pena International Airport','Curitiba','BR ','CWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1019,'Airport Chafei Amsei','Barretos','BR ','BAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1020,'Airport Cmdt. Gustavo Kraemer','Bage','BR ','BGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1021,'Alenquer','Alenquer','BR ','ALT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1022,'Almenara','Almenara','BR ','AMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1023,'Alta Floresta','Alta Floresta','BR ','AFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1024,'Altamira','Altamira','BR ','ATM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1025,'Alto Parnaiba','Alto Parnaiba','BR ','APY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1026,'Anapolis','Anapolis','BR ','APS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1027,'Apucarana','Apucarana','BR ','APU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1028,'Aracatuba','Aracatuba','BR ','ARU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1029,'Aragarcas','Aragarcas','BR ','ARS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1030,'Araguaina','Araguaina','BR ','AUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1031,'Arapiraca','Arapiraca','BR ','APQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1032,'Arapongas','Arapongas','BR ','APX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1033,'Arapoti','Arapoti','BR ','AAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1034,'Araraquara','Araraquara','BR ','AQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1035,'Araxa','Araxa','BR ','AAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1036,'Ariquemes','Ariquemes','BR ','AQM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1110,'Dos Galpoes','Livramento','BR ','LVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1111,'Dourados','Dourados','BR ','DOU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1112,'Dr Gastao Vidigal','Marilia','BR ','MII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1113,'Edu Chaves','Paranavai','BR ','PVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1114,'Eduardo Gomes','Ilheus','BR ','IOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1115,'Eduardo Gomes','Santarem','BR ','STM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1116,'Eduardo Gomes','Uberlandia','BR ','UDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1117,'Eduardo Gomes Intl','Manaus','BR ','MAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1118,'Eirunepe','Eirunepe','BR ','ERN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1119,'Ernesto Geisel','Umuarama','BR ','UMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1120,'Ernesto Pochler','Urubupunga','BR ','URB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1121,'Espinosa','Espinosa','BR ','ESI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1122,'Eurico Sales','Vitoria','BR ','VIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1123,'Federal','Alegrete','BR ','ALQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1124,'Federal','Pelotas','BR ','PET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1125,'Feijo','Feijo','BR ','FEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1126,'Feira De Santana','Feira De Santana','BR ','FEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1127,'Fernando De Noronha','Fernando De Noronha','BR ','FEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1128,'Franca','Franca','BR ','FRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1129,'Francisco Beltrao','Francisco Beltrao','BR ','FBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1130,'Francisco De Assis','Juiz De Fora','BR ','JDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1131,'Galeão–antonio Carlos Jobim International Airport','Rio De Janeiro','BR ','GIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1132,'Governador Jorge Teixeira','Porto Velho','BR ','PVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1133,'Governador Valadares','Governador Valadares','BR ','GVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1134,'Gravatai','Gravatai','BR ','GCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1135,'Guadalupe','Guadalupe','BR ','GDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1136,'Guajara-Mirim','Guajara-Mirim','BR ','GJM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1137,'Guanambi','Guanambi','BR ','GNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1138,'Guarapari','Guarapari','BR ','GUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1139,'Guararapes Intl','Recife','BR ','REC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1140,'Guaratingueta','Guaratingueta','BR ','GUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1141,'Guimaraes','Guimaraes','BR ','GMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1142,'Gurupi','Gurupi','BR ','GRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1143,'Helmuth Baungartem','Lontras','BR ','LOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1144,'Hercilio Luz','Florianopolis','BR ','FLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1145,'Hidroeletrica','Itumbiara','BR ','ITR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1146,'Horizontina','Horizontina','BR ','HRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1147,'Ilha Solteira','Ilha Solteira','BR ','ILB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1148,'Imperatriz','Imperatriz','BR ','IMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1149,'Internacional','Macapa','BR ','MCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1150,'Internacional','Petrolina','BR ','PNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1151,'Internacional','Tabatinga','BR ','TBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1152,'International','Campinas','BR ','CPQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1153,'International','Ponta Pora','BR ','PMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1154,'Intl. Airport Campo Grande','Campo Grande','BR ','CGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1155,'Intl. Airport Corumba','Corumba','BR ','CMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1156,'Intl. Airpt. Cruzeiro Do Sul','Cruzeiro Do Sul','BR ','CZS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1157,'Intl. Airpt. Marechal Rondon','Cuiaba','BR ','CGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1158,'Ipiau','Ipiau','BR ','IPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1159,'Ipiranga','Ipiranga','BR ','IPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1160,'Irece','Irece','BR ','IRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1161,'Itabuna','Itabuna','BR ','ITN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1162,'Itacoatiara','Itacoatiara','BR ','ITA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1163,'Itaituba','Itaituba','BR ','ITB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1164,'Itambacuri','Itambacuri','BR ','ITI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1165,'Itaperuna','Itaperuna','BR ','ITP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1166,'Itaqui','Itaqui','BR ','ITQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1167,'Itauba','Itauba','BR ','AUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1168,'Itubera','Itubera','BR ','ITE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1169,'J. Batista Bos Filho Airport','Ijui','BR ','IJU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1170,'Jacareacanga','Jacareacanga','BR ','JCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1171,'Jacobina','Jacobina','BR ','JCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1172,'Januaria','Januaria','BR ','JNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1173,'Jatai','Jatai','BR ','JTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1174,'Jequie','Jequie','BR ','JEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1175,'Ji-Parana','Ji-Parana','BR ','JPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1176,'Joacaba','Joacaba','BR ','JCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1177,'Joao Suassuna','Campina Grande','BR ','CPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1178,'Juina','Juina','BR ','JIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1179,'Juruena','Juruena','BR ','JRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1180,'Labrea','Labrea','BR ','LBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1181,'Lages','Lages','BR ','LAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1182,'Lauro Carneiro De Loyola','Joinville','BR ','JOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1183,'Leite Lopes','Ribeirao Preto','BR ','RAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1184,'Leopoldina','Leopoldina','BR ','LEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1185,'Lins','Lins','BR ','LIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1186,'Londrina','Londrina','BR ','LDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1187,'Macae','Macae','BR ','MEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1188,'Maj. Brig. Trompowsky','Varginha','BR ','VAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1189,'Manicore','Manicore','BR ','MNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1190,'Maraba','Maraba','BR ','MAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1191,'Marechal Cunha Machado','São Luis','BR ','SLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1192,'Mato Grosso','Mato Grosso','BR ','MTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1193,'Matupa','Matupa','BR ','MBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1194,'Maues','Maues','BR ','MBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1195,'Miracema Do Norte','Miracema Do Norte','BR ','NTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1196,'Monte Alegre','Monte Alegre','BR ','MTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1197,'Monte Dourado','Monte Dourado','BR ','MEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1198,'Montes Claros','Montes Claros','BR ','MOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1199,'Municipal','Paranagua','BR ','PNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1200,'Municipal','Pato Branco','BR ','PTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1201,'Nanuque','Nanuque','BR ','NNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1202,'Navegantes','Navegantes','BR ','NVT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1203,'Niquelandia','Niquelandia','BR ','NQL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1204,'Nova Xavantina','Nova Xavantina','BR ','NOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1205,'Novo Aripuana','Aripuana','BR ','NVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1206,'Obidos','Obidos','BR ','OBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1207,'Oiapoque','Oiapoque','BR ','OYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1208,'Oriximina','Oriximina','BR ','ORX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1209,'Errol','Errol','US ','ERR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1210,'Esler Field','Alexandria','US ','ESF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1211,'Espanola','Espanola','US ','ESO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1212,'Eugene','Eugene','US ','EUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1213,'Eunice','Eunice','US ','UCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1214,'Eureka','Eureka','US ','EUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1215,'Evanston','Evanston','US ','EVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1216,'Evansville Regional Airport','Evansville IN','US ','EVV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1217,'Eveleth','Eveleth','US ','EVM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1218,'Everett-Stewart','Union City','US ','UCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1219,'Exchangest Railway Svc','Buffalo','US ','ZXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1220,'Executive','Clearwater','US ','CLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1221,'Executive','Fort Lauderdale','US ','FXE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1222,'Executive','Sacramento','US ','SAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1223,'Fairbanks International Airport','Fairbanks','US ','FAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1224,'Fairchild Intl','Port Angeles','US ','CLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1225,'Fairfax Municipal','Kansas City','US ','KCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1226,'Fairmont','Fairmont','US ','FRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1227,'Falcon Field','Mesa','US ','MSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1228,'Falcon State','Roma','US ','FAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1229,'Falls Bay','Falls Bay','US ','FLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1230,'Falls Intl','International Falls','US ','INL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1231,'False Island','False Island','US ','FAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1232,'False Pass','False Pass','US ','KFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1233,'Fanning Field','Idaho Falls','US ','IDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1234,'Farewell','Farewell','US ','FWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1235,'Federal No 1','Sandy River','US ','KSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1236,'Felker AAF','Fort Eustis','US ','FAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1237,'Felts Field','Spokane','US ','SFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1238,'Fergus Falls','Fergus Falls','US ','FFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1239,'Fin Creek','Fin Creek','US ','FNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1240,'Findlay','Findlay','US ','FDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1241,'Fire Cove','Fire Cove','US ','FIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1242,'Firing Center AAF','Yakima','US ','FCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1243,'First Flight','Kill Devil Hills','US ','FFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1244,'Fisheries','Chignik','US ','KCG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1245,'Five Finger','Five Finger Coast Guard Heliport','US ','FIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1246,'Five Mile','Five Mile','US ','FMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1247,'Flat','Flat','US ','FLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1248,'Flaxman Island','Flaxman Island','US ','FXM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1249,'Fletcher Field','Clarksdale MS','US ','CKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1250,'Flippin','Flippin','US ','FLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1251,'Florence','Florence','US ','FLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1252,'Flushing','New York','US ','FLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1253,'Flying Cloud','Minneapolis','US ','FCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1254,'Fond Du Lac','Fond Du Lac','US ','FLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1255,'Forbes Field','Topeka KS','US ','FOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1256,'Ford','Iron Mountain','US ','IMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1257,'Forney AAF','Fort Leonard Wood','US ','TBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1258,'Fort Bragg','Fort Bragg','US ','FOB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1259,'Fort Bridger','Fort Bridger','US ','FBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1260,'Fort Collins Bus Servi','Fort Collins/Loveland','US ','QWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1261,'Fort Dodge Regional','Fort Dodge IA','US ','FOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1262,'Fort Hood AAF','Killeen','US ','HLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1263,'Fort Jefferson','Fort Jefferson','US ','RBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1264,'Fort Lauderdale/hollywood International','Fort Lauderdale FL','US ','FLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1265,'Fort Lee AAF','Petersburg','US ','FLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1266,'Fort Mccoy','Sparta','US ','CMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1267,'Fort Sumner','Fort Sumner','US ','FSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1268,'Fort Worth Alliance','Fort Worth TX','US ','AFW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1269,'Fort Worth NAS Jrb/Carswell Field','Fort Worth TX','US ','FWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1270,'Fort Yukon','Fort Yukon','US ','FYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1271,'Fortuna Ledge','Fortuna Ledge','US ','FTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1272,'Fox','Fox','US ','FOX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1273,'Franklin','Louisburg','US ','LFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1274,'Franklin County','Sewanee','US ','UOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1275,'Frederick Municipal','Frederick','US ','FDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1276,'Freeman Municipal','Seymour','US ','SER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1277,'French Valley','Rancho','US ','RBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1278,'Frenchville','Frenchville','US ','WFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1279,'Fresh Water Bay','Fresh Water Bay','US ','FRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1280,'Fresno Air Terminal Airport','Fresno','US ','FAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1281,'Fresno-Chandler','Fresno','US ','FCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1282,'Friday Harbor','Friday Harbor','US ','FRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1283,'Friday Harbor SPB','Friday Harbor SPB','US ','FBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1284,'Front Royal-Warren County','Front Royal','US ','FRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1285,'Fryeburg','Fryeburg','US ','FRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1286,'Ft Wainwright','Fairbanks','US ','FBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1287,'Ft Wolter AAF','Mineral Wells','US ','CWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1288,'Fulton County','Atlanta','US ','FTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1289,'Fulton County','Rochester','US ','RCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1290,'Fulton International','Akron/Canton','US ','AKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1291,'Gabbs','Gabbs','US ','GAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1292,'Gage','Gage','US ','GAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1293,'Gainesville Regional','Gainesville','US ','GNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1294,'Gakona','Gakona','US ','GAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1295,'Galbraith Lake','Galbraith Lake','US ','GBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1296,'Galena','Galena','US ','GAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1297,'Galesburg','Galesburg','US ','GBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1298,'Galion','Galion','US ','GQQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1299,'Gallatin Field','Bozeman','US ','BZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1300,'Galleria Heliport','Atlanta','US ','JGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1301,'Gambell','Gambell','US ','GAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1302,'Ganes Creek','Ganes Creek','US ','GEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1303,'Garden City Municipal Airport','Garden City KS','US ','GCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1304,'Garden Harris County','Pine Mountain','US ','PIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1305,'Garfield County','Rifle','US ','RIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1306,'Garner Fld','Uvalde','US ','UVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1307,'Gary/Chicago International','Gary IN','US ','GYY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1308,'Gatlinburg','Gatlinburg','US ','GKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1309,'General Brees Field','Laramie','US ','LAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1310,'General Mitchell International','Milwaukee','US ','MKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1311,'George Bush Intercontinental','Houston','US ','IAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1312,'George Downer','Aliceville','US ','AIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1313,'George R Carr','Bogalusa','US ','BXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1314,'Georgetown','Georgetown','US ','GGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1315,'Gettysburg','Gettysburg','US ','GTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1316,'Gilbert Field','Winter Haven','US ','GIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1317,'Gillespie Field','El Cajon','US ','CJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1318,'Gillespie Field','San Diego','US ','SEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1319,'Glacier Creek','Glacier Creek','US ','KGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1320,'Glacier Park International','Kalispell MT','US ','FCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1321,'Gladwin','Gladwin','US ','GDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1322,'Glendale','Glendale','US ','GWV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1323,'Glenn County','Willows','US ','WLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1324,'Glenn L Martin','Baltimore','US ','MTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1325,'Glennallen','Glennallen','US ','GLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1326,'Glenwood Springs','Glenwood Springs','US ','GWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1327,'Glynco Jetport','Brunswick','US ','BQK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1328,'Godman AAF','Fort Knox','US ','FTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1329,'Gogebic County','Ironwood','US ','IWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1330,'Golden Horn Lodge SPB','Golden Horn Lodge Alaska','US ','GDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1331,'Golden Triangle Reg.','Columbus','US ','GTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1332,'Golovin','Golovin','US ','GLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1333,'Goodfellow AFB','San Angelo','US ','GOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1334,'Gooding','Gooding','US ','GNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1335,'Goodnews Bay','Goodnews Bay','US ','GNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1336,'Goodwin Field','El Dorado','US ','ELD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1337,'Gordon','Gordon','US ','GRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1338,'Goshen','Goshen','US ','GSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1339,'Grand Forks','Grand Forks','US ','GFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1340,'Grand Forks AFB','Red River','US ','RDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1341,'Grand Island','Grand Island NE','US ','GRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1342,'Grand Rapids','Grand Rapids','US ','GPZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1343,'Grand Strand Airport','Myrtle Beach','US ','CRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1344,'Granite Mountain','Granite Mountain','US ','GMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1345,'Grant County','Moses Lake','US ','MWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1346,'Grant County','Petersburg','US ','PGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1347,'Grant County','Silver City','US ','SVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1348,'Gratiot Community','Alma','US ','AMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1349,'Gray Aaf','Fort Hood TX','US ','GRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1350,'Gray Aaf','Tacoma','US ','GRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1351,'Grayling','Grayling','US ','KGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1352,'Grayson County','Sherman-Denison','US ','PNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1353,'Great Bend','Great Bend','US ','GBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1354,'Greater Binghamton','Binghamton NY','US ','BGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1355,'Greater Kankakee','Kankakee','US ','IKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1356,'Greater Peoria','Peoria IL','US ','PIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1357,'Greater Portsmouth Regional','Portsmouth OH','US ','PMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1358,'Greater Rochester International','Rochester NY','US ','ROC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1359,'Greater Rockford Airport','Rockford','US ','RFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1360,'Greater Wilmington','Wilmington','US ','ILG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1361,'Green','Oaktown','US ','OTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1362,'Green River','Green River','US ','RVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1363,'Greenbrier','White Sulphur Springs','US ','SSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1364,'Greenbrier Valley','Lewisburg','US ','LWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1365,'Greene County','Waynesburg','US ','WAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1366,'Greenville','Greenville','US ','GLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1367,'Greenville Downtown','Greenville','US ','GMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1368,'Greenville Spartanbur Int''l Airport','Greenville','US ','GSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1369,'Greenwood','Greenwood','US ','GRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1370,'Grider Field','Pine Bluff','US ','PBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1371,'Griffing Sandusky','Sandusky','US ','SKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1372,'Griffiss AFB','Rome NY','US ','RME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1373,'Grissom Afb','Peru Indiana','US ','GUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1374,'Griswold','Madison','US ','MPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1375,'Grumman','Bethpage','US ','BPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1376,'Gulfport-Biloxi International','Gulfport','US ','GPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1377,'Gulkana','Gulkana','US ','GKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1378,'Gunnison','Gunnison','US ','GUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1379,'Gunter AFB','Montgomery','US ','GUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1380,'Gustavus Arpt','Gustavus','US ','GST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1381,'Guthrie','Guthrie','US ','GOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1382,'Guymon','Guymon','US ','GUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1383,'Gwinnett County Airport','Lawrenceville','US ','LZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1384,'Hacienda Bus.Park H/P','Pleasanton','US ','JBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1385,'Hale County','Plainview','US ','PVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1386,'Haley AAF','Fort Sheridan','US ','FSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1387,'Half Moon','Half Moon','US ','HAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1388,'Halifax County','Roanoke Rapids','US ','RZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1389,'Halliburton Field','Duncan','US ','DUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1390,'Hamilton','Hamilton','US ','HAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1391,'Hamilton Field','San Rafael','US ','SRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1392,'Hana','Hana','US ','HNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1393,'Hanchey Army Heliport','Ozark','US ','HEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1394,'Hanscom Field','Bedford/Hanscom','US ','BED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1395,'Hardy-Anders','Natchez','US ','HEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1396,'Harrell Fld','Camden','US ','CDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1397,'Harriet Field','Wells','US ','LWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1398,'Harrisburg International','Harrisburg PA','US ','MDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1399,'Harrisburg Rail','Harrisburg','US ','ZUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1400,'Harry Clever','New Philadelphia','US ','PHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1401,'Hartsfield-jackson Atlanta International','Atlanta GA','US ','ATL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1402,'Hastings','Hastings','US ','HSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1403,'Hatbox Field','Muskogee','US ','HAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1404,'Hatteras','Hatteras','US ','HNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1405,'Hattiesburg-Laurel Regional','Hattiesburg/Laurel MS','US ','PIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1406,'Havasupai','Havasupai','US ','HAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1407,'Hawkins Field','Jackson','US ','HKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1408,'Hawthorne','Hawthorne','US ','HHR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1409,'Hawthorne','Hawthorne','US ','HTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1410,'Haycock','Haycock','US ','HAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1411,'Hazleton','Hazleton','US ','HZL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1412,'Healy Lake','Healy Lake','US ','HKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1413,'Hector Field','Fargo','US ','FAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1414,'Helena','Helena','US ','HLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1415,'Heliport','Downey','US ','JDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1416,'Heliport','Emeryville','US ','JEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1417,'Heliport','Glendale','US ','JGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1418,'Heliport','Grand Canyon','US ','JGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1419,'Heliport','Long Beach','US ','JLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1420,'Heliport','Newport Beach','US ','JNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1421,'Heliport','Norwalk','US ','ORQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1422,'Heliport','Pasadena','US ','JPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1423,'Henderson Sky Harbor','Las Vegas','US ','HSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1424,'Hendersonville Airport','Hendersonville','US ','0A7');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1425,'Henry County','Paris','US ','PHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1426,'Henry Post AAF','Fort Sill','US ','FSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1427,'Henry Tift Myers','Tifton GA','US ','TMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1428,'Herendeen','Herendeen','US ','HED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1429,'Hesler-Noble Field','Laurel MS','US ','LUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1430,'Hickam AFB','Honolulu','US ','HIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1431,'Hickory','Hickory','US ','HKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1432,'Hidden Falls','Hidden Falls','US ','HDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1433,'Hill Afb','Ogden','US ','HIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1434,'Hill City','Hill City','US ','HLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1435,'Hillenbrand','Batesville','US ','HLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1436,'Hilo International','Hilo','US ','ITO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1437,'Hilton Head','Hilton Head','US ','HHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1438,'Hiltons Har H','Boulder','US ','WHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1439,'Hinkles Ferry','Brazoria','US ','BZT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1440,'Hobart','Hobart OK','US ','HBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1441,'Hobart Bay','Hobart Bay','US ','HBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1442,'Hogatza','Hogatza','US ','HGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1443,'Holikachu','Holikachu','US ','HOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1444,'Hollister','Hollister','US ','HLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1445,'Holloman AFB','Alamogordo','US ','HMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1446,'Holy Cross','Holy Cross','US ','HCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1447,'Homer','Homer','US ','HOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1448,'Homeshore','Homeshore AK','US ','HMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1449,'Honolulu International','Honolulu','US ','HNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1450,'Hook Field','Middletown Ohio','US ','MWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1451,'Hoonah','Hoonah','US ','HNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1452,'Hooper Bay','Hooper Bay','US ','HPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1453,'Hopkins International','Cleveland','US ','CLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1454,'Horlick','Racine','US ','RAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1455,'Hot Springs','Thermopolis','US ','THP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1456,'Hot Springs SPB','Bell Island','US ','KBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1457,'Houghton County','Hancock','US ','CMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1458,'Howard County','Big Spring','US ','HCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1459,'Howes','Huron','US ','HON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1460,'Hughes','Culver City','US ','CVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1461,'Hugo','Hugo','US ','HUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1462,'Hulman Field','Terre Haute','US ','HUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1463,'Humboldt','Humboldt','US ','HUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1464,'Hunt Field','Lander','US ','LND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1465,'Hunter AAF','Jolon','US ','HGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1466,'Hunter AAF','Savannah GA','US ','SVN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1467,'Huntsville International - Carl T. Jones Field','Huntsville AL','US ','HSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1468,'Huslia','Huslia','US ','HSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1469,'Hutchinson','Hutchinson','US ','HUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1037,'Arraias','Arraias','BR ','AAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1038,'Aruja','Aruja','BR ','ZFU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1039,'Assis','Assis','BR ','AIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1040,'Augusto Severo','Natal','BR ','NAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1041,'Bacacheri','Curitiba','BR ','BFH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1042,'Balsas','Balsas','BR ','BSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1043,'Barbelos','Barbelos','BR ','BAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1044,'Barra','Barra','BR ','BQQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1045,'Barra Do Corda','Barra Do Corda','BR ','BDC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1046,'Barra Do Garcas','Barra Do Garcas','BR ','BPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1047,'Barreiras','Barreiras','BR ','BRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1048,'Barreirinhas','Barreirinhas','BR ','BRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1049,'Bartolomeu Lisandro','Campos','BR ','CAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1050,'Base Aerea De Santa Maria','Santa Maria Rs','BR ','RIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1051,'Bauru','Bauru','BR ','BAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1052,'Belmonte','Belmonte','BR ','BVM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1053,'Bento Goncalves','Bento Goncalves','BR ','BGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1054,'Blumenau','Blumenau','BR ','BNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1055,'Boa Vista','Boa Vista','BR ','BVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1056,'Boca Do Acre','Boca Do Acre','BR ','BCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1057,'Bom Jesus Da Lapa','Bom Jesus Da Lapa','BR ','LAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1058,'Bonito Airport','Bonito','BR ','BYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1059,'Borba','Borba','BR ','RBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1060,'Braganca Paulista','Braganca Paulista','BR ','BJP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1061,'Breves','Breves','BR ','BVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1062,'Brumado','Brumado','BR ','BMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1063,'Buzios','Buzios','BR ','BZC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1064,'Cabo Frio','Cabo Frio','BR ','CFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1065,'Cacador','Cacador','BR ','CFC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1066,'Caceres','Caceres','BR ','CCX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1067,'Cachoeira','Cachoeira','BR ','CCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1068,'Cachoeiro Itapemirim','Cachoeiro Itapemirim','BR ','CDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1069,'Cacoal','Cacoal','BR ','OAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1070,'Caldas Novas','Caldas Novas','BR ','CLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1071,'Cameta','Cameta','BR ','CMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1072,'Camocim','Camocim','BR ','CMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1073,'Campo Alegre','Santana Do Araguaia','BR ','CMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1074,'Campo Dos Bugres','Caxias Do Sul','BR ','CXJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1075,'Campo Mourao','Campo Mourao','BR ','CBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1076,'Cana Brava','Cana Brava','BR ','NBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1077,'Canarana Airport','Canarana','BR ','CQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1078,'Canavieiras','Canavieiras','BR ','CNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1079,'Cangapara','Floriano','BR ','FLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1080,'Carajas','Carajas','BR ','CKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1081,'Carauari','Carauari','BR ','CAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1082,'Caravelas','Caravelas','BR ','CRQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1083,'Carlos Ruhl','Cruz Alta','BR ','CZB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1084,'Carolina','Carolina','BR ','CLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1085,'Caruaru','Caruaru','BR ','CAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1086,'Carutapera','Carutapera','BR ','CTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1087,'Cascavel','Cascavel','BR ','CAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1088,'Cassilandia','Cassilandia','BR ','CSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1089,'Castro Pinto','Joao Pessoa','BR ','JPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1090,'Catalao','Catalao','BR ','TLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1091,'Cataratas','Iguassu Falls','BR ','IGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1092,'Chapada Diamantina','Lencois','BR ','LEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1093,'Coari','Coari','BR ','CIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1094,'Colorado do Oeste','Colorado do Oeste','BR ','CSW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1095,'Comandante Kraemer','Erechim','BR ','ERM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1096,'Conceicao Do Araguaia','Conceicao Do Araguaia','BR ','CDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1097,'Concordia','Concordia','BR ','CCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1098,'Confresa','Santa Terezinha','BR ','STZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1099,'Confreza','Confreza','BR ','CFO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1100,'Congonhas','Sao Paulo','BR ','CGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1101,'Cornelio Procopio','Cornelio Procopio','BR ','CKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1102,'Criciuma','Criciuma','BR ','CCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1103,'Cururupu','Cururupu','BR ','CPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1104,'Da Cachoeira','Sao Gabriel','BR ','SJL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1105,'Diamantino','Diamantino','BR ','DMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1106,'Dianopolis','Dianopolis','BR ','DNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1107,'Divinopolis','Divinopolis','BR ','DIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1108,'Dixsept Rosado','Mossoro','BR ','MVF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1109,'Do Palmar','Santa Vitoria','BR ','CTQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1833,'Mobile Regional Airport','Alabama AL','US ','MOB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1834,'Mobridge','Mobridge','US ','MBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1835,'Moffett Field','Mountain View','US ','NUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1836,'Molokai','Hoolehua','US ','MKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1837,'Mondell','Newcastle','US ','ECS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1838,'Monmouth Executive Airport','Belmar - Farmingdale','US ','BLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1839,'Monroe - Walton County','Monroeville','US ','MVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1840,'Montauk Airport','Montauk','US ','MTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1841,'Monterey Peninsula','Monterey','US ','MRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1842,'Montevideo-Chippewa','Montevideo MN','US ','MVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1843,'Montezuma County','Cortez','US ','CEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1844,'Montgomery Co','Conroe','US ','CXO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1845,'Montgomery County','Gaithersburg','US ','GAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1846,'Montgomery Field','San Diego','US ','MYF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1847,'Montrose Regional Airport','Montrose','US ','MTJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1848,'Montvale','Montvale','US ','QMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1849,'Monument Valley','Kayenta AZ','US ','MVM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1850,'Monument Valley','Monument Valley Gldngs','US ','GMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1851,'Moody AFB','Valdosta','US ','VAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1852,'Moore-Murrell','Morristown','US ','MOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1853,'Morenci','Clifton','US ','CFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1854,'Morgantown','Morgantown','US ','MGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1855,'Morrisville-Stowe','Stowe','US ','MVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1856,'Moser Bay','Moser Bay','US ','KMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1857,'Moultrie Municipal','Moultrie','US ','MGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1858,'Mount Pleasant','Mount Pleasant','US ','MPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1859,'Mount Union','Mount Union','US ','MUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1860,'Mount Wilson','Mount Wilson','US ','MWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1861,'Mountain Home','Mountain Home','US ','WMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1862,'Mountain Village','Mountain Village','US ','MOU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1863,'Mt Mckinley','Mt Mckinley','US ','MCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1864,'Mt Pleasant','Mt Pleasant','US ','MSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1865,'Mt Pocono','Mt Pocono','US ','MPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1866,'Mt Vernon-Outland','Mt Vernon','US ','MVN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1867,'Mudhole Smith','Cordova','US ','CDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1868,'Muir AAF','Fort Indiantown','US ','MUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1869,'Mullen','Mullen','US ','MHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1870,'Municipal','Aberdeen','US ','ABR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1871,'Municipal','Abilene','US ','ABI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1872,'Municipal','Afton','US ','AFO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1873,'Municipal','Aiken','US ','AIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1874,'Municipal','Alamogordo','US ','ALM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1875,'Municipal','Alamosa','US ','ALS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1876,'Municipal','Altus','US ','AXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1877,'Municipal','Amery','US ','AHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1878,'Municipal','Anderson','US ','AID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1879,'Municipal','Ann Arbor MI','US ','ARB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1880,'Municipal','Apalachicola','US ','AAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1881,'Municipal','Arapahoe','US ','AHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1882,'Municipal','Atlantic','US ','AIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1883,'Municipal','Avon Park','US ','AVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1884,'Municipal','Batesville','US ','BVX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1885,'Municipal','Benson','US ','BBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1886,'Municipal','Blytheville','US ','HKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1887,'Municipal','Boulder','US ','WBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1888,'Municipal','Britton','US ','TTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1889,'Municipal','Buffalo','US ','BYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1890,'Municipal','Burwell','US ','BUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1891,'Municipal','Caribou','US ','CAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1892,'Municipal','Casa Grande','US ','CGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1893,'Municipal','Centerville','US ','GHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1894,'Municipal','Centralia','US ','ENL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1895,'Municipal','Charles City','US ','CCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1896,'Municipal','Chickasha','US ','CHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1897,'Municipal','Claremont','US ','CNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1898,'Municipal','Clarinda','US ','ICL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1899,'Municipal','Clinton','US ','CLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1900,'Municipal','Clovis','US ','CVN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1901,'Municipal','Coffeyville','US ','CFV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1902,'Municipal','Colby','US ','CBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1903,'Municipal','Columbus','US ','CUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1904,'Municipal','Council Bluffs','US ','CBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1905,'Municipal','Creston','US ','CSQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1906,'Municipal','Crookston','US ','CKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1907,'Municipal','Crossett','US ','CRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1908,'Municipal','Cushing','US ','CUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1909,'Municipal','Dalton','US ','DNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1910,'Municipal','Danville','US ','DAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1911,'Municipal','Decorah','US ','DEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1912,'Municipal','Denison','US ','DNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1913,'Municipal','Detroit Lakes','US ','DTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1914,'Municipal','Dillingham','US ','DLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1915,'Municipal','Dublin','US ','DBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1916,'Municipal','Dubuque','US ','DBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1917,'Municipal','Eastland','US ','ETN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1918,'Municipal','Edenton','US ','EDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1919,'Municipal','Elk City','US ','ELK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1920,'Municipal','Elkhart','US ','EKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1921,'Municipal','Enterprise','US ','ETS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1922,'Municipal','Estherville','US ','EST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1923,'Municipal','Fairbury','US ','FBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1924,'Municipal','Fairfield','US ','FFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1925,'Municipal','Fallon','US ','FLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1926,'Municipal','Faribault','US ','FBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1927,'Municipal','Farmington','US ','FMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1928,'Municipal','Fayetteville','US ','FAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1929,'Municipal','Fayetteville','US ','FYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1930,'Municipal','Fillmore','US ','FIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1931,'Municipal','Forest City','US ','FXY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1932,'Municipal','Forrest City','US ','FCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1933,'Municipal','Fort Madison','US ','FMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1934,'Municipal','Fort Scott','US ','FSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1935,'Municipal','Franklin','US ','FKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1936,'Municipal','Frederick','US ','FDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1937,'Municipal','Fremont','US ','FET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1938,'Municipal','French Lick','US ','FRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1939,'Municipal','Fullerton','US ','FUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1940,'Municipal','Gadsden','US ','GAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1941,'Municipal','Gainesville','US ','GLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1942,'Municipal','Gardner','US ','GDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1943,'Municipal','Glasgow','US ','GLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1944,'Municipal','Gordonsville','US ','GVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1945,'Municipal','Grantsburg','US ','GTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1946,'Municipal','Greenville','US ','GRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1947,'Municipal','Greenville','US ','GCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1948,'Municipal','Haines','US ','HNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1949,'Municipal','Hampton','US ','HPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1950,'Municipal','Hartsville','US ','HVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1951,'Municipal','Hays','US ','HYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1952,'Municipal','Hayward','US ','HYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1953,'Municipal','Hughes','US ','HUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1954,'Municipal','Humboldt','US ','HBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1955,'Municipal','Huntingburg','US ','HNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1956,'Municipal','Ida Grove','US ','IDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1957,'Municipal','Iraan','US ','IRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1958,'Municipal','Jacksonville','US ','IJX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1959,'Municipal','Jaffrey','US ','AFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1960,'Municipal','Jefferson','US ','EFW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1961,'Municipal','Joliet','US ','JOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1962,'Municipal','Kalskag','US ','KLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1963,'Municipal','Kennett','US ','KNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1964,'Municipal','Killeen','US ','ILE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1965,'Municipal','Kirksville','US ','IRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1966,'Municipal','Kodiak','US ','KDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1967,'Municipal','La Crosse','US ','LSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1968,'Municipal','Laconia','US ','LCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1969,'Municipal','Lake Charles','US ','LCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1970,'Municipal','Lake Geneva','US ','XES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1971,'Municipal','Lake Havasu City','US ','HII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1972,'Municipal','Lakeland','US ','LAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1973,'Municipal','Laporte','US ','LPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1974,'Municipal','Las Cruces NM','US ','LRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1975,'Municipal','Lawrenceville','US ','LWV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1976,'Municipal','Lawton','US ','LAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1977,'Municipal','Lemars','US ','LRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1978,'Municipal','Lewistown','US ','LWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1979,'Municipal','Liberal','US ','LBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1980,'Municipal','Limon','US ','LIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1981,'Municipal','Macomb','US ','MQB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1982,'Municipal','Magnolia','US ','AGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1983,'Municipal','Manhattan','US ','MHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1984,'Municipal','Manila','US ','MXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1985,'Municipal','Manitowoc','US ','MTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1986,'Municipal','Mankato','US ','MKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1987,'Municipal','Marfa','US ','MRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1988,'Municipal','Marion','US ','MNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1989,'Municipal','Marshalltown','US ','MIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1990,'Municipal','Marshfield','US ','MFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1991,'Municipal','Merrill','US ','RRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1992,'Municipal','Miles City','US ','MLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1993,'Municipal','Mitchell','US ','MHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1994,'Municipal','Modesto CA','US ','MOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1995,'Municipal','Monroe','US ','MLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1996,'Municipal','Monticello','US ','MXO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1997,'Municipal','Morris','US ','MOX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1998,'Municipal','Morristown','US ','MMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1999,'Municipal','Mount Pleasant','US ','MOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2000,'Municipal','Mt Pleasant','US ','MPZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2001,'Municipal','Nenana','US ','ENN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2002,'Municipal','New Richmond','US ','RNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2003,'Municipal','Newton','US ','TNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2004,'Municipal','Ocean City','US ','OCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2005,'Municipal','Oceanside','US ','OCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2006,'Municipal','Ogden','US ','OGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2007,'Municipal','Olean','US ','OLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2008,'Municipal','Omak','US ','OMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2009,'Municipal','Oneill','US ','ONL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2010,'Municipal','Oneonta','US ','ONH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2011,'Municipal','Orangeburg','US ','OGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2012,'Municipal','Osceola','US ','OEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2013,'Municipal','Oskaloosa','US ','OOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2014,'Municipal','Palm Springs','US ','PSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2015,'Municipal','Palmer','US ','PAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2016,'Municipal','Paragould','US ','PGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2017,'Municipal','Perry','US ','PRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2018,'Municipal','Petersburg','US ','PTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2019,'Municipal','Pittsburg','US ','PTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2020,'Municipal','Pocahontas','US ','POH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2021,'Municipal','Prairie Du Chien','US ','PCD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2022,'Municipal','Presque Isle','US ','PQI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2023,'Municipal','Quincy','US ','UIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2024,'Municipal','Rockwood','US ','RKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2025,'Municipal','Roseburg','US ','RBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2026,'Municipal','Ruidoso','US ','RUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2027,'Municipal','Saint Cloud','US ','STC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2028,'Municipal','Saint George','US ','SGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2029,'Municipal','Sand Point','US ','SDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2030,'Municipal','Santa Barbara CA','US ','SBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2031,'Municipal','Shawnee','US ','SNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2032,'Municipal','Sierra Vista','US ','FHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2033,'Municipal','Skagway','US ','SGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2034,'Municipal','Spencer','US ','SPW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2035,'Municipal','Statesville','US ','SVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2036,'Municipal','Storm Lake','US ','SLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2037,'Municipal','Sumter','US ','SUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2038,'Municipal','Thomasville','US ','TVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2039,'Municipal','Torrington','US ','TOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2040,'Municipal','Troy','US ','TOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2041,'Municipal','Truth Or Consequences','US ','TCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2042,'Municipal','Valdez','US ','VDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2043,'Municipal','Vero Beach','US ','VRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2044,'Municipal','Vidalia','US ','VDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2045,'Municipal','Waco','US ','ACT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2046,'Municipal','Walterboro','US ','RBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2047,'Municipal','Waukon','US ','UKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2048,'Municipal','Wausau','US ','AUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2049,'Municipal','Webster City','US ','EBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2050,'Municipal','Wellsville','US ','ELZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2051,'Municipal','West Memphis','US ','AWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2052,'Municipal','Whitesburg','US ','BRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2053,'Municipal','Winchester','US ','WGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2054,'Municipal','Winona','US ','ONA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2055,'Municipal','Fayetteville','US ','FYV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1470,'Hyatt Regency H/P','Cambridge','US ','JHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1471,'Hyatt Regency H/P','Dearborn','US ','DEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1472,'Icy Bay','Icy Bay','US ','ICY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1473,'Igiugig','Igiugig','US ','IGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1474,'Igor I. Sikorsky Mem.','Bridgeport','US ','BDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1475,'Iliamna','Iliamna','US ','ILI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1476,'Illinois Valley Regnl','Peru','US ','VYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1477,'Immokalee','Immokalee','US ','IMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1478,'Imperial','Imperial','US ','IML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1479,'Imperial County','Imperial','US ','IPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1480,'Independence','Independence','US ','IDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1481,'Indian Mountain AFS','Utopia Creek','US ','UTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1482,'Indianapolis International','Indianapolis IN','US ','IND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1483,'Industrial','Ottumwa','US ','OTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1484,'Industrial','Roswell','US ','ROW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1485,'Industrial','Tacoma','US ','TIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1486,'Industrial Airpark','Hobbs','US ','HBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1487,'Ingalls Field','Hot Springs','US ','HSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1488,'Intermediate','Hanksville','US ','HVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1489,'Intermediate','Middleton Island','US ','MDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1490,'Intermediate','Minchumina','US ','MHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1491,'Intermediate','Moses Point','US ','MOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1492,'Intermediate','Pembina','US ','PMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1493,'Intermediate','Skwentna','US ','SKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1494,'Intermediate','Tanacross','US ','TSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1495,'Intermediate','Yakataga','US ','CYT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1496,'Intermediate Field','Big Delta','US ','BIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1497,'International','Alice','US ','ALI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1498,'International','Calexico','US ','CXL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1499,'International','Del Rio','US ','DRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1500,'International','Erie','US ','ERI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1501,'International','Glasgow','US ','GGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1502,'International','Great Falls','US ','GTF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1503,'International','Houlton','US ','HUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1504,'International','Ketchikan','US ','KTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1505,'International','Key West','US ','EYW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1506,'International','Laredo','US ','LRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1507,'International','Lubbock','US ','LBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1508,'International','Minot','US ','MOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1509,'International','Niagara Falls','US ','IAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1510,'International','Nogales','US ','OLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1511,'International','Rochester','US ','RST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1512,'International','Wolf Point','US ','OLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1513,'International','Yuma','US ','YUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1514,'Intl Heliport','Ontario','US ','JIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1515,'Intl Jetport','Portland','US ','PWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1516,'Iowa City','Iowa City IA','US ','IOW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1517,'Iowa Falls','Iowa Falls','US ','IFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1518,'Isabel Pass','Isabel Pass','US ','ISL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1519,'Island Heliport','Garden City','US ','JHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1520,'Ivishak','Ivishak','US ','IVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1521,'J t Robidoux','Valle','US ','VLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1522,'Jackpot','Jackpot','US ','KPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1523,'Jackson','Jackson','US ','MJQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1524,'Jackson Hole','Jackson','US ','JAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1525,'Jackson-evers','Jackson','US ','JAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1526,'"Jacksonville','Jacksonville FL','US ','JAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1527,'Jahrom','Jahrom','US ','JAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1528,'James Cox Dayton Intl','Dayton Oh','US ','DAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1529,'Jamestown','Jamestown','US ','JMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1530,'Jamestown','Jamestown','US ','JHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1531,'Jeffco','Broomfield','US ','BJC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1532,'Jefferson County','Beaumont','US ','BPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1533,'Jefferson Proving Grd','Madison','US ','MDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1534,'Jerry Tyler Memorial','Niles','US ','NLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1535,'Joe Foss Field Airport','Sioux Falls','US ','FSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1536,'John Day','John Day','US ','JDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1537,'John F Kennedy Intl','New York','US ','JFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1538,'John Wayne','Santa Ana CA','US ','SNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1539,'Johnson','Johnson','US ','JCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1540,'Johnson Executive','Kansas City','US ','OJC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1541,'Jonesboro','Jonesboro','US ','JBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1542,'Joplin Regional','Joplin MO','US ','JLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1543,'Jordan','Jordan','US ','JDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1544,'Joslin Field - Magic Valley Regional','Twin Falls ID','US ','TWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1545,'Kahului','Maui HI','US ','OGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1546,'Kakhonak','Kakhonak','US ','KNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1547,'Kalakaket AFS','Kalakaket','US ','KKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1548,'Kalamazoo/Battle Creek Intl','Kalamazoo','US ','AZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1549,'Kalaupapa','Kalaupapa','US ','LUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1550,'Kaltag','Kaltag','US ','KAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1551,'Kamuela','Kamuela','US ','MUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1552,'Kamusi Airport','Kamusi','US ','KUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1553,'Kanab','Kanab','US ','KNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1554,'Kansas City International Airport','Kansas City','US ','MCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1555,'Kapalua West Maui','Lahaina','US ','JHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1556,'Karluk','Karluk','US ','KYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1557,'Karluk Lake SPB','Karluk Lake','US ','KKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1558,'Kasaan SPB','Kasaan','US ','KXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1559,'Kasigluk','Kasigluk','US ','KUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1560,'Kearney','Kearney','US ','EAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1561,'Keesler AFB','Biloxi','US ','BIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1562,'Kegelman Af','Cherokee','US ','CKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1563,'Kelly AFB','San Antonio','US ','SKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1564,'Kelly Bar','Kelly Bar','US ','KEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1565,'Kelp Bay','Kelp Bay','US ','KLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1566,'Kemerer','Kemerer','US ','EMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1567,'Kenai','Kenai','US ','ENA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1568,'Kenmore Air Harbor','Kenmore Air Harbor','US ','KEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1569,'Kenmore Air Harbor SPB','Seattle WA','US ','LKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1570,'Kenosha Regional Airport','Kenosha','US ','ENW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1571,'Kent County Intl','Grand Rapids','US ','GRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1572,'Kentland','Kentland','US ','KKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1573,'Keokuk','Keokuk','US ','EOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1574,'Kern County','Inyokern','US ','IYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1575,'Kern County','Mojave','US ','MHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1576,'Kern County','Shafter','US ','MIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1577,'Kern County','Tehachapi CA','US ','TSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1578,'Kerrville','Kerrville','US ','ERV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1579,'Key Field','Meridian','US ','MEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1580,'Kickapoo','Wichita Falls','US ','KIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1581,'Kilgore','Kilgore','US ','GGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1582,'Kimble County','Junction','US ','JCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1583,'Kincheloe AFB','Sault Ste Marie','US ','INR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1584,'King Cove','King Cove','US ','KVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1585,'King Of Prussia','King Of Prussia','US ','KPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1586,'King Salmon','King Salmon','US ','AKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1587,'Kingman','Kingman','US ','IGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1588,'Kingsley Field','Klamath Falls','US ','LMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1589,'Kipnuk SPB','Kipnuk','US ','KPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1590,'Kirsch Municipal','Sturgis','US ','IRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1591,'Kissimmee Gateway','Kissimmee','US ','ISM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1592,'Kivalina','Kivalina','US ','KVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1593,'Kizhuyak','Kizhuyak','US ','KZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1594,'Klag Bay','Klag Bay','US ','KBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1595,'Klawock','Klawock','US ','KLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1596,'Knox County Regional','Rockland','US ','RKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1597,'Kobuk/Wien','Kobuk','US ','OBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1598,'Kodiak Airport','Kodiak','US ','ADQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1599,'Kodiak Fss','Kodiak','US ','WDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1600,'Kokomo','Kokomo','US ','OKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1601,'Kona International Airport','Kona HI','US ','KOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1602,'Kongiganak','Kongiganak','US ','KKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1603,'Kotlik','Kotlik','US ','KOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1604,'Kotzebue','Kotzebue','US ','OTZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1605,'Koyuk','Koyuk','US ','KKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1606,'Koyukuk','Koyukuk','US ','KYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1607,'Kulik Lake','Kulik Lake','US ','LKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1608,'Kuparuk','Kuparuk','US ','UUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1609,'Kwethluk','Kwethluk','US ','KWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1610,'Kwigillingok','Kwigillingok','US ','KWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1611,'Kwinhagak','Quinhagak','US ','KWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1612,'La Grande','La Grande','US ','LGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1613,'La Guardia','New York','US ','LGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1614,'La Palmdale Regional Airport','Palmdale CA','US ','PMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1615,'La Plata','Durango','US ','DRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1616,'Labouchere Bay','Labouchere Bay','US ','WLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1617,'Lafayette Regional','Lafayette LA','US ','LFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1618,'Lagoon','Chignik','US ','KCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1619,'Laguna AAF','Yuma','US ','LGF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1620,'Lahm Municipal','Mansfield','US ','MFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1621,'Lake Brooks SPB','Katmai National Park','US ','BKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1622,'Lake County','Lakeview','US ','LKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1623,'Lake Minchumina','Lake Minchumina','US ','LMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1624,'Lake Placid','Lake Placid','US ','LKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1625,'Lakefront','New Orleans','US ','NEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1626,'Lakeside','Lakeside','US ','LKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1627,'Lakeside USAF','Duluth','US ','LKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1628,'Lamar Field','Lamar','US ','LAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1629,'Lambert-St. Louis International','St Louis','US ','STL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1630,'Lanai City','Lanai City','US ','LNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1631,'Lancaster','Lancaster','US ','LNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1632,'Lancaster PA Rail','Lancaster','US ','ZRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1633,'Lander County','Battle Mountain','US ','BAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1634,'Landing Strip','Evadale','US ','EVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1635,'Langley AFB','Hampton','US ','LFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1636,'Larsen SPB','Larsen Bay','US ','KLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1637,'Las Animas','Trinidad','US ','TAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1638,'Las Vegas','Las Vegas','US ','LVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1639,'Lathrop Wells','Lathrop Wells','US ','LTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1640,'Laughlin Afb','Del Rio','US ','DLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1641,'Laughlin Bullhead Intl','Bullhead City','US ','IFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1642,'Lawrence','Lawrence','US ','LWC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1643,'Lawrence','Lawrence','US ','LWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1644,'Lawrence County Airpark','Chesapeake/Huntington Wv','US ','HTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1645,'Lawrence J Timmerman','Milwaukee','US ','MWC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1646,'Lawrenceville','Lawrenceville','US ','LVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1647,'Lawson Aaf','Columbus','US ','LSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1648,'Lea County','Hobbs','US ','HOB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1649,'Leadville','Leadville','US ','LXV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1650,'Leckrone','Salem','US ','SLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1651,'Lee','Annapolis','US ','ANP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1652,'Lee Bird Field','North Platte','US ','LBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1653,'Lee C Fine Memorial','Kaiser/Lake Ozark','US ','AIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1654,'Lee Gilmer Memorial','Gainesville','US ','GVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1655,'Leesburg','Leesburg','US ','LEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1656,'Leflore','Greenwood','US ','GWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1657,'Lehigh Valley International','Allentown','US ','ABE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1658,'Lemmon','Lemmon','US ','LEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1659,'Lemons Municipal','Tupelo','US ','TUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1660,'Lemoore NAS','Lemoore CA','US ','NLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1661,'Lenawee County','Adrian','US ','ADG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1662,'Lenoir','Morganton','US ','MRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1663,'Levelock','Levelock','US ','KLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1664,'Lewis','Cedar Key','US ','CDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1665,'Lewis B Wilson','Macon','US ','MCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1666,'Lewis Lockport','Lockport','US ','LOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1667,'Lexington','Lexington','US ','LXN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1668,'Lihue','Kauai Island','US ','LIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1669,'Lime Village','Lime Village','US ','LVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1670,'Lincoln','Lincoln NE','US ','LNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1671,'Lincoln Regional Airport','Lincoln CA','US ','LHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1672,'Linden','Linden','US ','LDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1673,'Litchfield','Goodyear','US ','GYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1674,'Little Naukati','Little Naukati','US ','WLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1675,'Little Port Walter','Little Port Walter','US ','LPW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1676,'Little Rock Afb','Jacksonville','US ','LRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1677,'Livengood','Livengood AK','US ','LIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1678,'Livermore','Livermore','US ','LVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1679,'Logan International','Boston','US ','BOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1680,'Lompoc Airport','Lompoc','US ','LPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1681,'Long Beach Municipal','Long Beach','US ','LGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1682,'Long Island','Long Island','US ','LIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1683,'Long Island Mac Arthur','Islip NY','US ','ISP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1684,'Longview','Kelso','US ','KLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1685,'Longview','Longview','US ','LOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1686,'Lopez Island','Lopez Island','US ','LPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1687,'Lordsburg','Lordsburg','US ','LSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1688,'Loring','Loring','US ','WLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1689,'Loring AFB','Limestone','US ','LIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1690,'Los Alamos','Los Alamos','US ','LAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1691,'Los Angeles International','Los Angeles','US ','LAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1692,'Los Banos','Los Banos','US ','LSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1693,'Lost Harbor Sea Port','Lost Harbor','US ','LHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1694,'Lost Nation','Willoughby','US ','LNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1695,'Lost River','Lost River','US ','LSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1696,'Louis Armstrong New Orléans International Airport','New Orleans','US ','MSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1697,'Louisville International','Louisville KY','US ','SDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1698,'Love Field','Dallas','US ','DAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1699,'Lovell Field','ChattanoogaTN','US ','CHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1700,'Lowe Army Heliport','Ozark','US ','LOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1701,'Lowndes County','Columbus','US ','UBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1702,'Lufkin Angelina County','Lufkin TX','US ','LFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1703,'Luke Afb','Phoenix','US ','LUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1704,'Lumberton','Lumberton','US ','LBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1705,'Lycoming County','Williamsport','US ','IPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1706,'Lyndonville','Lyndonville','US ','LLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1707,'M Graham Clark','Branson/point Lookout','US ','PLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1708,'Mac Dill AFB','Tampa','US ','MCF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1709,'Machesney','Rockford','US ','RMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1710,'Mackall AAF','Hoffman','US ','HFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1711,'Mackinac Island','Mackinac Island','US ','MCD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1712,'Madera','Madera','US ','MAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1713,'Madison','Madison','US ','XMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1714,'Majors Field','Greenville','US ','GVT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1715,'Malad City','Malad City','US ','MLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1716,'Malden','Malden','US ','MAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1717,'Malmstrom AFB','Great Falls','US ','GFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1718,'Malta','Malta','US ','MLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1719,'Mammoth Lakes','Mammoth Lakes','US ','MMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1720,'Manassas','Manassas','US ','MNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1721,'Manchester-boston Regional Airport','Manchester NH','US ','MHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1722,'Manley Hot Springs','Manley Hot Springs','US ','MLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1723,'Manokotak SPB','Manokotak','US ','KMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1724,'Manti-Ephraim','Manti','US ','NTJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1725,'Marana','Marana','US ','MZJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1726,'Marathon Flight Strip','Marathon','US ','MTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1727,'Marble Canyon','Marble Canyon','US ','MYH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1728,'March ARB','Riverside','US ','RIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1729,'Marco Island','Marco Island','US ','MRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1730,'Marguerite Bay','Marguerite Bay','US ','RTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1731,'Marin County','Sausalito CA','US ','JMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1732,'Marina Municipal','Marina CA','US ','OAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1733,'Marine Air Terminal','New York','US ','QNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1734,'Marion','Marion','US ','MZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1735,'Marion County','Hamilton','US ','HAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1736,'Marion County','Jasper','US ','APT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1737,'Market Centre H/P','Dallas','US ','JMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1738,'Marlborough','Marlborough','US ','MXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1739,'Marriott Heliport','Schaumburg','US ','JMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1740,'Marshall','Marshall','US ','MLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1741,'Marshall AAF','Fort Riley KS','US ','FRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1742,'Martin Johnson','Chanute','US ','CNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1743,'Martindale Army Heliport','San Antonio TX','US ','MDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1744,'Martinsburg','Martinsburg','US ','AOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1745,'Mason City Municipal','Mason City IA','US ','MCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1746,'Mason County','Ludington','US ','LDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1747,'Mathis Fld','San Angelo','US ','SJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1748,'Maury County','Columbia','US ','MRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1749,'Maverick Co','Eagle Pass','US ','EGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1750,'Max Westheimer','Norman','US ','OUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1751,'Maxton','Maxton','US ','MXE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1752,'May Creek','May Creek','US ','MYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1753,'MBS International','Saginaw','US ','MBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1754,'Mc Alester','Mc Alester','US ','MLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1755,'Mc Allen Miller International','Mc Allen TX','US ','MFE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1756,'Mc Carran Intl','Las Vegas','US ','LAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1757,'Mc Clellan-Palomar Airport','Carlsbad CA','US ','CLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1758,'Mc Entire ANG Base','Columbia','US ','MMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1759,'Mc Ghee Tyson','Knoxville','US ','TYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1760,'Mc Guire Afb','Wrightstown New Jersey','US ','WRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1761,'Mc Kellar-Sipes Regional','Jackson','US ','MKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1762,'Mc Namara Fld','Crescent City','US ','CEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1763,'Mccall','Mccall','US ','MYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1764,'Mccarthy','Mccarthy','US ','MXY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1765,'McChord AFB','Tacoma WA','US ','TCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1766,'Mcclellan AFB','Sacramento','US ','MCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1767,'Mccook','Mccook','US ','MCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1768,'Mcgrath','Mcgrath','US ','MCG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1769,'Mckenna AAF','Columbus','US ','MKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1770,'Mckinnon','Brunswick','US ','SSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1771,'McMinn County','Athens','US ','MMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1772,'Mcnary Field','Salem','US ','SLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1773,'Mcpherson','Mcpherson','US ','MPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1774,'Meacham Field','Fort Worth','US ','FTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1775,'Meadows Field','Bakersfield','US ','BFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1776,'Meadville','Meadville','US ','MEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1777,'Medford','Medford','US ','MDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1778,'Medfra','Medfra','US ','MDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1779,'Mefford Field','Tulare CA','US ','TLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1780,'Melbourne International Airport','Melbourne','US ','MLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1781,'Melsing Creek','Council','US ','CIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1782,'Memorial','Crossville','US ','CSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1783,'Memorial','Defiance','US ','DFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1784,'Memorial','Jefferson City MO','US ','JEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1785,'Memorial','Norwood','US ','OWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1786,'Memorial','Pueblo','US ','PUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1787,'Memorial','Sheboygan','US ','SBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1788,'Memorial','Sikeston','US ','SIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1789,'Memorial','Trenton','US ','TRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1790,'Memorial','Waukegan','US ','UGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1791,'Memorial Field','Hot Springs','US ','HOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1792,'Memphis International','Memphis','US ','MEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1793,'Menominee','Menominee','US ','MNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1794,'Merced Municipal Arpt','Merced','US ','MCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1795,'Merrill C Meigs','Chicago','US ','CGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1796,'Merrill Field','Anchorage','US ','MRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1797,'Merritt Island','Cocoa','US ','COI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1798,'Mesa Del Rey','King City','US ','KIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1799,'Metro Field','Fairbanks','US ','MTX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1800,'Metropark Rail','Newark','US ','ZME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1801,'Metropolitan','Palmer','US ','PMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1802,'Metropolitan Airport','Columbia SC','US ','CAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1803,'Metroport','Clearlake','US ','CLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1804,'Mettle Field','Connersville','US ','CEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1805,'Miami','Miami','US ','MIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1806,'Miami International Airport','Miami','US ','MIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1807,'Miami University','Oxford','US ','OXD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1808,'Michael AAF','Dugway','US ','DPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1809,'Michigan City Arpt','Michigan City','US ','MGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1810,'Mid-Continent','Wichita','US ','ICT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1811,'Midland International','Midland','US ','MAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1812,'Midway','Chicago','US ','MDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1813,'Mifflin County','Reedsville','US ','RED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1814,'Milan','Grants','US ','GNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1815,'Milford','Milford','US ','MLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1816,'Miller Field','Reed City','US ','RCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1817,'Miller Field','Valentine','US ','VTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1818,'Millington Regional Jetport','Millington TN','US ','NQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1819,'Millinocket','Millinocket','US ','MLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1820,'Millville','Millville','US ','MIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1821,'Milwaukee General Mitchell','Milwaukee','US ','ZML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1822,'Mineral Wells Arpt','Mineral Wells','US ','MWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1823,'Mineta San Jose International Airport','San Jose','US ','SJC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1824,'Minneapolis - St. Paul Intl','Minneapolis','US ','MSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1825,'Minot AFB','Minot','US ','MIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1826,'Minto','Minto','US ','MNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1827,'Minute Man Airfield','Stow','US ','MMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1828,'Miramar MCAS','San Diego','US ','NKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1829,'Mission Field','Livingston','US ','LVM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1830,'Missoula International','Missoula','US ','MSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1831,'Mob Aerospace','Mobile','US ','BFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (1832,'Moberly','Moberly','US ','MBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2056,'Municipal Airport','Aurora','US ','AUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2057,'Municipal Airport','Fort Collins/Loveland','US ','FNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2058,'Municipal Heliport','Mankato','US ','JMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2059,'Municipal Heliport','Rochester','US ','JRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2060,'Municipal Heliport','Saint Cloud','US ','JSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2061,'Municipal-Ryan Field','Marshall','US ','MML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2062,'Municipal/Baer Field','Fort Wayne','US ','FWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2063,'Municipal/Spaatz Fld','Reading','US ','RDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2064,'Murray Field','Eureka CA','US ','EKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2065,'Muscatine','Muscatine','US ','MUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2066,'Muskegon','Muskegon','US ','MKG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2067,'Mustin Alf','Philadelphia','US ','MUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2068,'Myrtle Beach Afb','Myrtle Beach','US ','MYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2069,'N Philadelphia Rail St','Philadelphia','US ','ZHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2070,'Naec','Lakehurst','US ','NEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2071,'NAF','Dahlgren','US ','DGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2072,'Naknek','Naknek','US ','NNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2073,'Nakolik River','Nakolik River','US ','NOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2074,'Nantucket Memorial','Nantucket','US ','ACK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2075,'Nanwalek','Nanwalek','US ','KEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2076,'Napa County','Napa','US ','APC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2077,'Napakiak SPB','Napakiak','US ','WNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2078,'Naples','Naples','US ','APF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2079,'NAS','Alameda','US ','NGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2080,'NAS','Brunswick','US ','NHZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2081,'NAS','Fallon','US ','NFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2082,'NAS','Glenview','US ','NBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2083,'NAS','Imperial Beach','US ','NRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2084,'NAS','Kingsville','US ','NQI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2085,'NAS','Oceana','US ','NTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2086,'Nas Chambers','Norfolk','US ','NGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2087,'NAS/Alvin Callendar','New Orleans','US ','NBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2088,'Nashville International','Nashville TN','US ','BNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2089,'National','Rolla','US ','RLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2090,'National Park','Grand Canyon','US ','GCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2091,'Natrona County International Airport','Casper WY','US ','CPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2092,'Naukiti','Naukiti','US ','NKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2093,'ndiana County Airport','Indiana PA','US ','IDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2094,'Needles','Needles','US ','EED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2095,'Neil Armstrong','Wapakoneta','US ','AXV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2096,'Nellis AFB','Las Vegas NV','US ','LSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2097,'Nelson Lagoon','Nelson Lagoon','US ','NLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2098,'Neosho','Neosho','US ','EOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2099,'Nephi','Nephi','US ','NPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2100,'Nevada','Nevada','US ','NVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2101,'New Bedford','New Bedford','US ','EWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2102,'New Carrolton RR','Washington','US ','ZRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2103,'New Century Aircenter Airport','Olathe KS','US ','JCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2104,'New Chenega','New Chenega','US ','NCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2105,'New Haven','New Haven','US ','HVN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2106,'New Haven Rail','New Haven','US ','ZVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2107,'New Koliganek','New Koliganek','US ','KGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2108,'New London','New London','US ','GON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2109,'New London Rail','Groton','US ','ZGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2110,'New River Valley','Dublin','US ','PSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2111,'New Stuyahok','New Stuyahok','US ','KNW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2112,'New Ulm','New Ulm','US ','ULM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2113,'Newark Liberty International','Newark','US ','EWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2114,'Newport','Newport','US ','ONP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2115,'Newport','Newport','US ','EFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2116,'Newport News Rail','Hampton','US ','ZWW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2117,'Newport News/williamsb','Newport News','US ','PHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2118,'Newtok','Newtok','US ','WWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2119,'Nez Perce County Rgnl','Lewiston','US ','LWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2120,'Niblack','Niblack','US ','NIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2121,'Nichen Cove','Nichen Cove AK','US ','NKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2122,'Nightmute','Nightmute','US ','NME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2123,'Nikolai','Nikolai','US ','NIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2124,'Nikolski AFS','Nikolski','US ','IKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2125,'Ninilchik','Ninilchik','US ','NIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2126,'Noatak','Noatak','US ','WTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2127,'Noble F. Lee','Minocqua','US ','ARV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2128,'Nome','Nome','US ','OME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2202,'Palacios','Palacios','US ','PSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2203,'Palestine Municipal Airport','Palestine TX','US ','PSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2204,'Palm Beach Co Glades','Pahokee','US ','PHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2205,'Palm Beach County Park','West Palm Beach','US ','LNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2206,'Palm Beach International','West Palm Beach','US ','PBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2207,'Palo Alto','Palo Alto','US ','PAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2208,'Pangborn Field','Wenatchee','US ','EAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2209,'Panguitch','Panguitch','US ','PNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2210,'Park & Ride Bus Svc','Rockford','US ','ZRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2211,'Park Falls','Park Falls','US ','PKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2212,'Park Rapids','Park Rapids','US ','PKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2213,'Park Township','Holland','US ','HLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2214,'Parker County','Weatherford','US ','WEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2215,'Parks SPB','Parks','US ','KPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2216,'Parlin Field','Newport','US ','NWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2217,'Paso Robles','Paso Robles','US ','PRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2218,'Patterson Afb','Dayton','US ','FFO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2219,'Patuxent River NAS','Patuxent River MD','US ','NHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2220,'Pauloff Harbor SPB','Pauloff Harbor','US ','KPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2221,'Payson','Payson','US ','PJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2222,'Peach Springs','Peach Springs','US ','PGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2223,'Pearl River County','Picayune','US ','PCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2224,'Pease International','Portsmouth NH','US ','PSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2225,'Peconic River','Calverton','US ','CTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2226,'Pecos City','Pecos City','US ','PEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2227,'Pecos County','Fort Stockton','US ','FST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2228,'Pedro Bay','Pedro Bay','US ','PDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2229,'Pelican SPB','Pelican','US ','PEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2230,'Pendleton','Pendleton','US ','PDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2231,'Penn Valley','Selinsgrove','US ','SEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2232,'Pennsylvania Railroad Station','Newark','US ','ZRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2233,'Pentagon Army','Washington','US ','JPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2234,'Perimeter Mall','Atlanta','US ','JAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2235,'Perry Lefors Field','Pampa','US ','PPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2236,'Perry SPB','Perry Island','US ','PYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2237,'Perry-Foley','Perry','US ','FPY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2238,'Perryville SPB','Perryville','US ','KPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2239,'Petersburg James A Johnson','Petersburg AK','US ','PSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2240,'Petit Jean Park','Morrilton','US ','MPJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2241,'Phifer Field','Wheatland','US ','EAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2242,'Philadelphia International','Philadelphia','US ','PHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2243,'Philip','Philip','US ','PHP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2244,'Philip Billard','Topeka','US ','TOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2245,'Phillips AAF','Aberdeen','US ','APG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2246,'Phillips Field','Fairbanks','US ','PII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2247,'Phoenix Deer Valley Airport','Phoenix','US ','DVT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2248,'Pickens','Pickens','US ','LQK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2249,'Piedmont Triad Intl','Greensboro NC','US ','GSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2250,'Pier 11/Wall St. SPB','New York','US ','NWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2251,'Pierre','Pierre','US ','PIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2252,'Pike County','Mccomb','US ','MCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2253,'Pilot Point','Pilot Point','US ','PIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2254,'Pilot Station','Pilot Station','US ','PQS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2255,'Pine Island Airport','Corolla NC','US ','DUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2256,'Pine Ridge','Pine Ridge','US ','XPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2257,'Pinehurst-S. Pines','Southern Pines','US ','SOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2258,'Pitt-Greenville','Greenville','US ','PGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2259,'Pittsburgh International','Pittsburgh PA','US ','PIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2260,'Pittsfield','Pittsfield','US ','PSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2261,'Placerville','Placerville','US ','PVF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2262,'Platinum','Platinum','US ','PTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2263,'Plattsburgh International','Plattsburgh','US ','PBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2264,'Pleasant Harbour','Pleasant Harbour','US ','PTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2265,'Plymouth','Plymouth','US ','PLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2266,'Plymouth','Plymouth','US ','PYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2267,'Pocatello','Pocatello','US ','PIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2268,'Point Baker SPB','Point Baker','US ','KPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2269,'Point Barrow','Barrow','US ','PBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2270,'Point Hope','Point Hope','US ','PHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2271,'Point Mugu NAS','Port Hueneme CA','US ','NTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2272,'Polacca','Polacca','US ','PXL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2273,'Polk AAF','Fort Polk','US ','POE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2274,'Polk Inlet','Polk Inlet','US ','POQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2275,'Pompano Beach','Pompano Beach','US ','PPM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2276,'Ponca City','Ponca City','US ','PNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2277,'Pontiac','Pontiac','US ','PTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2278,'Pope AFB','Fayetteville NC','US ','POB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2279,'Pope Field','Greenfield','US ','GFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2280,'Pope Vanoy','Pope Vanoy','US ','PVY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2281,'Porcupine Creek','Porcupine Creek','US ','PCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2282,'Port Alexander','Port Alexander','US ','PTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2283,'Port Alice','Port Alice','US ','PTC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2284,'Port Allen','Hanapepe','US ','PAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2285,'Port Alsworth','Port Alsworth','US ','PTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2286,'Port Armstrong','Port Armstrong','US ','PTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2287,'Port Bailey SPB','Port Bailey','US ','KPY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2288,'Port Clarence','Port Clarence','US ','KPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2289,'Port Columbus Intl','Columbus','US ','CMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2290,'Port Frederick','Port Frederick','US ','PFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2291,'Port Graham','Port Graham','US ','PGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2292,'Port Heiden','Port Heiden','US ','PTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2293,'Port Johnson','Port Johnson','US ','PRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2294,'Port Largo','Key Largo','US ','KYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2295,'Port Lions SPB','Port Lions','US ','ORI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2296,'Port Oceanic','Port Oceanic','US ','PRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2297,'Port Protection','Port Protection','US ','PPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2298,'Port San Juan','Port San Juan','US ','PJS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2299,'Port Townsend','Port Townsend','US ','TWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2300,'Port Walter','Port Walter','US ','PWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2301,'Port Williams SPB','Port Williams','US ','KPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2302,'Portage Creek','Portage Creek','US ','PCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2303,'Porter County','Valparaiso','US ','VPZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2304,'Porterville','Porterville','US ','PTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2305,'Portland','Hillsboro','US ','HIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2306,'Portland International','Portland OR','US ','PDX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2307,'Pottstown/Limerick','Pottstown','US ','PTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2308,'Poulsbo','Poulsbo','US ','PUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2309,'Powell','Powell','US ','POY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2310,'Pratt','Pratt','US ','PTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2311,'Prentice','Prentice','US ','PRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2312,'Prescott','Prescott','US ','PRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2313,'Preston-Glenn Field','Lynchburg','US ','LYH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2314,'Princeton','Princeton','US ','PNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2315,'Princeton','Princeton','US ','PCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2316,'Princeton','Princeton','US ','BLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2317,'Princeton JT Rail','Princeton','US ','ZTJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2318,'Princeville','Kauai Island','US ','HPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2319,'Prineville','Prineville','US ','PRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2320,'Prospect Creek','Prospect Creek','US ','PPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2321,'Providence Rail','Providence','US ','ZRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2322,'Provincetown','Provincetown','US ','PVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2323,'Provo','Provo','US ','PVU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2324,'Prudhoe Bay','Prudhoe Bay','US ','PUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2325,'Prudhoe Bay/Deadhorse','Prudhoe Bay/Deadhorse','US ','SCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2326,'Public','Boca Raton','US ','BCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2327,'Public','Santa Maria','US ','SMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2328,'Pulaski County','Somerset','US ','SME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2329,'Pulliam Field','Grand Canyon','US ','FLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2330,'Pullman-Moscow Regional Airport','Pullman','US ','PUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2331,'Purdue University','Lafayette','US ','LAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2332,'Quad-City','Moline','US ','MLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2333,'Quantico Nas','Quantico','US ','NYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2334,'Quartz Creek','Cooper Lodge','US ','JLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2335,'Quartz Hill','Lancaster','US ','RZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2336,'Queen','Queen','US ','UQE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2337,'Quillayute State','Quillayute','US ','UIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2338,'Quincy','Quincy','US ','MQI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2339,'Raleigh','Harrisburg','US ','HSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2340,'Raleigh-durham International Airport','Raleigh/Durham NC','US ','RDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2341,'Ralph Calhoun','Tanana','US ','TAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2342,'Rampart','Rampart','US ','RMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2343,'Randolph AFB','San Antonio','US ','RND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2344,'Rangely','Rangely','US ','RNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2345,'Ranger Municipal','Ranger','US ','RGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2346,'Raspberry Strait','Raspberry Strait','US ','RSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2347,'Rawlins','Rawlins','US ','RWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2348,'Red Bluff Fss','Red Bluff','US ','RBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2349,'Red Devil','Red Devil','US ','RDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2350,'Redbird','Dallas','US ','RBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2351,'Redding','Redding','US ','RDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2352,'Redwood Falls Muni','Redwood Falls','US ','RWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2353,'Reese AFB','Lubbock','US ','REE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2354,'Regional','Daytona Beach','US ','DAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2355,'Regional','Farmington','US ','FAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2356,'Regional','Fort Smith','US ','FSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2357,'Regional','Pensacola','US ','PNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2358,'Regional','Rapid City','US ','RAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2359,'Regional','Shreveport','US ','SHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2360,'Regional','Thief River Falls','US ','TVF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2361,'Regional','Valdosta','US ','VLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2362,'Regional','Whitefield','US ','HIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2363,'Rehoboth Beach','Rehoboth Beach','US ','REH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2364,'Reid-hillview','San Jose','US ','RHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2365,'Renner Field','Goodland','US ','GLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2366,'Reno-Tahoe International','Reno NV','US ','RNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2367,'Rensselaer','Rensselaer','US ','RNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2368,'Renton','Renton WA','US ','RNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2369,'Rentschler','East Hartford','US ','EHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2370,'Rep','Mount Shasta','US ','MHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2371,'Republic Field','Farmingdale','US ','FRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2372,'Reynolds','Richfield','US ','RIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2373,'Reynolds Municipal','Jackson','US ','JXN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2374,'Rice Lake','Rice Lake','US ','RIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2375,'Richard B Russell','Rome','US ','RMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2376,'Richard I Bong Arpt','Superior','US ','SUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2377,'Richards Field','Massena','US ','MSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2378,'Richards-Gebaur','Grandview','US ','GVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2379,'Richland','Richland','US ','RLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2380,'Richland Municipal','Sidney','US ','SDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2381,'Richmond International Airport','Richmond VA','US ','RIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2382,'Richmond Municipal Airport','Richmond IN','US ','RID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2383,'Richmond VA Rail','Richmond','US ','ZRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2384,'Rick Husband Amarillo International','Amarillo TX','US ','AMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2385,'Rickenbacker','Columbus','US ','LCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2386,'Rinkenberger','Bradford','US ','BDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2387,'Riverside Fla-Bob','Riverside','US ','RIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2388,'Riverside Municipal','Riverside','US ','RAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2389,'Riverton Regional','Riverton WY','US ','RIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2390,'Roanoke Regional Airport','Roanoke','US ','ROA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2391,'Robert Lafleur','Waterville','US ','WVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2392,'Robert S Kerr','Poteau','US ','RKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2393,'Roberts AAF','San Miguel','US ','SYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2394,'Roberts Field','Redmond','US ','RDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2395,'Robins AFB','Macon','US ','WRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2396,'Roche Harbor','Roche Harbor','US ','RCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2397,'Rochester NY Rail','Rochester','US ','ZTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2398,'Rock County','Janesville','US ','JVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2399,'Rock Hill','Rock Hill','US ','RKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2400,'Rocky Mount-wilson','Rocky Mount','US ','RWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2401,'Rogers','Rogers','US ','ROG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2402,'Rogue Valley International - Medford Airport','Medford','US ','MFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2403,'Rolla National','Vichy','US ','VIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2404,'Rollang Field','Anguilla','US ','RFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2405,'Ronald Reagan Washington National Airport','Washington DC','US ','DCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2406,'Rooke Field','Refugio','US ','RFG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2407,'Roosevelt','Roosevelt','US ','ROL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2408,'Rosario SPB','Rosario','US ','RSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2409,'Roscoe Turner','Corinth','US ','CRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2410,'Roscommon County','Houghton','US ','HTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2411,'Rosecrans Memorial','St Joseph','US ','STJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2412,'Ross Field','Benton Harbor','US ','BEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2413,'Rotunda','Rotunda','US ','RTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2414,'Roundup','Roundup','US ','RPX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2415,'Rouses Point','Rouses Point','US ','RSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2416,'Rowan Bay','Rowan Bay','US ','RWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2417,'Rowan County','Salisbury','US ','SRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2418,'Reivilo','Reivilo','ZA ','RVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2419,'Richards Bay','Richards Bay','ZA ','RCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2420,'Robertson','Robertson','ZA ','ROD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2421,'Sabi Sabi','Sabi Sabi','ZA ','GSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2422,'Secunda','Secunda','ZA ','ZEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2423,'Sishen','Sishen','ZA ','SIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2424,'Skukuza','Skukuza','ZA ','SZK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2425,'Springbok','Springbok','ZA ','SBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2426,'Tanda Tula','Tanda Tula','ZA ','TDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2427,'Thaba Nchu','Thaba Nchu','ZA ','TCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2428,'Thohoyandou','Thohoyandou','ZA ','THY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2429,'Tshipise','Tshipise','ZA ','TSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2430,'Ulundi','Ulundi','ZA ','ULD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2431,'Ulusaba','Ulusaba','ZA ','ULX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2432,'Umtata','Umtata','ZA ','UTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2433,'Upington','Upington','ZA ','UTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2434,'Virginia','Durban','ZA ','VIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2435,'Vredendal','Vredendal','ZA ','VRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2436,'Vryburg','Vryburg','ZA ','VRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2437,'Vryheid','Vryheid','ZA ','VYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2438,'Waterkloof AFB','Waterkloof','ZA ','WKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2439,'Welkom','Welkom','ZA ','WEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2440,'Wonderboom Apt.','Pretoria','ZA ','PRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2441,'Zulu Inyala','Phinda','ZA ','PZL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2442,'Aeroport De La Seu','Seu De Urgel','ES ','LEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2443,'Agoncillo','Logrono','ES ','RJL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2444,'Alicante El Altet','Alicante','ES ','ALC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2445,'Almeria','Almeria','ES ','LEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2446,'Asturias','Oviedo/Aviles','ES ','OVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2447,'Barajas','Madrid','ES ','MAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2448,'Bobadilla','Bobadilla','ES ','OZI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2449,'Bus Station','San Pedro de Alcantara','ES ','ZRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2450,'Cadiz','Cadiz','ES ','CDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2451,'Ceuta Heliport','Ceuta','ES ','JCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2452,'Ciudad Real - Don Quijote Airport','Ciudad Real','ES ','CJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2453,'Cordoba','Cordoba','ES ','ODB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2454,'Donostia - San Sebastian','San Sebastian','ES ','EAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2455,'El Prat De Llobregat','Barcelona','ES ','BCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2456,'Fuengirola','Fuengirola','ES ','FGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2457,'Fuerteventura','Puerto del Rosario','ES ','FUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2458,'Girona-Costa Brava','Gerona','ES ','GRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2459,'Gran Canaria','Las Palmas','ES ','LPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2460,'Granada','Granada','ES ','GRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2461,'Hierro','Valverde','ES ','VDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2462,'Huelva','Huelva','ES ','HEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2463,'Ibiza','Ibiza','ES ','IBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2464,'Jerez De La Frontera','Jerez De La Frontera','ES ','XRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2465,'La Coruna','La Coruna','ES ','LCG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2466,'La Gomera','San Sebas De La Gomera','ES ','GMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2467,'La Palma','Santa Cruz De La Palma','ES ','SPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2468,'La Palma Del Condado','La Palma Del Condado','ES ','NDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2469,'Lanzarote','Arrecife','ES ','ACE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2470,'Leon','Leon','ES ','LEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2471,'Los Llanos','Albacete','ES ','ABC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2472,'Mahon','Menorca','ES ','MAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2473,'Matacan','Salamanca','ES ','SLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2474,'Melilla','Melilla','ES ','MLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2475,'Montilla','Montilla','ES ','OZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2476,'Moron','Moron','ES ','OZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2477,'Pablo Ruiz Picasso','Malaga','ES ','AGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2478,'Pamplona','Pamplona','ES ','PNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2479,'Puerto De Santa Maria','Puerto De Santa Maria','ES ','PXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2480,'Puertollano','Puertollano','ES ','UER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2481,'Reus','Reus','ES ','REU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2482,'Ronda','Ronda','ES ','RRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2483,'San Fernando','San Fernando','ES ','FES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2484,'San Javier','Murcia','ES ','MJV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2485,'San Pablo','Sevilla','ES ','SPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2486,'San Pablo','Sevilla','ES ','SVQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2487,'Santander','Santander','ES ','SDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2488,'Santiago De Compostela','Santiago De Compostela','ES ','SCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2489,'Son Sant Joan Airport','Palma Mallorca','ES ','PMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2490,'Sondica','Bilbao','ES ','BIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2491,'Sur Reina Sofia','Tenerife','ES ','TFS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2492,'Talaveral La Real','Badajoz','ES ','BJZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2493,'Tenerife Norte','Tenerife','ES ','TFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2494,'Torrejon Afb','Madrid','ES ','TOJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2495,'Torremolinos','Torremolinos','ES ','UTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2496,'Valencia','Manises','ES ','VLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2497,'Valladolid','Valladolid','ES ','VLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2498,'Vigo','Vigo','ES ','VGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2499,'Vitoria.','Vitoria.','ES ','VIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2500,'Zaragoza','Zaragoza','ES ','ZAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2501,'Ampara','Ampara','LK ','ADP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2502,'Amparai','Gal Oya','LK ','GOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2503,'Anuradhapura','Anuradhapura','LK ','ACJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2504,'Bandaranayake','Colombo','LK ','CMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2505,'Batticaloa','Batticaloa','LK ','BTC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2506,'Bentota River','Bentota River','LK ','BJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2507,'Castlereigh Reservoir','Hatton','LK ','NUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2508,'China Bay','Trincomalee','LK ','TRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2509,'Dambulu Oya Tank','Dambula','LK ','DBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2510,'Hingurakgoda','Hingurakgoda','LK ','HIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2511,'Kankesanturai','Jaffna','LK ','JAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2512,'Katukurunda Slaf Base','Katukurunda','LK ','KTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2513,'Kelaniya River','Kelaniya','LK ','KEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2514,'Koggala','Koggala','LK ','KCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2515,'Kondavattavan Tank','Ampara','LK ','AFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2516,'Mahaweli','Mahaweli','LK ','KDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2517,'Mawella Lagoon','Dickwella','LK ','DIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2518,'Minneriya','Minneriya','LK ','MNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2519,'Polgolla Reservoir','Katugastota','LK ','KDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2520,'Sigiriya Slaf Base','Sigiriya','LK ','GIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2521,'Vic. Resevour Kandy','Kandy','LK ','KDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2522,'Wirawila','Wirawila','LK ','WRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2523,'Wideawake Field','Georgetown Ascension Island','SH ','ASI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2524,'Miquelon Aprt','Miquelon','PM ','MQC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2525,'Saint-pierre Pointe-blanche','St Pierre','PM ','FSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2526,'Ad-Dabbah','Ad-Dabbah','SD ','AAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2527,'Atbara','Atbara','SD ','ATB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2528,'Civil','Khartoum','SD ','KRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2529,'Dongola','Dongola','SD ','DOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2530,'El Fasher','El Fasher','SD ','ELF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2531,'El Obeid','El Obeid','SD ','EBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2532,'Eldebba','Eldebba','SD ','EDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2533,'En Nahud','En Nahud','SD ','NUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2534,'Galegu','Dinder','SD ','DNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2535,'Gedaref','Gedaref','SD ','GSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2536,'Geneina','Geneina','SD ','EGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2537,'Higlieg','Higlieg','SD ','HGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2538,'Juba','Juba','SD ','JUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2539,'Kassala','Kassala','SD ','KSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2540,'Khashm El Girba','Khashm El Girba','SD ','GBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2541,'Kosti','Kosti','SD ','KST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2542,'Malakal','Malakal','SD ','MAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2543,'Merowe','Merowe','SD ','MWE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2544,'New Halfa','New Halfa','SD ','NHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2545,'Nyala','Nyala','SD ','UYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2546,'Port Sudan','Port Sudan','SD ','PZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2547,'Roseires','Roseires','SD ','RSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2548,'Wad Medani','Wad Medani','SD ','DNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2549,'Wadi Halfa','Wadi Halfa','SD ','WHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2550,'Wau','Wau','SD ','WUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2551,'Albina','Albina','SR ','ABN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2552,'Botopasie','Botopasie','SR ','BTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2553,'Cayana Airstrip','Awaradam','SR ','AAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2554,'Djoemoe','Djoemoe','SR ','DOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2555,'Ladouanie','Ladouanie','SR ','LDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2556,'Moengo','Moengo','SR ','MOJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2557,'Nieuw Nickerie','Nieuw Nickerie','SR ','ICK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2558,'Stoelmans Eiland','Stoelmans Eiland','SR ','SMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2559,'Wageningen','Wageningen','SR ','AGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2560,'Washabo','Washabo','SR ','WSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2561,'Zanderij Intl','Paramaribo','SR ','PBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2562,'Zorg En Hoop','Paramaribo','SR ','ORG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2563,'Matsapha Intl','Manzini','SZ ','MTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2564,'Angelholm','Angelholm/Helsingborg','SE ','AGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2129,'Nondalton','Nondalton','US ','NNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2130,'Norfolk International Airport','Norfolk','US ','ORF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2131,'North Air Terminal','Las Vegas','US ','VGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2132,'North Bend','North Bend','US ','OTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2133,'North Central','Pawtucket RI','US ','SFZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2134,'North Fork Valley','Paonia','US ','WPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2135,'North Island Nas','San Diego','US ','NZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2136,'North Park Inn H/P','Dallas','US ','JNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2137,'North Perry','Hollywood','US ','HWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2138,'North Philadelphia','Philadelphia','US ','PNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2139,'North Rim','Grand Canyon','US ','NGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2140,'North Shore','Umnak Island','US ','UMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2141,'Northway','Northway','US ','ORT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2142,'Northwest Arkansas Regional','Fayetteville AR','US ','XNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2143,'Norton Afb','San Bernardino','US ','SBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2144,'Novato','Novato','US ','NOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2145,'Ns','Mayport','US ','NRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2146,'Nuiqsut','Nuiqsut','US ','NUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2147,'Nulato','Nulato','US ','NUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2148,'Nunapitchuk','Nunapitchuk','US ','NUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2149,'Nyac','Nyac','US ','ZNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2150,'Oak Harbor','Oak Harbor','US ','ODW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2151,'Oakland International Airport','Oakland','US ','OAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2152,'Oakland/Coliseum Stat','Oakland MD','US ','OBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2153,'Ocean Reef','Ocean Reef','US ','OCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2154,'Oceanic','Oceanic','US ','OCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2155,'Oconee County','Clemson','US ','CEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2156,'Off line Point','Rail','US ','XZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2157,'Ogdensburg','Ogdensburg','US ','OGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2158,'Ohio County','Wheeling','US ','HLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2159,'Ohio State University','Columbus','US ','OSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2160,'Ohio University','Athens','US ','ATO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2161,'Okmulgee','Okmulgee','US ','OKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2162,'Old Harbor SPB','Old Harbor','US ','OLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2163,'Old Town','Old Town','US ','OLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2164,'Olf Usn','Whitehouse','US ','NEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2165,'Olga Bay SPB','Olga Bay','US ','KOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2166,'Olive Branch Arpt','Olive Branch','US ','OLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2167,'Olney','Olney','US ','ONY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2168,'Olney-Noble','Olney','US ','OLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2169,'Olympia','Olympia','US ','OLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2170,'Oneal','Vincennes','US ','OEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2171,'Oneida County','Rhinelander','US ','RHI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2172,'Oneida County','Utica','US ','UCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2173,'Onion Bay','Onion Bay','US ','ONN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2174,'Ontario International','Ontario','US ','ONT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2175,'Ontario Municipal Airport','Ontario','US ','ONO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2176,'Opa Locka','Miami','US ','OPF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2177,'Orange County','Montgomery','US ','MGJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2178,'Orange County Steel Salvage Heliport','Anaheim','US ','ANA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2179,'Orcas Island','Eastsound','US ','ESD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2180,'Orlando Executive','Orlando','US ','ORL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2181,'Orlando International','Orlando','US ','MCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2182,'Orlando Sanford Intl','Sanford','US ','SFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2183,'Oroville','Oroville','US ','OVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2184,'Osage Beach','Osage Beach','US ','OSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2185,'Oshkosh','Oshkosh','US ','OKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2186,'Otis AFB','Falmouth','US ','FMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2187,'Otsego County','Gaylord','US ','GLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2188,'Outagamie County','Appleton','US ','ATW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2189,'Outlaw Field','Clarksville TN','US ','CKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2190,'Ouzinkie SPB','Ouzinkie','US ','KOZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2191,'Owatonna','Owatonna','US ','OWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2192,'Owens Field','Columbia','US ','CUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2193,'Oxnard','Santa Paula','US ','SZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2194,'Ozona Municipal','Ozona','US ','OZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2195,'Pacific City State','Pacific City OH','US ','PFC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2196,'Pack Creek','Pack Creek','US ','PBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2197,'Paf Warren','Paf Warren','US ','PFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2198,'Page','Page','US ','PGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2199,'Page Field','Fort Myers','US ','FMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2200,'Painter Creek','Painter Creek','US ','PCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2201,'Pal-Waukee','Chicago','US ','PWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2940,'Glasgow International','Glasgow','GB ','GLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2941,'Glenegedale','Islay','GB ','ILY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2942,'Gloucestershire','Gloucester','GB ','GLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2943,'Greenham RAF','Newbury','GB ','EWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2944,'Guernsey','Guernsey','GB ','GCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2945,'Gypsy','Swindon','GB ','SWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2946,'Hatfield','Hatfield','GB ','HTF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2947,'Haverfordwest','Haverfordwest','GB ','HAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2948,'Heliport','Fort William','GB ','FWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2949,'Heliport','Lochgilphead','GB ','LPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2950,'Heliport','Oban','GB ','OHP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2951,'Heliport','Rothesay','GB ','RAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2952,'Hendon','Hendon','GB ','HEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2953,'High Wycombe','High Wycombe','GB ','HYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2954,'Honington','Bury St Edmunds','GB ','BEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2955,'Hoy Island','Hoy Island','GB ','HOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2956,'Humberside International','Humberside','GB ','HUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2957,'Inverness','Inverness','GB ','INV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2958,'Ipswich','Ipswich','GB ','IPW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2959,'Isle Of Coll','Isle Of Coll','GB ','COL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2960,'Isle Of Colonsay','Isle Of Colonsay','GB ','CSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2961,'Jersey','Jersey','GB ','JER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2962,'Kent International','Manston','GB ','MSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2963,'Kinloss','Forres','GB ','FSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2964,'Lakenheath RAF','Brandon','GB ','LKZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2965,'Lands End','Lands End','GB ','LEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2966,'Leeds/bradford','Leeds','GB ','LBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2967,'Lerwick/Tingwall','Shetland Islands','GB ','LWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2968,'Leuchars','St Andrews','GB ','ADX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2969,'Linton-On-Ouse','Harrogate','GB ','HRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2970,'Liverpool John Lennon','Liverpool','UK ','LPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2971,'London City Airport','London','GB ','LCY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2972,'London Gatwick','London','GB ','LGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2973,'London Heathrow','London','UK ','LHR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2974,'London Luton','Luton','GB ','LTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2975,'London Southend','Southend','GB ','SEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2976,'Machrihanish','Campbeltown','GB ','CAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2977,'Manchester','Manchester','GB ','MAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2978,'Manchester Bus Stn.','Manchester','GB ','ZMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2979,'Marham RAF','Kings Lynn','GB ','KNF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2980,'Mildenhall Arpt','Mildenhall','GB ','MHZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2981,'Milton Keynes','Milton Keynes','GB ','KYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2982,'Mull','Mull','GB ','ULL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2983,'NAF','Mildenhall','GB ','GXH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2984,'Newcastle Airport','Newcastle','GB ','NCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2985,'Newquay Cornwall Airport','Newquay','GB ','NQY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2986,'North Bay','Barra','GB ','BRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2987,'North Ronaldsay','North Ronaldsay','GB ','NRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2988,'Northampton','Northampton','GB ','ORM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2989,'Northolt','Northolt','GB ','NHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2990,'Norwich International Airport','Norwich','GB ','NWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2991,'Nottingham Airport','Nottingham','GB ','NQT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2992,'Oban Airport','Oban','GB ','OBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2993,'Off Line Point','Hammersmith','GB ','WUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2994,'Orkney Island','Orkney Island','GB ','KOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2995,'Oxford','Oxford','GB ','OXF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2996,'Papa Westray','Papa Westray','GB ','PPW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2997,'Penzance','Penzance','GB ','PZE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2998,'Perth','Perth','GB ','PSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2999,'Plymouth','Plymouth','GB ','PLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3000,'Portsmouth','Portsmouth','GB ','PME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3001,'Prestwick','Prestwick South Ayrshire','GB ','PIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3002,'Raf Brize Norton','Oxford','GB ','BZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3003,'RAF Station','Abingdon','GB ','ABB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3004,'RAF Station','Alconbury','GB ','AYH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3005,'RAF Station','Fairford','GB ','FFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3006,'RAF Station','Lossiemouth','GB ','LMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3007,'RAF Station','Lyneham','GB ','LYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3008,'RAF Station','Machrihanish','GB ','GQJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3009,'RAF Station','Odiham','GB ','ODH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3010,'RAF Station','Scampton','GB ','SQZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3011,'RAF Station','Upper Heyford','GB ','UHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3012,'RAF Station','Waddington','GB ','WTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3013,'Railway Station','Nottingham','GB ','XQI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3014,'Railway Station','Nottingham','GB ','XQH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3015,'Railway Station','Swindon','GB ','XWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3016,'Robin Hood','Doncaster Sheffield','GB ','DSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3017,'Rochester','Rochester','GB ','RCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3018,'Ronaldsway','Isle Of Man','GB ','IOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3019,'Sanday','Sanday','GB ','NDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3020,'Scatsta','Shetland Islands','GB ','SCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3021,'ScotRail','Dundee','GB ','ZDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3022,'ScotRail','Inverness','GB ','ZIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3023,'ScotRail','Perth','GB ','ZXP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3024,'Sculthorp RAF','Fakenham','GB ','FKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3025,'Sheffield City Airport','Sheffield','GB ','SZD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3026,'Shoreham','Shoreham By Sea','GB ','ESH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3027,'Southampton Airport','Eastleigh near Southampton','GB ','SOU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3028,'St Marys','Isles Of Scilly','GB ','ISC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3029,'Stansted','London','GB ','STN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3030,'Stornoway','Stornoway','GB ','SYY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3031,'Stronsay','Stronsay','GB ','SOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3032,'Sumburgh','Shetland Islands','GB ','LSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3033,'The Blaye','Alderney','GB ','ACI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3034,'Tiree','Tiree','GB ','TRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3035,'Tresco','Isles Of Scilly','GB ','TSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3036,'Upavon','Upavon','GB ','UPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3037,'Walney Island','Barrow-In-Furness','GB ','BWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3038,'Weathersfield Raf','Braintree','GB ','WXF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3039,'West Malling','West Malling','GB ','WEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3040,'West Midlands International','Coventry','GB ','CVT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3041,'Westray','Westray','GB ','WRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3042,'Whalsay','Whalsay','GB ','WHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3043,'Wick','Wick','GB ','WIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3044,'Woodbridge RAF','Suttonheath','GB ','WOB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3045,'Woodford','Woodford','GB ','WFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3046,'Yeovilton','Yeovilton','GB ','YEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3047,'A L Mangham Jr. Regional','Nacogdoches TX','US ','OCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3048,'AAF Heliport','Fort Devens','US ','AYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3049,'Acadiana Regional','New Iberia','US ','ARA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3050,'Accomack County','Melfa','US ','MFV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3051,'Adak Island Ns','Adak Island','US ','ADK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3052,'Adams Field Airport','Little Rock AR','US ','LIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3053,'Addison Airport','Dallas','US ','ADS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3054,'Adirondack','Saranac Lake','US ','SLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3055,'Af Aux','Indian Springs','US ','INS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3056,'AFB','Homestead','US ','HST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3057,'AFB','Mountain Home','US ','MUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3058,'AFS','Northeast Cape','US ','OHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3059,'AFS','Port Moller','US ','PML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3060,'Ainsworth','Ainsworth','US ','ANW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3061,'Air Terminal','Hayward','US ','HWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3062,'Airpark','Midland','US ','MDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3063,'Airstrip','Kavik','US ','VIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3064,'Akhiok SPB','Akhiok','US ','AKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3065,'Akiak','Akiak','US ','AKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3066,'Akron/canton Regional','Akron/Canton OH','US ','CAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3067,'Akutan','Akutan','US ','KQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3068,'Alakanuk','Alakanuk','US ','AUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3069,'Albany','Albany','US ','CVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3070,'Albany International','Albany','US ','ALB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3071,'Albemarle','Charlottesville','US ','CHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3072,'Albert J Ellis','Jacksonville','US ','OAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3073,'Albert Lea','Albert Lea','US ','AEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3074,'Albertus','Freeport','US ','FEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3075,'Albuquerque International','Albuquerque','US ','ABQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3076,'Aleknagik','Aleknagik','US ','WKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3077,'Aleneva','Aleneva','US ','AED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3078,'Alexander Field','Wisconsin Rapids','US ','ISW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3079,'Alexandria','Alexandria','US ','AXN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3080,'Alexandria Bay','Alexandria Bay','US ','AXB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3081,'Alexandria International','Alexandria LA','US ','AEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3082,'Algona','Algona','US ','AXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3083,'Alitak SPB','Alitak','US ','ALZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3084,'Allakaket','Allakaket','US ','AET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3085,'Allegheny County','Pittsburgh','US ','AGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3086,'Allen County','Lima','US ','AOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3087,'Alliance','Alliance','US ','AIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3088,'Alpena County Regional','Alpena','US ','APN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3089,'Alpine','Alpine','US ','ALE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3090,'Alton','Alton','US ','ALN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3091,'Altus AFB','Altus','US ','LTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3092,'Alyeska','Alyeska','US ','AQY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3093,'Ambler','Ambler','US ','ABL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3094,'Amchitka','Amchitka','US ','AHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3095,'Amedee AAF','Herlong','US ','AHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3096,'Ames','Ames','US ','AMW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3097,'Amook','Amook','US ','AOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3098,'Anacortes','Anacortes','US ','OTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3099,'Anaktuvuk','Anaktuvuk','US ','AKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3100,'Anderson','Anderson','US ','AND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3101,'Andrau Airpark','Houston TX','US ','AAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3102,'Andrews','Andrews','US ','ADR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3103,'Andrews AFB','Camp Springs','US ','ADW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3104,'Andrews NAF','Camp Springs','US ','NSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3105,'Angel Fire','Angel Fire','US ','AXX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3106,'Angoon','Angoon','US ','AGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3107,'Aniak','Aniak','US ','ANI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3108,'Animas Airpark','Durango','US ','AMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3109,'Anita Bay','Anita Bay','US ','AIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3110,'Annette Island','Annette Island','US ','ANN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3111,'Anniston Metropolitan','Anniston','US ','ANB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3112,'Anthony','Anthony','US ','ANY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3113,'Antlers','Antlers','US ','ATE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3114,'Antrim County','Bellaire','US ','ACB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3115,'Anvik','Anvik','US ','ANV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3116,'Ap In The Sky','Catalina Island','US ','CIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3117,'Apple Valley','Apple Valley','US ','APV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3118,'Aransas County','Rockport','US ','RKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3119,'Aransas National Wildlife Refuge','Matagorda Island TX','US ','MGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3120,'Arapahoe Co','Denver','US ','APA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3121,'Arcata','Arcata','US ','ACV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3122,'Arctic Village','Arctic Village','US ','ARC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3123,'Ardmore Municipal Arpt','Ardmore','US ','ADM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3124,'Arkansas City','Winfield','US ','WLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3125,'Arnold AFS','Tullahoma','US ','TUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3126,'Artesia','Artesia','US ','ATS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3127,'Asbury Park','Neptune NJ','US ','ARX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3128,'Asheville Regional Airport','Fletcher','US ','AVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3129,'Ashland','Ashland','US ','ASX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3130,'Ashley','Ashley','US ','ASY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3131,'Ashtabula','Jefferson','US ','JFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3132,'Aspen','Aspen','US ','ASE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3133,'Astoria','Astoria','US ','AST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3134,'Athens','Athens','US ','AHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3135,'Atka','Atka','US ','AKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3136,'Atlanta Nas','Marietta GA','US ','NCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3137,'Atlantic City Intl','Atlantic City','US ','ACY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3138,'Atmautluak','Atmautluak','US ','ATT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3139,'Atqasuk','Atqasuk','US ','ATK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3140,'Attala County','Kosciusko','US ','OSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3141,'Auburn','Auburn','US ','AUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3142,'Auburn','Lewiston','US ','LEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3143,'Auburn-Opelika','Auburn','US ','AUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3144,'Augusta','Augusta','US ','AUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3145,'Austin','Austin','US ','AUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3146,'Austin','Austin','US ','ASQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3147,'Austin-bergstrom International','Austin','US ','AUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3148,'Austin-straubel Field','Green Bay','US ','GRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3149,'Aux Field','Crows Landing','US ','NRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3150,'Avalo Vor/WP','Catalina Island','US ','SXC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3151,'Avalon Bay','Catalina Island','US ','AVX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3152,'Baca Grande','Baca Grande','US ','BCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3153,'Bader Field','Atlantic City','US ','AIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3154,'Bagdad','Bagdad AZ','US ','BGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3155,'Baker','Baker','US ','BKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3156,'Baker Aaf','Baker Island','US ','BAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3157,'Baldwin County','Milledgeville','US ','MLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3158,'Baltimore Greenbelt T','Baltimore','US ','GBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3159,'Baltimore Rail','Baltimore','US ','ZBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2565,'Angelholm Railway Svc.','Angelholm/Helsingborg','SE ','XYQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2566,'Arlanda','Stockholm','SE ','ARN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2567,'Arvidsjaur','Arvidsjaur','SE ','AJR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2568,'Axamo','Jonkoping','SE ','JKG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2569,'Borlange Railway Svc.','Borlange/Falun','SE ','XYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2570,'Bromma','Stockholm','SE ','BMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2571,'Dala Airport','Borlange','SE ','BLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2572,'Enkoping','Enkoping','SE ','XWQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2573,'Eskilstuna','Eskilstuna','SE ','EKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2574,'Falkenberg Rail','Falkenberg','SE ','XYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2575,'Flen','Flen','SE ','XYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2576,'Gallivare','Gallivare','SE ','GEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2577,'Gothenburg City Airport','Gothenburg','SE ','GSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2578,'Gothenburg Rail','Gothenburg','SE ','XWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2579,'Gunnarn','Storuman','SE ','SQO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2580,'Hagfors','Hagfors','SE ','HFS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2581,'Halmstad','Halmstad','SE ','HAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2582,'Hassleholm','Hassleholm','SE ','XWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2583,'Hedemora','Hedemora','SE ','XXU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2584,'Heliport','Angelholm/Helsingborg','SE ','JHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2585,'Heliport','Landskrona','SE ','JLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2586,'Helsingborg Railway','Angelholm/Helsingborg','SE ','XYH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2587,'Hemavan','Hemavan','SE ','HMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2588,'Herrljunga','Herrljunga','SE ','XYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2589,'Hovby','Lidkoping','SE ','LDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2590,'Hudiksvall','Hudiksvall','SE ','HUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2591,'Hultsfred - Vimmerby','Hultsfred','SE ','HLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2592,'Idre','Idre','SE ','IDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2593,'Kallax','Lulea','SE ','LLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2594,'Kallinge','Ronneby','SE ','RNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2595,'Kalmar','Kalmar','SE ','KLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2596,'Karlshamn','Karlshamn','SE ','XYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2597,'Karlskoga','Karlskoga','SE ','KSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2598,'Karlskrona Rail Svc.','Ronneby','SE ','XWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2599,'Karlstad','Karlstad','SE ','KSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2600,'Katrineholm','Katrineholm','SE ','XXK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2601,'Kiruna','Kiruna','SE ','KRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2602,'Kramfors','Kramfors','SE ','KRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2603,'Kristianstad','Kristianstad','SE ','KID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2604,'Kristinehamn Rail','Kristinehamn','SE ','XYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2605,'Kungsangen','Norrkoping','SE ','NRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2606,'Landvetter','Gothenburg','SE ','GOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2607,'Linkoping','Linkoping','SE ','LPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2608,'Lycksele','Lycksele','SE ','LYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2609,'Malmo Harbour Heliport','Malmo','SE ','JMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2610,'Malmo South Railway','Malmo','SE ','XFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2611,'Mora','Mora','SE ','MXX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2612,'Nykoping','Nykoping','SE ','XWZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2613,'Orebro-bofors','Orebro','SE ','ORB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2614,'Ornskoldsvik','Ornskoldsvik','SE ','OER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2615,'Oskarshamn','Oskarshamn','SE ','OSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2616,'Pajala','Pajala','SE ','PJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2617,'Pass Rail','Rail','SE ','XZQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2618,'Sala','Sala','SE ','XYX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2619,'Sandviken','Gavle','SE ','GVX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2620,'Skavsta','Stockholm','SE ','NYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2621,'Skelleftea','Skelleftea','SE ','SFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2622,'Skovde','Skovde','SE ','KVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2623,'Smaland Airport','Växjö','SE ','VXO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2624,'Soderhamn','Soderhamn','SE ','SOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2625,'Sodertalje Heliport','Sodertalje','SE ','JSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2626,'Sodertalje S Railway','Sodertalje','SE ','XEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2627,'Solvesborg','Solvesborg','SE ','XYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2628,'Sturup','Malmo','SE ','MMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2629,'Sundsvall/harnosand','Sundsvall','SE ','SDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2630,'Sveg','Sveg','SE ','EVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2631,'Torsby Airport','Torsby','SE ','TYF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2632,'Trollhattan','Trollhattan','SE ','THN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2633,'Umea','Umea','SE ','UME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2634,'Vasteras/Hasslo','Stockholm','SE ','VST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2635,'Vastervik','Vastervik','SE ','VVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2636,'Vilhelmina','Vilhelmina','SE ','VHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2637,'Visby','Visby','SE ','VBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2638,'Åre Östersund Airport','Ostersund','SE ','OSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2639,'Altenrhein','Altenrhein','CH ','ACH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2640,'Ascona','Ascona','CH ','ACO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2641,'Basel Bad - Railway','Basel/mulhouse','CH ','ZBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2642,'Belp','Berne','CH ','BRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2643,'Emmen','Luzern','CH ','EML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2644,'Euroairport Basel Mulhouse Freiburg','Mulhouse/basel','CH ','BSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2645,'Geneve-cointrin','Geneva','CH ','GVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2646,'Lugano','Lugano/Agno','CH ','LUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2647,'Samedan','St Moritz','CH ','SMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2648,'Sion','Sion','CH ','SIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2649,'Zürich-Kloten','Zurich','CH ','ZRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2650,'Al Jafrah','Deirezzor','SY ','DEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2651,'Al Thaurah','Al Thaurah','SY ','SOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2652,'International','Damascus','SY ','DAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2653,'Kameshli','Kameshli','SY ','KAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2654,'Latakia','Latakia','SY ','LTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2655,'Nejrab','Aleppo','SY ','ALP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2656,'Palmyra','Palmyra','SY ','PMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2657,'Chi Mei','Chi Mei','TW ','CMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2658,'Chiayi','Chiayi','TW ','CYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2659,'Chingchuankang','Taichung','TW ','RMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2660,'Green Island','Green Island','TW ','GNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2661,'Hengchun','Hengchun','TW ','HCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2662,'Hsinchu','Hsinchu','TW ','HSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2663,'Hualien','Hualien','TW ','HUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2664,'Kaoshiung International Airport','Kaohsiung','TW ','KHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2665,'Lishan','Lishan','TW ','LHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2666,'Makung','Makung','TW ','MZG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2667,'Matsu','Matsu','TW ','MFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2668,'Nangan','Nangan','TW ','LZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2669,'Orchid Island','Orchid Island','TW ','KYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2670,'Pingtung','Pingtung','TW ','PIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2671,'Shang-Yi','Kinmen','TW ','KNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2672,'Sun Moon Lake','Sun Moon Lake','TW ','SMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2673,'Taichung','Taichung','TW ','TXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2674,'Tainan','Tainan','TW ','TNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2675,'Taipei Songshan','Taipei','TW ','TSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2676,'Taitung','Taitung','TW ','TTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2677,'Taiwan Taoyuan International','Taipei','TW ','TPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2678,'Wonan','Wonan','TW ','WOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2679,'Dushanbe','Dushanbe','TJ ','DYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2680,'Khudzhand','Khudzhand','TJ ','LBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2681,'Arusha','Arusha','TZ ','ARK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2682,'Bukoba','Bukoba','TZ ','BKZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2683,'Dodoma','Dodoma','TZ ','DOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2684,'Geita','Geita','TZ ','GIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2685,'International','Dar Es Salaam','TZ ','DAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2686,'Kigoma','Kigoma','TZ ','TKQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2687,'Kikwetu','Lindi','TZ ','LDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2688,'Kilimanjaro','Kilimanjaro','TZ ','JRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2689,'Kilwa','Kilwa','TZ ','KIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2690,'Kisauni','Zanzibar','TZ ','ZNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2691,'Lake Manyara','Lake Manyara','TZ ','LKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2692,'Lushoto','Lushoto','TZ ','LUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2693,'Mafia','Mafia','TZ ','MFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2694,'Masasi','Masasi','TZ ','XMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2695,'Mbeya','Mbeya','TZ ','MBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2696,'Mtwara','Mtwara','TZ ','MYW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2697,'Musoma','Musoma','TZ ','MUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2698,'Mwadui','Mwadui','TZ ','MWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2699,'Mwanza','Mwanza','TZ ','MWZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2700,'Nachingwea','Nachingwea','TZ ','NCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2701,'Nduli','Iringa','TZ ','IRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2702,'Njombe','Njombe','TZ ','JOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2703,'Seronera','Seronera','TZ ','SEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2704,'Shinyanga','Shinyanga','TZ ','SHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2705,'Songea','Songea','TZ ','SGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2706,'Sumbawanga','Sumbawanga','TZ ','SUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2707,'Tabora','Tabora','TZ ','TBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2708,'Tanga','Tanga','TZ ','TGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2709,'Wawi','Pemba','TZ ','PMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2710,'George Town','George Town','AU ','GEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2711,'Buri Ram','Buri Ram','TH ','BFV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2712,'Chiang Mai International','Chiang Mai','TH ','CNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2713,'Chiang Rai','Chiang Rai','TH ','CEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2714,'Chumphon Airport','Chumphon','TH ','CJM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2715,'Don Muang','Bangkok','TH ','DMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2716,'Hat Yai','Hat Yai','TH ','HDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2717,'Hua Hin Airport','Hua Hin','TH ','HHQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2718,'Kamphangsaen','Kamphangsaen','TH ','KDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2719,'Khon Kaen','Khon Kaen','TH ','KKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2720,'Koh Samui','Koh Samui','TH ','USM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2721,'Krabi','Krabi','TH ','KBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2722,'Lampang','Lampang','TH ','LPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2723,'Loei','Loei','TH ','LOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2724,'Lop Buri','Lop Buri','TH ','KKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2725,'Mae Hong Son','Mae Hong Son','TH ','HGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2726,'Mae Sot','Mae Sot','TH ','MAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2727,'Muang Ubon','Ubon Ratchathni','TH ','UBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2728,'Nakhon Phanom','Nakhon Phanom','TH ','KOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2729,'Nakhon Ratchasima','Nakhon Ratchasima','TH ','NAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2730,'Nakhon Sawan','Takhli','TH ','TKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2731,'Nakhon Si Thammarat','Nakhon Si Thammarat','TH ','NST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2732,'Nan','Nan','TH ','NNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2733,'Narathiwat','Narathiwat','TH ','NAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2734,'Patong Beach','Patong Beach','TH ','PBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2735,'Pattani','Pattani','TH ','PAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2736,'Pattaya','Pattaya','TH ','PYX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2737,'Phanom Sarakham','Phanom Sarakham','TH ','PMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2738,'Phetchabun','Phetchabun','TH ','PHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2739,'Phi Phi Island','Phi Phi Island','TH ','PHZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2740,'Phitsanulok','Phitsanulok','TH ','PHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2741,'Phrae','Phrae','TH ','PRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2742,'Phuket International','Phuket','TH ','HKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2743,'Ranong','Ranong','TH ','UNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2744,'Roi Et Airport','Roi Et','TH ','ROI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2745,'Sakon Nakhon','Sakon Nakhon','TH ','SNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2746,'Songkhla','Songkhla','TH ','SGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2747,'Sukhothai','Sukhothai','TH ','THS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2748,'Surat Thani','Surat Thani','TH ','URT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2749,'Surin','Surin','TH ','PXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2750,'Suvarnabhumi International','Bangkok','TH ','BKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2751,'Tak','Tak','TH ','TKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2752,'Trang','Trang','TH ','TST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2753,'Trat','Trat','TH ','TDX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2754,'Udon Thani','Udon Thani','TH ','UTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2755,'Udorn','Ban Mak Khaen','TH ','BAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2756,'Utapao','Utapao','TH ','UTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2757,'Uttaradit','Uttaradit','TH ','UTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2758,'Lome','Lome','TG ','LFW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2759,'Niamtougou','Niamtougou','TG ','LRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2760,'Fua''amotu International','Nuku''alofa','TO ','TBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2761,'Kaufana','Eua','TO ','EUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2762,'Kuini Lavenia','Niuatoputapu','TO ','NTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2763,'Crown Point Airport','Tobago','TT ','TAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2764,'Piarco International','Port Of Spain','TT ','POS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2765,'Carthage','Tunis','TN ','TUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2766,'Djerba-Zarzis','Djerba','TN ','DJE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2767,'El Borma','El Borma','TN ','EBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2768,'Gabes','Gabes','TN ','GAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2769,'Gafsa','Gafsa','TN ','GAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2770,'Habib Bourguiba','Monastir','TN ','MIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2771,'Sfax Thyna','Sfax','TN ','SFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2772,'Tabarka','Tabarka','TN ','TBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2773,'Tozeur','Tozeur','TN ','TOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2774,'Ağri','Agri','TR ','AJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2775,'Adana','Adana','TR ','ADA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2776,'Adana-Incirlik Airbase','Adana','TR ','UAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2777,'Adiyaman','Adiyaman','TR ','ADF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2778,'Adnan Menderes','Izmir','TR ','ADB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2779,'Afyon','Afyon','TR ','AFY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2780,'Anadolu University','Eskisehir','TR ','AOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2781,'Antalya','Antalya','TR ','AYT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2782,'Ataturk','Istanbul','TR ','IST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2783,'Balikesir','Balikesir','TR ','BZI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2784,'Bandirma','Bandirma','TR ','BDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2785,'Batman','Batman','TR ','BAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2786,'Budrum','Erzurum','TR ','ERZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2787,'Bursa Airport','Bursa','TR ','BTZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2788,'Canakkale','Canakkale','TR ','CKZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2789,'Cardak','Denizli','TR ','DNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2790,'Carsamba','Samsun','TR ','SZF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2791,'Cengiz Topel','Kocaeli','TR ','KCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2792,'Cigli Military Arpt','Izmir','TR ','IGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2793,'Corlu','Tekirdag','TR ','TEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2794,'Dalaman','Dalaman','TR ','DLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2795,'Diyarbakir','Diyarbakir','TR ','DIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2796,'Edremit/korfez','Edremit/korfez','TR ','EDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2797,'Elazig','Elazig','TR ','EZS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2798,'Erkilet International Airport','Kayseri','TR ','ASR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2799,'Erzincan','Erzincan','TR ','ERC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2800,'Esenboga','Ankara','TR ','ESB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2801,'Eskisehir','Eskisehir','TR ','ESK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2802,'Etimesgut','Ankara','TR ','ANK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2803,'Ferit Melen Airport','Van','TR ','VAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2804,'Gaziantep','Gaziantep','TR ','GZT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2805,'Imsik Airport','Bodrum','TR ','BXN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2806,'Kahramanmaras','Kahramanmaras','TR ','KCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2807,'Kars','Kars','TR ','KSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2808,'Kastamonu','Kastamonu','TR ','KFS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2809,'Konya','Konya','TR ','KYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2810,'Malatya','Malatya','TR ','MLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2811,'Mardin','Mardin','TR ','MQM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2812,'Merkez','Balikesir','TR ','MQJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2813,'Merzifon','Merzifon','TR ','MZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2814,'Milas','Milas','TR ','BJV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2815,'Sabiha Gokcen','Istanbul','TR ','SAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2816,'Samsun','Samsun/carsamba','TR ','SSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2817,'Sanliurfa','Sanliurfa','TR ','SFQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2818,'Siirt','Siirt','TR ','SXZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2819,'Sinop','Sinop','TR ','SQD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2820,'Sinop Airport','Sinop','TR ','SIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2821,'Sivas','Sivas','TR ','VAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2822,'Tokat','Tokat','TR ','TJK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2823,'Trabzon','Trabzon','TR ','TZX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2824,'Usak','Usak','TR ','USQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2825,'Yenisehir','Bursa','TR ','YEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2826,'Zonguldak','Zonguldak','TR ','ONQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2827,'Ashgabat','Ashgabat','TM ','ASB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2828,'Mary','Mary','TM ','MYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2829,'Turkmanbashi','Turkmenbashi','TM ','KRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2830,'Turkmenabad','Turkmenabad','TM ','CRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2831,'Grand Turk Is','Grand Turk Is','TC ','GDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2832,'International','Providenciales','TC ','PLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2833,'International','South Caicos','TC ','XSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2834,'Middle Caicos','Middle Caicos','TC ','MDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2835,'North Caicos','North Caicos','TC ','NCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2836,'Pine Cay','Pine Cay','TC ','PIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2837,'Salt Cay','Salt Cay','TC ','SLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2838,'International','Funafuti Atol','TV ','FUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2839,'Arua','Arua','UG ','RUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2840,'Entebbe','Entebbe','UG ','EBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2841,'Gulu','Gulu','UG ','ULU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2842,'Jinja','Jinja','UG ','JIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2843,'Kabalega Falls','Kabalega Falls','UG ','KBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2844,'Kasese','Kasese','UG ','KSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2845,'Masindi','Masindi','UG ','KCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2846,'Mbarara','Mbarara','UG ','MBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2847,'Moyo','Moyo','UG ','OYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2848,'Pakuba','Pakuba','UG ','PAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2849,'Soroti','Soroti','UG ','SRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2850,'Tororo','Tororo','UG ','TRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2851,'Belbek','Sevastopol','UA ','UKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2852,'Berdyansk','Berdyansk','UA ','ERD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2853,'Borispol','Kiev','UA ','KBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2854,'Cherkassy','Cherkassy','UA ','CKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2855,'Chernigov','Chernigov','UA ','CEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2856,'Chernovtsy','Chernovtsy','UA ','CWC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2857,'Darnitsa Bus Station','Kiev','UA ','QOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2858,'Dnepropetrovsk','Dnepropetrovsk','UA ','DNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2859,'Donetsk International Airport','Donetsk','UA ','DOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2860,'Hotel Rus Bus Station','Kiev','UA ','QOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2861,'Ivano-Frankovsk','Ivano-Frankovsk','UA ','IFO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2862,'Kamenets-podolskiy','Kamenets-podolskiy','UA ','KCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2863,'Kerch','Kerch','UA ','KHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2864,'Kharkov','Kharkov','UA ','HRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2865,'Kherson','Kherson','UA ','KHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2866,'Khmelnitskiy','Khmelnitskiy','UA ','HMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2867,'Kirovograd','Kirovograd','UA ','KGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2868,'Kramatorsk','Kramatorsk','UA ','KRQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2869,'Kremenchug','Kremenchug','UA ','KHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2870,'Krivoy Rog','Krivoy Rog','UA ','KWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2871,'Lugansk','Lugansk','UA ','VSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2872,'Lutsk','Lutsk','UA ','UCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2873,'Mariupol','Mariupol MN','UA ','MPW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2874,'Mirgorod','Mirgorod','UA ','MXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2875,'Nikolaev','Nikolaev','UA ','NLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2876,'Odessa International','Odessa','UA ','ODS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2877,'Poltava','Poltava','UA ','PLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2878,'Rovno','Rovno','UA ','RWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2879,'Severodoneck','Severodoneck','UA ','SEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2880,'Simferopol','Simferopol','UA ','SIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2881,'Snilow','Lviv','UA ','LWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2882,'Sumy','Sumy','UA ','UMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2883,'Ternopol','Ternopol','UA ','TNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2884,'Uzhgorod','Uzhgorod','UA ','UDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2885,'Vinnica','Vinnica','UA ','VIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2886,'Zaporozhye','Zaporozhye','UA ','OZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2887,'Zhitomir Airport','Zhitomir','UA ','ZTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2888,'Zhulhany','Kiev','UA ','IEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2889,'Abu Dhabi International','Abu Dhabi','AE ','AUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2890,'Al Ain','Al Ain','AE ','AAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2891,'Al Dhafra Military Apt','Abu Dhabi','AE ','DHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2892,'Bateen','Abu Dhabi','AE ','AZI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2893,'Dubai','Dubai','AE ','DXB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2894,'Fujairah Intl','Al-fujairah','AE ','FJR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2895,'Minhad AB','Minhad AB','AE ','NHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2896,'Ras Al Khaimah','Ras Al Khaimah','AE ','RKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2897,'Sharjah','Sharjah','AE ','SHJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2898,'Aldergrove International Airport','Belfast','GB ','BFS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2899,'Andover','Andover','GB ','ADV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2900,'Anglesey Airport','Holyhead','GB ','HLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2901,'Bally Kelly','Bally Kelly','GB ','BOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2902,'Baltasound','Unst Shetland Is','GB ','UNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2903,'Bembridge','Bembridge','GB ','BBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2904,'Benbecula','Benbecula','GB ','BEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2905,'Bentwaters St','Woodbridge','GB ','BWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2906,'Binbrook','Grimsby','GB ','GSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2907,'Birmingham International Airport','Birmingham','GB ','BHX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2908,'Blackbushe','Yateley','GB ','BBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2909,'Blackpool Airport','Blackpool','GB ','BLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2910,'Bournemouth International','Bournemouth','GB ','BOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2911,'Bradford','Bradford','GB ','BRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2912,'Brighton','Brighton','GB ','BSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2913,'Bristol','Bristol','GB ','BRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2914,'Broadford','Isle Of Skye','GB ','SKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2915,'Burtonwood','Burtonwood','GB ','BUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2916,'Bus Station','Bradford','GB ','ZFC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2917,'Cambridge','Cambridge','GB ','CBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2918,'Cardiff','Cardiff','GB ','CWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2919,'Carlisle','Carlisle','GB ','CAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2920,'Chester','Chester','GB ','CEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2921,'Colmore Row Bus Stn','Birmingham','GB ','ZBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2922,'Cottesmor RAF','Oakham','GB ','OKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2923,'Cromarty','Cromarty','GB ','CRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2924,'Dornoch','Dornoch','GB ','DOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2925,'Dundee','Dundee','GB ','DND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2926,'Durham Tees Valley','Teesside Durham','GB ','MME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2927,'East Midlands','Derby','GB ','EMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2928,'Eday','Eday','GB ','EOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2929,'Eglinton','Derry','GB ','LDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2930,'Enniskillen St. Angelo','Enniskillen','GB ','ENK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2931,'Exeter','Exeter','GB ','EXT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2932,'Fair Isle','Fair Isle','GB ','FIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2933,'Fairwood Comm','Swansea','GB ','SWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2934,'Farnborough','Farnborough','GB ','FAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2935,'Fetlar','Fetlar','GB ','FEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2936,'Filton','Bristol','GB ','FZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2937,'Flotta','Flotta','GB ','FLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2938,'Foula','Foula','GB ','FOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (2939,'George Best Belfast City','Belfast','GB ','BHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3160,'Baltimore/Washington International Thurgood Marshall','Baltimore MD','US ','BWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3161,'Bangor International Airport','Bangor','US ','BGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3162,'Banning','Banning','US ','BNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3163,'Bar Harbor','Bar Harbor','US ','BHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3164,'Barbers Point','Barbers Point','US ','NAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3165,'Barin Olf Osn','Foley','US ','NHX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3166,'Barking Sands PMRF','Kekaha','US ','BKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3167,'Barkley Regional','Paducah KY','US ','PAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3168,'Barnes','Hartford','US ','BNH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3169,'Barnstable','Hyannis','US ','HYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3170,'Barnwell Regional','Barnwell SC','US ','BNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3171,'Barstow-Daggett','Daggett','US ','DAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3172,'Barter Island','Barter Island','US ','BTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3173,'Bartlesville','Bartlesville','US ','BVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3174,'Bartlett SPB','Gustavus','US ','BQV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3175,'Bartletts','Bartletts','US ','BSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3176,'Bartow','Bartow','US ','BOW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3177,'Battery Pk City/N. Cov','New York','US ','NBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3178,'Baudette','Baudette','US ','BDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3179,'Bay City','Bay City','US ','BBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3180,'Bay County','Panama City','US ','PFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3181,'Baytown','Baytown','US ','HPY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3182,'Bear Creek','Bear Creek','US ','BCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3183,'Beatrice','Beatrice','US ','BIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3184,'Beatty','Beatty','US ','BTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3185,'Beaumont Muni','Beaumont','US ','BMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3186,'Beauregard Parish','De Ridder','US ','DRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3187,'Beaver','Beaver','US ','WBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3188,'Beaver Falls','Beaver Falls','US ','BFP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3189,'Beaver Ruin','Atlanta','US ','JAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3190,'Beckley','Beckley','US ','BKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3191,'Beech','Wichita','US ','BEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3192,'Bellefonte','Bellefonte','US ','PSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3193,'Belleville','Belleville','US ','BLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3194,'Bellingham','Bellingham','US ','BLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3195,'Bellows Field','Waimanalo','US ','BLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3196,'Bemidji','Bemidji','US ','BJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3197,'Benedum','Clarksburg','US ','CKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3198,'Bennettsville','Bennettsville','US ','BTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3199,'Berkeley','Berkeley','US ','JBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3200,'Berlin Municipal Airport','Berlin','US ','BML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3201,'Bermuda Dunes','Palm Springs','US ','UDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3202,'Bert Mooney Airport','Butte','US ','BTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3203,'Berz-Macomb','Utica','US ','UIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3204,'Bethel Airport','Bethel','US ','BET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3205,'Bettles','Bettles','US ','BTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3206,'Beverly Municiple Airport','Beverly','US ','BVY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3207,'Bhurban Heliport','Bhurban','US ','BHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3208,'Bicycle Lake AAF','Fort Irwin','US ','BYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3209,'Big Bear City Arpt','Big Bear','US ','RBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3210,'Big Creek','Big Creek','US ','BIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3211,'Big Lake','Big Lake','US ','BGQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3212,'Big Mountain','Big Mountain','US ','BMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3213,'Big Piney-marbleton','Big Piney','US ','BPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3214,'Big Rapids','Big Rapids','US ','WBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3215,'Biggs Aaf','El Paso','US ','BIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3216,'Billings','Billings','US ','BIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3217,'Birch Creek','Birch Creek','US ','KBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3218,'Birchwood-Pocono','East Stroudsburg','US ','ESP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3219,'Birmingham','Birmingham','US ','BHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3220,'Bisbee Municipal Arpt','Bisbee','US ','BSQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3221,'Bisbee-Douglas Intl','Douglas','US ','DUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3222,'Bishop','Bishop','US ','BIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3223,'Bishop International Airport','Flint','US ','FNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3224,'Bismarck','Bismarck','US ','BIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3225,'Black Hills','Spearfish','US ','SPF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3226,'Blacker','Manistee','US ','MBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3227,'Blackstone AAF','Blackstone','US ','BKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3228,'Blackwell','Blackwell','US ','BWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3229,'Blaine','Blaine','US ','BWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3230,'Blairsville','Blairsville','US ','BSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3231,'Blakely Island','Blakely Island','US ','BYW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3232,'Blanding','Blanding','US ','BDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3305,'Bush Field','Augusta','US ','AGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3306,'Butler','Butler','US ','BUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3307,'Butler County - Kenny Scholter Field','Butler','US ','BTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3308,'Butts AAF','Colorado Springs','US ','FCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3309,'Buzzards Pt S','Washington','US ','BZS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3310,'Cabin Creek','Cabin Creek','US ','CBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3311,'Cable Airport','Upland CA','US ','CCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3312,'Cable Heliport','Upland','US ','JUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3313,'Cache','Logan','US ','LGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3314,'Cadillac','Cadillac','US ','CAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3315,'Cairns AAF','Ozark','US ','OZR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3316,'Cairo','Cairo','US ','CIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3317,'Caldwell Wright','Caldwell NJ','US ','CDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3318,'Calipatria','Calipatria','US ','CLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3319,'Callaway Gardens','Callaway Gardens','US ','CWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3320,'Calloway','La Grange','US ','LGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3321,'Calloway County','Murray','US ','CEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3322,'Cambria County','Johnstown','US ','JST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3323,'Cambridge','Cambridge','US ','CGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3324,'Camp A P Hill','Bowling Green','US ','APH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3325,'Campbell AAF','Hopkinsville','US ','HOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3326,'Campbell County','Gillette','US ','GCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3327,'Campo','Campo','US ','CZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3328,'Candle','Candle','US ','CDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3329,'Cannon AFB','Clovis','US ','CVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3330,'Canon City','Canon City','US ','CNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3331,'Canton','Canton','US ','CTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3332,'Canyonlands Field','Moab','US ','CNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3333,'Cape Girardeau','Cape Girardeau','US ','CGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3334,'Cape Lisburne','Cape Lisburne','US ','LUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3335,'Cape May County','Wildwood','US ','WWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3336,'Cape Newenham','Cape Newenham','US ','EHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3337,'Cape Pole','Cape Pole','US ','CZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3338,'Cape Romanzof','Cape Romanzof','US ','CZF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3339,'Capital','Springfield','US ','SPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3340,'Capital City','Frankfort KY','US ','FFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3341,'Capital City','Harrisburg','US ','HAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3342,'Capital City','Lansing','US ','LAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3343,'Carbon County','Price','US ','PUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3344,'Carleton','Stanton','US ','SYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3345,'Carlsbad','Carlsbad','US ','CNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3346,'Carrizo Springs','Carrizo Springs','US ','CZT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3347,'Carroll','Carroll','US ','CIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3348,'Carson City','Carson City','US ','CSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3349,'Cascade Locks/Stevens','Cascade Locks','US ','CZK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3350,'Casco Cove','Attu Island','US ','ATU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3351,'Casement','Painesville','US ','PVZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3352,'Castle AFB','Atwater CA','US ','MER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3353,'Catalina SPB','San Pedro','US ','SPQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3354,'Cecil Field','Jacksonville','US ','VQQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3355,'Cedar City','Cedar City','US ','CDC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3356,'Cedar Rapids','Cedar Rapids','US ','CID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3357,'Centerport Heliport','Santa Ana','US ','JOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3358,'Central','Central','US ','CEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3359,'Central Illinois Regional Airport at Bloomington-Normal','Bloomington/Normal IL','US ','BMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3360,'Central Jersey Regional Airport','Manville','US ','JVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3361,'Central Maine Airport of Norridgewock','Norridgewock','US ','OWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3362,'Central Wisconsin','Wausau','US ','CWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3363,'Centralia','Chehalis','US ','CLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3364,'Cessna Aircraft Field','Wichita','US ','CEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3365,'Chadron','Chadron','US ','CDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3366,'Chaffee AFB','Fort Chaffee','US ','CCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3367,'Chalkyitsik','Chalkyitsik','US ','CIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3368,'Challis','Challis','US ','CHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3369,'Chan Gurney','Yankton','US ','YKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3370,'Chandalar','Chandalar','US ','WCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3371,'"Charleston',' AFB MunicipalCharleston SC','US ','CHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3372,'Charlotte County','Punta Gorda','US ','PGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3373,'Charlotte Douglas','Charlotte','US ','CLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3374,'Chatham SPB','Chatham','US ','CYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3375,'Chefornak','Chefornak AK','US ','CFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3376,'Chefornak SPB','Chefornak','US ','CYF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3377,'Chena Hot Springs','Chena Hot Springs','US ','CEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3378,'Cheraw','Cheraw','US ','HCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3379,'Cherokee','Cherokee','US ','CKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3380,'Cherokee County','Jacksonville TX','US ','JKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3381,'Cherry Capital Airport','Traverse City','US ','TVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3382,'Chess-Lambertin','Franklin','US ','FKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3383,'Chestercounty Carlson','Coatesville','US ','CTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3384,'Chevak','Chevak','US ','VAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3385,'Cheyenne','Cheyenne','US ','CYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3386,'Chicago FSS','Chicago','US ','CHI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3387,'Chicago NAS','Chicago','US ','NOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3388,'Chicago O''hare International','Chicago Il','US ','ORD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3389,'Chicken','Chicken','US ','CKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3390,'Chico','Chico','US ','CIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3391,'Chignik','Chignik','US ','KCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3392,'Chignik Bay','Chignik','US ','KBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3393,'Childress','Childress','US ','CDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3394,'China Basin Heliport','San Francisco','US ','JCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3395,'Chino','Chino','US ','CNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3396,'Chippewa County','Sault Ste Marie','US ','CIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3397,'Chippewa Valley Regional Airport','Eau Claire WI','US ','EAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3398,'Chisana Field','Chisana','US ','CZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3399,'Chisholm','Chisholm','US ','HIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3400,'Chistochina','Chistochina','US ','CZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3401,'Chitina Arpt','Chitina','US ','CXC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3402,'Chomley','Chomley','US ','CIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3403,'Chuathbaluk','Chuathbaluk','US ','CHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3404,'Cincinnati Municipal-Lunken Field','Cincinnati OH','US ','LUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3405,'Cincinnati-Blue Ash Airport','Cincinnati OH','US ','ISZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3406,'Cincinnati/northern Kentucky','Covington KY','US ','CVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3407,'Cinder River','Cinder River','US ','RCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3408,'Circle City','Circle','US ','IRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3409,'Circle Hot Springs','Circle Hot Springs','US ','CHP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3410,'City','Cordova','US ','CKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3411,'City County','Havre','US ','HVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3412,'City Landing','Bethel','US ','JBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3413,'City Of Industry H/P','Los Angeles','US ','JID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3414,'City-county','Madras','US ','MDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3415,'City-County','Newton','US ','EWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3416,'Clark Field','Stephenville','US ','SEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3417,'Clarks Point','Clarks Point','US ','CLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3418,'Clayton','Clayton','US ','CAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3419,'Clear Lake','Clear Lake','US ','CKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3420,'Clinton','Clinton','US ','CWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3421,'Clinton County','Plattsburgh','US ','PLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3422,'Clinton Field','Wilmington','US ','ILN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3423,'Clintonville','Clintonville','US ','CLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3424,'Coalinga','Coalinga','US ','CLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3425,'Coast Guard','Eldred Rock','US ','ERO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3426,'Coast Guard','Lincoln Rock AK','US ','LRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3427,'Coast Guard Heliport','Cape Spencer','US ','CSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3428,'Coast Guard Heliport','Point Retreat','US ','PRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3429,'Coast Guard Heliport','Tree Point','US ','TRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3430,'Coffee Point','Coffee Point','US ','CFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3431,'Coffield','Rockdale','US ','RCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3432,'Coffman Cove SPB','Coffman Cove','US ','KCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3433,'Cold Bay','Cold Bay','US ','CDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3434,'Coldfoot','Coldfoot','US ','CXF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3435,'Coleman','Coleman','US ','COM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3436,'Coles County Memorial','Mattoon','US ','MTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3437,'College Park','College Park','US ','CGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3438,'Colorado Creek','Colorado Creek','US ','KCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3439,'Colorado Plains Regional Airport','Akron CO','US ','AKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3440,'Colorado Springs','Colorado Springs','US ','COS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3441,'Columbia','Columbia','US ','COA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3442,'Columbia Gorge Regional/The Dalles Municipal Airport','The Dalles','US ','DLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3443,'Columbia Regional','Columbia','US ','COU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3444,'Columbus AFB','Columbus MS','US ','CBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3445,'Columbus Municipal','Columbus','US ','CLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3446,'Columbus Municipal','Columbus NE','US ','OLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3447,'Commerce Bus. Plaza','Los Angeles','US ','JBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3448,'Compton','Compton CA','US ','CPM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3449,'Concord','Concord','US ','CON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3450,'Condron AAF','White Sands','US ','WSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3451,'Convention Center H/P','Oakland','US ','JCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3452,'Converse County','Douglas','US ','DGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3453,'Cooperstown - Westville Airport','Cooperstown NY','US ','COP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3454,'Copper Centre','Copper Centre','US ','CZC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3455,'Corbin-London','London','US ','LOZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3456,'Corcoran','Corcoran','US ','CRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3457,'Corner Bay','Corner Bay','US ','CBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3458,'Corpus Christi International Airport','Corpus Christi TX','US ','CRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3459,'Corsicana','Corsicana','US ','CRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3460,'Cortland','Cortland','US ','CTX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3461,'Cottonwood','Cottonwood','US ','CTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3462,'Cotulla','Cotulla','US ','COT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3463,'Coulter Field','Bryan','US ','CFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3464,'County','Beaufort','US ','BFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3465,'County','Jasper','US ','JAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3466,'County','Okeechobee','US ','OBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3467,'County','Sullivan','US ','SIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3468,'County','Washington','US ','WSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3469,'County-Foster','Victoria','US ','VCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3470,'Cox Field','Paris','US ','PRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3471,'Craig AFB','Selma','US ','SEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3472,'Craig Municipal','Jacksonville','US ','CRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3473,'Craig SPB','Craig','US ','CGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3474,'Craig-Moffat','Craig','US ','CIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3475,'Crane County Arpt','Crane','US ','CCG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3476,'Crane Island','Crane Island','US ','CKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3477,'Crews Field','Raton','US ','RTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3478,'Crooked Creek','Crooked Creek','US ','CKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3479,'Cross City','Cross City','US ','CTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3480,'Crosson Field','Sterling','US ','STK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3481,'Crystal','Minneapolis','US ','MIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3482,'Crystal Lake','Crystal Lake','US ','CYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3483,'Cube Cove','Cube Cove','US ','CUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3484,'Culberson County','Van Horn','US ','VHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3485,'Cummings Park','Woburn','US ','WBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3486,'Curtis Field','Brady','US ','BBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3487,'Curtis Memorial','Noorvik','US ','ORV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3488,'Cut Bank','Cut Bank','US ','CTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3489,'Cuyahoga County','Cleveland','US ','CGF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3490,'Dade Collier','Miami','US ','TNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3491,'Dahl Creek Arpt','Dahl Creek','US ','DCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3492,'Dalhart','Dalhart','US ','DHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3493,'Dallas North Airport','Dallas','US ','DNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3494,'Dallas/Fort Worth International','Dallas TX','US ','DFW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3495,'Danbury Municipal Airport','Danbury CT','US ','DXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3496,'Dane County Regional','Madison','US ','MSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3497,'Danger Bay','Danger Bay','US ','DGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3498,'Daniel Field','Augusta GA','US ','DNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3499,'Dannelly Fld','Montgomery','US ','MGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3500,'Dare County Regional','Manteo','US ','MEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3501,'Davenport','Davenport','US ','DVN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3502,'David Wayne Hooks','Houston','US ','DWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3503,'Daviess County','Owensboro','US ','OWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3504,'Davis Field','Muskogee','US ','MKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3505,'Davison AAF','Fort Belvoir','US ','DAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3506,'Dawson Community','Glendive','US ','GDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3507,'Dayton-Wright Brothers Airport','Dayton','US ','MGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3508,'Death Valley','Death Valley','US ','DTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3509,'Decatur Arpt','Decatur','US ','DEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3510,'Decatur County','Bainbridge','US ','BGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3511,'Decatur Hi-Way','Decatur','US ','DCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3512,'Decatur Island','Decatur Island','US ','DTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3513,'Deep Bay','Deep Bay','US ','WDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3514,'Deer Park','Deer Park','US ','DPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3515,'Deering','Deering','US ','DRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3516,'Dekalb-Peachtree','Atlanta GA','US ','PDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3517,'Delaware County','Muncie','US ','MIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3518,'Delta','Delta','US ','DTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3519,'Delta County Arpt','Escanaba','US ','ESC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3520,'Delta Junction','Delta Junction','US ','DJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3521,'Deming','Deming','US ','DMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3522,'Denver International','Denver','US ','DEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3523,'Derby Field','Lovelock','US ','LOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3524,'Des Moines International','Des Moines IA','US ','DSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3525,'Desert Rock','Mercury','US ','DRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3526,'Destin-Fort Walton Beach Airport','Destin','US ','DSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3527,'Detroit City','Detroit MI','US ','DET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3528,'Detroit Metropolitan Wayne County','Detroit MI','US ','DTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3529,'Devils Lake','Devils Lake','US ','DVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3530,'Devils Track','Grand Marais','US ','GRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3531,'Dew Station','Lonely','US ','LNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3532,'Dew Station','Point Lay','US ','PIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3533,'Dickinson','Dickinson','US ','DIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3534,'Dillant-Hopkins','Keene','US ','EEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3535,'Dillingham Airfield','Oahu','US ','HDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3536,'Dillon','Dillon','US ','DLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3537,'Dillon','Dillon','US ','DLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3538,'Diomede Island','Diomede Island','US ','DIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3539,'Dobbins Afb','Marietta','US ','MGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3540,'Dodge City Municipal','Dodge City','US ','DDC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3541,'Dodge County','Juneau WI','US ','UNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3542,'Dolomi','Dolomi','US ','DLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3543,'Door County','Sturgeon Bay','US ','SUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3544,'Dora Bay','Dora Bay','US ','DOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3545,'Dothan Arpt','Dothan','US ','DHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3546,'Dougherty County','Albany','US ','ABY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3547,'Douglas County','Minden','US ','MEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3548,'Douglas Municipal','Douglas','US ','DGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3549,'Dover AFB','Dover-Cheswold DE','US ','DOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3550,'Downtown','Ardmore','US ','AHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3551,'Downtown','Baton Rouge','US ','EBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3552,'Downtown','Kansas City','US ','MKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3553,'Downtown','St Paul','US ','STP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3554,'Downtown Airpark','Oklahoma City','US ','DWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3555,'Downtown Heliport','Dallas','US ','JDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3556,'Downtown Heliport','Miami','US ','JDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3557,'Downtown Heliport','Minneapolis','US ','JDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3558,'Downtown Heliport','Santa Ana','US ','DNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3559,'Downtown Manhattan H/p','New York NY','US ','JRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3560,'Doylestown','Doylestown','US ','DYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3561,'Dr Haines','Three Rivers','US ','HAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3562,'Draughon-miller Central Texas Regional','Temple TX','US ','TPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3563,'Drift River','Drift River','US ','DRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3564,'Drummond','Drummond','US ','DRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3565,'Drummond Island','Drummond Island','US ','DRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3566,'Du Bois-Jefferson County','Du Bois','US ','DUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3567,'Dubois','Dubois','US ','DBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3568,'Duke Field','Valparaiso','US ','EGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3569,'Duluth International','Duluth','US ','DLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3570,'Dunkirk','Dunkirk','US ','DKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3571,'Dupage County','Chicago','US ','DPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3572,'Dutchess County','Poughkeepsie','US ','POU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3573,'Dyess AFB','Abilene','US ','DYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3574,'Eagle','Eagle','US ','EAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3575,'Eagle County','Vail/Eagle','US ','EGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3576,'Eagle Lake','Eagle Lake','US ','ELA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3577,'Eagle River','Eagle River','US ','EGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3578,'Eaker','Durant','US ','DUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3579,'Earl Fields Memorial','Poplar Bluff','US ','POF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3580,'East 34th St Heliport','New York','US ','TSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3581,'East 34th St Landing','New York','US ','NES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3582,'East 60th Street H/P','New York','US ','JRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3583,'East Hampton','East Hampton','US ','HTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3584,'Eastern Wv Regional Airport/Shepherd Field','Martinsburg','US ','MRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3585,'Easterwood Field','College Station TX','US ','CLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3586,'Easton','Easton','US ','ESN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3587,'Eaton','Norwich','US ','OIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3588,'Edna Bay','Edna Bay','US ','EDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3589,'Edward F Knapp State','Montpelier VT','US ','MPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3590,'Edwards','Gulf Shores','US ','GUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3591,'Edwards AFB','Edwards AFB','US ','EDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3592,'Eek','Eek','US ','EEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3593,'Egegik','Egegik','US ','EGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3594,'Eglin AFB','Valparaiso FL','US ','VPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3595,'Eielson AFB','Fairbanks','US ','EIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3596,'Eight Fathom Bight','Eight Fathom Bight','US ','EFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3597,'Ekuk','Ekuk','US ','KKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3598,'Ekwok','Ekwok','US ','KEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3599,'El Centro NAF','El Centro CA','US ','NJK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3600,'El Dorado','El Dorado','US ','EDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3601,'El Monte','El Monte','US ','EMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3602,'El Paso International Airport','El Paso','US ','ELP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3603,'Elfin Cove SPB','Elfin Cove','US ','ELV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3604,'Elim','Elim','US ','ELI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3605,'Elizabeth City','Elizabeth City NC','US ','ECG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3606,'Elizabeth Field','Fishers Island','US ','FID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3607,'Elizabethtown','Elizabethtown','US ','EKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3608,'Elkins','Elkins','US ','EKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3609,'Elko Regional','Elko NV','US ','EKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3610,'Ellamar','Ellamar','US ','ELW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3611,'Ellington Field','Houston','US ','EFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3612,'Ellis Field','Mekoryuk','US ','MYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3613,'Ellsworth Afb','Rapid City','US ','RCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3614,'Ellyson NAS','Pensacola FL','US ','NDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3615,'Elmendorf Afb','Anchorage','US ','EDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3616,'Elmira Corning Regional','Corning NY','US ','ELM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3617,'Ely','Ely','US ','LYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3618,'Embarkadero','San Francisco','US ','EMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3619,'Emergency Field','Dutch Harbor','US ','DUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3620,'Emmet County','Pellston','US ','PLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3621,'Emmet County Airport','East Tawas','US ','ECA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3622,'Emmonak','Emmonak','US ','EMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3623,'Emporia','Emporia','US ','EMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3624,'Enid Woodring Mun.','Enid','US ','WDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3625,'Ephrata','Ephrata','US ','EPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3626,'Eppley Airfield','Omaha','US ','OMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3627,'Roy Hurd Memorial','Monahans','US ','MIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3628,'Ruby','Ruby','US ','RBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3629,'Rupert','Rupert','US ','BYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3630,'Russell','Russell','US ','RSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3631,'Russian SPB','Russian Mission','US ','RSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3632,'Ruston','Ruston','US ','RSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3633,'Rutland','Rutland','US ','RUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3634,'Ryan','Baton Rouge','US ','BTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3635,'Ryan Field','Hemet','US ','HMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3636,'Sacramento International','Sacramento CA','US ','SMF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3637,'Sacramento Mather Airport','Sacramento CA','US ','MHR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3638,'Safford','Safford','US ','SAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3639,'Saginaw Bay','Saginaw Bay','US ','SGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3640,'Sagwon','Sagwon','US ','SAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3641,'Saint Marys','Saint Marys','US ','KSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3642,'Saint Paul Island','Saint Paul Island','US ','SNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3643,'Salida','Salida','US ','SLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3644,'Salina','Salina','US ','SLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3645,'Salina','Salina','US ','SBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3646,'Salinas','Salinas','US ','SNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3647,'Salmon','Salmon','US ','SMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3648,'Salt Lake City International','Salt Lake City UT','US ','SLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3649,'Salt Lake Skypark','Bountiful','US ','BTF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3650,'Salton City','Salton City','US ','SAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3651,'Sampson County','Clinton','US ','CTZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3652,'Samuels Field','Bardstown KY','US ','BRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3653,'San Antonio International','San Antonio','US ','SAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3654,'San Carlos','San Carlos','US ','SQL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3655,'San Diego International Airport','San Diego','US ','SAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3656,'San Francisco International','San Francisco CA','US ','SFO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3657,'San Juan County','Monticello','US ','MXC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3658,'San Juan SPB','San Juan','US ','WSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3659,'San Luis County Regional Airport','San Luis Obispo','US ','SBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3660,'San Rafael H/P','San Rafael','US ','JSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3661,'Sanderson Field','Shelton','US ','SHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3662,'Sanford','Sanford','US ','SFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3663,'Santa Cruz Island','Santa Barbara','US ','SZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3664,'Santa Fe','Santa Fe','US ','SAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3233,'Block Island','Block Island','US ','BID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3234,'Bloomington','Bloomington','US ','BMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3235,'Blosser Municipal','Concordia','US ','CNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3236,'Blue Canyon','Blue Canyon','US ','BLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3237,'Blue Fox Bay','Blue Fox Bay','US ','BFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3238,'Blue Grass','Lexington','US ','LEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3239,'Blue Grass Station Army Heliport','Lexington KY','US ','LSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3240,'Blythe','Blythe','US ','BLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3241,'Blytheville AFB','Blytheville','US ','BYH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3242,'Bob Barker Memorial','Kiana','US ','IAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3243,'Bob Hope','Burbank','US ','BUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3244,'Bob Sikes','Crestview','US ','CEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3245,'Boeing Field/King County International Airport','Seattle','US ','BFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3246,'Boire Field','Nashua NH','US ','ASH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3247,'Boise Air Terminal/Gowen Field','Boise ID','US ','BOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3248,'Bolling AFB','Washington','US ','BOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3249,'Bomar Field','Shelbyville','US ','SYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3250,'Boone','Boone','US ','BNW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3251,'Boone County','Harrison','US ','HRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3252,'Borger','Borger','US ','BGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3253,'Bornite Upper','Bornite','US ','RLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3254,'Borrego Springs','Borrego Springs','US ','BXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3255,'Boston City Heliport','Boston','US ','JBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3256,'Boswell Bay','Boswell Bay','US ','BSW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3257,'Boulder City','Boulder City','US ','BLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3258,'Boundary','Boundary','US ','BYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3259,'Boundary Bay','Juneau','US ','JNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3260,'Bowerman','Hoquiam','US ','HQM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3261,'Bowers Field','Ellensburg','US ','ELN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3262,'Bowman','Bowman','US ','BWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3263,'Bowman Field Airport','Louisville','US ','LOU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3264,'Boxborough','Boxborough','US ','BXC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3265,'Brackett Field','La Verne','US ','POC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3266,'Bradford','Bradford','US ','BFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3267,'Bradley International','Windsor Locks CT','US ','BDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3268,'Bradshaw AAF','Pohakuloa','US ','BSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3269,'Brainard','Hartford','US ','HFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3270,'Brainerd Lakes Regional','Brainerd MN','US ','BRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3271,'Brawley','Brawley','US ','BWC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3272,'Brazoria County','Lake Jackson','US ','LJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3273,'Bremerton','Bremerton','US ','PWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3274,'Brevig Mission','Teller Mission','US ','KTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3275,'Brewster Field','Holdrege','US ','HDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3276,'Brigham City','Brigham City','US ','BMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3277,'Broadus','Broadus','US ','BDX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3278,'Broken Bow','Broken Bow','US ','BBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3279,'Broker Inn','Boulder','US ','WBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3280,'Brookhaven','Shirley','US ','WSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3281,'Brookings','Brookings','US ','BKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3282,'Brookings State','Brookings','US ','BOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3283,'Brooks Lodge','Brooks Lodge','US ','RBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3284,'Brown Field Municipal','San Diego','US ','SDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3285,'Browns','Weeping Water','US ','EPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3286,'Brownwood','Brownwood','US ','BWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3287,'Brunswick Golden Isles','Glynco','US ','NEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3288,'Bryant AAF','Fort Richardson','US ','FRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3289,'Bryce','Bryce','US ','BCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3290,'Buchanan Fld','Concord','US ','CCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3291,'Buckeye Municipal','Buckeye','US ','BXK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3292,'Buckland','Buckland','US ','BKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3293,'Buffalo Depew Rr','Buffalo','US ','ZFZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3294,'Buffalo Municipal Airport','Buffalo','US ','BFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3295,'Buffalo Niagara International','Buffalo NY','US ','BUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3296,'Bullfrog Basin','Bullfrog Basin','US ','BFG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3297,'Burke Lakefront','Cleveland','US ','BKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3298,'Burlington','Burlington','US ','BRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3299,'Burlington','Burlington','US ','BBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3300,'Burlington County','Mount Holly','US ','LLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3301,'Burlington International','Burlington','US ','BTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3302,'Burns','Burns','US ','BNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3303,'Bus Station','Santa Fe','US ','ZSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3304,'Bus Station','Telluride','US ','ZTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4026,'Willow','Willow','US ','WOW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4027,'Willow Grove NAS','Willow Grove','US ','NXX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4028,'Willow Run','Detroit MI','US ','YIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4029,'Wilmington International','Wilmington','US ','ILM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4030,'Wilmington Rail','Wilmington','US ','ZWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4031,'Winder','Winder','US ','WDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4032,'Windom Municipal','Windom MN','US ','MWM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4033,'Wings Field','Blue Bell','US ','BBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4034,'Wink','Wink','US ','INK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4035,'Winlock','Toledo','US ','TDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4036,'Winnemucca','Winnemucca','US ','WMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4037,'Winslow-Lindbergh','Winslow AZ','US ','INW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4038,'Winston County','Louisville','US ','LMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4039,'Winston Field','Snyder','US ','SNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4040,'Wiscasset','Wiscasset','US ','ISS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4041,'Wise','Wise','US ','LNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4042,'Wiseman','Wiseman','US ','WSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4043,'Witham Field','Stuart','US ','SUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4044,'Wittman Field','Oshkosh','US ','OSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4045,'WK Kellogg Regional','Battle Creek','US ','BTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4046,'Wood County','Parkersburg','US ','PKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4047,'Wood River','Wood River','US ','WOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4048,'Woodchopper','Woodchopper','US ','WOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4049,'Woodward Fld','Camden','US ','CDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4050,'Worcester Regional Airport','Worcester','US ','ORH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4051,'Worland','Worland WY','US ','WRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4052,'World Trade Center','New York','US ','WTC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4053,'Worthington','Worthington','US ','OTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4054,'Wrangell SPB','Wrangell','US ','WRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4055,'Wright AFB','Dayton','US ','DWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4056,'Wurtsmith AFB','Oscoda','US ','OSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4057,'Yakima Air Terminal','Yakima','US ','YKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4058,'Yakutat','Yakutat','US ','YAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4059,'Yampa Valley','Hayden','US ','HDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4060,'Yeager','Charleston','US ','CRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4061,'Yelland','Ely','US ','ELY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4062,'Yellowstone','West Yellowstone','US ','WYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4063,'Yellowstone Regional','Cody/Yellowstone','US ','COD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4064,'Yerington','Yerington','US ','EYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4065,'York Airport','York','US ','THV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4066,'Yosemite Ntl Park','Yosemite Ntl Park','US ','OYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4067,'Youngstown','Youngstown','US ','YNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4068,'Yreka','Yreka','US ','RKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4069,'Yuba County','Marysville','US ','MYV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4070,'Zachar Bay SPB','Zachar Bay','US ','KZB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4071,'Zahns','Amityville','US ','AYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4072,'Zanesville','Zanesville','US ','ZZV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4073,'Zephyrhills','Zephyrhills','US ','ZPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4074,'Zwara','Zwara','US ','WAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4075,'Bisbee-douglas International','Douglas','US ','DGF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4076,'Artigas','Artigas','UY ','ATI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4077,'Bella Union','Bella Union','UY ','BUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4078,'Capitan Corbeta CA Curbelo International Airport','Maldonado','UY ','PDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4079,'Carrasco International','Montevideo','UY ','MVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4080,'Laguna De Los Patos','Colonia','UY ','CYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4081,'Melo','Melo','UY ','MLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4082,'Paysandu','Paysandu','UY ','PDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4083,'Rivera','Rivera','UY ','RVY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4084,'Salto','Salto','UY ','STY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4085,'Santa Bernardina','Durazno','UY ','DZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4086,'Tacuarembo','Tacuarembo','UY ','TAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4087,'Treinta-y-Tres','Treinta-y-Tres','UY ','TYT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4088,'Vichadero','Vichadero','UY ','VCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4089,'Johnston Island','Johnston Island','UM ','JON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4090,'Sand Island Field','Midway Island','UM ','MDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4091,'Wake Island','Wake Island','UM ','AWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4092,'Andizhan','Andizhan','UZ ','AZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4093,'Bukhara','Bukhara','UZ ','BHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4094,'Fergana','Fergana','UZ ','FEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4095,'Karshi','Karshi','UZ ','KSQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4096,'Namangan','Namangan','UZ ','NMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4097,'Navoi','Navoi','UZ ','NVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4098,'Nukus','Nukus','UZ ','NCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4099,'Samarkand','Samarkand','UZ ','SKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4100,'Termez','Termez','UZ ','TMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4101,'Urgench','Urgench','UZ ','UGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4102,'Yuzhny','Tashkent','UZ ','TAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4103,'Zarafshan','Zarafshan','UZ ','AFS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4104,'Aneityum','Aneityum','VU ','AUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4105,'Aniwa','Aniwa','VU ','AWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4106,'Bauerfield','Port Vila','VU ','VLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4107,'Big Bay','Big Bay','VU ','GBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4108,'Craig Cove','Craig Cove','VU ','CCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4109,'Dillons Bay','Dillons Bay','VU ','DLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4110,'Emae','Emae','VU ','EAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4111,'Epi','Epi','VU ','EPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4112,'Futuna Airport','Futuna Island','VU ','FTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4113,'Gaua','Gaua','VU ','ZGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4114,'Ipota','Ipota','VU ','IPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4115,'Lamap','Lamap','VU ','LPM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4116,'Lamen Bay','Lamen Bay','VU ','LNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4117,'Longana','Longana','VU ','LOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4118,'Lonorore','Lonorore','VU ','LNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4119,'Maewo','Maewo','VU ','MWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4120,'Mota Lava','Mota Lava','VU ','MTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4121,'Norsup','Norsup','VU ','NUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4122,'Olpoi','Olpoi','VU ','OLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4123,'Paama','Paama','VU ','PBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4124,'Pekoa','Espiritu Santo','VU ','SON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4125,'Quine Hill','Quine Hill','VU ','UIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4126,'Redcliffe','Redcliffe','VU ','RCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4127,'Sara','Sara','VU ','SSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4128,'Sola','Sola','VU ','SLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4129,'South West Bay','South West Bay','VU ','SWJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4130,'Tanna','Tanna','VU ','TAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4131,'Tongoa','Tongoa','VU ','TGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4132,'Torres Airstrip','Torres','VU ','TOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4133,'Ulei','Ulei','VU ','ULB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4134,'Valesdir','Valesdir','VU ','VLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4135,'Walaha','Walaha','VU ','WLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4136,'A Carnevalli','Merida','VE ','MRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4137,'Acarigua','Acarigua','VE ','AGV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4138,'Anaco','Anaco','VE ','AAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4139,'Barinas','Barinas','VE ','BNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4140,'Barquisimeto','Barquisimeto','VE ','BRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4141,'Caicara Del Orinoco','Caicara Del Orinoco','VE ','CXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4142,'Calabozo','Calabozo','VE ','CLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4143,'Canaima','Canaima','VE ','CAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4144,'Carora','Carora','VE ','VCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4145,'Carupano','Carupano','VE ','CUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4146,'Carvajal','Valera','VE ','VLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4147,'Casigua','Casigua','VE ','CUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4148,'Ciudad Bolivar','Ciudad Bolivar','VE ','CBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4149,'Ciudad Guayana','Ciudad Guayana','VE ','CGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4150,'Coro','Coro','VE ','CZE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4151,'Cumana','Cumana','VE ','CUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4152,'Del Caribe International','Porlamar','VE ','PMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4153,'Edmundo Barrios','San Tome','VE ','SOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4154,'El Dorado','El Dorado','VE ','EOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4155,'El Tigre','El Tigre','VE ','ELX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4156,'El Vigia','El Vigia','VE ','VIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4157,'Elorza','Elorza','VE ','EOZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4158,'Gen J A Anzoategui','Barcelona','VE ','BLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4159,'Guanare','Guanare','VE ','GUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4160,'Guiria','Guiria','VE ','GUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4161,'Icabaru','Icabaru','VE ','ICA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4162,'Josefa Camejo','Las Piedras','VE ','LSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4163,'Kamarata','Kamarata','VE ','KTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4164,'Kavanayen','Kavanayen','VE ','KAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4165,'L Delicias','Santa Barbara Ed','VE ','STB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4166,'La Chinita','Maracaibo','VE ','MAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4167,'La Fria','La Fria','VE ','LFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4168,'La Guaira','La Guaira','VE ','LAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4169,'Lagunillas','Lagunillas','VE ','LGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4170,'Las Flecheras','San Fernando De Apure','VE ','SFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4171,'Los Roques','Los Roques','VE ','LRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4172,'Maracay','Maracay','VE ','MYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4173,'Mayo Guerrero','Santo Domingo','VE ','STD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4174,'Oro Negro','Cabimas','VE ','CBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4175,'Palmarito','Palmarito','VE ','PTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4176,'Pedernales','Pedernales','VE ','PDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4177,'Peraitepuy','Peraitepuy','VE ','PPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4178,'Pijiguaos','Pijiguaos','VE ','LPJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4179,'Puerto Ayacucho','Puerto Ayacucho','VE ','PYH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4180,'Puerto Cabello','Puerto Cabello','VE ','PBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4181,'Puerto La Cruz','Puerto La Cruz','VZ ','UPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4182,'Puerto Ordaz','Puerto Ordaz','VE ','PZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4183,'Puerto Paez','Puerto Paez','VE ','PPZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4184,'Quiriquire','Maturin','VE ','MUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4185,'San Antonio','San Antonio','VE ','SVZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4186,'San Cristobal','San Cristobal','VE ','SCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4187,'San Felipe','San Felipe','VE ','SNF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4188,'San Felix','San Felix','VE ','SFX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4189,'San Salvador De','San Salvador De','VE ','SVV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4190,'Santa Barbara Ba','Santa Barbara de Barinas','VE ','SBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4191,'Santa Elena','Santa Elena','VE ','SNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4192,'Simón Bolívar International','Maiquetía','VE ','MIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4193,'Simon Bolivar International Airport','Caracas','VE ','CCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4194,'Tucupita','Tucupita','VE ','TUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4195,'Tumeremo','Tumeremo','VE ','TMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4196,'Uriman','Uriman','VE ','URM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4197,'Valencia','Valencia','VE ','VLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4198,'Valle De Pascua','Valle De Pascua','VE ','VDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4199,'Vare Maria','Guasdualito','VE ','GDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4200,'Wonken','Wonken','VE ','WOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4201,'Ca Mau','Ca Mau','VN ','CAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4202,'Can Tho','Can Tho','VN ','VCA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4203,'Cape St Jacques','Cape St Jacques','VN ','CSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4204,'Catbi','Haiphong','VN ','HPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4205,'Chulai','Tamky','VN ','VCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4206,'Coong','Con Dao','VN ','VCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4207,'Da Nang','Da Nang','VN ','DAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4208,'Dien Bien','Dien Bien Phu','VN ','DIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4209,'Duong Dong','Phu Quoc','VN ','PQC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4210,'Flamingo','Phu-bon','VN ','HBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4211,'Kontum','Kontum','VN ','KON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4212,'Lienkhang','Dalat','VN ','DLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4213,'Long Xuyen','Long Xuyen','VN ','XLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4214,'Nha Trang','Nha Trang','VN ','NHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4215,'Nha Trang','Nha Trang','VN ','CXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4216,'Nhon Co','Quanduc','VN ','HOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4217,'Noibai International','Hanoi','VN ','HAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4218,'Phan Rang','Phan Rang','VN ','PHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4219,'Phan Thiet','Phan Thiet','VN ','PHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4220,'Phu Bai','Hue','VN ','HUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4221,'Phu Vinh','Phu Vinh','VN ','PHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4222,'Phung-Duc','Banmethuot','VN ','BMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4223,'Phuoclong','Phuoclong','VN ','VSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4224,'Pleiku','Pleiku','VN ','PXU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4225,'Quang Ngai','Quang Ngai','VN ','XNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4226,'Qui Nhon','Qui Nhon','VN ','UIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4227,'Rach Gia','Rach Gia','VN ','VKG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4228,'Soc Trang','Soc Trang','VN ','SOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4229,'Tan Son Nhat International','Ho Chi Minh City','VN ','SGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4230,'Tuy Hoa','Tuy Hoa','VN ','TBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4231,'Vinh City','Vinh City','VN ','VII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4232,'Vinh Long','Vinh Long','VN ','XVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4233,'Vung Tau','Vung Tau','VN ','VTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4234,'Anegada','Anegada','VG ','NGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4235,'Hovercraft/Launch Pt','N. Sound/Virgin Gorda','VG ','NSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4236,'Road Town','Tortola','VG ','RAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4237,'West End SPB','Tortola','VG ','TOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4238,'Henry E Rohlsen','St Croix Island','VI ','STX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4239,'St John Island','St John Island','VI ','SJF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4240,'Cyril E King Airport','Charlotte Amalie St ThomasVirgin Islands','VI ','STT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4241,'Futuna Island','Futuna Island','WF ','FUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4242,'Wallis Island','Wallis Island','WF ','WLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4243,'Abbse','Abbse','YE ','EAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4244,'Al Ghaydah','Al Ghaydah','YE ','AAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4245,'Al Janad','Taiz','YE ','TAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4246,'Albuq','Albuq','YE ','BUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4247,'Aljouf','Aljouf','YE ','AJO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3665,'Santa Monica','Santa Monica','US ','SMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3666,'Santa Ynez','Santa Ynez','US ','SQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3667,'Sarasota-Bradenton International Airport','Sarasota FL','US ','SRQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3668,'Sarichef','Sarichef','US ','WSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3669,'Savannah/Hilton Head','Savannah','US ','SAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3670,'Savoonga','Savoonga','US ','SVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3671,'Sawyer International','Marquette','US ','MQT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3672,'Schenectady County','Schenectady NY','US ','SCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3673,'Schenectady Rail','Schenectady','US ','ZTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3674,'Schloredt','Sundance','US ','SUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3675,'Scholes Field','Galveston','US ','GLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3676,'Scotts Bluff County','Scottsbluff','US ','BFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3677,'Scottsdale Municipal','Phoenix','US ','SCF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3678,'Sea Port','Beaver Inlet','US ','BVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3679,'Seal Bay','Seal Bay','US ','SYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3680,'Searcy','Searcy','US ','SRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3681,'Searcy Fld','Stillwater','US ','SWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3682,'Searle Field','Ogallala','US ','OGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3683,'Seattle-Tacoma International','Seattle WA','US ','SEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3684,'Sebring Regional Airport','Sebring Fl','US ','SEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3685,'Sedalia','Sedalia','US ','DMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3686,'Sedona','Sedona','US ','SDX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3687,'Selawik','Selawik','US ','WLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3688,'Seldovia','Seldovia','US ','SOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3689,'Selfield','Selma','US ','SES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3690,'Senator Clark','Gallup','US ','GUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3691,'Sequim Valley Arpt','Sequim','US ','SQV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3692,'Seward','Seward','US ','SWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3693,'Shageluk','Shageluk','US ','SHX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3694,'Shaktoolik','Shaktoolik','US ','SKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3695,'Shangri-la','Shangri-la','US ','NRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3696,'Sharpe AAF','Lathrop','US ','LRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3697,'Sharpe Field','Tuskegee','US ','TGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3698,'Shaw AFB','Sumter','US ','SSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3699,'Sheep Mountain','Sheep Mountain','US ','SMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3700,'Sheffield','Sheffield','US ','MSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3701,'Shelby','Shelby','US ','SBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3702,'Sheldon SPB','Sheldon Point','US ','SXP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3703,'Shemya AFB','Shemya','US ','SYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3704,'Shenandoah Valley','Staunton','US ','SHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3705,'Sheppard AFB','Wichita Falls','US ','SPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3706,'Sheridan','Sheridan','US ','SHR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3707,'Sherman','Clinton','US ','CSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3708,'Sherman AAF','Fort Leavenworth','US ','FLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3709,'Sherwood','Plentywood','US ','PWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3710,'Shishmaref','Shishmaref','US ','SHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3711,'Shively Field','Saratoga','US ','SAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3712,'Shoal Cove','Shoal Cove','US ','HCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3713,'Show Low','Show Low AZ','US ','SOW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3714,'Shreveport Downtown','Shreveport LA','US ','DTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3715,'Shungnak','Shungnak','US ','SHG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3716,'Sidney','Sidney','US ','SNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3717,'Sidney','Sidney','US ','SXY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3718,'Sikorsky Heliport','Stratford CT','US ','JSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3719,'Simmons AAF','Fort Bragg','US ','FBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3720,'Simmons Nott','New Bern','US ','EWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3721,'Sioux Gateway','Sioux City','US ','SUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3722,'Siskiyou County','Montague','US ','SIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3723,'Sitka','Sitka','US ','SIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3724,'Sitkinak Cgs','Sitkinak Island','US ','SKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3725,'Skagit Regional','Mount Vernon','US ','MVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3726,'Sky Harbor Intl','Phoenix','US ','PHX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3727,'Skypark','Santa Cruz','US ','SRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3728,'Sleetmute','Sleetmute','US ','SLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3729,'Sloulin Field Intl','Williston','US ','ISN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3730,'Smart','Macon','US ','MAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3731,'Smith Cove','Smith Cove','US ','SCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3732,'Smith Field','Fort Wayne IN','US ','SMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3733,'Smith Field','Siloam Springs','US ','SLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3734,'Smith-Reynolds','Winston Salem','US ','INT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3735,'Smyrna','Smyrna','US ','MQY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3736,'Snohomish County','Everett','US ','PAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3737,'Socorro','Socorro','US ','ONM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3738,'Soldotna','Soldotna','US ','SXQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3739,'Solomon','Solomon','US ','SOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3740,'Sonoma County','Santa Rosa','US ','STS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3741,'South Bend Regional','South Bend','US ','SBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3742,'South Big Horn County','Greybull','US ','GEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3743,'South Lake Tahoe','South Lake Tahoe','US ','TVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3744,'South Naknek','South Naknek','US ','WSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3745,'South Padre Is. Intl','Brownsville','US ','BRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3746,'South Weymouth','South Weymouth','US ','NZW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3747,'Southern California Logistics','Victorville CA','US ','VCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3748,'Southern Illinois','Carbondale','US ','MDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3749,'Southern Seaplane','Belle Chasse','US ','BCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3750,'Southwest Florida Reg','Fort Myers','US ','RSW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3751,'Sparrevohn AFS','Sparrevohn','US ','SVW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3752,'Sparta Community','Sparta','US ','SAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3753,'"Spartanburg',' Downtown MemorialSpartanburg SC','US ','SPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3754,'Spb','Akiachak','US ','KKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3755,'SPB','Chernofski','US ','KCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3756,'SPB','Excursion Inlet','US ','EXI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3757,'SPB','Funter Bay','US ','FNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3758,'SPB','Hawk Inlet','US ','HWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3759,'SPB','Hollis','US ','HYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3760,'SPB','Hydaburg','US ','HYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3761,'SPB','Hyder','US ','WHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3762,'SPB','Ivanof Bay','US ','KIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3763,'SPB','Kake','US ','KAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3764,'SPB','Kitoi Bay','US ','KKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3765,'SPB','Metlakatla','US ','MTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3766,'SPB','Meyers Chuck','US ','WMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3767,'SPB','Miami','US ','MPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3768,'SPB','Napaskiak','US ','PKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3769,'SPB','Paimiut','US ','PMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3770,'SPB','Philadelphia','US ','PSQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3771,'SPB','Scammon Bay','US ','SCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3772,'SPB','Steamboat Bay','US ','WSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3773,'SPB','Tikchik','US ','KTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3774,'SPB','Yes Bay','US ','WYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3775,'Spirit Lake','Spirit Lake','US ','RTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3776,'Spirit Of St Louis','St Louis','US ','SUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3777,'Splane Memorial','Oil City PA','US ','OIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3778,'Spokane International','Spokane','US ','GEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3779,'Springdale Muni','Springdale','US ','SPZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3780,'Springfield','Springfield','US ','SGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3781,'Springfield MA RR','Springfield','US ','ZSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3782,'Springfield-Branson Rg','Springfield','US ','SGF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3783,'St Augustine','St Augustine','US ','UST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3784,'St Clair County','Pell City','US ','PLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3785,'St Clair County Intl','Port Huron','US ','PHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3786,'St George Island','St George Island','US ','STG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3787,'St Johns','St Johns','US ','SJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3788,'St Landry Parish','Opelousas','US ','OPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3789,'St Lucie County','Fort Pierce','US ','FPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3790,'St Marys','St Marys','US ','XSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3791,'St Marys County','Leonardtown','US ','LTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3792,'St Michael','St Michael','US ','SMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3793,'St. Louis Downtown Airport','St Louis Il','US ','CPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3794,'St. Petersburg-Clearwater International','Clearwater','US ','PIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3795,'Stallings Field','Kinston','US ','ISO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3796,'Stamford Rail STN','Westchester County','US ','ZTF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3797,'State','Bandon','US ','BDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3798,'State','Chiloquin','US ','CHZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3799,'State','Easton','US ','ESW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3800,'State','Gold Beach','US ','GOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3801,'State','Hermiston','US ','HES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3802,'State','Newport','US ','NPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3803,'State','Rome','US ','REO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3804,'State','Scribner','US ','SCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3805,'State','Springfield','US ','VSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3806,'Statesboro-Bulloch County Airport','Statesboro GA','US ','TBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3807,'Steamboat Springs','Steamboat Springs','US ','SBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3808,'Stebbins','Stebbins','US ','WBB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3809,'Steel Pier Hlpt','Atlantic City','US ','JSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3810,'Stefan Field','Norfolk','US ','OFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3811,'Stellar Air Park','Chandler','US ','SLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3812,'Stephens County','Breckenridge','US ','BKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3813,'Stevens Point','Stevens Point','US ','STE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3814,'Stevens Village','Stevens Village','US ','SVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3815,'Stewart','Newburgh','US ','SWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3816,'Stinson Municipal','San Antonio','US ','SSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3817,'Stockton Metropolitan Airport','Stockton','US ','SCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3818,'Stolport','Vallejo','US ','VLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3819,'Stony River','Stony River','US ','SRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3820,'Stroud','Stroud','US ','SUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3821,'Stuart Island','Stuart Island','US ','SSW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3822,'Stuttgart Municipal','Stuttgart AR','US ','SGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3823,'Suffolk County','Westhampton','US ','FOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3824,'Sugar Land Regional','Houston TX','US ','SGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3825,'Sullivan County Intl','Monticello','US ','MSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3826,'Sulphur Springs','Sulphur Springs','US ','SLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3827,'Summit','Summit','US ','UMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3828,'Sun River','Sun River','US ','SUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3829,'Sun Valley','Sun Valley','US ','SUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3830,'Susanville','Susanville','US ','SVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3831,'Sussex County','Georgetown','US ','GED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3832,'Sweetwater','Sweetwater','US ','SWW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3833,'Sweetwater County','Rock Springs','US ','RKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3834,'Sylvester','Sylvester','US ','SYV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3835,'Syracuse Hancock International Airport','Syracuse','US ','SYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3836,'T. F. Green Airport','Providence','US ','PVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3837,'Tahneta Pass','Tahneta Pass Lodge','US ','HNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3838,'Takotna','Takotna','US ','TCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3839,'Taku SPB','Taku Lodge','US ','TKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3840,'Talkeetna','Talkeetna','US ','TKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3841,'Talladega','Talladega','US ','ASN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3842,'Tallahassee Regional Airport','Tallahassee','US ','TLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3843,'Tamiami','Miami','US ','TMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3844,'Tampa International','Tampa','US ','TPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3845,'Tanalian Point','Tanalian Point','US ','TPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3846,'Tatalina AFS','Tatalina','US ','TLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3847,'Tatitlek','Tatitlek','US ','TEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3848,'Taylor','Taylor','US ','TWE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3849,'Taylor','Taylor','US ','TYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3850,'Taylor Field','Ocala','US ','OCF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3851,'Technology Park','Atlanta','US ','JAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3852,'Ted Stevens Anchorage International Airport','Anchorage','US ','ANC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3853,'Telfair-Wheeler','Mc Rae','US ','MQW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3854,'Teller','Teller','US ','TLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3855,'Telluride','Telluride','US ','TEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3856,'Tenakee SPB','Tenakee Springs','US ','TKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3857,'Terrebonne','Houma','US ','HUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3858,'Terrell Field','Terrell','US ','TRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3859,'Test Range','Tonopah','US ','XSD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3860,'Teterboro','Teterboro','US ','TEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3861,'Tetlin','Tetlin','US ','TEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3862,'The City Heliport','Orange','US ','JOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3863,'The Hattiesburg-Bobby L. Chain Mun.','Hattiesburg','US ','HBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3864,'Thermal','Thermal','US ','TRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3865,'Thomas C Russell Fld','Alexander City','US ','ALX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3866,'Thompson-Robbins','Helena','US ','HEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3867,'Thompsonfield','Thompsonfield','US ','THM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3868,'Thorne Bay','Thorne Bay','US ','KTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3869,'Tin City Afs','Tin City AK','US ','TNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3870,'Tinker AFB','Oklahoma City','US ','TIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3871,'Tipton AAF','Fort Meade','US ','FME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3872,'Toccoa','Toccoa','US ','TOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3873,'Togiak Fish','Togiak Fish','US ','GFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3874,'Togiak Village','Togiak Village','US ','TOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3875,'Tok','Tok','US ','TKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3876,'Toledo','Toledo','US ','TDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3877,'Toledo Express','Toledo OH','US ','TOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3878,'Tompkins County','Ithaca','US ','ITH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3879,'Tonopah Arpt','Tonopah','US ','TPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3880,'Topp Of Tampa','Tampa','US ','KYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3881,'Torrance Airport','Torrance','US ','TOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3882,'Tradewind','Amarillo','US ','TDW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3883,'Travis AFB','Fairfield','US ','SUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3884,'Tremonton','Tremonton','US ','TRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3885,'Trenton Mercer Airport','Trenton NJ','US ','TTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3886,'Trenton Rail STN','Philadelphia','US ','ZTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3887,'Tri County','Lone Rock','US ','LNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3888,'Tri-cities','Pasco WA','US ','PSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3889,'Tri-cities Regional','Blountville','US ','TRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3890,'Tri-City','Parsons','US ','PPF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3891,'Tri-City','San Bernardino','US ','SBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3892,'Tri-State Steuben Cty','Angola','US ','ANQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3893,'Tri-State/Milton','Huntington','US ','HTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3894,'Trona','Trona','US ','TRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3895,'Troutdale','Troutdale','US ','TTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3896,'Truckee-Tahoe','Truckee CA','US ','TKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3897,'TSTC Waco Airport','Waco TX','US ','CNW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3898,'Tuba City','Tuba City','US ','TBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3899,'Tucson International Airport','Tucson AZ','US ','TUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3900,'Tucumcari','Tucumcari','US ','TCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3901,'Tullahoma/William Northern Field','Tullahoma TN','US ','THA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3902,'Tulsa International','Tulsa','US ','TUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3903,'Tuluksak','Tuluksak','US ','TLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3904,'Tuntutuliak','Tuntutuliak','US ','WTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3905,'Tununak','Tununak','US ','TNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3906,'Twentynine Palms','Twentynine Palms','US ','TNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3907,'Twin Hills','Twin Hills','US ','TWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3908,'Two Harbors','Catalina Island','US ','TWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3909,'Tyler Pounds Regional Airport','Tyler','US ','TYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3910,'Tyndall AFB','Panama City FL','US ','PAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3911,'Uganik','Uganik','US ','UGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3912,'Ugashik Bay','Pilot Point','US ','UGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3913,'Ukiah','Ukiah','US ','UKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3914,'Umiat','Umiat','US ','UMT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3915,'Umnak','Umnak Island','US ','UNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3916,'Unalakleet','Unalakleet','US ','UNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3917,'University Of Illinois Willard','Champaign','US ','CMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3918,'University Park','State College','US ','SCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3919,'University-Oxford','Oxford','US ','UOX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3920,'Upolu Point','Upolu Point','US ','UPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3921,'Upper Bucks','Quakertown','US ','UKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3922,'US Army Heliport','Arlington Heights','US ','JLH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3923,'USAF Academy Airstrip','Colorado Springs','US ','AFF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3924,'USAF Heliport','Wildwood','US ','WWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3925,'USN Heliport','Anacostia','US ','NDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3926,'Utica NNY Rail','Utica','US ','ZUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3927,'Valley International','Harlingen','US ','HRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3928,'Van De Graaf','Tuscaloosa AL','US ','TCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3929,'Van Nuys','Los Angeles CA','US ','VNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3930,'Van Service','Breckenridge','US ','QKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3931,'Van Service','Copper Mountain','US ','QCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3932,'Van Service','Winter Park','US ','QWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3933,'Vance Afb','Enid','US ','END');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3934,'Vandalia','Vandalia','US ','VLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3935,'VanGalder Bus Termina','Rockford','US ','ZRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3936,'Venetie','Venetie','US ','VEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3937,'Venice Municipal','Venice FL','US ','VNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3938,'Ventura','Ventura','US ','OXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3939,'Vermilion County','Danville IL','US ','DNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3940,'Vernal','Vernal UT','US ','VEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3941,'Versailles','Versailles','US ','VRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3942,'View Cove','View Cove','US ','VCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3943,'Village SPB','West Point','US ','KWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3944,'Virgil I Grissom Muni','Bedford','US ','BFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3945,'Virginia Highlands','Abingdon','US ','VJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3946,'Virginia Tech','Blacksburg','US ','BCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3947,'Visalia','Visalia','US ','VIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3948,'Volk Field','Camp Douglas','US ','VOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3949,'Vor','Otto','US ','OTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3950,'W T Piper Memorial','Lock Haven','US ','LHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3951,'Wahpeton','Wahpeton','US ','WAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3952,'Waikoloa Airport','Waikoloa','US ','WKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3953,'Wainwright','Wainwright','US ','AIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3954,'Wales','Wales','US ','WAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3955,'Walker Field','Grand Junction','US ','GJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3956,'Walla Walla','Walla Walla','US ','ALW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3957,'Wallops Flight Center','Chincoteague','US ','WAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3958,'Walnut Ridge','Walnut Ridge','US ','ARG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3959,'Walt Disney World','Orlando','US ','DWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3960,'Walter J. Koladza Airport','Great Barrington','US ','GBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3961,'Waltham','Waltham','US ','WLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3962,'Ware','Ware','US ','UWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3963,'Ware County','Waycross','US ','AYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3964,'Warm Spring Bay SPB','Baranof','US ','BNF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3965,'Warren AFB','Cheyenne','US ','FEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3966,'Warren County','Bowling Green','US ','BWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3967,'Warren County','Glens Falls','US ','GFL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3968,'Warren County','Mcminnville','US ','RNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3969,'Warren Field','Washington','US ','OCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3970,'Warroad','Warroad','US ','RRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3971,'Wash. County Regional','Hagerstown','US ','HGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3972,'Washington Dulles International','Washington DC','US ','IAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3973,'Wasilla','Wasilla','US ','WWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3974,'Waterbury-oxford','Oxford CT','US ','OXC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3975,'Waterfall SPB','Waterfall','US ','KWF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3976,'Waterfront SPB','Ketchikan','US ','WFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3977,'Waterloo','Waterloo','US ','ALO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3978,'Watertown','Watertown','US ','ART');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3979,'Watertown','Watertown','US ','ATY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3980,'Watsonville','Watsonville','US ','WVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3981,'Waukesha','Waukesha','US ','UES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3982,'Wayne County','Wooster','US ','BJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3983,'Webb AFB','Big Spring','US ','BGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3984,'Weedon Field','Eufaula','US ','EUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3985,'Weide AAF','Edgewood','US ','EDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3986,'Weld County','Greeley','US ','GXY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3987,'Wendover','Wendover','US ','ENV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3988,'West 30th St Heliport','New York','US ','JRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3989,'West Bend','West Bend','US ','ETB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3990,'West Kavik','West Kavik','US ','VKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3991,'West Kuparuk','West Kuparuk','US ','XPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3992,'West Woodward','Woodward','US ','WWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3993,'Westchester County Apt','White Plains','US ','HPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3994,'Westerly State','Westerly','US ','WST');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3995,'Westmoreland County','Latrobe','US ','LBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3996,'Westover Metro Arpt','Springfield','US ','CEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3997,'Westsound','Westsound','US ','WSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3998,'Whale Pass','Whale Pass','US ','WWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (3999,'Wharton','Wharton','US ','WHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4000,'Wheeler AFB','Wahiawa','US ','HHI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4001,'Whidbey Island NAS','Oak Harbor','US ','NUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4002,'White Mountain','White Mountain','US ','WMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4003,'White River','White River','US ','WTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4004,'White River','White River','US ','LEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4005,'Whiteman','Los Angeles','US ','WHP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4006,'Whiteman AFB','Kansas','US ','SZL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4007,'Whiteside County','Sterling Rockfalls','US ','SQI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4008,'Whiting Field NAS','Milton','US ','NSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4009,'Wicomico Regional','Salisbury-Ocean City','US ','SBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4010,'Wildman Lake','Wildman Lake','US ','EWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4011,'Wiley Ford','Cumberland','US ','CBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4012,'Wiley Post','Oklahoma City','US ','PWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4013,'Wiley Post/W.Rogers M','Barrow','US ','BRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4014,'Wilgrove Air Park','Charlotte NC','US ','QWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4015,'Wilkes County','Wilkesboro','US ','IKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4016,'Wilkes-Barre/Scranton International Airport','Wilkes-Barre/Scranton PA','US ','AVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4017,'Wilkes-Barre/Wyoming Valley','Wilkes-Barre PA','US ','WBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4018,'Will Rogers World Airport','Oklahoma City','US ','OKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4019,'William J Fox','Lancaster','US ','WJF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4020,'William P Hobby','Houston TX','US ','HOU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4021,'Williams Gateway Airport','Mesa','US ','CHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4022,'Williams Memorial','Patterson','US ','PTN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4023,'Williamsburg Rail','Hampton','US ','ZWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4024,'Williamson County','Marion','US ','MWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4025,'Willmar','Willmar','US ','ILL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4248,'Ataq','Ataq','YE ','AXK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4249,'Beidah','Beidah','YE ','BYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4250,'Beihan','Beihan','YE ','BHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4251,'Dathina','Dathina','YE ','DAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4252,'Dhala','Dhala','YE ','DHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4253,'Dhamar','Dhamar','YE ','DMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4254,'El Rahaba Airport','Sanaa','YE ','SAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4255,'Hodeidah Arpt','Hodeidah','YE ','HOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4256,'International','Aden','YE ','ADE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4257,'Kamaran Is','Kamaran Is','YE ','KAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4258,'Lodar','Lodar','YE ','LDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4259,'Mareb','Mareb','YE ','MYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4260,'Mukalla','Mukalla','YE ','MKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4261,'Mukeiras','Mukeiras','YE ','UKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4262,'Qishn','Qishn','YE ','IHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4263,'Raudha','Raudha','YE ','RXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4264,'Riyan Mukalla','Riyan Mukalla','YE ','RIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4265,'Sadah','Sadah','YE ','SYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4266,'Seiyun','Seiyun','YE ','GXF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4267,'Socotra','Socotra','YE ','SCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4268,'Wadi Ain','Wadi Ain','YE ','WDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4269,'Zabljak','Zabljak','YU ','ZBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4270,'Basankusu','Basankusu','ZR ','BSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4271,'Basongo','Basongo','ZR ','BAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4272,'Beni','Beni','ZR ','BNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4273,'Boende','Boende','ZR ','BNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4274,'Boma','Boma','ZR ','BOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4275,'Bumba','Bumba','ZR ','BMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4276,'Bunia','Bunia','ZR ','BUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4277,'Buta','Buta','ZR ','BZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4278,'Gandajika','Gandajika','ZR ','GDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4279,'Gemena','Gemena','ZR ','GMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4280,'Idiofa','Idiofa','ZR ','IDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4281,'Ilebo','Ilebo','ZR ','PFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4282,'Kabalo','Kabalo','ZR ','KBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4283,'Kabinda','Kabinda','ZR ','KBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4284,'Kalemie','Kalemie','ZR ','FMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4285,'Kalima','Kalima','ZR ','KLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4286,'Kamina','Kamina','ZR ','KMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4287,'Kananga','Kananga','ZR ','KGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4288,'Kaniama','Kaniama','ZR ','KNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4289,'Kapanga','Kapanga','ZR ','KAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4290,'Kasenga','Kasenga','ZR ','KEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4291,'Kasongo Lunda','Kasongo Lunda','ZR ','KGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4292,'Kikwit','Kikwit','ZR ','KKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4293,'Kilwa','Kilwa','ZR ','KIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4294,'Kindu','Kindu','ZR ','KND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4295,'Kiri','Kiri','ZR ','KRZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4296,'Kongolo','Kongolo','ZR ','KOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4297,'Kota Koli','Kota Koli','ZR ','KLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4298,'Libenge','Libenge','ZR ','LIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4299,'Lisala','Lisala','ZR ','LIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4300,'Luiza','Luiza','ZR ','LZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4301,'Luozi','Luozi','ZR ','LZI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4302,'Lusambo','Lusambo','ZR ','LBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4303,'Lusanga','Lusanga','ZR ','LUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4304,'Masi Manimba','Masi Manimba','ZR ','MSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4305,'Matadi','Matadi','ZR ','MAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4306,'Matari','Isiro','ZR ','IRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4307,'Mbandaka','Mbandaka','ZR ','MDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4308,'Mbuji Mayi','Mbuji Mayi','ZR ','MJM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4309,'Moanda','Moanda','ZR ','MNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4310,'Moba','Moba','ZR ','BDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4311,'Mweka','Mweka','ZR ','MEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4312,'Nioki','Nioki','ZR ','NIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4313,'Nkolo','Nkolo','ZR ','NKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4314,'Punia','Punia','ZR ','PUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4315,'Pweto','Pweto','ZR ','PWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4316,'Yangambi','Yangambi','ZR ','YAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4317,'Chingola','Chingola','ZM ','CGJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4318,'Chipata','Chipata','ZM ','CIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4319,'Kalabo','Kalabo','ZM ','KLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4320,'Kaoma','Kaoma','ZM ','KMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4321,'Kasaba Bay','Kasaba Bay','ZM ','ZKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4322,'Kasama','Kasama','ZM ','KAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4323,'Kasompe','Kasompe','ZM ','ZKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4324,'Livingstone','Livingstone','ZM ','LVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4325,'Lukulu','Lukulu','ZM ','LXU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4326,'Lusaka','Lusaka','ZM ','LUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4403,'Ibadan','Ibadan','NG ','IBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4404,'Ilorin','Ilorin','NG ','ILR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4405,'Jos','Jos','NG ','JOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4406,'Kaduna','Kaduna','NG ','KAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4407,'Maiduguri','Maiduguri','NG ','MIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4408,'Makurdi','Makurdi','NG ','MDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4409,'Minna','Minna','NG ','MXJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4410,'Murtala Muhammed','Lagos','NG ','LOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4411,'Nnamdi Azikiwe International Airport','Abuja','NG ','ABV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4412,'Port Harcourt','Port Harcourt','NG ','PHC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4413,'Port Harcourt City','Port Harcourt','NG ','PHG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4414,'Sokoto','Sokoto','NG ','SKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4415,'Victoria Island','Victoria Island','NG ','QVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4416,'Warri','Warri','NG ','QRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4417,'Yola','Yola','NG ','YOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4418,'Zaria','Zaria','NG ','ZAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4419,'Hanan','Niue Island','NU ','IUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4420,'Norfolk Island','Norfolk Island','NF ','NLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4421,'International','Saipan','MP ','SPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4422,'Rota','Rota','MP ','ROP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4423,'Tinian','Tinian','MP ','TIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4424,'Alta','Alta','NO ','ALF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4425,'Andenes','Andenes','NO ','ANX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4426,'Aro','Molde','NO ','MOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4427,'Banak','Lakselv','NO ','LKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4428,'Bardufoss','Bardufoss','NO ','BDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4429,'Batsfjord','Batsfjord','NO ','BJF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4430,'"Bergen Airport',' FleslandBergen','NO ','BGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4431,'Berlevag','Berlevag','NO ','BVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4432,'Bodo','Bodo','NO ','BOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4433,'Bringeland','Forde','NO ','FDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4434,'Bronnoy','Bronnoysund','NO ','BNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4435,'Dagali Airport','Geilo','NO ','DLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4436,'Evenes','Harstad-narvik','NO ','EVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4437,'Flora','Floro','NO ','FRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4438,'Framnes','Narvik','NO ','NVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4439,'Hamar Arpt','Hamar','NO ','HMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4440,'Hammerfest','Hammerfest','NO ','HFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4441,'Harbour','Maloy','NO ','QFQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4442,'Harbour','Selje','NO ','QFK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4443,'Hasvik','Hasvik','NO ','HAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4444,'Haugesund','Haugesund','NO ','HAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4445,'Haukasen','Sogndal','NO ','SOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4446,'Helle','Svolvaer','NO ','SVJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4447,'Hoeybuktmoen','Kirkenes','NO ','KKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4448,'Hovden','Orsta-Volda','NO ','HOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4449,'Kjaerstad','Mosjoen','NO ','MJF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4450,'Kjevik','Kristiansand','NO ','KRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4451,'Klanten Arpt','Gol','NO ','GLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4452,'Kvernberget','Kristiansund','NO ','KSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4453,'Leknes','Leknes','NO ','LKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4454,'Lista','Farsund','NO ','FAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4455,'Mehamn','Mehamn','NO ','MEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4456,'Mo I Rana','Mo I Rana','NO ','MQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4457,'Namsos','Namsos','NO ','OSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4458,'Notodden','Notodden','NO ','NTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4459,'Orland','Orland','NO ','OLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4460,'Oslo - Gardermoen Airport','Oslo','NO ','GEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4461,'"Oslo Airport',' GardermoenOslo','NO ','OSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4462,'Roros','Roros','NO ','RRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4463,'Ryumsjoen','Roervik','NO ','RVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4464,'Sandane','Sandane','NO ','SDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4465,'Sandefjord','Torp','NO ','TRF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4466,'Sandnes Rail St.','Sandnes','NO ','XKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4467,'Skagen','Stokmarknes','NO ','SKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4468,'Skien','Skien','NO ','SKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4469,'Sola','Stavanger','NO ','SVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4470,'Sorkjosen','Sorkjosen','NO ','SOJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4471,'Spitsberg','Svalbard','NO ','SYG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4472,'Stokka','Sandnessjoen','NO ','SSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4473,'Stolport','Rost','NO ','RET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4474,'Stolport','Vaeroy','NO ','VRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4475,'Stord Airport','Stord','NO ','SRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4476,'Storekvina Railway','Storekvina','NO ','XUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4477,'Storen Railway','Storen','NO ','XUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4478,'Svalbard','Longyearbyen','NO ','LYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4479,'Tromso/langnes','Tromso','NO ','TOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4480,'Vadso','Vadso','NO ','VDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4481,'Valan','Honningsvag','NO ','HVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4482,'Valdres','Fagernes','NO ','VDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4483,'Vardoe','Vardoe','NO ','VAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4484,'Vigra','Aalesund','NO ','AES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4485,'Værnes','Trondheim','NO ','TRD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4486,'Al Koude','Al Koude','OM ','WWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4487,'Buraimi','Buraimi','OM ','RMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4488,'Dibaa','Dibaa','OM ','BYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4489,'Khasab','Khasab','OM ','KHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4490,'Marmul','Marmul','OM ','OMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4491,'Masirah','Masirah','OM ','MSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4492,'Salalah','Salalah','OM ','SLL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4493,'Seeb','Muscat','OM ','MCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4494,'Sur','Sur','OM ','SUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4495,'Thumrait','Thumrait','OM ','TTH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4496,'Abbottabad','Abbottabad','PK ','AAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4497,'Alama Iqbal International','Lahore','PK ','LHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4498,'Attock','Attock','PK ','ATG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4499,'Bahawalnagar','Bahawalnagar','PK ','WGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4500,'Bahawalpur','Bahawalpur','PK ','BHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4501,'Bannu','Bannu','PK ','BNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4502,'Bhagatanwala Apt','Sargodha','PK ','BHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4503,'Campbellpore','Campbellpore','PK ','CWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4504,'Chilas','Chilas','PK ','CHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4505,'Chitral','Chitral','PK ','CJL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4506,'Dadu','Dadu','PK ','DDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4507,'Dalbandin','Dalbandin','PK ','DBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4508,'Dera Ghazi Khan','Dera Ghazi Khan','PK ','DEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4509,'Dera Ismail Khan','Dera Ismail Khan','PK ','DSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4510,'Faisalabad','Faisalabad','PK ','LYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4511,'Gilgit','Gilgit','PK ','GIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4512,'Gujrat','Gujrat','PK ','GRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4513,'Gwadar','Gwadar','PK ','GWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4514,'Hyderabad','Hyderabad','PK ','HDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4515,'Islamabad International','Islamabad','PK ','ISB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4516,'Jacobabad','Jacobabad','PK ','JAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4517,'Jiwani','Jiwani','PK ','JIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4518,'Kadanwari','Kadanwari','PK ','KCF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4519,'Kalat','Kalat','PK ','KBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4520,'Khuzdar','Khuzdar','PK ','KDD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4521,'Kohat','Kohat','PK ','OHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4522,'Lora Lai','Lora Lai','PK ','LRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4523,'Mangla','Mangla','PK ','XJM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4524,'Mansehra','Mansehra','PK ','HRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4525,'Mianwali','Mianwali','PK ','MWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4526,'Mirpur Khas','Mirpur Khas','PK ','MPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4527,'Mohenjodaro','Mohenjodaro','PK ','MJD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4528,'Multan International','Multan','PK ','MUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4529,'Muzaffarabad','Muzaffarabad','PK ','MFG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4530,'Nawabshah','Nawabshah','PK ','WNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4531,'Nushki','Nushki','PK ','NHS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4532,'Ormara','Ormara','PK ','ORW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4533,'Panjgur','Panjgur','PK ','PJG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4534,'Para Chinar','Para Chinar','PK ','PAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4535,'Pasni','Pasni','PK ','PSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4536,'Peshawar','Peshawar','PK ','PEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4537,'Quaid-e-azam Intl','Karachi','PK ','KHI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4538,'Quetta','Quetta','PK ','UET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4539,'Rahim Yar Khan','Rahim Yar Khan','PK ','RYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4540,'Rawala Kot','Rawala Kot','PK ','RAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4541,'Sahiwal','Sahiwal','PK ','SWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4542,'Saidu Sharif','Saidu Sharif','PK ','SDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4543,'Sargodha Apt','Sargodha','PK ','SGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4544,'Sawan','Sawan','PK ','RZS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4545,'Sehwen Sharif','Sehwen Sharif','PK ','SYW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4546,'Shikarpur','Shikarpur','PK ','SWV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4547,'Sialkot International','Sialkot','PK ','SKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4548,'Sibi','Sibi','PK ','SBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4549,'Skardu','Skardu','PK ','KDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4550,'Sui','Sui','PK ','SUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4551,'Sukkur','Sukkur','PK ','SKZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4552,'Taftan','Taftan','PK ','TFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4553,'Talhar','Badin','PK ','BDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4554,'Tarbela','Tarbela','PK ','TLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4555,'Turbat','Turbat','PK ','TUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4556,'Wana','Wana','PK ','WAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4557,'Zhob','Zhob','PK ','PZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4558,'Babelthuap/Koror','Koror','PW ','ROR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4559,'Gaza - Yaser Arafat International Airport','Rafah','PS ','GZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4560,'Ramallah Heliport','Ramallah','PS ','ZDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4561,'Achutupo','Achutupo','PA ','ACU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4562,'Ailigandi','Ailigandi','PA ','AIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4563,'Bahia Pinas','Bahia Pinas','PA ','BFQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4564,'Balboa','Balboa','PA ','BLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4565,'Bocas Del Toro','Bocas Del Toro','PA ','BOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4566,'Caledonia','Caledonia','PA ','CDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4567,'Carti','Carti','PA ','CTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4568,'Changuinola','Changuinola','PA ','CHX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4569,'Chitre','Chitre','PA ','CTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4570,'Contadora','Contadora','PA ','OTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4571,'Corazon De Jesus','Corazon De Jesus','PA ','CZJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4572,'El Porvenir','El Porvenir','PA ','PVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4573,'El Real','El Real','PA ','ELE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4574,'Enrique Adolfo Jimenez','Colon','PA ','ONX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4575,'Enrique Malek','David','PA ','DAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4576,'Garachine','Garachine','PA ','GHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4577,'Howard Afb','Fort Kobbe','PA ','HOW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4578,'Jaque','Jaque','PA ','JQE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4579,'La Palma','La Palma','PA ','PLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4580,'Mamitupo','Mamitupo','PA ','MPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4581,'Mulatupo','Mulatupo','PA ','MPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4582,'Nargana','Nargana','PA ','NGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4583,'Paitilla-Marcos A. Gelabert','Panama City','PA ','PAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4584,'Playon Chico','Playon Chico','PA ','PYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4585,'Puerto Armuellas','Puerto Armuellas','PA ','AML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4586,'Puerto Obaldia','Puerto Obaldia','PA ','PUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4587,'Rio Alzucar','Rio Alzucar','PA ','RIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4588,'Rio Sidra','Rio Sidra','PA ','RSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4589,'Rio Tigre','Rio Tigre','PA ','RIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4590,'Sambu','Sambu','PA ','SAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4591,'San Blas','San Blas','PA ','NBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4592,'San Miguel','San Miguel','PA ','NMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4593,'Santa Fe','Santa Fe','PA ','SFW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4594,'Santiago','Santiago','PA ','SYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4595,'Ticantiki','Ticantiki','PA ','TJC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4596,'Tocumen International','Panama City','PA ','PTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4597,'Tubala','Tubala','PA ','TUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4598,'Tupile','Tupile','PA ','TUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4599,'Ustupo','Ustupo','PA ','UTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4600,'Yaviza','Yaviza','PA ','PYV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4601,'Abau','Abau','PG ','ABW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4602,'Afore','Afore','PG ','AFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4603,'Agaun','Agaun','PG ','AUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4604,'Aiambak','Aiambak','PG ','AIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4605,'Aiome','Aiome','PG ','AIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4606,'Airstrip','Aitape','PG ','ATP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4607,'Aiyura','Aiyura','PG ','AYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4608,'Ama','Ama','PG ','AMF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4609,'Amanab','Amanab','PG ','AMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4610,'Amazon Bay','Amazon Bay','PG ','AZB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4611,'Amboin','Amboin','PG ','AMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4612,'Ambunti','Ambunti','PG ','AUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4613,'Andakombe','Andakombe','PG ','ADC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4614,'Angoram','Angoram','PG ','AGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4615,'Anguganak','Anguganak','PG ','AKG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4616,'Annanberg','Annanberg','PG ','AOB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4617,'April River','April River','PG ','APR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4618,'Aragip','Aragip','PG ','ARP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4619,'Arawa','Arawa','PG ','RAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4620,'Aroa','Aroa','PG ','AOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4621,'Arona','Arona','PG ','AON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4622,'Aropa','Kieta','PG ','KIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4623,'Asapa','Asapa','PG ','APP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4624,'Aseki','Aseki','PG ','AEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4625,'Atkamba','Atkamba','PG ','ABP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4626,'Aua Island','Aua Island','PG ','AUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4627,'Aumo','Aumo','PG ','AUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4628,'Awaba','Awaba','PG ','AWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4629,'Awar','Awar','PG ','AWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4630,'Baibara','Baibara','PG ','BAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4631,'Baimuru','Baimuru','PG ','VMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4632,'Baindoung','Baindoung','PG ','BDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4633,'Bali','Bali','PG ','BAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4634,'Balimo','Balimo','PG ','OPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4635,'Bambu','Bambu','PG ','BCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4636,'Bamu','Bamu','PG ','BMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4637,'Banz','Banz','PG ','BNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4638,'Bapi','Bapi','PG ','BPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4639,'Bawan','Bawan','PG ','BWJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4640,'Bensbach','Bensbach','PG ','BSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4641,'Bereina','Bereina','PG ','BEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4642,'Besakoa','Besakoa','PG ','BSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4643,'Bewani','Bewani','PG ','BWP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4644,'Bialla','Bialla','PG ','BAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4645,'Biangabip','Biangabip','PG ','BPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4646,'Biaru','Biaru','PG ','BRP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4647,'Biliau','Biliau','PG ','BIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4648,'Bimin','Bimin','PG ','BIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4649,'Biniguni','Biniguni','PG ','XBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4650,'Boana','Boana','PG ','BNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4651,'Boang','Boang','PG ','BOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4652,'Bodinumu','Bodinumu','PG ','BNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4653,'Boku','Boku','PG ','BOQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4654,'Bolovip','Bolovip','PG ','BVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4655,'Bomai','Bomai','PG ','BMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4656,'Boram','Wewak','PG ','WWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4657,'Boridi','Boridi','PG ','BPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4658,'Brahman','Brahman','PG ','BRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4659,'Buin','Buin','PG ','UBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4660,'Buka','Buka','PG ','BUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4661,'Bulolo','Bulolo','PG ','BUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4662,'Bundi','Bundi','PG ','BNT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4663,'Cape Gloucester','Cape Gloucester','PG ','CGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4664,'Cape Orford','Cape Orford','PG ','CPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4665,'Cape Rodney','Cape Rodney','PG ','CPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4666,'Cape Vogel','Cape Vogel','PG ','CVL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4667,'Chimbu','Kundiawa','PG ','CMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4668,'China Straits Airstrip','Samarai Island','PG ','SQT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4669,'Chungribu','Chungribu','PG ','CVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4670,'Dabo','Dabo','PG ','DAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4671,'Dalbertis','Dalbertis','PG ','DLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4672,'Daru','Daru','PG ','DAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4673,'Daup','Daup','PG ','DAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4674,'Debepare','Debepare','PG ','DBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4675,'Derim','Derim','PG ','DER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4676,'Dinangat','Dinangat','PG ','DNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4677,'Dios','Dios','PG ','DOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4678,'Dodoima','Dodoima','PG ','DDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4679,'Doini','Doini','PG ','DOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4680,'Dorobisoro','Dorobisoro','PG ','DOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4681,'Dumpu','Dumpu','PG ','DPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4682,'Efogi','Efogi','PG ','EFG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4683,'Eliptamin','Eliptamin','PG ','EPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4684,'Embessa','Embessa','PG ','EMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4685,'Emirau','Emirau','PG ','EMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4686,'Emo','Emo','PG ','EMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4687,'Engati','Engati','PG ','EGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4688,'Erave','Erave','PG ','ERE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4689,'Erume','Erume','PG ','ERU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4690,'Fane','Fane','PG ','FNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4691,'Feramin','Feramin','PG ','FRQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4692,'Finschhafen','Finschhafen','PG ','FIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4693,'Freida River','Freida River','PG ','FAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4694,'Fulleborn','Fulleborn','PG ','FUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4695,'Fuma','Fuma','PG ','FUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4696,'Garaina','Garaina','PG ','GAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4697,'Garasa','Garasa','PG ','GRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4698,'Garuahi','Garuahi','PG ','GRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4699,'Gasmata Island','Gasmata Island','PG ','GMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4700,'Gasuke','Gasuke','PG ','GBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4701,'Gewoia','Gewoia','PG ','GEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4702,'Girua','Popondetta','PG ','PNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4703,'Gnarowein','Gnarowein','PG ','GWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4704,'Gonalia','Gonalia','PG ','GOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4705,'Gora','Gora','PG ','GOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4706,'Goroka','Goroka','PG ','GKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4707,'Green Islands','Green Islands','PG ','GEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4708,'Green River','Green River','PG ','GVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4709,'Guari','Guari','PG ','GUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4710,'Guasopa','Guasopa','PG ','GAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4711,'Gulgubip','Gulgubip','PG ','GLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4712,'Guriaso','Guriaso','PG ','GUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4713,'Gurney','Alotau','PG ','GUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4714,'Gusap','Gusap','PG ','GAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4715,'Habi','Habi','PG ','HBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4716,'Haelogo','Haelogo','PG ','HEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4717,'Hatzfeldthaven','Hatzfeldthaven','PG ','HAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4718,'Hawabango','Hawabango','PG ','HWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4719,'Hayfields','Hayfields','PG ','HYF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4720,'Heiweni','Heiweni','PG ','HNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4721,'Hivaro','Hivaro','PG ','HIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4722,'Honinabi','Honinabi','PG ','HNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4723,'Hoskins','Hoskins','PG ','HKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4724,'Iamalele','Iamalele','PG ','IMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4725,'Iaura','Iaura','PG ','IAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4726,'Iboki','Iboki','PG ','IBI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4727,'Ihu','Ihu','PG ','IHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4728,'Ileg','Ileg','PG ','ILX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4729,'Imane','Imane','PG ','IMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4730,'Imonda','Imonda','PG ','IMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4731,'Indagen','Indagen','PG ','IDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4732,'Inus','Inus','PG ','IUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4733,'Iokea','Iokea','PG ','IOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4734,'Ioma','Ioma','PG ','IOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4735,'Itokama','Itokama','PG ','ITK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4736,'Jackson Fld','Port Moresby','PG ','POM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4737,'Jacquinot Bay','Jacquinot Bay','PG ','JAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4738,'Josephstaal','Josephstaal','PG ','JOP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4739,'Kabwum','Kabwum','PG ','KBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4740,'Kagamuga','Mount Hagen','PG ','HGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4741,'Kagi','Kagi','PG ','KGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4742,'Kagua','Kagua','PG ','AGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4743,'Kaiapit','Kaiapit','PG ','KIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4744,'Kaintiba','Kaintiba','PG ','KZF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4745,'Kairuku','Yule Island','PG ','RKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4746,'Kamberatoro','Kamberatoro','PG ','KDQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4747,'Kamina','Kamina','PG ','KMF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4748,'Kamiraba','Kamiraba','PG ','KJU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4749,'Kamulai','Kamulai','PG ','KAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4750,'Kanabea','Kanabea','PG ','KEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4751,'Kanainj','Kanainj','PG ','KNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4752,'Kandep','Kandep','PG ','KDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4753,'Kandrian','Kandrian','PG ','KDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4754,'Kanua','Kanua','PG ','KTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4755,'Kapal','Kapal','PG ','KPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4756,'Kar','Kar','PG ','KAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4757,'Kar Kar','Kar Kar','PG ','KRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4758,'Karato','Karato','PG ','KAF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4759,'Karawari','Karawari','PG ','KRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4760,'Karimui','Karimui','PG ','KMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4761,'Karoola','Karoola','PG ','KXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4762,'Kasanombe','Kasanombe','PG ','KSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4763,'Kavieng','Kavieng','PG ','KVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4764,'Kawito','Kawito','PG ','KWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4765,'Keglsugl','Keglsugl','PG ','KEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4766,'Kelanoa','Kelanoa','PG ','KNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4767,'Kerau','Kerau','PG ','KRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4768,'Kerema','Kerema','PG ','KMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4769,'Kibuli','Kibuli','PG ','KII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4770,'Kikinonda','Kikinonda','PG ','KIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4771,'Kikori','Kikori','PG ','KRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4772,'Kira','Kira','PG ','KIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4773,'Kisengan','Kisengan','PG ','KSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4774,'Kitava','Kitava','PG ','KVE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4775,'Kiunga','Kiunga','PG ','UNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4776,'Kiwai Island','Kiwai Island','PG ','KWX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4777,'Koinambe','Koinambe','PG ','KMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4778,'Kokoda','Kokoda','PG ','KKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4779,'Kokoro','Kokoro','PG ','KOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4780,'Kol','Kol','PG ','KQL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4781,'Komaio','Komaio','PG ','KCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4782,'Komako','Komako','PG ','HOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4783,'Komo-Manda','Komo-Manda','PG ','KOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4784,'Kompiam','Kompiam','PG ','KPM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4785,'Kondubol','Kondubol','PG ','KPF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4786,'Konge','Konge','PG ','KGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4787,'Kopiago','Kopiago','PG ','KPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4788,'Koroba','Koroba','PG ','KDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4327,'Mansa','Mansa','ZM ','MNS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4328,'Mbala','Mbala','ZM ','MMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4329,'Mfuwe','Mfuwe','ZM ','MFU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4330,'Mongu','Mongu','ZM ','MNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4331,'Ndola','Ndola','ZM ','NLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4332,'Ngoma','Ngoma','ZM ','ZGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4333,'Senanga','Senanga','ZM ','SXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4334,'Sesheke','Sesheke','ZM ','SJQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4335,'Solwezi','Solwezi','ZM ','SLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4336,'Southdowns','Kitwe','ZM ','KIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4337,'Zambezi','Zambezi','ZM ','BBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4338,'Buffalo Range','Buffalo Range','ZW ','BFO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4339,'Bulawayo','Bulawayo','ZW ','BUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4340,'Bumi Hills','Bumi Hills','ZW ','BZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4341,'Chipinge','Chipinge','ZW ','CHJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4342,'Gweru','Gweru','ZW ','GWE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4343,'Harare','Harare','ZW ','HRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4344,'Hwange','Hwange','ZW ','WKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4345,'Hwange Nat Park','Hwange Nat Park','ZW ','HWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4346,'Kariba','Kariba','ZW ','KAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4347,'Mahenye','Mahenye','ZW ','MJW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4348,'Masvingo','Masvingo','ZW ','MVZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4349,'Mutare','Mutare','ZW ','UTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4350,'Victoria Falls','Victoria Falls','ZW ','VFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4351,'Milford Sound','Milford Sound','NZ ','MFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4352,'Motueka','Motueka','NZ ','MZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4353,'Mount Cook Airport','Mount Cook','NZ ','MON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4354,'Nelson','Nelson','NZ ','NSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4355,'New Plymouth','New Plymouth','NZ ','NPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4356,'Oamaru','Oamaru','NZ ','OAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4357,'Pakatoa Island','Pakatoa Island','NZ ','PKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4358,'Palmerston North','Palmerston North','NZ ','PMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4359,'Port Fitzroy','Port Fitzroy','NZ ','GBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4360,'Pukaki/Twizel','Mount Cook','NZ ','TWZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4361,'Queenstown','Queenstown','NZ ','ZQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4362,'Raglan','Raglan','NZ ','RAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4363,'Rotorua','Rotorua','NZ ','ROT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4364,'Royal Air Force Base','Ohakea','NZ ','OHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4365,'Stewart Island','Stewart Island','NZ ','SZS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4366,'Surfdale','Surfdale','NZ ','WIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4367,'Taharoa','Taharoa','NZ ','THH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4368,'Takaka','Takaka','NZ ','KTF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4369,'Taupo','Taupo','NZ ','TUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4370,'Tauranga City','Tauranga','NZ ','TRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4371,'Thames','Thames','NZ ','TMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4372,'Timaru','Timaru','NZ ','TIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4373,'Waitangi','Waitangi','NZ ','WGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4374,'Wanaka','Wanaka','NZ ','WKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4375,'Wanganui','Wanganui','NZ ','WAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4376,'Wellington International','Wellington','NZ ','WLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4377,'Westport','Westport','NZ ','WSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4378,'Whakatane','Whakatane','NZ ','WHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4379,'Whangarei','Whangarei','NZ ','WRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4380,'Whitianga','Whitianga','NZ ','WTZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4381,'Augusto C Sandino','Managua','NI ','MGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4382,'Bluefields','Bluefields','NI ','BEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4383,'Corn Island','Corn Island','NI ','RNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4384,'Nueva Guinea','Nueva Guinea','NI ','NVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4385,'Puerto Cabezas','Puerto Cabezas','NI ','PUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4386,'San Carlos','San Carlos','NI ','NCR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4387,'San Pedro','Bonanza','NI ','BZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4388,'Siuna','Siuna','NI ','SIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4389,'Waspam','Waspam','NI ','WSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4390,'Agades','Agades','NE ','AJY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4391,'Arlit','Arlit','NE ','RLT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4392,'Birni Nkoni','Birni Nkoni','NE ','BKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4393,'Maradi','Maradi','NE ','MFQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4394,'Niamey','Niamey','NE ','NIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4395,'Tahoua','Tahoua','NE ','THZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4396,'Zinder','Zinder','NE ','ZND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4397,'Akure','Akure','NG ','AKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4398,'Aminu Kano Intl Apt','Kano','NG ','KAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4399,'Bauchi','Bauchi','NG ','BCU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4400,'Benin City','Benin City','NG ','BNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4401,'Calabar','Calabar','NG ','CBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4402,'Enugu','Enugu','NG ','ENU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5173,'Iasi','Iasi','RO ','IAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5174,'Kogalniceanu','Constanta','RO ','CND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5175,'Oradea','Oradea','RO ','OMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5176,'Salcea','Suceava','RO ','SCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5177,'Satu Mare','Satu Mare','RO ','SUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5178,'Sibiu','Sibiu','RO ','SBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5179,'Timisoara','Timisoara','RO ','TSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5180,'Transilvania','Tirgu Mures','RO ','TGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5181,'Tulcea','Tulcea','RO ','TCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5182,'Khanty-Mansiysk','Khanty-mansiysk','RU ','HMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5183,'Kogalym International','Kogalym','RU ','KGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5184,'Koltsovo International Airport','Ekaterinburg','RU ','SVX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5185,'Raduzhnyi','Raduzhnyi','RU ','RAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5186,'Rybinsk','Rybinsk','RU ','RYB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5187,'Solovky','Solovetsky','RUS','CSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5188,'Abakan','Abakan','RU ','ABA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5189,'Achinsk','Achinsk','RU ','ACS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5190,'Adler/Sochi','Adler/Sochi','RU ','AER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5191,'Aldan','Aldan','RU ','ADH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5192,'Amderma','Amderma','RU ','AMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5193,'Anadyr','Anadyr','RU ','DYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5194,'Anapa','Anapa','RU ','AAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5195,'Arkhangelsk','Arkhangelsk','RU ','ARH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5196,'Astrakhan','Astrakhan','RU ','ASF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5197,'Balakovo','Balakovo','RU ','BWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5198,'Barnaul','Barnaul','RU ','BAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5199,'Belgorod','Belgorod','RU ','EGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5200,'Beloreck','Beloreck','RU ','BCX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5201,'Blagoveschensk','Blagoveschensk','RU ','BQS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5202,'Bratsk','Bratsk','RU ','BTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5203,'Briansk','Briansk','RU ','BZK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5204,'Bugulma','Bugulma','RU ','UUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5205,'Bykovo','Moscow','RU ','BKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5206,'Cheboksary','Cheboksary','RU ','CSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5207,'Chelyabinsk','Chelyabinsk','RU ','CEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5208,'Cherepovets','Cherepovets','RU ','CEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5209,'Cherskiy','Cherskiy','RU ','CYX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5210,'Chertovitskoye','Voronezh','RU ','VOZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5211,'Chita','Chita','RU ','HTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5212,'Chkalovsky','Chkalovsky','RU ','CKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5213,'Chokurdah','Chokurdah','RU ','CKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5214,'Dikson','Dikson','RU ','DKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5215,'Domodedovo','Moscow','RU ','DME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5216,'Elista','Elista','RU ','ESL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5217,'Eniseysk','Eniseysk','RU ','EIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5218,'Gelendzik','Gelendzik','RU ','GDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5219,'Groznyj','Groznyj','RU ','GRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5220,'Hatanga','Hatanga','RU ','HTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5221,'Igarka','Igarka','RU ','IAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5222,'Inta','Inta','RU ','INA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5223,'Irkutsk','Irkutsk','RU ','IKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5224,'Ivanova','Ivanova','RU ','IWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5225,'Izhevsk','Izhevsk','RU ','IJK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5226,'Joshkar-Ola','Joshkar-Ola','RU ','JOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5227,'Kaliningrad Devau','Kaliningrad','RU ','KGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5228,'Kaluga','Kaluga','RU ','KLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5229,'Kazan','Kazan','RU ','KZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5230,'Kemerovo','Kemerovo','RU ','KEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5231,'Kirov','Kirov','RU ','KVX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5232,'Kirovsk','Kirovsk','RU ','KVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5233,'Komsomolsk Na Amure','Komsomolsk Na Amure','RU ','KXK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5234,'Kostroma','Kostroma','RU ','KMW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5235,'Kotlas','Kotlas','RU ','KSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5236,'Krasnojarsk','Krasnojarsk','RU ','KJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5237,'Kurgan','Kurgan','RU ','KRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5238,'Kursk','Kursk','RU ','URS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5239,'Kurumoch','Samara','RU ','KUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5240,'Kyzyl','Kyzyl','RU ','KYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5241,'Lipetsk','Lipetsk','RU ','LPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5242,'Magadan','Magadan','RU ','GDX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5243,'Magdagachi','Magdagachi','RU ','GDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5244,'Magnitogorsk','Magnitogorsk','RU ','MQF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5245,'Makhachkala','Makhachkala','RU ','MCX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5246,'Migalovo','Kalinin','RU ','KLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5247,'Mineralnye Vodyj','Mineralnye Vody','RU ','MRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5248,'Mirnyj','Mirnyj','RU ','MJZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5249,'Murmansk Airport Murmashi','Murmansk','RU ','MMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5250,'Naberevnye Chelny','Naberevnye Chelny','RU ','NBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5251,'Nadym','Nadym','RU ','NYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5252,'Nalchik','Nalchik','RU ','NAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5253,'Naryan-Mar','Naryan-Mar','RU ','NNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5254,'Neftekamsk','Neftekamsk','RU ','NEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5255,'Nefteyugansk','Nefteyugansk','RU ','NFG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5256,'Neryungri','Neryungri','RU ','NER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5257,'Nizhnevartovsk','Nizhnevartovsk','RU ','NJC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5258,'Novokuznetsk','Novokuznetsk','RU ','NOZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5259,'Novorossijsk','Novorossijsk','RU ','NOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5260,'Novy Urengoy','Novy Urengoy','RU ','NUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5261,'Novyy','Khabarovsk','RU ','KHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5262,'Okhotsk','Okhotsk','RU ','OHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5263,'Oktiabrskij','Oktiabrskij','RU ','OKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5264,'Omsk','Omsk','RU ','OMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5265,'Orel','Orel','RU ','OEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5266,'Orenburg','Orenburg','RU ','REN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5267,'Orsk','Orsk','RU ','OSW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5268,'Pashkovsky','Krasnodar','RU ','KRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5269,'Pechora','Pechora','RU ','PEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5270,'Penza','Penza','RU ','PEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5271,'Perm','Perm','RU ','PEE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5272,'Petropavlovsk-Kamchats','Petropavlovsk-Kamchats','RU ','PKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5273,'Petrozavodsk','Petrozavodsk','RU ','PES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5274,'Pevek','Pevek','RU ','PWE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5275,'Polyarnyj','Polyarnyj','RU ','PYJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5276,'Provedenia','Provedenia','RU ','PVX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5277,'Provideniya','Provideniya','RU ','PVS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5278,'Pskov','Pskov','RU ','PKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5279,'Pulkovo','St Petersburg','RU ','LED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5280,'Roschino','Tyumen','RU ','TJM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5281,'Rostov','Rostov','RU ','ROV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5282,'Ryazan','Ryazan','RU ','RZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5283,'Salekhard','Salekhard','RU ','SLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5284,'Saransk','Saransk','RU ','SKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5285,'Saratov','Saratov','RU ','RTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5286,'Sheremetyevo','Moscow','RU ','SVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5287,'Smolensk','Smolensk','RU ','LNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5288,'Stavropol','Stavropol','RU ','STW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5289,'Surgut','Surgut','RU ','SGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5290,'Syktyvkar','Syktyvkar','RU ','SCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5291,'Tambov','Tambov','RU ','TBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5292,'Tiksi','Tiksi','RU ','IKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5293,'Tobolsk','Tobolsk','RU ','TOX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5294,'Tolmachevo','Novosibirsk','RU ','OVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5295,'Tomsk','Tomsk','RU ','TOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5296,'Tula','Tula','RU ','TYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5297,'Tynda','Tynda','RU ','TYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5298,'Ufa','Ufa','RU ','UFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5299,'Ukhta','Ukhta','RU ','UCT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5300,'"Ulan-ude',' MukhinoUlan-ude','RU ','UUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5301,'Uraj','Uraj','RU ','URJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5302,'Usinsk','Usinsk','RU ','USK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5303,'Ust-Ilimsk','Ust-Ilimsk','RU ','UIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5304,'Ust-Kut','Ust-Kut','RU ','UKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5305,'Velikij Ustyug','Velikij Ustyug','RU ','VUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5306,'Velikiye Luki','Velikiye Luki','RU ','VLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5307,'Vladikavkaz','Vladikavkaz','RU ','OGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5308,'Vladivostok','Vladivostok','RU ','VVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5309,'Vnukovo','Moscow','RU ','VKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5310,'Volgodonsk','Volgodonsk','RU ','VLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5311,'Volgograd','Volgograd','RU ','VOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5312,'Vologda','Vologda','RU ','VGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5313,'Vorkuta','Vorkuta','RU ','VKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5314,'Vostochny','Ulyanovsk','RU ','ULY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5315,'Yakutsk','Yakutsk','RU ','YKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5316,'Yaroslavl','Yaroslavl','RU ','IAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5317,'Yerievo','Velikiy Novgorod','RU ','NVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5318,'Nizhniy Novgorod','Nizhniy Novgorod','RU ','GOJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5319,'Rzhevka','St Petersburg','RU ','RVH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5320,'Yuzhno-Sakhalinsk','Yuzhno-Sakhalinsk','RU ','UUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5321,'Butare','Butare','RW ','BTQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5322,'Gisenyi','Gisenyi','RW ','GYI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5323,'Gregoire Kayibanda','Kigali','RW ','KGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5324,'Kamembe','Kamembe','RW ','KME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5325,'Ruhengeri','Ruhengeri','RW ','RHG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5326,'Newcastle','Nevis','KN ','NEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5327,'Robert L Bradshaw International','Basseterre St. Kitts Island','KN ','SKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5328,'George F L Charles','Castries','LC ','SLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5329,'Hewanorra','St Lucia','LC ','UVF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5330,'Canouan Island','Canouan Island','VC ','CIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5331,'E. T. Joshua','St Vincent','VC ','SVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5332,'J.F. Mitchell','Bequia','SVG','BQU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5333,'Mustique','Mustique Island','VC ','MQS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5334,'Palm Island','Palm Island','VC ','PLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5335,'Union Island','Union Island','VC ','UNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5336,'Asau','Asau','WS ','AAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5337,'Fagali I','Apia','WS ','FGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5338,'Faleolo','Apia','WS ','APW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5339,'Lalomalava','Lalomalava','WS ','LAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5340,'Maota Savaii Is','Maota Savaii Is','WS ','MXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5341,'Porto Alegre','Porto Alegre','ST ','PGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5342,'Principe','Principe','ST ','PCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5343,'Sao Tome Is','Sao Tome Is','ST ','TMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5344,'Abha','Abha','SA ','AHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5345,'Al-Aqiq','Al-Baha','SA ','ABT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5346,'Alahsa','Alahsa','SA ','HOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5347,'Arar','Arar','SA ','RAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5348,'Bisha','Bisha','SA ','BHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5349,'Dammam Port','Dammam','SA ','XZF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5350,'Dawadmi','Dawadmi','SA ','DWD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5351,'Dhahran','Dhahran','SA ','DHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5352,'Gassim Regional Airport','Buraidah','SA ','ELQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5353,'Gurayat','Gurayat','SA ','URY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5354,'Hafr Albatin','Hafr Albatin','SA ','HBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5355,'Hail','Hail','SA ','HAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5356,'Jazan','Jazan','SA ','GIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5357,'Jouf','Sakaka Al Jouf','SA ','AJF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5358,'Khamis Mushait','Khamis Mushait','SA ','KMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5359,'King Abdulaziz International','Jeddah','SA ','JED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5360,'King Fahd International Airport','Dammam','SA ','DMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5361,'King Khaled Intl','Riyadh','SA ','RUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5362,'King Khalid Military','King Khalid Mil. City','SA ','KMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5363,'Majma','Majma','SA ','MJH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5364,'Mohammad Bin Abdulaziz','Madinah','SA ','MED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5365,'Nejran','Nejran','SA ','EAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5366,'Prince Sultan Air Base','Al Kharj','SA ','AKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5367,'Qaisumah','Qaisumah','SA ','AQI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5368,'Rafha','Rafha','SA ','RAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5369,'Sharurah','Sharurah','SA ','SHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5370,'Sulayel','Sulayel','SA ','SLF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5371,'Tabuk','Tabuk','SA ','TUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5372,'Taif','Taif','SA ','TIF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5373,'Turaif','Turaif','SA ','TUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5374,'Unayzah','Unayzah','SA ','UZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5375,'Wadi Ad Dawasir','Wadi Ad Dawasir','SA ','WAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5376,'Wedjh','Wedjh','SA ','EJH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5377,'Yanbu','Yanbu','SA ','YNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5378,'Zilfi','Zilfi','SA ','ZUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5379,'Dyce','AberdeenScotland','GB ','ABZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5380,'Turnhouse','EdinburghScotland','GB ','EDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5381,'Bakel','Bakel','SN ','BXE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5382,'Cap Skirring','Cap Skirring','SN ','CSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5383,'Dakar-Yoff-Léopold Sédar Senghor International','Dakar','SN ','DKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5384,'Kaolack','Kaolack','SN ','KLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5385,'Kedougou','Kedougou','SN ','KGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5386,'Kolda','Kolda','SN ','KDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5387,'Matam','Matam','SN ','MAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5388,'Niokolo Koba','Niokolo Koba','SN ','NIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5389,'Podor','Podor','SN ','POD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5390,'Richard Toll','Richard Toll','SN ','RDT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5391,'Simenti','Simenti','SN ','SMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5392,'St Louis','St Louis','SN ','XLS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5393,'Tambacounda','Tambacounda','SN ','TUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5394,'Ziguinchor','Ziguinchor','SN ','ZIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5395,'Batajnica','Belgrade','RS ','BJY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5396,'Constantine The Great International','Nis','RS ','INI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5397,'Nikola Tesla','Belgrade','RS ','BEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5398,'Ponikve','Uzice','CS ','UZC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4789,'Kosipe','Kosipe','PG ','KSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4790,'Kugururok River','Kugururok River','PG ','KUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4791,'Kungum','Kungum','PG ','KGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4792,'Kupiano','Kupiano','PG ','KUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4793,'Kuri','Kuri','PG ','KUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4794,'Kurwina','Kurwina','PG ','KWV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4795,'Kuyol','Kuyol','PG ','KUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4796,'Lablab','Lablab','PG ','LAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4797,'Laiagam','Laiagam','PG ','LGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4798,'Lake Murray','Lake Murray','PG ','LMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4799,'Lamassa','Lamassa','PG ','LMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4800,'Langimar','Langimar','PG ','LNM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4801,'Lehu','Lehu','PG ','LHP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4802,'Leitre','Leitre','PG ','LTF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4803,'Lengbati','Lengbati','PG ','LNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4804,'Leron Plains','Leron Plains','PG ','LPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4805,'Lese','Lese','PG ','LNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4806,'Lihir Island','Lihir Island','PNG','LNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4807,'Linga Linga','Linga Linga','PG ','LGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4808,'Loani','Loani','PG ','LNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4809,'Long Island','Long Island','PG ','LSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4810,'Losuia','Losuia','PG ','LSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4811,'Lowai','Lowai','PG ','LWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4812,'Lumi','Lumi','PG ','LMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4813,'Madang','Madang','PG ','MAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4814,'Makini','Makini','PG ','MPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4815,'Mal','Mal','PG ','MMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4816,'Malalaua','Malalaua','PG ','MLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4817,'Malam','Malam','PG ','MQO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4818,'Malekolon','Malekolon','PG ','MKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4819,'Mamai','Mamai','PG ','MAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4820,'Manare','Manare','PG ','MRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4821,'Manetai','Manetai','PG ','MVI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4822,'Manga','Manga','PG ','MGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4823,'Manumu','Manumu','PG ','UUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4824,'Mapoda','Mapoda','PG ','MPF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4825,'Mapua','Mapua','PG ','MPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4826,'Maramuni','Maramuni','PG ','MWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4827,'Marawaka','Marawaka','PG ','MWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4828,'Margarima','Margarima','PG ','MGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4829,'Maron','Maron','PG ','MNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4830,'Masa','Masa','PG ','MBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4831,'May River','May River','PG ','MRH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4832,'Mendi','Mendi','PG ','MDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4833,'Menyamya','Menyamya','PG ','MYX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4834,'Mindik','Mindik','PG ','MXK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4835,'Minj','Minj','PG ','MZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4836,'Misima Island','Misima Island','PG ','MIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4837,'Miyanmin','Miyanmin','PG ','MPX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4838,'Moki','Moki','PG ','MJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4839,'Momote','Manus Island','PG ','MAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4840,'Morehead','Morehead','PG ','MHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4841,'Moro','Moro','PG ','MXH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4842,'Morobe','Morobe','PG ','OBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4843,'Mougulu','Mougulu','PG ','GUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4844,'Mount Aue','Mount Aue','PG ','UAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4845,'Munbil','Munbil','PG ','LNF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4846,'Munduku','Munduku','PG ','MDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4847,'Mussau','Mussau','PG ','MWU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4848,'Nadunumu','Nadunumu','PG ','NDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4849,'Nadzab','Lae','PG ','LAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4850,'Namatanai','Namatanai','PG ','ATN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4851,'Nambaiyufa','Nambaiyufa','PG ','NBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4852,'Namudi','Namudi','PG ','NDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4853,'Nankina','Nankina','PG ','NKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4854,'Naoro','Naoro','PG ','NOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4855,'Negarbo','Negarbo','PG ','GBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4856,'Ningerum','Ningerum','PG ','NGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4857,'Nipa','Nipa','PG ','NPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4858,'Nissan Island','Nissan Island','PG ','IIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4859,'Nomad River','Nomad River','PG ','NOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4860,'Nomane','Nomane','PG ','NMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4861,'Nowata','Nowata','PG ','NWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4862,'Nuguria','Nuguria','PG ','NUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4863,'Nuku','Nuku','PG ','UKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4864,'Nutuve','Nutuve','PG ','NUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4865,'Obo','Obo','PG ','OBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4866,'Ogeranang','Ogeranang','PG ','OGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4867,'Okao','Okao','PG ','OKV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4868,'Oksapmin','Oksapmin','PG ','OKP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4869,'Olsobip','Olsobip','PG ','OLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4870,'Omkalai','Omkalai','PG ','OML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4871,'Omora','Omora','PG ','OSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4872,'Ononge','Ononge','PG ','ONB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4873,'Open Bay','Open Bay','PG ','OPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4874,'Oram','Oram','PG ','RAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4875,'Oria','Oria','PG ','OTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4876,'Ossima','Ossima','PG ','OSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4877,'Pambwa','Pambwa','PG ','PAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4878,'Pangia','Pangia','PG ','PGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4879,'Pangoa','Pangoa','PG ','PGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4880,'Param','Param','PG ','PPX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4881,'Pimaga','Pimaga','PG ','PMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4882,'Pindiu','Pindiu','PG ','PDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4883,'Popondetta','Eia','PG ','EIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4884,'Porgera','Porgera','PG ','RGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4885,'Puas','Puas','PG ','PUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4886,'Pumani','Pumani','PG ','PMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4887,'Pureni','Pureni','PG ','PUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4888,'Rabaraba','Rabaraba','PG ','RBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4889,'Rakanda','Rakanda','PG ','RAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4890,'Robinson River','Robinson River','PG ','RNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4891,'Rumginae','Rumginae','PG ','RMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4892,'Ruti','Ruti','PG ','RUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4893,'Sabah','Sabah','PG ','SBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4894,'Safia','Safia','PG ','SFU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4895,'Sagarai','Sagarai','PG ','SGJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4896,'Saidor','Saidor','PG ','SDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4897,'Salamo','Salamo','PG ','SAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4898,'Sangapi','Sangapi','PG ','SGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4899,'Sapmanga','Sapmanga','PG ','SMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4900,'Satwag','Satwag','PG ','SWG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4901,'Sauren','Sauren','PG ','SXW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4902,'Sehulea','Sehulea','PG ','SXH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4903,'Selbang','Selbang','PG ','SBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4904,'Sepik Plains','Sepik Plains','PG ','SPV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4905,'Sialum','Sialum','PG ','SXA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4906,'Siassi','Siassi','PG ','SSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4907,'Sila','Sila','PG ','SIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4908,'Sim','Sim','PG ','SMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4909,'Simbai','Simbai','PG ','SIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4910,'Simberi','Simberi Island','PG ','NIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4911,'Singaua','Singaua','PG ','SGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4912,'Sissano','Sissano','PG ','SIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4913,'Siwea','Siwea','PG ','SWE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4914,'Sopu','Sopu','PG ','SPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4915,'Suabi','Suabi','PG ','SBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4916,'Suki','Suki','PG ','SKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4917,'Sule','Sule','PG ','ULE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4918,'Suria','Suria','PG ','SUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4919,'Tabibuga','Tabibuga','PG ','TBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4920,'Tabubil','Tabubil','PG ','TBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4921,'Tadji','Aitape','PG ','TAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4922,'Tagula','Tagula','PG ','TGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4923,'Talasea','Talasea','PG ','TLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4924,'Tapini','Tapini','PG ','TPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4925,'Tarabo','Tarabo','PG ','TBQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4926,'Tarakbits','Tarakbits','PG ','TRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4927,'Tari','Tari','PG ','TIZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4928,'Tauta','Tauta','PG ','TUT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4929,'Tawa','Tawa','PG ','TWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4930,'Tekadu','Tekadu','PG ','TKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4931,'Tekin','Tekin','PG ','TKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4932,'Telefomin','Telefomin','PG ','TFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4933,'Teptep','Teptep','PG ','TEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4934,'Terapo','Terapo','PG ','TEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4935,'Tetabedi','Tetabedi','PG ','TDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4936,'Tifalmin','Tifalmin','PG ','TFB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4937,'Timbunke','Timbunke','PG ','TBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4938,'Tinboli Airport','Tinboli','PG ','TCK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4939,'Tingwon','Tingwon','PG ','TIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4940,'Tokua','Rabaul','PG ','RAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4941,'Tol','Tol','PG ','TLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4942,'Tonu','Tonu','PG ','TON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4943,'Torembi Airport','Torembi','PG ','TCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4944,'Torokina','Torokina','PG ','TOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4945,'Tufi','Tufi','PG ','TFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4946,'Tumolbil','Tumolbil','PG ','TLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4947,'Umba','Umba','PG ','UMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4948,'Upiara','Upiara','PG ','UPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4949,'Usino','Usino','PG ','USO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4950,'Uvol','Uvol','PG ','UVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4951,'Vanimo','Vanimo','PG ','VAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4952,'Vivigani','Vivigani','PG ','VIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4953,'Wabag','Wabag','PNG','WAB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4954,'Wabo','Wabo','PG ','WAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4955,'Wagau','Wagau','PG ','WGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4956,'Wakunai','Wakunai','PG ','WKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4957,'Wanigela','Wanigela','PG ','AGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4958,'Wantoat','Wantoat','PG ','WTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4959,'Wanuma','Wanuma','PG ','WNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4960,'Wapenamanda','Wapenamanda','PG ','WBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4961,'Wasu','Wasu','PG ','WSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4962,'Wasua','Wasua','PG ','WSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4963,'Wau','Wau','PG ','WUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4964,'Wawoi Falls','Wawoi Falls','PG ','WAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4965,'Weam','Weam','PG ','WEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4966,'Wedau','Wedau','PG ','WED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4967,'Wipim','Wipim','PG ','WPM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4968,'Witu','Witu','PG ','WIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4969,'Woitape','Woitape','PG ','WTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4970,'Wonenara','Wonenara','PG ','WOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4971,'Wuvulu Is','Wuvulu Is','PG ','WUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4972,'Yalumet','Yalumet','PG ','KYX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4973,'Yapsiei','Yapsiei','PG ','KPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4974,'Yasuru','Yasuru','PG ','KSX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4975,'Yegepa','Yegepa','PG ','PGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4976,'Yellow River','Yellow River','PG ','XYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4977,'Yenkis','Yenkis','PG ','YEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4978,'Yeva','Yeva','PG ','YVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4979,'Yongai','Yongai','PG ','KGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4980,'Zenag','Zenag','PG ','ZEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4981,'Stockholm','Stockholm','PG ','SMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4982,'Alejo Garcia','Ciudad Del Este','PY ','AGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4983,'Ayolas','Ayolas','PY ','AYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4984,'Bahia Negra','Bahia Negra','PY ','BFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4985,'Filadelfia','Filadelfia','PY ','FLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4986,'Fuerte Olimpo','Fuerte Olimpo','PY ','OLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4987,'INC','Vallemi','PY ','VMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4988,'Mariscal Estigarribia','Mariscal Estigarribia','PY ','ESG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4989,'MCAL Lopez','Concepcion','PY ','CIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4990,'Pedro Juan Caballero','Pedro Juan Caballero','PY ','PJC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4991,'Pilar','Pilar','PY ','PIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4992,'Puerto La Victoria','Puerto La Victoria','PY ','PCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4993,'Puerto Leda','Puerto Leda','PY ','PBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4994,'Silvio Pettirossi','Asuncion','PY ','ASU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4995,'Teniente Prim Alarcon','Encarnacion','PY ','ENO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4996,'Alerta','Alerta','PE ','ALD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4997,'Andahuaylas','Andahuaylas','PE ','ANS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4998,'Anta','Anta','PE ','ATA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (4999,'Bellavista','Bellavista','PE ','BLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5000,'C.F. Secada','Iquitos','PE ','IQT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5001,'Cajamarca','Cajamarca','PE ','CJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5002,'Captain Rolden International Airport','Pucallpa','PE ','PCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5003,'Chachapoyas','Chachapoyas','PE ','CHH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5004,'Chimbote','Chimbote','PE ','CHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5005,'Cornel Ruiz','Chiclayo','PE ','CIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5006,'Huanuco','Huanuco','PE ','HUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5007,'Iberia','Iberia','PE ','IBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5008,'Ilo','Ilo','PE ','ILQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5009,'Jauja','Jauja','PE ','JAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5010,'Jorge Chavez International','Lima','PE ','LIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5011,'Juanjui','Juanjui','PE ','JJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5012,'Juliaca','Juliaca','PE ','JUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5013,'Machu Picchu','Machu Picchu','PE ','MFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5014,'Moyobamba','Moyobamba','PE ','MBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5015,'Pisco','Pisco','PE ','PIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5016,'Piura','Piura','PE ','PIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5017,'Puerto Maldonado','Puerto Maldonado','PE ','PEM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5018,'Quincemil','Quincemil','PE ','UMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5019,'Rioja','Rioja','PE ','RIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5020,'Rodriguez Ballon','Arequipa','PE ','AQP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5021,'Rodriguez De Mendoza','Rodriguez De Mendoza','PE ','RIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5022,'San Juan','San Juan','PE ','SJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5023,'San Juan Aposento','San Juan Aposento','PE ','APE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5024,'Santa Maria','Santa Maria','PE ','SMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5025,'Shiringayoc','Shiringayoc','PE ','SYC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5026,'Tacna','Tacna','PE ','TCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5027,'Talara','Talara','PE ','TYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5028,'Tarapoto','Tarapoto','PE ','TPP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5029,'Tingo Maria','Tingo Maria','PE ','TGI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5030,'Trujillo','Trujillo','PE ','TRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5031,'Tumbes','Tumbes','PE ','TBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5032,'Velazco Astete','Cuzco','PE ','CUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5033,'Yanamilla','Ayacucho','PE ','AYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5034,'Yurimaguas','Yurimaguas','PE ','YMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5035,'Allah Valley','Surallah','PH ','AAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5036,'Awang','Cotabato','PH ','CBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5037,'Bacolod','Bacolod','PH ','BCD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5038,'Baganga','Baganga','PH ','BNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5039,'Baler','Baler','PH ','BQA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5040,'Basco','Basco','PH ','BSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5041,'Bislig','Bislig','PH ','BPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5042,'Butuan','Butuan','PH ','BXU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5043,'Cagayan De Oro Domestic Airport','Cagayan De Oro','PH ','CGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5044,'Cagayan De Sulu','Cagayan De Sulu','PH ','CDY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5045,'Calbayog','Calbayog','PH ','CYP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5046,'Cauayan','Cauayan','PH ','CYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5047,'CLR Airport','Taytay Sandoval','PH ','RZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5048,'Coron Airport','Coron','PH ','XCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5049,'Cubi Pt NAS','Luzon Is','PH ','NCP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5050,'Culion','Culion','PH ','CUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5051,'Cuyo','Cuyo','PH ','CYU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5052,'D.Z. Romualdez','Tacloban','PH ','TAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5053,'Diosdado Macapagal International','Angeles City','PH ','CRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5054,'Dipolog','Dipolog','PH ','DPL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5055,'Dumaguete','Dumaguete','PH ','DGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5056,'El Nido','El Nido','PH ','ENI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5057,'Evelio Javier','Antique','PH ','EUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5058,'Francisco Bangoy International','Davao','PH ','DVO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5059,'General Santos International','General Santos','PH ','GES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5060,'Iloilo International','Iloilo','PH ','ILO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5061,'Imelda Romualdez Marcos','Mati','PH ','MXI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5062,'Ipil','Ipil','PH ','IPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5063,'Jolo','Jolo','PH ','JOL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5064,'Kalibo','Kalibo','PH ','KLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5065,'Labo','Ozamis City','PH ','OZC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5066,'Laoag International Airport','Laoag','PH ','LAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5067,'Legazpi','Legazpi','PH ','LGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5068,'Loakan','Baguio','PH ','BAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5069,'Lubang','Lubang','PH ','LBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5070,'Mactan-Cebu International','Cebu','PH ','CEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5071,'Malabang','Malabang','PH ','MLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5072,'Malay','Caticlan','PH ','MPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5073,'Mambajao','Camiguin','PH ','CGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5074,'Mamburao','Mamburao','PH ','MBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5075,'Maramag','Maramag','PH ','XMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5076,'Maria Cristina','Iligan','PH ','IGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5077,'Marinduque','Marinduque','PH ','MRQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5078,'Masbate','Masbate','PH ','MBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5079,'Mcguire Fld','San Jose','PH ','SJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5080,'NAF','Sangley Point','PH ','NSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5081,'Naga','Daet','PH ','DTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5082,'Naga','Naga','PH ','WNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5083,'National','Catarman','PH ','CRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5084,'Ninoy Aquino Intl','Manila','PH ','MNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5085,'Ormoc','Ormoc','PH ','OMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5086,'Pagadian','Pagadian','PH ','PAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5087,'Puerto Princesa','Puerto Princesa','PH ','PPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5088,'Puerto Princessa','Busuanga','PH ','USU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5089,'Romblon','Tablas','PH ','TBH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5090,'Roxas City','Roxas City','PH ','RXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5091,'San Fernando','San Fernando','PH ','SFE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5092,'Sanga Sanga','Sanga Sanga','PH ','SGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5093,'Sangley Point NAS','Cavite City','PH ','SGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5094,'Siasi','Siasi','PH ','SSV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5095,'Sicogon Island','Sicogon Island','PH ','ICO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5096,'Siocon','Siocon','PH ','XSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5097,'Surigao','Surigao','PH ','SUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5098,'Tagbilaran','Tagbilaran','PH ','TAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5099,'Tagbita','Tagbita','PH ','TGB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5100,'Tandag','Tandag','PH ','TDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5101,'Tawitawi','Tawitawi','PH ','TWT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5102,'Tuguegarao','Tuguegarao','PH ','TUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5103,'Virac','Virac','PH ','VRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5104,'Zamboanga International','Zamboanga','PH ','ZAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5105,'Babimost','Zielona Gora','PL ','IEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5106,'Bydgoszcz I. J. Paderewski Airport','Bydgoszcz','PL ','BZG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5107,'Copernicus Airport','Wroclaw','PL ','WRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5108,'Czestochowa','Czestochowa','PL ','CZW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5109,'Frederic Chopin','Warsaw','PL ','WAW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5110,'Goleniow','Szczecin','PL ','SZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5111,'J. Paul Ii Balice Intl','Krakow','PL ','KRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5112,'Jasionka','Rzeszow','PL ','RZE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5113,'Koszalin','Koszalin','PL ','OSZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5114,'Lawica','Poznan','PL ','POZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5115,'Lech Walesa','Gdansk','PL ','GDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5116,'Lodz Lublinek','Lodz','PL ','LCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5117,'Mazury','Szymany','PL ','SZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5118,'Pyrzowice','Katowice','PL ','KTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5119,'Redzikowo','Slupsk','PL ','OSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5120,'Braga','Braga','PT ','BGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5121,'Braganca','Braganca','PT ','BGC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5122,'Chaves','Chaves','PT ','CHV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5123,'Coimbra','Coimbra','PT ','CBP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5124,'Corvo Island','Corvo Island','PT ','CVU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5125,'Covilha','Covilha','PT ','COV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5126,'Faro','Faro','PT ','FAO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5127,'Faro TP','Faro','PT ','ZYF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5128,'Francisco Sá Carneiro','Porto','PT ','OPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5129,'Graciosa Island','Graciosa Island','PT ','GRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5130,'Horta','Horta','PT ','HOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5131,'Lajes Ab','Terceira Island','PT ','TER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5132,'Lisbon TP','Lisbon','PT ','ZYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5133,'Madeira','Funchal','PT ','FNC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5134,'Nordela','Ponta Delgada Azores','PT ','PDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5135,'Pico Island','Pico Island','PT ','PIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5136,'Portela','Lisbon','PT ','LIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5137,'Portimao','Portimao','PT ','PRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5138,'Porto Santo','Porto Santo','PT ','PXO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5139,'Santa Cruz','Flores Island','PT ','FLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5140,'Sao Jorge Island','Sao Jorge Island','PT ','SJZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5141,'Sines','Sines','PT ','SIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5142,'Vila Do Porto','Santa Maria','PT ','SMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5143,'Vila Real','Vila Real','PT ','VRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5144,'Viseu','Viseu','PT ','VSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5145,'Arecibo','Arecibo','PR ','ARE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5146,'Borinquen','Aguadilla','PR ','BQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5147,'Culebra','Culebra','PR ','CPX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5148,'Diego Jimenez Torres','Fajardo','PR ','FAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5149,'Dorado Beach','Dorado','PR ','DDP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5150,'Eugenio M De Hostos','Mayaguez','PR ','MAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5151,'Humacao Arpt','Humacao','PR ','HUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5152,'Isla Grande','San Juan','PR ','SIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5153,'Luis Munoz Marin Intl','San Juan','PR ','SJU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5154,'Mercedita','Ponce','PR ','PSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5155,'Palmas Del Mar','Humacao','PR ','PPD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5156,'Roosevelt NAS','Roosevelt Roads','PR ','NRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5157,'Vieques','Vieques','PR ','VQS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5158,'Al Udeid AB','Al Udeid','QA ','XJD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5159,'Doha','Doha','QA ','DOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5160,'Doha Free Zone','Doha','QA ','XOZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5161,'Ulsan','Ulsan','KR ','USN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5162,'Gillot','St Denis de la Reunion','RE ','RUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5163,'St Pierre dela Reunion','St Pierre dela Reunion','RE ','ZSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5164,'Arad','Arad','RO ','ARW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5165,'Bacau','Bacau','RO ','BCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5166,'Baia Mare','Baia Mare','RO ','BAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5167,'Baneasa','Bucharest','RO ','BBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5168,'Caransebes','Caransebes','RO ','CSB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5169,'Cluj Napoca International Airport','Cluj-Napoca','RO ','CLJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5170,'Craiova','Craiova','RO ','CRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5171,'Deva','Deva','RO ','DVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5172,'Henri Coanda International','Bucharest','RO ','OTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5399,'Prishtina International Airport','Prishtina','RS ','PRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5400,'Hercegnovi','Hercegnovi','CS ','HNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5401,'Bird Island','Bird Island','SC ','BDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5402,'Denis Island','Denis Island','SC ','DEI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5403,'Desroches','Desroches','SC ','DES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5404,'Fregate Is','Fregate Is','SC ','FRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5405,'Praslin Island','Praslin Island','SC ','PRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5406,'Seychelles International Airport','Mahe Island','SC ','SEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5407,'Bo','Bo','SL ','KBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5408,'Bonthe','Bonthe','SL ','BTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5409,'Daru','Daru','SL ','DSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5410,'Gbangbatok','Gbangbatok','SL ','GBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5411,'Hastings','Freetown','SL ','HGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5412,'Kabala','Kabala','SL ','KBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5413,'Kenema','Kenema','SL ','KEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5414,'Lungi International','Freetown','SL ','FNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5415,'Mammy Yoko Heliport','Freetown','SL ','JMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5416,'Sierra Leone','Sierra Leone','SL ','SRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5417,'Yengema','Yengema','SL ','WYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5418,'Changi','Singapore','SG ','SIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5419,'Paya Lebar','Singapore','SG ','QPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5420,'Seletar','Singapore','SG ','XSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5421,'Barca','Kosice','SK ','KSC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5422,'Lucenec','Lucenec','SK ','LUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5423,'Piestany','Piestany','SK ','PZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5424,'Poprad/tatry','Poprad','SK ','TAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5425,'Presov','Presov','SK ','POV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5426,'Zilina','Zilina','SK ','ILZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5427,'M. R. Štefánika','Bratislava','SK ','BTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5428,'Sliac','Sliac','SK ','SLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5429,'Brnik','Ljubljana','SI ','LJU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5430,'Maribor International Airport','Maribor','SI ','MBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5431,'Portoroz','Portoroz','SI ','POW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5432,'Afutara Aerodrome','Afutara','SB ','AFT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5433,'Anuha Island Resort','Anuha Island Resort','SB ','ANH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5434,'Atoifi','Atoifi','SB ','ATD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5435,'Avu Avu','Avu Avu','SB ','AVU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5436,'Balalae','Balalae','SB ','BAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5437,'Barakoma','Barakoma','SB ','VEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5438,'Barora','Barora','SB ','RRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5439,'Batuna Aerodrome','Batuna','SB ','BPF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5440,'Bellona','Bellona','SB ','BNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5441,'Choiseul Bay','Choiseul Bay','SB ','CHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5442,'Fera Island','Fera Island','SB ','FRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5443,'Gatokae Aerodrom','Gatokae','SB ','GTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5444,'Geva Airstrip','Geva','SB ','GEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5445,'Gizo','Gizo','SB ','GZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5446,'Guadalcanal','Guadalcanal','SB ','GSI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5447,'Henderson Intl','Honiara','SB ','HIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5448,'Kagau','Kagau','SB ','KGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5449,'Kirakira','Kirakira','SB ','IRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5450,'Kukundu','Kukundu','SB ','KUE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5451,'Kwai Harbour','Kwai Harbour','SB ','KWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5452,'Kwailabesi Aerodrom','Kwailabesi','SB ','KWS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5453,'Marau Sound','Marau Sound','SB ','RUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5454,'Mbambanakira','Mbambanakira','SB ','MBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5455,'Mono','Mono','SB ','MNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5456,'Munda','Munda','SB ','MUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5457,'Nana','Star Habour','SB ','NAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5458,'Onepusu','Onepusu','SB ','ONE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5459,'Ontong Java','Ontong Java','SB ','OTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5460,'Parasi','Parasi','SB ','PRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5461,'Ramata','Ramata','SB ','RBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5462,'Rennell','Rennell','SB ','RNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5463,'Ringi Cove','Ringi Cove','SB ','RIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5464,'Santa Ana','Santa Ana','SB ','NNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5465,'Santa Cruz Is','Santa Cruz Is','SB ','SCZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5466,'Savo','Savo','SB ','SVY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5467,'Sege','Sege','SB ','EGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5468,'Tarapaina','Tarapaina','SB ','TAA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5469,'Tulagi Island','Tulagi Island','SB ','TLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5470,'Ulawa Airport','Arona','SB ','RNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5471,'Viru Harbour Airstrip','Viru','SB ','VIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5472,'Yandina','Yandina','SB ','XYA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5473,'Alula','Alula','SO ','ALU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5548,'Overberg','Overberg','ZA ','OVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5549,'Pietermaritzburg Oribi','Pietermaritzburg','ZA ','PZB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5550,'Pilanesberg','Sun City','ZA ','NTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5551,'Plettenberg Bay','Plettenberg Bay','ZA ','PBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5552,'Polokwane','Polokwane','ZA ','PTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5553,'Port Alfred','Port Alfred','ZA ','AFD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5554,'Port Elizabeth','Port Elizabeth','ZA ','PLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5555,'Port Saint Johns','Port Saint Johns','ZA ','JOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5556,'Prieska','Prieska','ZA ','PRK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5557,'Queenstown','Queenstown','ZA ','UTW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5558,'Rand/Germiston','Johannesburg','ZA ','QRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5559,'Randburg Heliport','Johannesburg','ZA ','HCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5560,'Morotai Island','Pitu Morotai Island','ID ','OTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5561,'Muko-Muko','Muko-Muko','ID ','MPC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5562,'Mulia','Mulia','ID ','LII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5563,'Mutiara','Labuan Bajo','ID ','LBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5564,'Mutiara','Palu','ID ','PLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5565,'Muting','Muting','ID ','MUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5566,'Nabire','Nabire','ID ','NBX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5567,'Naha','Naha','ID ','NAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5568,'Namlea','Namlea','ID ','NAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5569,'Nangapinoh','Nangapinoh','ID ','NPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5570,'Narita','Sabang','ID ','SBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5571,'Natuna Ranai','Natuna Ranai','ID ','NTX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5572,'Ngurah Rai International','Denpasar Bali','ID ','DPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5573,'Numfoor','Numfoor','ID ','FOO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5574,'Nunukan','Nunukan','ID ','NNX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5575,'Obano','Obano','ID ','OBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5576,'Ocussi','Ocussi','ID ','OEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5577,'Okaba','Okaba','ID ','OKQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5578,'Oksibil','Oksibil','ID ','OKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5579,'Padangkemiling','Bengkulu','ID ','BKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5580,'Palangkaraya','Palangkaraya','ID ','PKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5581,'Palibelo','Palibelo','ID ','PBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5582,'Pangkalanbuun','Pangkalanbuun','ID ','PKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5583,'Pangkalpinang','Pangkalpinang','ID ','PGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5584,'Pasir Pangarayan','Pasir Pangarayan','ID ','PPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5585,'Pattimura','Ambon','ID ','AMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5586,'Pendopo','Pendopo','ID ','PDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5587,'Penggung','Cirebon','ID ','CBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5588,'Pinang Kampai','Dumai','ID ','DUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5589,'Polonia','Medan','ID ','MES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5590,'Pomala','Pomala','ID ','PUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5591,'Pondok Cabe','Jakarta','ID ','PCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5592,'Poso','Poso','ID ','PSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5593,'Pulau Panjang','Pulau Panjang','ID ','PPJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5594,'Purwokerto','Purwokerto','ID ','PWL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5595,'Putussibau','Putussibau','ID ','PSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5596,'Ransiki','Ransiki','ID ','RSK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5597,'Rendani','Manokwari','ID ','MKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5598,'Rokot','Rokot','ID ','RKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5599,'Roti','Roti','ID ','RTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5600,'Ruteng','Ruteng','ID ','RTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5601,'Sabiha Gökçen Havaalanı','Kotabangun','ID ','KOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5602,'Samarinda','Samarinda','ID ','SRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5603,'Sampit','Sampit','ID ','SMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5604,'Samratulangi','Manado','ID ','MDC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5605,'Sanana','Sanana','ID ','SQN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5606,'Sanggata','Sanggata','ID ','SGQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5607,'Sangir','Sangir','ID ','SAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5608,'Sarmi','Sarmi','ID ','ZRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5609,'Saumlaki','Saumlaki','ID ','SXK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5610,'Sawu','Sawu','ID ','SAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5611,'Selaparang','Mataram','ID ','AMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5612,'Senggeh','Senggeh','ID ','SEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5613,'Senggo','Senggo','ID ','ZEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5614,'Senipah','Senipah','ID ','SZH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5615,'Sentani','Jayapura','ID ','DJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5616,'Sepingan','Balikpapan','ID ','BPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5617,'Serui','Serui','ID ','ZRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5618,'Seunagan','Meulaboh','ID ','MEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5619,'Sinak','Sinak','ID ','NKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5620,'Sintang','Sintang','ID ','SQG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5621,'Sipora','Sipora','ID ','RKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5622,'Sjamsudin Noor','Banjarmasin','ID ','BDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5623,'Soekarno-Hatta International','Jakarta','ID ','CGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5624,'Soekarno-hatta Intl','Jakarta','ID ','JKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5625,'Steenkool','Steenkool','ID ','ZKL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5626,'Suai','Suai','ID ','UAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5627,'Sugimanuru','Raha','ID ','RAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5628,'Sultan Lskandarmuda Airport','Banda Aceh','ID ','BTJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5629,'Sultan Syarif Kasim Ii','Pekanbaru','ID ','PKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5630,'Sultan Taha Syarifudn','Jambi','ID ','DJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5631,'Sungai Pakning','Sungai Pakning','ID ','SEQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5632,'Supadio','Pontianak','ID ','PNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5633,'Taliabu','Taliabu','ID ','TAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5634,'Tana Toraja','Tana Toraja','ID ','TTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5635,'Tanah Grogot','Tanah Grogot','ID ','TNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5636,'Tanahmerah','Tanahmerah','ID ','TMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5637,'Tanjung Balai','Tanjung Balai','ID ','TJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5638,'Tanjung Selor','Tanjung Selor','ID ','TJS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5639,'Tanjung Warukin','Tanjung Warukin','ID ','TJG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5640,'Tapaktuan','Tapaktuan','ID ','TPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5641,'Teminabuan','Teminabuan','ID ','TXM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5642,'Timika','Tembagapura','ID ','TIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5643,'Tiom','Tiom','ID ','TMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5644,'Tjilik Riwut','Tambolaka','ID ','TMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5645,'Tolitoli','Tolitoli','ID ','TLI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5646,'Tolotio','Gorontalo','ID ','GTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5647,'Trunojoyo','Sumenep','ID ','SUP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5648,'Tumbang Samba','Tumbang Samba','ID ','TBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5649,'Tunggul Wulung','Cilacap','ID ','CXP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5650,'Ubrub','Ubrub','ID ','UBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5651,'Viqueque','Viqueque','ID ','VIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5652,'Wagethe','Wagethe','ID ','WET');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5653,'Waingapu','Waingapu','ID ','WGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5654,'Waioti','Maumere','ID ','MOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5655,'Wamena','Wamena','ID ','WMX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5656,'Waris','Waris','ID ','WAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5657,'Wasior','Wasior','ID ','WSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5658,'Wolter Monginsidi','Kendari','ID ','KDI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5659,'Zugapa','Zugapa','ID ','UGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5660,'Abadan','Abadan','IR ','ABD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5661,'Abu Musa','Abu Musa','IR ','AEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5662,'Aghajari','Aghajari','IR ','AKW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5663,'Ahwaz','Ahwaz','IR ','AWZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5664,'Araak','Araak','IR ','AJK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5665,'Ardabil','Ardabil','IR ','ADU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5666,'Babolsar','Babolsar','IR ','BBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5667,'Bahregan','Bahregan','IR ','IAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5668,'Bam','Bam','IR ','BXR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5669,'Bandar Abbas','Bandar Abbas','IR ','BND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5670,'Bandar Lengeh','Bandar Lengeh','IR ','BDH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5671,'Birjand','Birjand','IR ','XBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5672,'Bishe-kola','Bishe-kola','IR ','BSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5673,'Bojnord','Bojnord','IR ','BJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5674,'Bushehr','Bushehr','IR ','BUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5675,'Chah-Bahar','Chah-Bahar','IR ','ZBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5676,'Dashte Naz','Sary','IR ','SRY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5677,'Dezful','Dezful','IR ','DEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5678,'Fasa','Fasa','IR ','FAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5679,'Ghazvin','Ghazvin','IR ','GZW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5680,'Gorgan','Gorgan','IR ','GBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5681,'Hamadan','Hamadan','IR ','HDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5682,'Havadarya','Havadarya','IR ','HDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5683,'Ilaam','Ilaam','IR ','IIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5684,'Iran Shahr','Iran Shahr','IR ','IHR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5685,'Isfahan International','Isfahan','IR ','IFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5686,'Jam','Kangan','IR ','KNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5687,'Jiroft','Jiroft','IR ','JYR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5688,'Kalaleh','Kalaleh','IR ','KLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5689,'Kerman','Kerman','IR ','KER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5690,'Kermanshah','Kermanshah','IR ','KSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5691,'Khaneh','Khaneh','IR ','KHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5692,'Khark Island','Khark Island','IR ','KHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5693,'Khorramabad','Khorramabad','IR ','KHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5694,'Khoy','Khoy','IR ','KHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5695,'Kish Island','Kish Island','IR ','KIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5696,'Lamerd','Lamerd','IR ','LFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5697,'Lar A/P','Lar','IR ','LRR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5698,'Lavan','Lavan','IR ','LVP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5699,'Mahshahr','Bandar Mahshahr','IR ','MRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5700,'Mashad','Mashad','IR ','MHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5701,'Mehrabad/ghaleh Morghi','Tehran','IR ','THR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5702,'Nojeh','Nojeh','IR ','NUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5703,'Now Shahr','Now Shahr','IR ','NSH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5704,'Omidieh','Omidieh','IR ','OMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5705,'Persian Gulf International','Assaluyeh','IR ','YEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5706,'Rafsanjan','Rafsanjan','IR ','RJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5707,'Ramsar','Ramsar','IR ','RZR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5708,'Rasht','Rasht','IR ','RAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5709,'Sabzevar','Sabzevar','IR ','AFZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5710,'Sahand','Sahand','IR ','ACP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5711,'Sanandaj','Sanandaj','IR ','SDG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5712,'Sarakhs','Sarakhs','IR ','CKT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5713,'Shahre-kord','Shahre-kord','IR ','CQD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5714,'Shiraz','Shiraz','IR ','SYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5715,'Sirjan','Sirjan','IR ','SYJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5716,'Sirri Island','Sirri Island','IR ','SXI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5717,'Tabriz','Tabriz','IR ','TBZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5718,'Tohid','Tohid','IR ','TEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5719,'Urmieh','Urmieh','IR ','OMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5720,'Yazd','Yazd','IR ','AZD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5721,'Zabol A/P','Zabol','IR ','ACZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5722,'Zahedan','Zahedan','IR ','ZAH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5723,'Zanjan','Zanjan','IR ','JWN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5724,'Erbil International','Erbil','IQ ','EBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5725,'Al Rasheed','Baghdad','IQ ','BGW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5726,'Baghdad International','Baghdad','IQ ','SDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5727,'Balad','Balad','IQ ','XQC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5728,'Bamerny','Bamerny','IQ ','BMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5729,'Baqubah','Baqubah','IQ ','XQV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5730,'International','Basra','IQ ','BSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5731,'Khan Al Baghdadi','Khan Al Baghdadi','IQ ','XIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5732,'Kirkuk','Kirkuk','IQ ','KIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5733,'Mosul','Mosul','IQ ','OSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5734,'Ramadi','Ramadi','IQ ','XTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5735,'Sulaimaniyah International','Sulaimaniyah','IQ ','OSO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5736,'Tikrit','Tikrit','IQ ','XTV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5737,'Bantry','Bantry','IE ','BYT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5738,'Belmullet','Belmullet','IE ','BLY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5739,'Bus Station','Sligo','IE ','ZSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5740,'Carnmore','Galway','IE ','GWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5741,'Castlebar','Castlebar','IE ','CLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5742,'Castlebridge','Wexford','IE ','WEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5743,'Collooney','Sligo','IE ','SXL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5744,'Connemara','Spiddal','IE ','NNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5745,'Cork','Cork','IE ','ORK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5746,'Donegal','Carrickfinn','IE ','CFN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5747,'Dublin','Dublin','IE ','DUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5748,'Inisheer','Inisheer','IE ','INQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5749,'Inishmaan','Galloway','IE ','IIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5750,'Ireland West Airport Knock','Knock','IE ','NOC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5751,'Kerry','Farranfore','IE ','KIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5752,'Kilkenny','Kilkenny','IE ','KKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5753,'Kilronan','Inishmore','IE ','IOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5754,'Letterkenny','Letterkenny','IE ','LTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5755,'Reenroe','Caherciveen','IE ','CHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5756,'Shannon','Shannon','IE ','SNN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5757,'Waterford','Waterford','IE ','WAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5758,'Beer Sheba','Beer Sheba','IL ','BEV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5759,'Ben Gurion Intl','Tel Aviv Yafo','IL ','TLV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5760,'Eilat','Eilat','IL ','ETH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5761,'Ein Yahav','Ein Yahav','IL ','EIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5762,'Gush Katif','Gush Katif','IL ','GHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5763,'Haifa','Haifa','IL ','HFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5764,'Herzlia','Herzlia','IL ','---');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5765,'Jerusalem','Jerusalem','IL ','JRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5766,'Kiryat Shmona','Kiryat Shmona','IL ','KSW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5767,'Masada','Masada','IL ','MTZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5768,'Mitspeh Ramon','Mitspeh Ramon','IL ','MIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5769,'Ovda','Eilat','IL ','VDA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5770,'Rosh Pina','Rosh Pina','IL ','RPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5771,'Sde Dov','Tel Aviv Yafo','IL ','SDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5772,'Yotvata','Yotvata','IL ','YOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5773,'Airfield','Udine','IT ','UDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5774,'Albenga','Albenga','IT ','ALL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5775,'Arbatax','Tortoli','IT ','TTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5776,'Aviano','Aviano','IT ','AVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5777,'Baccarini','Grosseto','IT ','GRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5778,'Belluno','Belluno','IT ','BLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5779,'Beverello Harbor','Naples','IT ','ZMF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5780,'Birgi','Trapani','IT ','TPS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5781,'Bolzano','Bolzano','IT ','BZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5782,'Brescia Montichiari','Brescia','IT ','VBS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5783,'Bus Station','Bozen','IT ','ZBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5784,'Bus Station','Meran','IT ','ZMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5785,'Bus Station','Modena','IT ','ZMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5786,'Capodichino','Napoli','IT ','NAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5787,'Capri','Capri','IT ','PRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5788,'Central Station','Milan','IT ','XIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5789,'Ciampino','Rome','IT ','CIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5790,'Comiso','Comiso','IT ','CIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5791,'Costa Smeralda','Olbia','IT ','OLB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5792,'Cristoforo Colombo','Genova','IT ','GOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5793,'Crotone','Crotone','IT ','CRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5794,'Elmas','Cagliari','IT ','CAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5795,'Falconara','Ancona','IT ','AOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5796,'Fertilia','Alghero','IT ','AHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5797,'Fontanarossa','Catania','IT ','CTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5798,'Galatina','Lecce','IT ','LCC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5799,'Galileo Galilei','Pisa','IT ','PSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5800,'Gino Lisa','Foggia','IT ','FOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5801,'Giuseppe Verdi','Parma','IT ','PMF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5802,'Guglielmo Marconi','Bologna','IT ','BLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5803,'Harbour','Ponza','IT ','ZJY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5804,'Harbour','Procida','IT ','ZJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5805,'Harbour','Lipari','IT ','ZIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5806,'Harbour','Panarea','IT ','ZJE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5807,'Harbour','Salina','IT ','ZIQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5808,'Harbour','Stromboli','IT ','ZJX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5809,'Harbour','Vulcano','IT ','ZIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5810,'Ischia','Ischia','IT ','ISH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5811,'Jesolo','Jesolo','IT ','JLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5812,'La Spreta','Ravenna','IT ','RAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5813,'Lampedusa','Lampedusa','IT ','LMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5814,'Leonardo da Vinci International','Rome','IT ','FCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5815,'Levaldigi','Cuneo','IT ','CUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5816,'Liberi','Pescara','IT ','PSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5817,'Linate','Milan','IT ','LIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5818,'Lucca','Lucca','IT ','LCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5819,'Luigi Ridolfi','Forli','IT ','FRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5820,'M. A. Grottag','Taranto','IT ','TAR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5821,'Malpensa','Milan','IT ','MXP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5822,'Marco Polo','Venice','IT ','VCE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5823,'Marina Di Campo','Elba Island','IT ','EBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5824,'Marina Di Massa','Marina Di Massa','IT ','QMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5825,'Mergellina Harbour','Naples','IT ','ZMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5826,'Mestre Rail Stn.','Rome','IT ','XVY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5827,'Miramare','Rimini','IT ','RMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5828,'Orio al Serio','Bergamo','IT ','BGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5829,'Palese','Bari','IT ','BRI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5830,'Pantelleria','Pantelleria','IT ','PNL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5831,'Papola Casale','Brindisi','IT ','BDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5832,'Peretola','Florence','IT ','FLR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5833,'Peschiei','Peschiei','IT ','PEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5834,'Porta Nuova Rail','Verona','IT ','XIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5835,'Punta Raisi','Palermo','IT ','PMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5836,'Rafsu Decimomannu','Decimomannu','IT ','DCI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5837,'Ronchi Dei Legionari','Trieste','IT ','TRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5838,'S Eufemia','Lamezia-terme','IT ','SUF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5839,'S. Angelo','Treviso','IT ','TSF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5840,'San Domino Island','San Domino Island','IT ','TQR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5841,'San Giovanni Rotondo','San Giovanni Rotondo','IT ','GBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5842,'Sandro Pertini','Turin','IT ','TRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5843,'Sant Egidio','Perugia','IT ','PEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5844,'Santa Lucia Rail','Venice','IT ','XVQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5845,'Segrate','Milan','IT ','SWK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5846,'Siena','Siena','IT ','SAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5847,'Sigonella NAF','Tokat','IT ','NSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5848,'Sorrento','Naples','IT ','RRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5849,'Taormina Harbour','Taormina','IT ','TFC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5850,'Termini Rail Stn.','Rome','IT ','XRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5851,'Tito Menniti','Reggio Calabria','IT ','REG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5852,'Valerio Catullo','Verona','IT ','VRN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5853,'Vicenza','Vicenza','IT ','VIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5854,'Boscobel','Ocho Rios','JM ','OCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5855,'Ken Jones','Port Antonio','JM ','POT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5856,'Marlboro','Mandeville','JM ','MVJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5857,'Negril','Negril','JM ','NEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5858,'Norman Manley','Kingston','JM ','KIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5859,'Sangster International','Montego Bay','JM ','MBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5860,'Tinson','Kingston','JM ','KTP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5861,'Aguni','Aguni','JP ','AGJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5862,'Akita','Akita','JP ','AXT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5863,'Amami O Shima','Amami O Shima','JP ','ASJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5864,'Aomori','Aomori','JP ','AOJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5865,'Asahikawa','Asahikawa','JP ','AKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5866,'Atsugi NAS','Atsugi','JP ','NJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5867,'Beppu','Beppu','JP ','BPU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5868,'Centrair','Tokoname','JP ','NGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5869,'Fukue','Fukue','JP ','FUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5870,'Fukui','Fukui','JP ','FKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5871,'Fukuoka','Fukuoka','JP ','FUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5872,'Hachijo Jima','Hachijo Jima','JP ','HAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5873,'Hachinohe','Hachinohe','JP ','HHE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5874,'Hakodate','Hakodate','JP ','HKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5875,'Hanamaki','Hanamaki','JP ','HNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5876,'Hateruma','Hateruma','JP ','HTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5877,'Hirara','Miyako Jima','JP ','MMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5878,'Hiroshima West','Hiroshima','JP ','HIW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5879,'Hokkaido','Wakkanai','JP ','WKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5880,'Iejima','Iejima','JP ','IEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5881,'Iki','Iki','JP ','IKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5882,'International','Hiroshima','JP ','HIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5883,'Ishigaki','Ishigaki','JP ','ISG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5884,'Itami','Osaka','JP ','ITM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5885,'Iwami','Iwami','JP ','IWJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5886,'Iwo Jima Airbase','Iwo Jima Vol','JP ','IWO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5887,'Izumo','Izumo','JP ','IZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5888,'Junmachi','Yamagata','JP ','GAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5889,'Kadena AB','Okinawa','JP ','DNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5890,'Kagoshima','Kagoshima','JP ','KOJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5891,'Kansai','Kyoto','JP ','UKY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5892,'Kansai International','Osaka','JP ','KIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5893,'Kikaiga Shima','Kikaiga Shima','JP ','KKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5894,'Kita Kyushu','Kita Kyushu','JP ','KKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5895,'Kitadaito','Kitadaito','JP ','KTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5896,'Kobe','Kobe','JP ','UKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5897,'Kochi','Kochi','JP ','KCZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5898,'Komaki AFB','Nagoya','JP ','NKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5899,'Komatsu','Komatsu','JP ','KMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5900,'Kumamoto','Kumamoto','JP ','KMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5901,'Kumejima','Kumejima','JP ','UEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5902,'Kushimoto','Kushimoto','JP ','KUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5903,'Kushiro','Kushiro','JP ','KUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5904,'Marcus Island','Marcus Island','JP ','MUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5905,'Maridor','Minami Daito','JP ','MMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5906,'Matsumoto','Matsumoto','JP ','MMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5907,'Matsuyama','Matsuyama','JP ','MYJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5908,'Memanbetsu','Memanbetsu','JP ','MMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5909,'Miho','Yonago','JP ','YGJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5910,'Misawa','Misawa','JP ','MSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5911,'Miyake Jima','Miyake Jima','JP ','MYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5912,'Miyazaki','Miyazaki','JP ','KMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5913,'Monbetsu','Monbetsu','JP ','MBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5914,'Nagasaki','Nagasaki','JP ','NGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5915,'Naha','Okinawa','JP ','OKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5916,'Naha Air Force Base','Okinawa','JP ','AHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5917,'Nakashibetsu','Nakashibetsu','JP ','SHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5918,'New Chitose Airport','Sapporo','JP ','CTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5919,'New Tokyo International Airport','Tokyo','JP ','NRT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5920,'Niigata','Niigata','JP ','KIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5921,'Niihama','Niihama','JP ','IHA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5922,'Nishinoomote','Nishinoomote','JP ','IIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5923,'Noto Airport','Wajima','JP ','NTQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5924,'Obihiro','Obihiro','JP ','OBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5925,'Odate Noshiro','Odate Noshiro','JP ','ONJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5474,'Baidoa','Baidoa','SO ','BIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5475,'Bardera','Bardera','SO ','BSY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5476,'Berbera','Berbera','SO ','BBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5477,'Borama International','Borama','SO ','BXX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5478,'Bossaso','Bossaso','SO ','BSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5479,'Burao','Burao','SO ','BUO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5480,'Candala','Candala','SO ','CXN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5481,'Eil','Eil','SO ','HCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5482,'Erigavo','Erigavo','SO ','ERA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5483,'Galcaio','Galcaio','SO ','GLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5484,'Garbaharey','Garbaharey','SO ','GBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5485,'Gardo','Gardo','SO ','GSR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5486,'Garoe','Garoe','SO ','GGR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5487,'Hargeisa','Hargeisa','SO ','HGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5488,'Kismayu','Kismayu','SO ','KMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5489,'Las Khoreh','Las Khoreh','SO ','LKR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5490,'Lugh Ganane','Lugh Ganane','SO ','LGX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5491,'Mogadishu International Airport','Mogadishu','SO ','MGQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5492,'Obbia','Obbia','SO ','CMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5493,'Scusciuban','Scusciuban','SO ','CMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5494,'Aggeneys','Aggeneys','ZA ','AGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5495,'Alldays','Alldays','ZA ','ADY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5496,'Babelegi Heliport','Babelegi','ZA ','HBL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5497,'Bisho','Bisho','ZA ','BIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5498,'Butterworth','Butterworth','ZA ','UTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5499,'Cape Town','Phalaborwa','ZA ','PHW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5500,'Cape Town International','Cape Town','ZA ','CPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5501,'Central Hpr','Pretoria','ZA ','HPR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5502,'Cradock','Cradock','ZA ','CDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5503,'Dukuduk','Dukuduk','ZA ','DUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5504,'Durban International','Durban','ZA ','DUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5505,'East London','East London','ZA ','ELS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5506,'Ellisras','Ellisras','ZA ','ELL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5507,'Empangeni','Empangeni','ZA ','EMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5508,'Ficksburg Sentra Oes','Ficksburg','ZA ','FCB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5509,'George','George','ZA ','GRJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5510,'Grand Central','Johannesburg','ZA ','GCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5511,'Harrismith Airport','Harrismith','ZA ','HRS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5512,'Hazyview','Hazyview','ZA ','HZV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5513,'Hluhluwe','Hluhluwe','ZA ','HLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5514,'Hoedspruit Airport','Hoedspruit','ZA ','HDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5515,'Inyati','Inyati','ZA ','INY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5516,'Iscor Heliport','Pretoria','ZA ','HIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5517,'Khoka Moya','Khoka Moya','ZA ','KHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5518,'Kimberley','Kimberley','ZA ','KIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5519,'Kleinzee','Kleinzee','ZA ','KLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5520,'Klerksdorp','Klerksdorp','ZA ','KXE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5521,'Koinghaas','Koinghaas','ZA ','KIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5522,'Komatipoort','Komatipoort','ZA ','KOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5523,'Kortdoorn','Alexander Bay','ZA ','ALJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5524,'Kruger Mpumalanga','Nelspruit','ZA ','MQP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5525,'Kuruman','Kuruman','ZA ','KMH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5526,'Ladysmith','Ladysmith','ZA ','LAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5527,'Langebaanweg','Saldanha Bay','ZA ','SDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5528,'Lanseria','Lanseria','ZA ','HLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5529,'Letaba','Tzaneen','ZA ','LTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5530,'Lime Acres','Lime Acres','ZA ','LMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5531,'Londolozi','Londolozi','ZA ','LDZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5532,'Louis Trichardt','Louis Trichardt','ZA ','LCD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5533,'Lusikisiki','Lusikisiki','ZA ','LUJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5534,'Mafikeng International Airport','Mmabatho','ZA ','MBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5535,'Mala Mala','Mala Mala','ZA ','AAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5536,'Malelane','Malelane','ZA ','LLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5537,'Margate','Margate','ZA ','MGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5538,'Messina','Messina','ZA ','MEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5539,'Mkambati','Mkambati','ZA ','MBM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5540,'Mkuze','Mkuze','ZA ','MZQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5541,'Mossel Bay','Mossel Bay','ZA ','MZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5542,'Mzamba','Mzamba','ZA ','MZF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5543,'Nelspruit International','Nelspruit','ZA ','NLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5544,'Newcastle','Newcastle','ZA ','NCS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5545,'Ngala Airfield','Ngala','ZA ','NGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5546,'Oliver Reginald Tambo International','Johannesburg','ZA ','JNB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5547,'Oudtshoorn','Oudtshoorn','ZA ','OUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6304,'Tioman','Tioman','MY ','TOD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6305,'Tomanggong','Tomanggong','MY ','TMG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6306,'Gan Airport','Gan Island','MV ','GAN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6307,'Hanimaadhoo','Hanimaadhoo','MV ','HAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6308,'Kaadedhdhoo','Kaadedhdhoo','MV ','KDM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6309,'Kadhdhoo','Kadhdhoo','MV ','KDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6310,'Male International','Male','MV ','MLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6311,'Bamako','Bamako','ML ','BKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6312,'Goundam','Goundam','ML ','GUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6313,'Kayes','Kayes','ML ','KYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6314,'Kenieba','Kenieba','ML ','KNZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6315,'Koutiala','Koutiala','ML ','KTX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6316,'Mopti','Mopti','ML ','MZI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6317,'Nara','Nara','ML ','NRM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6318,'Nioro','Nioro','ML ','NIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6319,'Segou','Segou','ML ','SZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6320,'Sikasso','Sikasso','ML ','KSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6321,'Tombouctou','Tombouctou','ML ','TOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6322,'Yelimane','Yelimane','ML ','EYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6323,'Gozo Heliport','Gozo','MT ','GZM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6324,'Heliport','Comino','MT ','JCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6325,'Malta International','Gudja','MT ','MLA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6326,'Ailinglapalap Island','Ailinglapalap Island','MH ','AIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6327,'Ailuk Island','Ailuk Island','MH ','AIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6328,'Airok','Airok Ailinglaplap','MH ','AIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6329,'Amata Kabua Intl','Majuro','MH ','MAJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6330,'Arno','Arno','MH ','AMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6331,'Aur Island','Aur Island','MH ','AUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6332,'Ebadon','Ebadon','MH ','EBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6333,'Elenak','Kwajalein Atoll','MH ','EAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6334,'Enewetak Island','Enewetak Island','MH ','ENT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6335,'Enijet','Mili Atoll','MH ','EJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6336,'Enyu Airfield','Bikini Atoll','MH ','BII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6337,'Ine Island','Ine Island','MH ','IMI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6338,'Jabot','Jabot','MH ','JAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6339,'Jaluit Island','Jaluit Island','MH ','UIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6340,'Jeh','Jeh','MH ','JEJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6341,'Kaben','Kaben','MH ','KBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6342,'Kili Island','Kili Island','MH ','KIO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6343,'Kwajalein','Kwajalein','MH ','KWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6344,'Lae Island','Lae Island','MH ','LML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6345,'Likiep Island','Likiep Island','MH ','LIK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6346,'Loen','Loen','MH ','LOF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6347,'Majkin','Majkin','MH ','MJE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6348,'Maloelap Island','Maloelap Island','MH ','MAV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6349,'Mejit Island','Mejit Island','MH ','MJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6350,'Mili Island','Mili Island','MH ','MIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6351,'Namdrik Island','Namdrik Island','MH ','NDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6352,'Namu','Namu','MH ','NMU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6353,'Rongelap Island','Rongelap Island','MH ','RNP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6354,'Tabal','Tabal','MH ','TBV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6355,'Tinak Island','Tinak Island','MH ','TIC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6356,'Ujae Island','Ujae Island','MH ','UJE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6357,'Utirik Island','Utirik Island','MH ','UTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6358,'Woja','Woja','MH ','WJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6359,'Wotho Island','Wotho Island','MH ','WTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6360,'Wotje Island','Wotje Island','MH ','WTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6361,'Lamentin','Fort De France','MQ ','FDF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6362,'Abbaye','Boghe','MR ','BGH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6363,'Aioun El Atrouss','Aioun El Atrouss','MR ','AEO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6364,'Akjoujt','Akjoujt','MR ','AJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6365,'Aleg','Aleg','MR ','LEG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6366,'Boutilimit','Boutilimit','MR ','OTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6367,'Chinguitti','Chinguitti','MR ','CGT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6368,'El Gouera','El Gouera','MR ','ZLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6369,'Fderik','Fderik','MR ','FGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6370,'Kaedi','Kaedi','MR ','KED');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6371,'Kiffa','Kiffa','MR ','KFA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6372,'Mbout','Mbout','MR ','MBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6373,'Mouakchott','Atar','MR ','ATR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6374,'Moudjeria','Moudjeria','MR ','MOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6375,'Nema','Nema','MR ','EMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6376,'Nouadhibou','Nouadhibou','MR ','NDB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6377,'Nouakchott','Nouakchott','MR ','NKC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6378,'Selibaby','Selibaby','MR ','SEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6379,'Tamchakett','Tamchakett','MR ','THT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6380,'Tichitt','Tichitt','MR ','THI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6381,'Tidjikja','Tidjikja','MR ','TIY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6382,'Timbedra','Timbedra','MR ','TMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6383,'Zouerate','Zouerate','MR ','OUZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6384,'Rodrigues Is','Rodrigues Is','MU ','RRG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6385,'Sir Seewoosagur Ramgoolam Int','Plaisance','MU ','MRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6386,'Abreojos','Abreojos','MX ','AJS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6387,'Aguascalients','Aguascalientes','MX ','AGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6388,'Alamos','Alamos','MX ','XAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6389,'Apatzingan','Apatzingan','MX ','AZG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6390,'Atizapan','Mexico City','MX ','AZP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6391,'Bahia Angeles','Bahia Angeles','MX ','BHL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6392,'Campeche International','Campeche','MX ','CPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6393,'Cananea','Cananea','MX ','CNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6394,'Cancún International','Cancun','MX ','CUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6395,'Capitan Carlos Rovirosa','Villahermosa','MX ','VSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6396,'Chetumal','Chetumal','MX ','CTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6397,'Chichen Itza','Chichen Itza','MX ','CZA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6398,'Ciudad Constitucion','Ciudad Constitucion','MX ','CUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6399,'Ciudad Del Carmen','Ciudad Del Carmen','MX ','CME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6400,'Ciudad Mante','Ciudad Mante','MX ','MMC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6401,'Ciudad Obregon','Ciudad Obregon','MX ','CEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6402,'Ciudad Victoria','Ciudad Victoria','MX ','CVM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6403,'Colima','Colima','MX ','CLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6404,'Copalar','Comitan','MX ','CJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6405,'Cozumel','Cozumel','MX ','CZM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6406,'Del Bajío International','León','MX ','BJX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6407,'Don Miguel Hidalgo y Costilla International','Guadalajara','MX ','GDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6408,'Ensenada','Ensenada','MX ','ESE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6409,'Federal','Los Mochis','MX ','LMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6410,'Fedl De Bachigualato','Culiacan','MX ','CUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6411,'Francisco J. Múgica Internacional','Morelia','MX ','MLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6412,'Francisco P. V. Y R.','Lagos De Moreno','MX ','LOM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6413,'Francisco Sarabia','Torreon','MX ','TRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6414,'Gen F Javier Mina','Tampico','MX ','TAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6415,'Gen Fierro Villalobos','Chihuahua','MX ','CUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6416,'Gen Jose M Yanez','Guaymas','MX ','GYM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6417,'Gen Lucio Blanco','Reynosa','MX ','REX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6418,'Gen Mariano Escobedo','Monterrey','MX ','MTY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6419,'Gen Pesqueira Garcia','Hermosillo','MX ','HMO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6420,'Gen Rafael Buelna','Mazatlan','MX ','MZT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6421,'General A. L. Rodriguez Intl','Tijuana','MX ','TIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6422,'General Juan N. Alvarez International','Acapulco','MX ','ACA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6423,'General Manuel Márquez De León International Airport','La Paz','MX ','LAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6424,'General Mariano Matamoros Airport','Cuernavaca','MX ','CVJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6425,'Guadalupe Victoria','Durango','MX ','DGO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6426,'Guerrero Negro','Guerrero Negro','MX ','GUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6427,'Hermanos Serdan International','Puebla Atlixco','MX ','PBC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6428,'Huatulco','Huatulco','MX ','HUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6429,'Internacional','Ixtapa/Zihuatanejo','MX ','ZIH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6430,'Internacional Benito Juarez','Mexico City','MX ','MEX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6431,'International','Ciudad Acuna','MX ','ACN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6432,'Intl Abraham Gonzalez','Ciudad Juarez','MX ','CJS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6433,'Intl Quetzalcoatl','Nuevo Laredo','MX ','NLD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6434,'Isla Mujeres','Isla Mujeres','MX ','ISJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6435,'Ixtepec','Ixtepec','MX ','IZT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6436,'Jalapa','Jalapa','MX ','JAL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6437,'La Calera','Zacatecas','MX ','ZCL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6438,'Las Bajadas','Veracruz','MX ','VER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6439,'Lazaro Cardenas','Lazaro Cardenas','MX ','LZC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6440,'Licenciado Adolfo Lopez Mateos International','Toluca','MX ','TLC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6441,'Licenciado Gustavo Díaz Ordaz International','Puerto Vallarta','MX ','PVR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6442,'Llano San Juan','Tuxtla Gutierrez','MX ','TGZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6443,'Loreto','Loreto','MX ','LTO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6444,'Los Cabos','San Jose Del Cabo','MX ','SJD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6445,'Manzanillo','Manzanillo','MX ','ZLO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6446,'Matamoros','Matamoros','MX ','MAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6447,'Mexicali','Mexicali','MX ','MXL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6448,'Minatitlan','Minatitlan','MX ','MTT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6449,'Monclova','Monclova','MX ','LOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6450,'Mulege','Mulege','MX ','MUG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6451,'Nogales','Nogales','MX ','NOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6452,'Nueva Casas Grandes','Paloma Grande','MX ','NCG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6453,'Palenque','Palenque','MX ','PQM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6454,'Piedras Negras','Piedras Negras','MX ','PDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6455,'Pinotepa Nacional','Pinotepa Nacional','MX ','PNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6456,'Playa Del Carmen','Playa Del Carmen','MX ','PCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6457,'Pochutla','Pochutla','MX ','PUH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6458,'Puerto Escondido','Puerto Escondido','MX ','PXM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6459,'Puerto Penasco','Puerto Penasco','MX ','PPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6460,'Puerto Vallarta','Puerto Juarez','MX ','PJZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6461,'Punta Chivato','Punta Chivato','MX ','PCV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6462,'Punta Colorada','Punta Colorada','MX ','PCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6463,'Queretaro','Queretaro','MX ','QRO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6464,'Rejon','Merida','MX ','MID');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6465,'Salina Cruz','Salina Cruz','MX ','SCX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6466,'Saltillo','Saltillo','MX ','SLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6467,'San Felipe','San Felipe','MX ','SFH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6468,'San Ignacio','San Ignacio','MX ','SGM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6469,'San Luis Potosi','San Luis Potosi','MX ','SLP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6470,'San Luis Rio Colorado','San Luis Rio Colorado','MX ','UAC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6471,'San Quintin','San Quintin','MX ','SNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6472,'Santa Lucia','Santa Lucia','MX ','NLU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6473,'Santa Rosalia','Santa Rosalia','MX ','SRL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6474,'Tajin','Poza Rica','MX ','PAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6475,'Tamuin','Tamuin','MX ','TSL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6476,'Tapachula International','Tapachula','MX ','TAP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6477,'Tehuacan','Tehuacan','MX ','TCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6478,'Tepic','Tepic','MX ','TPQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6479,'Tizimin','Tizimin','MX ','TZM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6480,'Tulum','Tulum','MX ','TUY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6481,'Tuxtla Gutierrez','Tuxtla Gutierrez','MX ','NTR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6482,'Uruapan','Uruapan','MX ','UPN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6483,'Villa Constitucion','Villa Constitucion','MX ','VIB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6484,'Xoxocotlan','Oaxaca','MX ','OAX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6485,'Zamora','Zamora','MX ','ZMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6486,'Kosrae','Kosrae','FM ','KSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6487,'Pohnpei','Pohnpei','FM ','PNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6488,'Truk','Truk','FM ','TKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6489,'Ulithi','Ulithi','FM ','ULI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6490,'Beltsy','Beltsy','MD ','BZY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6491,'International Airport Chisinau','Chisinau','MD ','KIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6492,'Fontvieille Heliport','Monte Carlo','MC ','MCM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6493,'Altai','Altai','MN ','LTI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6494,'Arvaikheer','Arvaikheer','MN ','AVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6495,'Baruun-Urt','Baruun-Urt','MN ','UUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6496,'Bayankhongor','Bayankhongor','MN ','BYN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6497,'Bulgan','Bulgan','MN ','UGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6498,'Chinggis Khaan International','Ulaanbaatar','MN ','ULN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6499,'Choibalsan','Choibalsan','MN ','COQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6500,'Dalanzadgad','Dalanzadgad','MN ','DLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6501,'Erdenet','Erdenet','MN ','ERT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6502,'Kharkhorin','Kharkhorin','MN ','KHR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6503,'Khatgal','Khatgal','MN ','HTM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6504,'Khovd','Khovd','MN ','HVD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6505,'Khujirt','Khujirt','MN ','HJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6506,'Mandalgobi','Mandalgobi','MN ','MXW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6507,'Moron','Moron','MN ','MXV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6508,'Ulaangom','Ulaangom','MN ','ULO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6509,'Ulgit','Ulgit','MN ','ULG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6510,'Uliastai','Uliastai','MN ','ULZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6511,'Underkhaan','Underkhaan','MN ','UNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6512,'Golubovci','Podgorica','ME ','TGD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6513,'Ivangrad','Berane','ME ','IVG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6514,'Tivat','Tivat','ME ','TIV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6515,'Gerald''s Airport','Gerald''s Park','MS ','MNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6516,'Agadir Almassira','Agadir','MA ','AGA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6517,'Anfa','Casablanca','MA ','CAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6518,'Boukhalef','Tangier','MA ','TNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6519,'Charif Al Idrissi','Al Hoceima','MA ','AHU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6520,'Dakhla','Dakhla','MA ','VIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6521,'Er Errachidia','Ksar Es Souk','MA ','SEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5926,'Off line Point','Rail','JP ','XZJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5927,'Oita','Oita','JP ','OIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5928,'Okadama','Sapporo','JP ','OKD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5929,'Okayama','Okayama','JP ','OKJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5930,'Oki Island','Oki Island','JP ','OKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5931,'Okino Erabu','Okino Erabu','JP ','OKE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5932,'Okushiri','Okushiri','JP ','OIR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5933,'Omura','Omura','JP ','OMJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5934,'Oshima','Oshima','JP ','OIM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5935,'Rebun','Rebun','JP ','RBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5936,'Rishiri','Rishiri','JP ','RIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5937,'Ryotsu Sado Is','Ryotsu Sado Is','JP ','SDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5938,'Sado Shima','Sado Shima','JP ','SDS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5939,'Saga','Saga','JP ','HSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5940,'Sendai','Sendai','JP ','SDJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5941,'Shimojishima','Shimojishima','JP ','SHI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5942,'Shirahama','Shirahama','JP ','SHM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5943,'Shonai','Shonai','JP ','SYO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5944,'Tajima','Toyooka','JP ','TJH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5945,'Takamatsu','Takamatsu','JP ','TAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5946,'Tanegashima','Tanegashima','JP ','TNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5947,'Tarama','Taramajima','JP ','TRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5948,'Tokunoshima','Tokunoshima','JP ','TKN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5949,'Tokushima','Tokushima','JP ','TKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5950,'Tokyo Haneda International','Tokyo','JP ','HND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5951,'Tottori','Tottori','JP ','TTJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5952,'Toyama','Toyama','JP ','TOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5953,'Tsushima','Tsushima','JP ','TSJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5954,'Ube','Ube','JP ','UBJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5955,'Yakushima','Yakushima','JP ','KUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5956,'Yokohama','Yokohama','JP ','YOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5957,'Yokota Afb','Tokyo','JP ','OKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5958,'Yonaguni Jima','Yonaguni Jima','JP ','OGN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5959,'Yoronjima','Yoronjima','JP ','RNJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5960,'King Hussein','Mafraq','JO ','OMF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5961,'King Hussein Intl','Aqaba','JO ','AQJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5962,'Maan','Maan','JO ','MPQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5963,'Marka International Airport','Amman','JO ','ADJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5964,'Queen Alia Intl','Amman','JO ','AMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5965,'Aktyubinsk','Aktyubinsk','KZ ','AKX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5966,'Almaty','Almaty','KZ ','ALA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5967,'Arkalyk','Arkalyk','KZ ','AYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5968,'Astana','Astana','KZ ','TSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5969,'Atbasar','Atbasar','KZ ','ATX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5970,'Atyrau International','Atyrau','KZ ','GUW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5971,'Balhash','Balhash','KZ ','BXH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5972,'Burundai','Burundai','KZ ','BXJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5973,'Ekibastuz','Ekibastuz','KZ ','EKB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5974,'Karaganda','Karaganda','KZ ','KGF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5975,'Kokshetau','Kokshetau','KZ ','KOV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5976,'Kostanay','Kostanay','KZ ','KSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5977,'Kzyl-Orda','Kzyl-Orda','KZ ','KZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5978,'Pavlodar','Pavlodar','KZ ','PWQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5979,'Petropavlovsk','Petropavlovsk','KZ ','PPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5980,'Semipalatinsk','Semipalatinsk','KZ ','PLX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5981,'Shevchenko','Aktau','KZ ','SCO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5982,'Shimkent','Shimkent','KZ ','CIT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5983,'Taldy-Kurgan','Taldy-Kurgan','KZ ','TDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5984,'Uralsk / Podstepnyy','Uralsk','KZ ','URA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5985,'Ust-kamenogorsk','Ust-kamenogorsk','KZ ','UKK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5986,'Zhairem','Zhairem','KZ ','HRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5987,'Zhambyl','Zhambyl','KZ ','DMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5988,'Zhezhazgan','Zhezkazgan','KZ ','DZN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5989,'Amboseli','Amboseli','KE ','ASV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5990,'Bamburi','Bamburi','KE ','BMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5991,'Eldoret','Eldoret','KE ','EDL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5992,'Eliye Springs','Eliye Springs','KE ','EYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5993,'Fergusons Gulf','Fergusons Gulf','KE ','FER');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5994,'Garissa','Garissa','KE ','GAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5995,'Hola','Hola','KE ','HOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5996,'Jomo Kenyatta International','Nairobi','KE ','NBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5997,'Kalokol','Kalokol','KE ','KLK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5998,'Kericho','Kericho','KE ','KEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (5999,'Kerio Valley','Kerio Valley','KE ','KRV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6000,'Kilaguni','Kilaguni','KE ','ILU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6001,'Kisumu','Kisumu','KE ','KIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6002,'Kitale','Kitale','KE ','KTL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6003,'Kiunga','Kiunga','KE ','KIU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6004,'Kiwayu','Kiwayu','KE ','KWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6005,'Lake Baringo','Lake Baringo','KE ','LBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6006,'Lake Rudolf','Lake Rudolf','KE ','LKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6007,'Lamu','Lamu','KE ','LAU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6008,'Liboi','Liboi','KE ','LBK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6009,'Lodwar','Lodwar','KE ','LOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6010,'Lokichoggio','Lokichoggio','KE ','LKG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6011,'Loyangalani','Loyangalani','KE ','LOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6012,'Malindi','Malindi','KE ','MYD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6013,'Mandera','Mandera','KE ','NDE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6014,'Mara Lodges','Mara Lodges','KE ','MRE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6015,'Marsabit','Marsabit','KE ','RBT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6016,'Moi International','Mombasa','KE ','MBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6017,'Moyale','Moyale','KE ','OYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6018,'Mumias','Mumias','KE ','MUM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6019,'Nakuru','Nakuru','KE ','NUU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6020,'Nanyuki','Nanyuki','KE ','NYK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6021,'Nyeri','Nyeri','KE ','NYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6022,'Nzoia','Nzoia','KE ','NZO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6023,'Samburu','Samburu','KE ','UAS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6024,'Ukunda','Ukunda','KE ','UKA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6025,'Wajir','Wajir','KE ','WJR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6026,'Wilson','Nairobi','KE ','WIL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6027,'Abaiang','Abaiang','KI ','ABF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6028,'Abemama Atoll','Abemama Atoll','KI ','AEA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6029,'Aranuka','Aranuka','KI ','AAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6030,'Arorae Island','Arorae Island','KI ','AIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6031,'Beru','Beru','KI ','BEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6032,'Bonriki','Tarawa','KI ','TRW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6033,'Butaritari','Butaritari','KI ','BBG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6034,'Canton Island','Canton Island','KI ','CIS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6035,'Cassidy International Airport','Christmas Island','KI ','CXI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6036,'Kuria','Kuria','KI ','KUC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6037,'Maiana','Maiana','KI ','MNK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6038,'Makin Island','Makin Island','KI ','MTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6039,'Marakei','Marakei','KI ','MZK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6040,'Nikunau','Nikunau','KI ','NIG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6041,'Nonouti','Rotima','KI ','NON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6042,'Onotoa','Onotoa','KI ','OOT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6043,'Tabiteuea North','Tabiteuea North','KI ','TBF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6044,'Tabiteuea South','Tabiteuea South','KI ','TSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6045,'Tabuaeran','Tabuaeran','KI ','TNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6046,'Tamana Island','Tamana Island','KI ','TMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6047,'Teraina','Teraina','KI ','TNQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6048,'Sunan International','Pyongyang','KP ','FNJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6049,'Cheongju','Cheongju','KR ','CJJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6050,'Chuja Heliport','Jeju','KR ','JCJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6051,'Daegu','Daegu','KR ','TAE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6052,'Gangneung','Gangneung','KR ','KAG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6053,'Gimhae','Busan','KR ','PUS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6054,'Gimpo International','Seoul','KR ','GMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6055,'Gunsan','Gunsan','KR ','KUV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6056,'Gwangju','Gwangju','KR ','KWJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6057,'Heliport','Geoje','KR ','JGE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6058,'Heliport','Incheon','KR ','JCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6059,'Incheon International','Seoul','KR ','ICN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6060,'Jeju Airport','Jeju','KR ','CJU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6061,'Jeonju','Jeonju','KR ','CHN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6062,'Jinhae','Jinhae','KR ','CHF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6063,'Mokpo','Mokpo','KR ','MPK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6064,'Osan AB','Osan','KR ','OSN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6065,'Pohang','Pohang','KR ','KPO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6066,'Sacheon','Jinju','KR ','HIN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6067,'Samcheok','Samcheok','KR ','SUK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6068,'Seogwipo Heliport','Jeju','KR ','JSP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6069,'Seolak','Sokcho','KR ','SHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6070,'Suwon','Suwon','KR ','SWU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6071,'WonJu','WonJu','KR ','WJU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6072,'Yangyang','Yangyang','KR ','YNY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6073,'Yecheon','Yecheon','KR ','YEC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6074,'Yeosu','Suncheon','KR ','SYS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6075,'Yeosu','Yeosu','KR ','RSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6076,'Ahmed Al Jaber','Ahmed Al Jaber','KW ','XIJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6077,'Kuwait International','Kuwait City','KW ','KWI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6078,'Manas','Bishkek','KG ','FRU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6079,'Osh International Airport','Osh','KG ','OSS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6080,'Attopeu','Attopeu','LA ','AOU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6081,'Ban Houei','Ban Houei','LA ','OUI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6082,'Bounneua','Phongsaly','LA ','PCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6083,'Houeisay','Houeisay','LA ','HOE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6084,'Khong','Khong','LA ','KOG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6085,'Luang Namtha','Luang Namtha','LA ','LXG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6086,'Luang Prabang','Luang Prabang','LA ','LPQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6087,'Muong Sai','Muong Sai','LA ','UON');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6088,'Oudomxai','Oudomxay','LA ','ODY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6089,'Paksane','Paksane','LA ','PKS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6090,'Pakse','Pakse','LA ','PKZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6091,'Sam Neua','Sam Neua','LA ','NEU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6092,'Saravane','Saravane','LA ','VNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6093,'Savannakhet','Savannakhet','LA ','ZVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6094,'Sayaboury','Sayaboury','LA ','ZBY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6095,'Seno','Seno','LA ','SND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6096,'Thakhek','Thakhek','LA ','THK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6097,'Udomxay','Udomxay','LA ','UDO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6098,'Vangrieng','Vangrieng','LA ','VGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6099,'Viengxay','Viengxay','LA ','VNG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6100,'Wattay','Vientiane','LA ','VTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6101,'Xayabury','Xayabury','LA ','XAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6102,'Xieng Khouang','Xieng Khouang','LA ','XKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6103,'Xienglom','Xienglom','LA ','XIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6104,'Daugavpils','Daugavpils','LV ','DGP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6105,'Liepaya','Liepaya','LV ','LPX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6106,'Riga International','Riga','LV ','RIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6107,'Beirut Rafic Hariri Airport','Beirut','LB ','BEY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6108,'Kleyate','Tripoli','LB ','KYE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6109,'Lebakeng','Lebakeng','LS ','LEF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6110,'Leribe','Leribe','LS ','LRB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6111,'Lesobeng','Lesobeng','LS ','LES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6112,'Mafeteng','Mafeteng','LS ','MFC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6113,'Matsaile','Matsaile','LS ','MSG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6114,'Mokhotlong','Mokhotlong','LS ','MKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6115,'Moshoeshoe Intl','Maseru','LS ','MSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6116,'Nkaus','Nkaus','LS ','NKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6117,'Pelaneng','Pelaneng','LS ','PEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6118,'Qachas Nek','Qachas Nek','LS ','UNE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6119,'Quthing','Quthing','LS ','UTG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6120,'Sehonghong','Sehonghong','LS ','SHK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6121,'Sekakes','Sekakes','LS ','SKQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6122,'Semongkong','Semongkong','LS ','SOK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6123,'Seshutes','Seshutes','LS ','SHZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6124,'Thaba-Tseka','Thaba-Tseka','LS ','THB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6125,'Tlokoeng','Tlokoeng','LS ','TKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6126,'A. Tubman','Cape Palmas','LR ','CPA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6127,'Bella Yella','Bella Yella','LR ','BYL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6128,'Buchanan','Buchanan','LR ','UCN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6129,'Foya','Foya','LR ','FOY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6130,'Grand Cess','Grand Cess','LR ','GRC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6131,'Nimba','Nimba','LR ','NIA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6132,'R.E. Murray','Sinoe','LR ','SNI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6133,'Rivercess','Rivercess','LR ','RVC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6134,'Roberts Intl','Monrovia','LR ','ROB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6135,'Sasstown','Sasstown','LR ','SAZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6136,'Sprigg Payne','Monrovia','LR ','MLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6137,'Tapeta','Tapeta','LR ','TPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6138,'Tchien','Tchien','LR ','THC');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6139,'Voinjama','Voinjama','LR ','VOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6140,'Weasua','Weasua','LR ','WES');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6141,'Wologissi','Wologissi','LR ','WOI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6142,'Benina Intl','Benghazi','LY ','BEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6143,'Brack','Brack','LY ','BCQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6144,'Ghadames','Ghadames','LY ','LTD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6145,'Ghat','Ghat','LY ','GHT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6146,'Houn','Houn','LY ','HUQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6147,'International','Tripoli','LY ','TIP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6148,'Kufrah','Kufrah','LY ','AKF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6149,'La Braq','Beida','LY ','LAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6150,'Marsa Brega','Marsa Brega','LY ','LMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6151,'Martuba','Derna','LY ','DNF');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6152,'Misurata','Misurata','LY ','MRA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6153,'Mitiga','Mitiga','LY ','MJI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6154,'Murzuq','Murzuq','LY ','QMQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6155,'Nafoora','Nafoora','LY ','NFR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6156,'Sebha','Sebha','LY ','SEB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6157,'Sert','Sert','LY ','SRX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6158,'Tobruk','Tobruk','LY ','TOB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6159,'Ubari','Ubari','LY ','QUB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6160,'Kaunas','Kaunas','LT ','KUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6161,'Palanga International','Klaipeda/Palanga','LT ','PLQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6162,'Panevezys','Panevezys','LT ','PNV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6163,'Siauliai International','Siauliai','LT ','SQQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6164,'Vilnius','Vilnius','LT ','VNO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6165,'Findel','Luxembourg','LU ','LUX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6166,'Macau International','Macau','MO ','MFM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6167,'Ohrid','Ohrid','MK ','OHD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6168,'Ambanja','Ambanja','MG ','IVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6169,'Ambatolahy','Ambatolahy','MG ','AHY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6170,'Ambatomainty','Ambatomainty','MG ','AMY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6171,'Ambatondrazaka','Ambatondrazaka','MG ','WAM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6172,'Ambilobe','Ambilobe','MG ','AMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6173,'Amborovy','Majunga','MG ','MJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6174,'Ampanihy','Ampanihy','MG ','AMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6175,'Analalava','Analalava','MG ','HVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6176,'Andapa','Andapa','MG ','ZWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6177,'Andriamena','Andriamena','MG ','WAD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6178,'Ankavandra','Ankavandra','MG ','JVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6179,'Ankazoabo','Ankazoabo','MG ','WAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6180,'Ankokoambo','Ankokoambo','MG ','NKO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6181,'Antananarivo','Antananarivo','MG ','TNR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6182,'Antsalova','Antsalova','MG ','WAQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6183,'Antsirabato','Antalaha','MG ','ANM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6184,'Antsirabe','Antsirabe','MG ','ATJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6185,'Antsiranana/Arrachart','Antsiranana','MG ','DIE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6186,'Antsohihy','Antsohihy','MG ','WAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6187,'Bealanana','Bealanana','MG ','WBE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6188,'Befandriana','Befandriana','MG ','WBD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6189,'Bekily','Bekily','MG ','OVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6190,'Belo','Belo','MG ','BMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6191,'Beroroha','Beroroha','MG ','WBO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6192,'Besalampy','Besalampy','MG ','BPY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6193,'Betioky','Betioky','MG ','BKU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6194,'Doany','Doany','MG ','DOA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6195,'Farafangana','Farafangana','MG ','RVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6196,'Fascene','Nossi-Be','MG ','NOS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6197,'Fianarantsoa','Fianarantsoa','MG ','WFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6198,'Ihosy','Ihosy','MG ','IHO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6199,'Ilaka','Ilaka','MG ','ILK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6200,'Madirovalo','Madirovalo','MG ','WMV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6201,'Mahanoro','Mahanoro','MG ','VVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6202,'Maintirano','Maintirano','MG ','MXT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6203,'Malaimbandy','Malaimbandy','MG ','WML');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6204,'Mampikony','Mampikony','MG ','WMP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6205,'Manakara','Manakara','MG ','WVK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6206,'Mananara','Mananara','MG ','WMR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6207,'Mananjary','Mananjary','MG ','MNJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6208,'Mandabe','Mandabe','MG ','WMD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6209,'Mandritsara','Mandritsara','MG ','WMA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6210,'Manja','Manja','MG ','MJA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6211,'Marillac','Fort Dauphin','MG ','FTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6212,'Maroantsetra','Maroantsetra','MG ','WMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6213,'Miandrivazo','Miandrivazo','MG ','ZVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6214,'Morafenobe','Morafenobe','MG ','TVA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6215,'Moramba','Ankorefo','MG ','WOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6216,'Morombe','Morombe','MG ','MXM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6217,'Morondava','Morondava','MG ','MOQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6218,'Port Berge','Port Berge','MG ','WPB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6219,'Sainte Marie','Sainte Marie','MG ','SMS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6220,'Sambava','Sambava','MG ','SVB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6221,'Soalala','Soalala','MG ','DWB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6222,'Tamatave','Tamatave','MG ','TMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6223,'Tambohorano','Tambohorano','MG ','WTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6224,'Tanandava','Tanandava','MG ','TDV');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6225,'Tsaratanana','Tsaratanana','MG ','TTS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6226,'Tulear','Tulear','MG ','TLE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6227,'Vangaindrano','Vangaindrano','MG ','VND');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6228,'Vatomandry','Vatomandry','MG ','VAT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6229,'Vohemar','Vohemar','MG ','VOH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6230,'Chelinda','Chelinda','MW ','CEH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6231,'Chileka','Blantyre','MW ','BLZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6232,'Club Makokola','Club Makokola','MW ','CMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6233,'Dwangwa','Dwangwa','MW ','DWA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6234,'Karonga','Karonga','MW ','KGJ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6235,'Kumuzu International Airport','Lilongwe','MW ','LLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6236,'Likoma','Likoma Island','MW ','LIX');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6237,'Mangochi','Mangochi','MW ','MAI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6238,'Monkey Bay','Monkey Bay','MW ','MYZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6239,'Mzuzu','Mzuzu','MW ','ZZU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6240,'Salima','Salima','MW ','LMB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6241,'Alor Setar','Alor Setar','MY ','AOR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6242,'Bakalalan','Bakalalan','MY ','BKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6243,'Bario','Bario','MY ','BBN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6244,'Batu Berendam','Malacca','MY ','MKZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6245,'Belaga','Belaga','MY ','BLG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6246,'Bintulu','Bintulu','MY ','BTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6247,'Bintulu Port','Bintulu','MY ','ZMK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6248,'Butterworth','Butterworth','MY ','BWH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6249,'Ferry','Port Klang','MY ','XPQ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6250,'Genting','Genting','MY ','GTB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6251,'Kapit','Kapit','MY ','KPI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6252,'Keningau','Keningau','MY ','KGU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6253,'Kerteh','Kerteh','MY ','KTE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6254,'Kota Kinabalu Port','Kota Kinabalu','MY ','ZWR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6255,'Kota-Kinabalu International Airport','Kota-Kinabalu','MY ','BKI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6256,'Kuala Lumpur International Airport','Kuala Lumpur','MY ','KUL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6257,'Kuantan','Kuantan','MY ','KUA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6258,'Kuantan Port','Kuantan','MY ','ZJB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6259,'Kuching','Kuching','MY ','KCH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6260,'Kuching Port','Kuching','MY ','ZGY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6261,'Kudat','Kudat','MY ','KUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6262,'Labuan','Labuan','MY ','LBU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6263,'Lahad Datu','Lahad Datu','MY ','LDU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6264,'Langakawi Intl','Langkawi','MY ','LGK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6265,'Lawas','Lawas','MY ','LWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6266,'Lawas','Long Semado','MY ','LSM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6267,'Limbang','Limbang','MY ','LMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6268,'Long Akah','Long Akah','MY ','LKH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6269,'Long Lama','Long Lama','MY ','LLM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6270,'Long Lellang','Long Lellang','MY ','LGL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6271,'Long Pasia','Long Pasia','MY ','GSA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6272,'Long Seridan','Long Seridan','MY ','ODN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6273,'Long Sukang','Long Sukang','MY ','LSU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6274,'LTS Pulau Redang','Redang','MY ','RDN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6275,'Marudi','Marudi','MY ','MUR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6276,'Mersing','Mersing','MY ','MEP');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6277,'Miri','Miri','MY ','MYY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6278,'Mukah','Mukah','MY ','MKM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6279,'Pamol','Pamol','MY ','PAY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6280,'Pasir Gudang Port','Pasir Gudang','MY ','ZLW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6281,'Penang International','Penang','MY ','PEN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6282,'Penang Port','Penang','MY ','ZJR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6283,'Ranau','Ranau','MY ','RNU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6284,'Sahabat 16','Sahabat 16','MY ','SXS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6285,'Sandakan','Sandakan','MY ','SDK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6286,'Sematan','Sematan','MY ','BSE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6287,'Semporna','Semporna','MY ','SMM');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6288,'Sepulot','Sepulot','MY ','SPE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6289,'Sibu','Sibu','MY ','SBW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6290,'Simanggang','Simanggang','MY ','SGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6291,'Sipitang','Sipitang','MY ','SPT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6292,'Sitiawan','Sitiawan','MY ','SWY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6293,'Sultan Abdul Aziz Shah','Kuala Lumpur','MY ','SZB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6294,'Sultan Azlan Shah Airport','Ipoh','MY ','IPH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6295,'Sultan Ismail Intl','Johor Bahru','MY ','JHB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6296,'Sultan Ismail Petra','Kota Bharu','MY ','KBR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6297,'Sultan Mahmood','Kuala Terengganu','MY ','TGG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6298,'Sungei Tekai','Sungei Tekai','MY ','GTK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6299,'Taiping','Taiping','MY ','TPG');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6300,'Taman Negara','Taman Negara','MY ','SXT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6301,'Tanjung Pelepas Port','Tanjung Pelepas','MY ','ZJT');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6302,'Tawau','Tawau','MY ','TWU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6303,'Telupid','Telupid','MY ','TEL');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6522,'Essaouira','Essaouira','MA ','ESU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6523,'Goulimime','Goulimime','MA ','GLN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6524,'Hassan I','Laayoune','MA ','EUN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6525,'Les Angades','Oujda','MA ','OUD');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6526,'Meknes','Meknes','MA ','MEK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6527,'Menara','Marrakech','MA ','RAK');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6528,'Mohamed V','Casablanca','MA ','CMN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6529,'Moulay Ali Cherif','Er-Rachidia','MA ','ERH');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6530,'Nador','Nador','MA ','NDR');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6531,'NAF','Kenitra','MA ','NNA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6532,'Ouarzazate','Ouarzazate','MA ','OZZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6533,'Safi','Safi','MA ','SFI');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6534,'Sais','Fez','MA ','FEZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6535,'Sale','Rabat','MA ','RBA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6536,'Sania Ramel','Tetuan','MA ','TTU');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6537,'Sidi Ifni','Sidi Ifni','MA ','SII');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6538,'Smara','Smara','MA ','SMW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6539,'Tan Tan','Tan Tan','MA ','TTA');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6540,'Tarfaya','Tarfaya','MA ','TFY');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6541,'Alto Molocue','Alto Molocue','MZ ','AME');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6542,'Angoche','Angoche','MZ ','ANO');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6543,'Bajone','Bajone','MZ ','BJN');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6544,'Bazaruto Island','Bazaruto Island','MZ ','BZB');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6545,'Beira','Beira','MZ ','BEW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6546,'Benguera Island','Benguera Island','MZ ','BCW');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6547,'Caia','Caia','MZ ','CMZ');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6548,'Chinde','Chinde','MZ ','INE');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6549,'Chokwe','Chokwe','MZ ','TGS');
Insert into CANARYAIRLINES.AIRPORTS (AIRPORTID,AIRPORTNAME,CITY,COUNTRYCODE,AIRPORTCODE) values (6550,'Cuamba','Cuamba','MZ ','FXO')